/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.NbCatalogManager;
import org.apache.xml.resolver.tools.NbCatalogResolver;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.retriever.XMLCatalogProvider;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.catalog.ProjectCatalogSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogFileWrapperDOMImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogModelFactoryImpl;
import org.netbeans.modules.xml.retriever.impl.Util;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogModelImpl
implements CatalogModel {
    protected FileObject catalogFileObject = null;
    private static Logger logger = Logger.getLogger(CatalogModelImpl.class.getName());
    private boolean doFetch = true;
    private boolean fetchSynchronous = false;
    NbCatalogResolver catalogResolver;
    Catalog apacheCatalogResolverObj;

    public CatalogModelImpl(Project project) throws IOException {
        assert (project != null);
        this.catalogFileObject = Util.getProjectCatalogFileObject(project, false);
    }

    public CatalogModelImpl(FileObject fileObject) throws IOException {
        assert (fileObject != null);
        this.catalogFileObject = fileObject;
    }

    public CatalogModelImpl() {
    }

    public CatalogModelImpl(File file) throws IOException {
        file = FileUtil.normalizeFile((File)file);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        String string = "catalog.xml";
        this.catalogFileObject = FileUtil.createData((FileObject)fileObject, (String)string);
    }

    private URI extractRealURI(URI uRI) throws URISyntaxException {
        URI uRI2 = uRI;
        String string = uRI.getQuery();
        if (string != null && string.indexOf("fetch=") != -1 && string.indexOf("sync=") != -1) {
            int n = string.indexOf("fetch=");
            String string2 = string.substring(n);
            String[] stringArray = string2.split("&&");
            this.doFetch = Boolean.valueOf(stringArray[0].split("=")[1]);
            this.fetchSynchronous = Boolean.valueOf(stringArray[1].split("=")[1]);
            uRI2 = new URI(uRI.toString().substring(0, uRI.toString().lastIndexOf("fetch=") - 1));
        }
        return uRI2;
    }

    public synchronized ModelSource getModelSource(URI uRI, ModelSource modelSource) throws CatalogModelException {
        ModelSource modelSource2 = null;
        try {
            modelSource2 = this.doGetModelSource(this.extractRealURI(uRI), modelSource);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CatalogModelException((Throwable)uRISyntaxException);
        }
        catch (CatalogModelException catalogModelException) {
            throw catalogModelException;
        }
        finally {
            this.doFetch = true;
            this.fetchSynchronous = false;
        }
        return modelSource2;
    }

    private synchronized ModelSource doGetModelSource(URI uRI, ModelSource modelSource) throws CatalogModelException {
        Object object;
        logger.entering("CatalogModelImpl", "getModelSource", uRI);
        Throwable throwable = null;
        ModelSource modelSource2 = null;
        this.useSuitableCatalogFile(modelSource);
        if (this.isOrphan() && this.isLocalFile(uRI)) {
            return this.tryOrphanResolution(uRI, modelSource);
        }
        File file = null;
        FileObject fileObject = null;
        if (modelSource != null) {
            fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
        }
        try {
            file = this.resolveUsingCatalog(uRI, fileObject);
        }
        catch (IOException iOException) {
            throwable = iOException;
        }
        catch (CatalogModelException catalogModelException) {
            throwable = catalogModelException;
        }
        if (file == null || throwable != null) {
            object = this.getModelSourceFromSystemWideCatalog(uRI, modelSource);
            if (object != null) {
                return object;
            }
            try {
                if (this.doFetch) {
                    file = this.retrieveCacheAndLookup(uRI, fileObject);
                }
            }
            catch (IOException iOException) {
                throw new CatalogModelException((Throwable)iOException);
            }
        }
        if (file != null) {
            logger.finer("Found  abs file res:" + file);
            object = FileUtil.normalizeFile((File)file);
            FileObject fileObject2 = FileUtil.toFileObject((File)object);
            boolean bl = this.isEditable(file);
            modelSource2 = this.createModelSource(fileObject2, bl);
        } else if (throwable != null) {
            throw new CatalogModelException(throwable);
        }
        logger.exiting("CatalogModelImpl", "getModelSource", modelSource2);
        return modelSource2;
    }

    private void useSuitableCatalogFile(ModelSource modelSource) {
        if (modelSource != null) {
            FileObject fileObject;
            FileObject fileObject2 = (FileObject)modelSource.getLookup().lookup(FileObject.class);
            if (fileObject2 == null) {
                return;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject2);
            if (project == null) {
                return;
            }
            XMLCatalogProvider xMLCatalogProvider = (XMLCatalogProvider)project.getLookup().lookup(XMLCatalogProvider.class);
            if (xMLCatalogProvider == null) {
                return;
            }
            URI uRI = xMLCatalogProvider.getCatalog(fileObject2);
            if (uRI == null) {
                return;
            }
            URI uRI2 = FileUtil.toFile((FileObject)project.getProjectDirectory()).toURI();
            URI uRI3 = uRI2.resolve(uRI);
            if (uRI3 == null) {
                return;
            }
            File file = new File(uRI3);
            if (!file.isFile()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    return;
                }
            }
            if ((fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file))) == null) {
                return;
            }
            this.catalogFileObject = fileObject;
        }
    }

    public ModelSource getModelSource(URI uRI) throws CatalogModelException {
        if (this.isOrphan()) {
            return this.tryOrphanResolution(uRI, null);
        }
        return this.getModelSource(uRI, null);
    }

    private Document getDocument(FileObject fileObject) throws CatalogModelException {
        StyledDocument styledDocument = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            StyledDocument styledDocument2 = editorCookie.openDocument();
            assert (styledDocument2 instanceof BaseDocument);
            styledDocument = styledDocument2;
        }
        catch (Exception exception) {
            throw new CatalogModelException((Throwable)exception);
        }
        return styledDocument;
    }

    protected ModelSource createModelSource(FileObject fileObject, boolean bl) throws CatalogModelException {
        ModelSource modelSource = Utilities.getModelSource(fileObject, bl);
        return modelSource;
    }

    protected CatalogModel createCatalogModel(FileObject fileObject) throws CatalogModelException {
        return new CatalogModelFactoryImpl().getCatalogModel(fileObject);
    }

    private ModelSource tryOrphanResolution(URI uRI, ModelSource modelSource) {
        logger.entering("CatalogModelImpl", "getModelSource", uRI);
        if (this.catalogFileObject == null) {
            try {
                FileObject fileObject;
                File file;
                if (uRI.isAbsolute()) {
                    File file2 = new File(uRI);
                    if (file2.isFile()) {
                        file2 = FileUtil.normalizeFile((File)file2);
                        FileObject fileObject2 = FileUtil.toFileObject((File)file2);
                        return this.createModelSource(fileObject2, this.isEditable(file2));
                    }
                } else if (modelSource != null && (file = this.resolveRelativeURI(uRI, fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class))) != null) {
                    file = FileUtil.normalizeFile((File)file);
                    FileObject fileObject3 = FileUtil.toFileObject((File)file);
                    return this.createModelSource(fileObject3, this.isEditable(file));
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private boolean isOrphan() {
        return this.catalogFileObject == null;
    }

    private boolean isLocalFile(URI uRI) {
        return uRI.isAbsolute() && uRI.getScheme() != null && "file".equals(uRI.getScheme());
    }

    protected File resolveUsingCatalog(URI uRI, FileObject fileObject) throws CatalogModelException, IOException {
        logger.entering("CatalogModelImpl", "resolveUsingCatalog", uRI);
        if (uRI == null) {
            return null;
        }
        File file = null;
        file = this.resolveUsingPublicCatalog(uRI);
        if (file != null) {
            return file;
        }
        if (fileObject != null) {
            file = this.resolveRelativeURI(uRI, fileObject);
        }
        if (file != null) {
            return file;
        }
        if (uRI.isAbsolute() && uRI.getScheme().equalsIgnoreCase("file")) {
            file = new File(uRI);
            if (file.isFile()) {
                logger.exiting("CatalogModelImpl", "resolveUsingCatalog", file);
                return file;
            }
            throw new FileNotFoundException(uRI.toString() + ": is absolute but " + file.getAbsolutePath() + " Not Found.");
        }
        throw new CatalogModelException(uRI.toString() + " : Entry is not a relative or absolute and catalog entry not found");
    }

    private File retrieveCacheAndLookup(URI uRI, FileObject fileObject) throws IOException, CatalogModelException {
        File file = null;
        if (uRI.isAbsolute() && uRI.getScheme().toLowerCase().startsWith("http") && !CatalogFileWrapperDOMImpl.TEST_ENVIRONMENT) {
            boolean bl = false;
            try {
                bl = Util.retrieveAndCache(uRI, fileObject, !this.fetchSynchronous);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl && (file = this.resolveUsingPublicCatalog(uRI)) != null) {
                return file;
            }
        }
        return file;
    }

    protected File resolveUsingPublicCatalog(URI uRI) throws IOException, CatalogModelException {
        File file;
        File file2 = null;
        if (this.catalogFileObject != null && (file = FileUtil.toFile((FileObject)this.catalogFileObject)).isFile()) {
            if (file.length() < 20L) {
                return null;
            }
            URI uRI2 = this.resolveUsingApacheCatalog(file, uRI.toString());
            if (uRI2 != null && uRI2.isAbsolute()) {
                if (uRI2.getScheme().equalsIgnoreCase("file")) {
                    file2 = new File(uRI2);
                    if (file2.isFile()) {
                        logger.exiting("CatalogModelImpl", "resolveUsingCatalog", file2);
                        return file2;
                    }
                    throw new FileNotFoundException(file2.getAbsolutePath() + " Not Found.");
                }
                File file3 = this.resolveProjectProtocol(uRI2);
                if (file3 != null) {
                    return file3;
                }
                throw new CatalogModelException("Catalog contains non-file URI. Catalog Maps URI to a local file only.");
            }
        }
        return null;
    }

    protected File resolveRelativeURI(URI uRI, FileObject fileObject) throws CatalogModelException, FileNotFoundException {
        File file = null;
        if (!uRI.isAbsolute()) {
            if (fileObject == null) {
                throw new CatalogModelException(uRI.toString() + " : Entry is relative but base file now known. Pass base file to the factory");
            }
            File file2 = FileUtil.toFile((FileObject)fileObject);
            if (file2 != null) {
                URI uRI2 = file2.toURI();
                URI uRI3 = uRI2.resolve(uRI);
                try {
                    file = new File(uRI3);
                }
                catch (Exception exception) {
                    throw new CatalogModelException(uRI.toString() + " : Entry is relative but resolved entry is not absolute");
                }
                if (file.isFile()) {
                    logger.exiting("CatalogModelImpl", "resolveUsingCatalog", file);
                    return file;
                }
                throw new FileNotFoundException(file.getAbsolutePath() + " Not Found.");
            }
        }
        return null;
    }

    protected URI resolveUsingApacheCatalog(File file, String string) throws IOException, CatalogModelException {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        return this.resolveUsingApacheCatalog(arrayList, string);
    }

    protected URI resolveUsingApacheCatalog(List<File> list, String string) throws CatalogModelException, IOException {
        NbCatalogManager nbCatalogManager;
        if (logger.getLevel() != null && logger.getLevel().intValue() <= Level.FINER.intValue()) {
            nbCatalogManager = NbCatalogManager.getStaticManager().debug;
            nbCatalogManager.setDebug(logger.getLevel().intValue());
        }
        nbCatalogManager = new NbCatalogManager(null);
        nbCatalogManager.setUseStaticCatalog(false);
        nbCatalogManager.setPreferPublic(false);
        this.catalogResolver = new NbCatalogResolver(nbCatalogManager);
        this.apacheCatalogResolverObj = this.catalogResolver.getCatalog();
        for (File comparable2 : list) {
            this.apacheCatalogResolverObj.parseCatalog(comparable2.toURL());
        }
        Object object = null;
        try {
            object = this.apacheCatalogResolverObj.resolveSystem(string);
        }
        catch (Exception exception) {
            object = "";
        }
        if (object == null) {
            object = "";
        } else {
            try {
                object = Utilities.normalizeURI((String)object);
                URI uRISyntaxException = new URI((String)object);
                if (uRISyntaxException.isOpaque() && uRISyntaxException.getScheme().equalsIgnoreCase("file")) {
                    StringBuffer stringBuffer = new StringBuffer((String)object);
                    object = stringBuffer.insert("file:".length(), "/").toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        if (((String)object).length() > 0) {
            try {
                URI uRI = new URI((String)object);
                return uRI;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    boolean isEditable(File file) {
        return true;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        try {
            return this.getInputSource(new URI(string2));
        }
        catch (CatalogModelException catalogModelException) {
            throw new IOException(catalogModelException.getMessage());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException("SystemID not a URL");
        }
    }

    private InputSource getInputSource(URI uRI) throws CatalogModelException, IOException {
        logger.entering("CatalogModelImpl", "getInputSource", uRI);
        File file = this.resolveUsingCatalog(uRI, null);
        logger.finer("Found  abs file res:" + file);
        InputSource inputSource = new InputSource(new FileInputStream(file));
        inputSource.setSystemId(uRI.toString());
        logger.exiting("CatalogModelImpl", "getInputSource", inputSource);
        return inputSource;
    }

    public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
        if (string4 == null || string4.trim().length() <= 0) {
            return null;
        }
        URI uRI = null;
        try {
            uRI = new URI(string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        FileObject fileObject = null;
        CatalogModel catalogModel = null;
        try {
            fileObject = this.getFileObject(string5);
            catalogModel = this.getResolver(fileObject);
        }
        catch (CatalogModelException catalogModelException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (catalogModel == null) {
            return null;
        }
        ModelSource modelSource = null;
        try {
            modelSource = this.createModelSource(fileObject, false);
        }
        catch (CatalogModelException catalogModelException) {
            // empty catch block
        }
        ModelSource modelSource2 = null;
        try {
            modelSource2 = catalogModel.getModelSource(uRI, modelSource);
        }
        catch (CatalogModelException catalogModelException) {
            return null;
        }
        if (modelSource2 == null) {
            return null;
        }
        FileObject fileObject2 = (FileObject)modelSource2.getLookup().lookup(FileObject.class);
        if (fileObject2 == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject2);
        if (file == null) {
            return null;
        }
        URI uRI2 = file.toURI();
        DOMImplementation dOMImplementation = null;
        try {
            dOMImplementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
        LSInput lSInput = dOMImplementationLS.createLSInput();
        Reader reader = this.getFileStreamFromDocument(file);
        if (reader != null) {
            lSInput.setCharacterStream(reader);
        }
        lSInput.setSystemId(uRI2.toString());
        return lSInput;
    }

    private FileObject getFileObject(String string) throws IOException {
        if (string == null) {
            return null;
        }
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException();
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
        if (uRI.isAbsolute() && uRI.getScheme().equalsIgnoreCase("file")) {
            File file = null;
            try {
                file = new File(uRI);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
            file = FileUtil.normalizeFile((File)file);
            FileObject fileObject = null;
            try {
                fileObject = FileUtil.toFileObject((File)file);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
            return fileObject;
        }
        return null;
    }

    private CatalogModel getResolver(FileObject fileObject) throws CatalogModelException {
        if (fileObject != null && FileOwnerQuery.getOwner((FileObject)fileObject) != null) {
            return CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(fileObject);
        }
        return this;
    }

    private Reader getFileStreamFromDocument(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject != null) {
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
            if (dataObject.isValid() && dataObject.isModified()) {
                return DataObjectAdapters.inputSource((DataObject)dataObject).getCharacterStream();
            }
            return null;
        }
        return null;
    }

    protected File resolveProjectProtocol(URI uRI) {
        FileObject fileObject;
        ProjectCatalogSupport projectCatalogSupport;
        File file = null;
        Project project = FileOwnerQuery.getOwner((FileObject)this.catalogFileObject);
        if (project != null && (projectCatalogSupport = (ProjectCatalogSupport)project.getLookup().lookup(ProjectCatalogSupport.class)).isProjectProtocol(uRI) && (fileObject = projectCatalogSupport.resolveProjectProtocol(uRI)) != null) {
            return FileUtil.toFile((FileObject)fileObject);
        }
        return file;
    }

    private ModelSource getModelSourceFromSystemWideCatalog(URI uRI, ModelSource modelSource) {
        if (uRI == null) {
            return null;
        }
        try {
            Lookup.Template template = new Lookup.Template(CatalogModel.class);
            Lookup.Result result = Lookup.getDefault().lookup(template);
            Collection collection = result.allInstances();
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                Object e = iterator.next();
                CatalogModel catalogModel = (CatalogModel)e;
                return catalogModel.getModelSource(uRI, modelSource);
            }
        }
        catch (CatalogModelException catalogModelException) {
            // empty catch block
        }
        return null;
    }
}

