/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.jumpto.SearchHistory;
import org.netbeans.modules.jumpto.file.FileDescription;
import org.netbeans.modules.jumpto.file.FileSearchAction;
import org.netbeans.modules.jumpto.file.FileSearchOptions;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class FileSearchPanel
extends JPanel
implements ActionListener {
    private static final int BRIGHTER_COLOR_COMPONENT = 10;
    private final ContentProvider contentProvider;
    private final Project currentProject;
    private boolean containsScrollPane;
    private JLabel messageLabel;
    private String oldText;
    long time;
    private FileDescription selectedFile;
    private final SearchHistory searchHistory;
    private JCheckBox caseSensitiveCheckBox;
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;
    private JCheckBox hiddenFilesCheckBox;
    private JLabel jLabelLocation;
    private JTextField jTextFieldLocation;
    private JPanel listPanel;
    private JCheckBox mainProjectCheckBox;
    private JLabel resultLabel;
    private JList resultList;
    private JScrollPane resultScrollPane;

    public FileSearchPanel(ContentProvider contentProvider, Project project) {
        this.contentProvider = contentProvider;
        this.currentProject = project;
        this.initComponents();
        this.containsScrollPane = true;
        Color color = new Color(Math.min(this.getBackground().getRed() + 10, 255), Math.min(this.getBackground().getGreen() + 10, 255), Math.min(this.getBackground().getBlue() + 10, 255));
        this.messageLabel = new JLabel();
        this.messageLabel.setBackground(color);
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setEnabled(true);
        this.messageLabel.setText(NbBundle.getMessage(FileSearchPanel.class, (String)"TXT_NoTypesFound"));
        this.messageLabel.setFont(this.resultList.getFont());
        this.caseSensitiveCheckBox.setSelected(FileSearchOptions.getCaseSensitive());
        this.hiddenFilesCheckBox.setSelected(FileSearchOptions.getShowHiddenFiles());
        this.mainProjectCheckBox.setSelected(FileSearchOptions.getPreferMainProject());
        if (project == null) {
            this.mainProjectCheckBox.setEnabled(false);
            this.mainProjectCheckBox.setSelected(false);
        } else {
            ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
            this.mainProjectCheckBox.setText(NbBundle.getMessage(FileSearchPanel.class, (String)"FMT_CurrentProjectLabel", (Object)projectInformation.getDisplayName()));
        }
        this.mainProjectCheckBox.addActionListener(this);
        this.caseSensitiveCheckBox.addActionListener(this);
        this.hiddenFilesCheckBox.addActionListener(this);
        this.hiddenFilesCheckBox.setVisible(false);
        this.resultList.setCellRenderer(contentProvider.getListCellRenderer(this.resultList));
        contentProvider.setListModel(this, null);
        this.fileNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                FileSearchPanel.this.update();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                FileSearchPanel.this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                FileSearchPanel.this.update();
            }
        });
        this.searchHistory = new SearchHistory(FileSearchPanel.class, this.fileNameTextField);
    }

    public void removeNotify() {
        this.searchHistory.saveHistory();
        super.removeNotify();
    }

    public void setModel(final ListModel listModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (listModel.getSize() > 0 || FileSearchPanel.this.getText() == null || FileSearchPanel.this.getText().trim().length() == 0) {
                    FileSearchPanel.this.resultList.setModel(listModel);
                    FileSearchPanel.this.resultList.setSelectedIndex(0);
                    ((FileDescription.Renderer)FileSearchPanel.this.resultList.getCellRenderer()).setColorPrefered(FileSearchPanel.this.isPreferedProject());
                    FileSearchPanel.this.setListPanelContent(null, false);
                    if (FileSearchPanel.this.time != -1L) {
                        FileSearchAction.LOGGER.fine("Real search time " + (System.currentTimeMillis() - FileSearchPanel.this.time) + " ms.");
                        FileSearchPanel.this.time = -1L;
                    }
                } else if (FileSearchPanel.this.getText() != null) {
                    try {
                        Pattern.compile(FileSearchPanel.this.getText().replace(".", "\\.").replace("*", ".*").replace('?', '.'), 2);
                        FileSearchPanel.this.setListPanelContent(NbBundle.getMessage(FileSearchPanel.class, (String)"TXT_NoTypesFound"), false);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        FileSearchPanel.this.setListPanelContent(NbBundle.getMessage(FileSearchPanel.class, (String)"TXT_SyntaxError", (Object)patternSyntaxException.getDescription(), (Object)patternSyntaxException.getIndex()), false);
                    }
                } else {
                    FileSearchPanel.this.setListPanelContent(NbBundle.getMessage(FileSearchPanel.class, (String)"TXT_NoTypesFound"), false);
                }
            }
        });
    }

    void setListPanelContent(String string, boolean bl) {
        if (string == null && !this.containsScrollPane) {
            this.listPanel.remove(this.messageLabel);
            this.listPanel.add(this.resultScrollPane);
            this.containsScrollPane = true;
            this.revalidate();
            this.repaint();
        } else if (string != null) {
            this.jTextFieldLocation.setText("");
            this.messageLabel.setText(string);
            this.messageLabel.setIcon(bl ? FileDescription.Renderer.WAIT_ICON : null);
            if (this.containsScrollPane) {
                this.listPanel.remove(this.resultScrollPane);
                this.listPanel.add(this.messageLabel);
                this.containsScrollPane = false;
            }
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isShowHiddenFiles() {
        return this.hiddenFilesCheckBox.isSelected();
    }

    public boolean isPreferedProject() {
        return this.mainProjectCheckBox.isSelected();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitiveCheckBox.isSelected();
    }

    private void update() {
        this.time = System.currentTimeMillis();
        String string = this.getText();
        if (this.oldText == null || this.oldText.trim().length() == 0 || !string.startsWith(this.oldText)) {
            this.setListPanelContent(NbBundle.getMessage(FileSearchPanel.class, (String)"TXT_Searching"), true);
        }
        this.oldText = string;
        this.contentProvider.setListModel(this, string);
    }

    private void initComponents() {
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.resultLabel = new JLabel();
        this.listPanel = new JPanel();
        this.resultScrollPane = new JScrollPane();
        this.resultList = new JList();
        this.caseSensitiveCheckBox = new JCheckBox();
        this.hiddenFilesCheckBox = new JCheckBox();
        this.mainProjectCheckBox = new JCheckBox();
        this.jLabelLocation = new JLabel();
        this.jTextFieldLocation = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setPreferredSize(new Dimension(540, 280));
        this.setLayout(new GridBagLayout());
        this.fileNameLabel.setFont(this.fileNameLabel.getFont());
        this.fileNameLabel.setLabelFor(this.fileNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileNameLabel, (String)NbBundle.getMessage(FileSearchPanel.class, (String)"CTL_FileName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.fileNameLabel, gridBagConstraints);
        this.fileNameTextField.setFont(new Font("Monospaced", 0, this.getFontSize()));
        this.fileNameTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileSearchPanel.this.fileNameTextFieldActionPerformed(actionEvent);
            }
        });
        this.fileNameTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                FileSearchPanel.this.fileNameTextFieldKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        this.add((Component)this.fileNameTextField, gridBagConstraints);
        this.fileNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileSearchPanel.class, (String)"AN_SearchText"));
        this.fileNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSearchPanel.class, (String)"AD_SearchText"));
        this.resultLabel.setLabelFor(this.resultList);
        Mnemonics.setLocalizedText((JLabel)this.resultLabel, (String)NbBundle.getMessage(FileSearchPanel.class, (String)"CTL_MatchingFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.resultLabel, gridBagConstraints);
        this.listPanel.setBorder(BorderFactory.createEtchedBorder());
        this.listPanel.setLayout(new BorderLayout());
        this.resultScrollPane.setBorder(null);
        this.resultList.setFont(new Font("Monospaced", 0, this.getFontSize()));
        this.resultList.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                FileSearchPanel.this.resultListMouseReleased(mouseEvent);
            }
        });
        this.resultList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FileSearchPanel.this.resultListValueChanged(listSelectionEvent);
            }
        });
        this.resultScrollPane.setViewportView(this.resultList);
        this.resultList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileSearchPanel.class, (String)"AN_MatchingList"));
        this.resultList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSearchPanel.class, (String)"AD_MatchingList"));
        this.listPanel.add((Component)this.resultScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.listPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitiveCheckBox, (String)NbBundle.getMessage(FileSearchPanel.class, (String)"LBL_CaseSensitive"));
        this.caseSensitiveCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add((Component)this.caseSensitiveCheckBox, gridBagConstraints);
        this.caseSensitiveCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSearchPanel.class, (String)"AD_CaseSensitive"));
        Mnemonics.setLocalizedText((AbstractButton)this.hiddenFilesCheckBox, (String)NbBundle.getMessage(FileSearchPanel.class, (String)"LBL_HiddenFiles"));
        this.hiddenFilesCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.hiddenFilesCheckBox, gridBagConstraints);
        this.hiddenFilesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSearchPanel.class, (String)"AD_HiddenFiles"));
        Mnemonics.setLocalizedText((AbstractButton)this.mainProjectCheckBox, (String)NbBundle.getMessage(FileSearchPanel.class, (String)"LBL_PreferMainProject"));
        this.mainProjectCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.mainProjectCheckBox, gridBagConstraints);
        this.mainProjectCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSearchPanel.class, (String)"AD_PreferMainProject"));
        this.jLabelLocation.setLabelFor(this.jTextFieldLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabelLocation, (String)NbBundle.getMessage(FileSearchPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 4, 0);
        this.add((Component)this.jLabelLocation, gridBagConstraints);
        this.jLabelLocation.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileSearchPanel.class, (String)"AN_Location"));
        this.jLabelLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSearchPanel.class, (String)"AD_Location"));
        this.jTextFieldLocation.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.jTextFieldLocation, gridBagConstraints);
    }

    private void fileNameTextFieldActionPerformed(ActionEvent actionEvent) {
        if (this.contentProvider.hasValidContent()) {
            this.contentProvider.closeDialog();
            this.setSelectedFile();
        }
    }

    private void resultListMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.fileNameTextFieldActionPerformed(null);
        }
    }

    private void resultListValueChanged(ListSelectionEvent listSelectionEvent) {
        Object e = this.resultList.getSelectedValue();
        if (e != null && e instanceof FileDescription) {
            FileDescription fileDescription = (FileDescription)e;
            this.jTextFieldLocation.setText(FileUtil.getFileDisplayName((FileObject)fileDescription.getFileObject()));
        } else {
            this.jTextFieldLocation.setText("");
        }
    }

    private void fileNameTextFieldKeyPressed(KeyEvent keyEvent) {
        Object object = this.resultList.getInputMap().get(KeyStroke.getKeyStrokeForEvent(keyEvent));
        boolean bl = "selectPreviousRow".equals(object) || "selectPreviousRowExtendSelection".equals(object) || "selectNextRow".equals(object) || "selectNextRowExtendSelection".equals(object) || "scrollUp".equals(object) || "scrollUpExtendSelection".equals(object) || "scrollDown".equals(object) || "scrollDownExtendSelection".equals(object);
        int n = this.resultList.getSelectedIndex();
        ListModel listModel = this.resultList.getModel();
        int n2 = listModel.getSize();
        if ("selectNextRow".equals(object) && (n == n2 - 1 || n == n2 - 2 && listModel.getElementAt(n2 - 1) == FileDescription.SEARCH_IN_PROGRES)) {
            this.resultList.setSelectedIndex(0);
            this.resultList.ensureIndexIsVisible(0);
            return;
        }
        if ("selectPreviousRow".equals(object) && n == 0) {
            int n3 = n2 - 1;
            if (listModel.getElementAt(n3) == FileDescription.SEARCH_IN_PROGRES) {
                --n3;
            }
            this.resultList.setSelectedIndex(n3);
            this.resultList.ensureIndexIsVisible(n3);
            return;
        }
        if (bl) {
            Action action = this.resultList.getActionMap().get(object);
            action.actionPerformed(new ActionEvent(this.resultList, 0, (String)object));
            keyEvent.consume();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.caseSensitiveCheckBox) {
            FileSearchOptions.setCaseSensitive(this.caseSensitiveCheckBox.isSelected());
        } else if (actionEvent.getSource() == this.hiddenFilesCheckBox) {
            FileSearchOptions.setShowHiddenFiles(this.hiddenFilesCheckBox.isSelected());
        } else if (actionEvent.getSource() == this.mainProjectCheckBox) {
            FileSearchOptions.setPreferMainProject(this.isPreferedProject());
        }
        this.update();
    }

    private String getText() {
        try {
            String string = this.fileNameTextField.getDocument().getText(0, this.fileNameTextField.getDocument().getLength());
            return string;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private int getFontSize() {
        return this.resultList.getFont().getSize();
    }

    public void setSelectedFile() {
        this.selectedFile = (FileDescription)this.resultList.getSelectedValue();
    }

    public FileDescription getSelectedFile() {
        return this.selectedFile;
    }

    public Project getCurrentProject() {
        return this.currentProject;
    }

    public static interface ContentProvider {
        public ListCellRenderer getListCellRenderer(JList var1);

        public void setListModel(FileSearchPanel var1, String var2);

        public void closeDialog();

        public boolean hasValidContent();
    }
}

