/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchHistory {
    private static final Logger LOGGER = Logger.getLogger(SearchHistory.class.getName());
    private static final String SEARCH_HISTORY = "SearchHistory";
    private static final int HISTORY_LIMIT = 10;
    private static final String HISTORY_BACK = "historyBack";
    private static final String HISTORY_FORWARD = "historyForward";
    private static final String DELIMITER = ";";
    private final String historyKey;
    private final JTextField textField;
    private final List<String> data;
    private int offset = -1;

    public SearchHistory(Class clazz, JTextField jTextField) {
        this(clazz.getName(), jTextField);
    }

    public SearchHistory(String string, JTextField jTextField) {
        assert (string != null && string.trim().length() > 0);
        assert (jTextField != null);
        this.historyKey = string;
        this.textField = jTextField;
        this.data = this.readHistory();
        this.registerListeners();
    }

    public void saveHistory() {
        this.saveHistory(this.textField.getText());
    }

    public void saveHistory(String string) {
        this.addHistoryItem(string);
        while (this.data.size() > 10) {
            String string2 = this.data.remove(this.getLastIndex());
            LOGGER.fine("History item removed: " + string2);
        }
        this.storeHistory();
    }

    private void addHistoryItem(String string) {
        this.addHistoryItem(string, MoveOffset.CURRENT);
    }

    private void addHistoryItem(String string, MoveOffset moveOffset) {
        if (string == null || string.trim().length() == 0) {
            LOGGER.fine("String to store is empty => ignoring.");
            return;
        }
        if (this.data.remove(string)) {
            LOGGER.fine(String.format("Text %s already in history, removing and readding.", string));
        }
        this.data.add(this.getFirstIndex(), string);
        switch (moveOffset) {
            case NEXT: {
                this.offset = this.getFirstIndex() + 1;
                break;
            }
            case PREVIOUS: {
                this.offset = this.getLastIndex();
                break;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("History item added: " + string);
            LOGGER.fine("History: " + this.data);
            LOGGER.fine(String.format("Offset %d, moved %s", new Object[]{this.offset, moveOffset}));
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(SearchHistory.class).node(SEARCH_HISTORY);
    }

    private void registerListeners() {
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(38, 2, true), HISTORY_BACK);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(40, 2, true), HISTORY_FORWARD);
        this.textField.getActionMap().put(HISTORY_BACK, new AbstractAction(){
            private static final long serialVersionUID = -29128233042020099L;

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistory.this.navigateBack();
            }
        });
        this.textField.getActionMap().put(HISTORY_FORWARD, new AbstractAction(){
            private static final long serialVersionUID = 2341042130613885L;

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistory.this.navigateForward();
            }
        });
    }

    void navigateBack() {
        LOGGER.fine("History back called, offset is " + this.offset);
        if (this.data.size() == 0) {
            LOGGER.fine("No data in history.");
            return;
        }
        String string = this.getCachedText();
        ++this.offset;
        if (this.offset > this.getLastIndex()) {
            this.offset = this.getFirstIndex();
        }
        this.navigate(string, MoveOffset.NEXT);
        LOGGER.fine(String.format("History: %s, offset: %d", this.data, this.offset));
    }

    void navigateForward() {
        LOGGER.fine("History forward called, offset is " + this.offset);
        if (this.data.size() == 0) {
            LOGGER.fine("No data in history.");
            return;
        }
        String string = this.getCachedText();
        --this.offset;
        if (this.offset < this.getFirstIndex()) {
            this.offset = this.getLastIndex();
        }
        this.navigate(string, MoveOffset.PREVIOUS);
        LOGGER.fine(String.format("History: %s, offset: %d", this.data, this.offset));
    }

    private void navigate(String string, MoveOffset moveOffset) {
        assert (this.data.size() > 0);
        String string2 = null;
        String string3 = this.textField.getText();
        if (string != null && string.equals(string3)) {
            LOGGER.fine("Text not changed => not saving, just iterating.");
            string2 = this.getCachedText();
            LOGGER.fine("New text is: " + string2);
        } else {
            LOGGER.fine("Text changed => remember the current one & set the last (or first) one to the text field.");
            int n = moveOffset.equals((Object)MoveOffset.PREVIOUS) ? this.getLastIndex() : this.getFirstIndex();
            string2 = this.getCachedText(n);
            LOGGER.fine("New text is: " + string2);
            this.addHistoryItem(string3, moveOffset);
        }
        assert (string2 != null && string2.trim().length() > 0);
        this.textField.setText(string2);
    }

    private List<String> readHistory() {
        String string = this.getPreferences().get(this.historyKey, null);
        if (string == null || string.trim().length() == 0) {
            LOGGER.fine("No history found");
            return new ArrayList<String>(20);
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string.split(DELIMITER)));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("History found: " + arrayList);
        }
        assert (arrayList.size() <= 10) : String.format("Too many items found %d > %d", arrayList.size(), 10);
        return arrayList;
    }

    private void storeHistory() {
        assert (this.data.size() <= 10) : String.format("Too many items found %d > %d", this.data.size(), 10);
        StringBuilder stringBuilder = new StringBuilder(200);
        boolean bl = false;
        for (String string : this.data) {
            if (bl) {
                stringBuilder.append(DELIMITER);
            }
            stringBuilder.append(string);
            bl = true;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("History to save: " + stringBuilder.toString());
        }
        this.getPreferences().put(this.historyKey, stringBuilder.toString());
    }

    private int getFirstIndex() {
        return 0;
    }

    private int getLastIndex() {
        return this.data.size() - 1;
    }

    private String getCachedText() {
        return this.getCachedText(this.offset);
    }

    private String getCachedText(int n) {
        if (n >= this.getFirstIndex() && n <= this.getLastIndex()) {
            return this.data.get(n);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MoveOffset {
        CURRENT,
        NEXT,
        PREVIOUS;

    }
}

