/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.pluginimporter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImporter {
    private final Collection<UpdateUnit> plugins;
    private boolean inspected = false;
    private Collection<UpdateElement> installed = null;
    private Collection<UpdateElement> toInstall = null;
    private Collection<UpdateElement> toImport = null;
    private Collection<UpdateElement> broken = null;
    private static final String TRACKING_FILE_NAME = "update_tracking";
    private static final String ELEMENT_MODULE = "module";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_FILE_NAME = "name";
    private static final String MODULES = "Modules";
    private static final String LAST_MODIFIED = ".lastModified";
    private static Logger LOG = Logger.getLogger(PluginImporter.class.getName());

    public PluginImporter(Collection<UpdateUnit> collection) {
        this.plugins = collection;
    }

    private void inspect() {
        OperationContainer.OperationInfo operationInfo;
        UpdateUnit updateUnit;
        if (this.inspected) {
            return;
        }
        this.installed = new HashSet<UpdateElement>();
        this.toImport = new HashSet<UpdateElement>();
        this.toInstall = new HashSet<UpdateElement>();
        this.broken = new HashSet<UpdateElement>();
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        List list = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        HashMap<String, UpdateUnit> hashMap = new HashMap<String, UpdateUnit>(list.size());
        for (UpdateUnit updateUnit2 : list) {
            hashMap.put(updateUnit2.getCodeName(), updateUnit2);
        }
        for (UpdateUnit updateUnit2 : this.plugins) {
            SpecificationVersion specificationVersion;
            UpdateElement updateElement;
            updateUnit = (UpdateUnit)hashMap.get(updateUnit2.getCodeName());
            operationInfo = null;
            SpecificationVersion specificationVersion2 = null;
            if (updateUnit != null && !updateUnit.getAvailableUpdates().isEmpty()) {
                operationInfo = (UpdateElement)updateUnit.getAvailableUpdates().get(0);
                specificationVersion2 = new SpecificationVersion(operationInfo.getSpecificationVersion());
            }
            if (updateUnit2.getInstalled() != null) {
                if (!updateUnit2.getAvailableUpdates().isEmpty()) {
                    updateElement = (UpdateElement)updateUnit2.getAvailableUpdates().get(0);
                    if (operationInfo != null) {
                        specificationVersion = new SpecificationVersion(updateElement.getSpecificationVersion());
                        if (specificationVersion.compareTo((Object)specificationVersion2) > 0) {
                            hashSet.add(updateElement);
                        }
                    } else {
                        hashSet.add(updateElement);
                    }
                }
                this.installed.add(updateUnit2.getInstalled());
                continue;
            }
            if (updateUnit2.isPending()) {
                LOG.log(Level.INFO, "Plugin " + updateUnit2.getCodeName() + " is not installed but is in pending state - i.e. will be installed upon restart, skipping");
                continue;
            }
            assert (!updateUnit2.getAvailableUpdates().isEmpty()) : "If " + updateUnit2 + " isn't installed thus has available updates.";
            updateElement = (UpdateElement)updateUnit2.getAvailableUpdates().get(0);
            if (operationInfo != null) {
                specificationVersion = new SpecificationVersion(updateElement.getSpecificationVersion());
                if (specificationVersion.compareTo((Object)specificationVersion2) > 0) {
                    hashSet.add(updateElement);
                    continue;
                }
                this.toInstall.add((UpdateElement)operationInfo);
                continue;
            }
            hashSet.add(updateElement);
        }
        for (UpdateElement updateElement : hashSet) {
            updateUnit = updateElement.getUpdateUnit().getInstalled() == null ? OperationContainer.createForInstall() : OperationContainer.createForUpdate();
            try {
                operationInfo = updateUnit.add(updateElement);
                updateUnit.add(hashSet);
                if (operationInfo.getBrokenDependencies().isEmpty()) {
                    this.toImport.add(updateElement);
                    continue;
                }
                LOG.log(Level.INFO, "Plugin " + updateElement + " cannot be install because not all dependencies can be match: " + operationInfo.getBrokenDependencies());
                this.broken.add(updateElement);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.log(Level.INFO, illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
                this.broken.add(updateElement);
            }
        }
        this.inspected = true;
    }

    public Collection<UpdateElement> getPluginsToImport() {
        this.inspect();
        return this.toImport;
    }

    public Collection<UpdateElement> getInstalledPlugins() {
        this.inspect();
        return this.installed;
    }

    public Collection<UpdateElement> getPluginsAvailableToInstall() {
        this.inspect();
        return this.toInstall;
    }

    public Collection<UpdateElement> getBrokenPlugins() {
        this.inspect();
        return this.broken;
    }

    public void importPlugins(Collection<UpdateElement> collection, File file, File file2) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        for (UpdateElement object : collection) {
            String string = object.getCodeName();
            Collection<String> collection2 = PluginImporter.getPluginFiles(file, string, PluginImporter.locateUpdateTracking(string, file));
            for (String string2 : collection2) {
                PluginImporter.copy(string2, file, file2);
            }
            String string3 = "config/Modules/" + string.replace('.', '-') + ".xml";
            arrayList.add(string3);
        }
        for (String string : arrayList) {
            PluginImporter.copy(string, file, file2);
        }
        PluginImporter.refreshModuleList();
    }

    private static void copy(String string, File file, File file2) throws IOException {
        LOG.finest("Copy " + string + " from " + file + " to " + file2);
        File file3 = new File(file, string);
        assert (file3.exists()) : file3 + " exists.";
        file3 = FileUtil.normalizeFile((File)file3);
        FileObject fileObject = FileUtil.toFileObject((File)file3);
        File file4 = new File(file2, string);
        file4.getParentFile().mkdirs();
        File file5 = file4.getParentFile();
        file5 = FileUtil.normalizeFile((File)file5);
        FileObject fileObject2 = FileUtil.toFileObject((File)file5);
        File file6 = new File(file5, fileObject.getNameExt());
        if (file6.exists() && !file6.delete()) {
            return;
        }
        FileObject fileObject3 = FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)fileObject.getName());
        LOG.finest(fileObject + " was copied to " + fileObject2 + ". Result is: " + fileObject3);
    }

    private static Collection<String> getPluginFiles(File file, String string, File file2) {
        HashSet<String> hashSet = new HashSet<String>();
        LOG.log(Level.FINE, "Read update_tracking " + file2 + " file.");
        Set<String> set = PluginImporter.readModuleFiles(PluginImporter.getUpdateTrackingConf(file2));
        String string2 = "config/Modules/" + string.replace('.', '-') + ".xml";
        set.remove(string2);
        for (String string3 : set) {
            File file3 = new File(file, string3);
            if (!file3.exists()) {
                LOG.log(Level.WARNING, "File " + file3 + " doesn't exist for module " + string);
                continue;
            }
            if (file3.equals(file2)) continue;
            hashSet.add(string3);
        }
        hashSet.add("update_tracking/" + string.replace('.', '-') + ".xml");
        LOG.log(Level.FINEST, string + " has files: " + hashSet);
        return hashSet;
    }

    private static File locateUpdateTracking(String string, File file) {
        String string2 = "update_tracking/" + string.replace('.', '-') + ".xml";
        File file2 = new File(file, string2);
        if (file2.exists()) {
            return file2;
        }
        throw new IllegalArgumentException(file2 + " doesn't exist.");
    }

    private static Node getUpdateTrackingConf(File file) {
        Document document = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            InputSource inputSource = new InputSource(bufferedInputStream);
            document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            LOG.log(Level.WARNING, null, sAXException);
            return null;
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
        assert (document.getDocumentElement() != null) : "File " + file + " must contain <module> element.";
        return PluginImporter.getModuleElement(document.getDocumentElement());
    }

    private static Node getModuleElement(Element element) {
        Node node = null;
        assert (ELEMENT_MODULE.equals(element.getTagName())) : "The root element is: module but was: " + element.getTagName();
        NodeList nodeList = element.getElementsByTagName(ELEMENT_VERSION);
        for (int i = 0; i < nodeList.getLength() && (node = PluginImporter.getModuleLastVersion(nodeList.item(i))) == null; ++i) {
        }
        return node;
    }

    private static Node getModuleLastVersion(Node node) {
        Node node2 = node.getAttributes().getNamedItem(ATTR_LAST);
        assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_LAST attribute.";
        if (Boolean.valueOf(node2.getNodeValue()).booleanValue()) {
            return node;
        }
        return null;
    }

    private static Set<String> readModuleFiles(Node node) {
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).hasAttributes()) continue;
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            hashSet.add(namedNodeMap.getNamedItem(ATTR_FILE_NAME).getNodeValue());
            LOG.log(Level.FINE, "File for import: " + namedNodeMap.getNamedItem(ATTR_FILE_NAME).getNodeValue());
        }
        return hashSet;
    }

    private static void refreshModuleList() {
        final FileObject fileObject = FileUtil.getConfigFile((String)MODULES);
        LOG.log(Level.FINE, "It's a hack: Call refresh on " + fileObject + " file object.");
        if (fileObject != null) {
            try {
                FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        fileObject.getParent().refresh();
                        fileObject.refresh();
                    }
                });
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static void touchLastModified(File file) {
        try {
            File file2 = new File(file, LAST_MODIFIED);
            if (!file2.createNewFile()) {
                file2.setLastModified(System.currentTimeMillis());
                if (!file2.setLastModified(System.currentTimeMillis())) {
                    file2.delete();
                    file2 = new File(file, LAST_MODIFIED);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

