/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.highlight.semantic.ModelUtils;
import org.netbeans.modules.cnd.highlight.semantic.SemanticHighlighter;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.EditorAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.OpenedEditors;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public final class SemanticHighlighterFactory
extends EditorAwareCsmFileTaskFactory
implements PropertyChangeListener {
    public SemanticHighlighterFactory() {
        SemanticHighlightingOptions.instance().addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        for (FileObject fileObject : OpenedEditors.getDefault().getVisibleEditorsFiles()) {
            this.reschedule(fileObject);
        }
    }

    protected CsmFileTaskFactory.PhaseRunner createTask(FileObject fileObject) {
        CsmFileTaskFactory.PhaseRunner phaseRunner = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            StyledDocument styledDocument = editorCookie.getDocument();
            if (styledDocument != null) {
                phaseRunner = new SemanticHighlighter(styledDocument);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        return phaseRunner != null ? phaseRunner : SemanticHighlighterFactory.lazyRunner();
    }

    protected int taskDelay() {
        return ModelUtils.SEMANTIC_DELAY;
    }

    protected int rescheduleDelay() {
        return ModelUtils.RESCHEDULE_SEMANTIC_DELAY;
    }
}

