/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.openide.util.NbBundle;

public class IncludeErrorProvider
extends CsmErrorProvider {
    public String getName() {
        return "include-errors";
    }

    protected void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile csmFile = request.getFile();
        for (CsmInclude csmInclude : CsmFileInfoQuery.getDefault().getBrokenIncludes(csmFile)) {
            if (request.isCancelled()) break;
            if (csmInclude.getIncludeFile() != null) continue;
            response.addError((CsmErrorInfo)new IncludeErrorInfo(csmInclude));
        }
        for (CsmInclude csmInclude : csmFile.getErrors()) {
            response.addError((CsmErrorInfo)new ErrorDirectiveInfo((CsmErrorDirective)csmInclude));
        }
    }

    private static class ErrorDirectiveInfo
    extends OffsetableErrorInfo
    implements CsmErrorInfo {
        private String message = NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_ErrorDirective");

        public ErrorDirectiveInfo(CsmErrorDirective csmErrorDirective) {
            super((CsmOffsetable)csmErrorDirective, CsmErrorInfo.Severity.ERROR);
        }

        public String getMessage() {
            return this.message;
        }
    }

    private static class IncludeErrorInfo
    extends OffsetableErrorInfo
    implements CsmErrorInfo {
        private String message;

        public IncludeErrorInfo(CsmInclude csmInclude) {
            super((CsmOffsetable)csmInclude, CsmErrorInfo.Severity.ERROR);
            this.message = NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_IncludeMissed", (Object)IncludeErrorInfo.getIncludeText(csmInclude));
        }

        public String getMessage() {
            return this.message;
        }

        private static String getIncludeText(CsmInclude csmInclude) {
            if (csmInclude.isSystem()) {
                return "<" + csmInclude.getIncludeName() + ">";
            }
            return "\"" + csmInclude.getIncludeName() + "\"";
        }
    }

    private static abstract class OffsetableErrorInfo
    implements CsmErrorInfo {
        private int start;
        private int end;
        private CsmErrorInfo.Severity severity;

        public OffsetableErrorInfo(CsmOffsetable csmOffsetable, CsmErrorInfo.Severity severity) {
            this.start = csmOffsetable.getStartOffset();
            this.end = csmOffsetable.getEndOffset();
            this.severity = severity;
        }

        public int getEndOffset() {
            return this.end;
        }

        public int getStartOffset() {
            return this.start;
        }

        public CsmErrorInfo.Severity getSeverity() {
            return this.severity;
        }
    }
}

