/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.netbeans.modules.db.dataview.util.JXDateTimePicker;

class DateTimePickerCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private boolean editable = true;
    private JXDateTimePicker datePicker;
    private DateFormat dateFormat;
    private ActionListener pickerActionListener;
    private boolean ignoreAction;
    private JTable table;

    public DateTimePickerCellEditor() {
        this(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    public DateTimePickerCellEditor(DateFormat dateFormat) {
        this.dateFormat = dateFormat != null ? dateFormat : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.datePicker = new JXDateTimePicker();
        this.datePicker.getEditor().setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.datePicker.setFont(UIManager.getDefaults().getFont("TextField.font"));
        if (dateFormat != null) {
            this.datePicker.setFormats(dateFormat);
        }
        this.datePicker.addActionListener(this.getPickerActionListener());
    }

    public Timestamp getCellEditorValue() {
        return this.datePicker.getDateTime();
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= 2;
        }
        return super.isCellEditable(eventObject);
    }

    public boolean stopCellEditing() {
        this.ignoreAction = true;
        boolean bl = this.commitChange();
        this.ignoreAction = false;
        if (bl) {
            this.datePicker.setDateTime(null);
            return super.stopCellEditing();
        }
        return false;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.table = jTable;
        this.ignoreAction = true;
        this.datePicker.setDateTime(this.getValueAsTimestamp(object));
        this.ignoreAction = false;
        this.setEditable(n2, this.datePicker);
        return this.datePicker;
    }

    protected Timestamp getValueAsTimestamp(Object object) {
        if (this.isEmpty(object) || DataViewUtils.isSQLConstantString(object)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Long) {
            return new Timestamp((Long)object);
        }
        if (object instanceof String) {
            try {
                return new Timestamp(this.dateFormat.parse((String)object).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Timestamp(System.currentTimeMillis());
    }

    protected boolean isEmpty(Object object) {
        return object == null || object instanceof String && ((String)object).length() == 0;
    }

    protected boolean commitChange() {
        try {
            this.datePicker.commitEdit();
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public DateFormat[] getFormats() {
        return this.datePicker.getFormats();
    }

    public void setFormats(DateFormat ... dateFormatArray) {
        this.datePicker.setFormats(dateFormatArray);
    }

    protected ActionListener getPickerActionListener() {
        if (this.pickerActionListener == null) {
            this.pickerActionListener = this.createPickerActionListener();
        }
        return this.pickerActionListener;
    }

    protected ActionListener createPickerActionListener() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DateTimePickerCellEditor.this.ignoreAction) {
                    return;
                }
                this.terminateEdit(actionEvent);
            }

            private void terminateEdit(ActionEvent actionEvent) {
                if (actionEvent != null && "datePickerCommit".equals(actionEvent.getActionCommand())) {
                    DateTimePickerCellEditor.this.stopCellEditing();
                } else {
                    DateTimePickerCellEditor.this.cancelCellEditing();
                }
            }
        };
        return actionListener;
    }

    protected void setEditable(int n, JXDateTimePicker jXDateTimePicker) {
        assert (this.table != null);
        DBColumn dBColumn = ((ResultSetJXTable)((Object)this.table)).getDBColumn(n);
        this.editable = dBColumn.isGenerated() ? false : (!((ResultSetJXTable)((Object)this.table)).dView.isEditable() ? false : dBColumn.isEditable());
        jXDateTimePicker.setEditable(this.editable);
    }

    protected void addKeyListener(KeyListener keyListener) {
        this.datePicker.addKeyListener(keyListener);
    }
}

