/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBMetaDataFactory;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.SQLStatementExecutor;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SQLExecutionHelper {
    private final DataView dataView;
    private final DatabaseConnection dbConn;
    private static Logger mLogger = Logger.getLogger(SQLExecutionHelper.class.getName());
    private final RequestProcessor rp = new RequestProcessor("SQLStatementExecution", 1, true);
    private static final String LIMIT_CLAUSE = " LIMIT ";
    public static final String OFFSET_CLAUSE = " OFFSET ";
    private static Logger LOGGER = Logger.getLogger(SQLExecutionHelper.class.getName());

    SQLExecutionHelper(DataView dataView, DatabaseConnection databaseConnection) {
        this.dataView = dataView;
        this.dbConn = databaseConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void initialDataLoad(DataView dataView, DatabaseConnection databaseConnection, SQLExecutionHelper sQLExecutionHelper) throws SQLException {
        boolean bl;
        String string;
        Statement statement;
        block14: {
            ResultSet resultSet;
            DBMetaDataFactory dBMetaDataFactory;
            block12: {
                block13: {
                    Connection connection;
                    block10: {
                        block11: {
                            block9: {
                                statement = null;
                                try {
                                    connection = DBConnectionFactory.getInstance().getConnection(databaseConnection);
                                    String string2 = "";
                                    if (connection != null) break block9;
                                    Throwable throwable = DBConnectionFactory.getInstance().getLastException();
                                    string2 = throwable != null ? throwable.getMessage() : NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_connection_failure", (Object)dataView.getDatabaseConnection());
                                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
                                }
                                catch (Throwable throwable) {
                                    DataViewUtils.closeResources(statement);
                                    throw throwable;
                                }
                                DataViewUtils.closeResources(statement);
                                return;
                            }
                            dBMetaDataFactory = new DBMetaDataFactory(connection);
                            dataView.setLimitSupported(dBMetaDataFactory.supportsLimit());
                            string = dataView.getSQLString();
                            bl = sQLExecutionHelper.isSelectStatement(string);
                            statement = sQLExecutionHelper.prepareSQLStatement(connection, string);
                            sQLExecutionHelper.executeSQLStatement(statement, string);
                            if (dataView.getUpdateCount() == -1) break block10;
                            if (connection.getAutoCommit()) break block11;
                            connection.commit();
                        }
                        DataViewUtils.closeResources(statement);
                        return;
                    }
                    resultSet = null;
                    resultSet = statement.getResultSet();
                    if (resultSet != null) break block12;
                    if (connection.getAutoCommit()) break block13;
                    connection.commit();
                }
                DataViewUtils.closeResources(resultSet);
                DataViewUtils.closeResources(statement);
                return;
            }
            Collection<DBTable> collection = dBMetaDataFactory.generateDBTables(resultSet, string, bl);
            DataViewDBTable dataViewDBTable = new DataViewDBTable(collection);
            dataView.setDataViewDBTable(dataViewDBTable);
            sQLExecutionHelper.loadDataFrom(resultSet);
            break block14;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                DataViewUtils.closeResources(resultSet);
            }
        }
        sQLExecutionHelper.getTotalCount(bl, string, statement);
        DataViewUtils.closeResources(statement);
    }

    void executeInsertRow(final String string, final Object[] objectArray) {
        String string2 = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_insert");
        SQLStatementExecutor sQLStatementExecutor = new SQLStatementExecutor(this.dataView, string2, ""){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                PreparedStatement preparedStatement = this.conn.prepareStatement(string);
                try {
                    int n;
                    int n2 = 1;
                    for (n = 0; n < objectArray.length; ++n) {
                        Object object = objectArray[n];
                        if (DataViewUtils.isSQLConstantString(object)) continue;
                        int n3 = this.dataView.getDataViewDBTable().getColumnType(n);
                        DBReadWriteHelper.setAttributeValue(preparedStatement, n2++, n3, object);
                    }
                    SQLExecutionHelper.this.executePreparedStatement(preparedStatement);
                    n = this.dataView.getUpdateCount();
                    if (n != 1) {
                        this.error = true;
                        this.errorMsg = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_failure_insert_rows");
                    }
                }
                finally {
                    DataViewUtils.closeResources(preparedStatement);
                }
            }

            public void finished() {
                this.dataView.setEditable(true);
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_insert_command"));
            }

            protected void executeOnSucess() {
                if (this.dataView.getDataViewPageContext().getTotalRows() < 0) {
                    this.dataView.getDataViewPageContext().setTotalRows(0);
                    this.dataView.getDataViewPageContext().first();
                }
                this.dataView.incrementRowSize(1);
                if (this.dataView.getDataViewPageContext().refreshRequiredOnInsert()) {
                    SQLExecutionHelper.this.executeQuery();
                } else {
                    this.reinstateToolbar();
                }
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)sQLStatementExecutor);
        sQLStatementExecutor.setTask(task);
        task.schedule(0);
    }

    void executeDeleteRow(final DataViewTableUI dataViewTableUI) {
        String string = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_delete");
        final int[] nArray = dataViewTableUI.getSelectedRows();
        SQLStatementExecutor sQLStatementExecutor = new SQLStatementExecutor(this.dataView, string, ""){

            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                for (int i = 0; i < nArray.length && !this.error && !Thread.currentThread().isInterrupted(); ++i) {
                    this.deleteARow(nArray[i], dataViewTableUI.getModel());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void deleteARow(int n, TableModel tableModel) throws SQLException, DBException {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                SQLStatementGenerator sQLStatementGenerator = this.dataView.getSQLStatementGenerator();
                String string = sQLStatementGenerator.generateDeleteStatement(arrayList2, arrayList, n, tableModel);
                PreparedStatement preparedStatement = this.conn.prepareStatement(string);
                try {
                    int n2 = 1;
                    for (Object e : arrayList) {
                        DBReadWriteHelper.setAttributeValue(preparedStatement, n2, (Integer)arrayList2.get(n2 - 1), e);
                        ++n2;
                    }
                    SQLExecutionHelper.this.executePreparedStatement(preparedStatement);
                    int n3 = this.dataView.getUpdateCount();
                    if (n3 == 0) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_match_to_delete");
                    } else if (n3 > 1) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_unique_row_for_match");
                    }
                }
                finally {
                    DataViewUtils.closeResources(preparedStatement);
                }
            }

            public void finished() {
                this.dataView.setEditable(true);
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_delete_command"));
            }

            protected void executeOnSucess() {
                this.dataView.decrementRowSize(nArray.length);
                SQLExecutionHelper.this.executeQuery();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)sQLStatementExecutor);
        sQLStatementExecutor.setTask(task);
        task.schedule(0);
    }

    void executeUpdateRow(final DataViewTableUI dataViewTableUI, final boolean bl) {
        String string = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_update");
        SQLStatementExecutor sQLStatementExecutor = new SQLStatementExecutor(this.dataView, string, ""){
            private PreparedStatement pstmt;
            Set<Integer> keysToRemove;
            {
                super(dataView, string, string2);
                this.keysToRemove = new HashSet<Integer>();
            }

            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                if (bl) {
                    this.updateSelected();
                } else {
                    for (Integer n : this.dataView.getUpdatedRowContext().getUpdateKeys()) {
                        if (Thread.currentThread().isInterrupted()) break;
                        this.updateARow(n);
                        this.keysToRemove.add(n);
                    }
                }
            }

            private void updateSelected() throws SQLException, DBException {
                int[] nArray = dataViewTableUI.getSelectedRows();
                UpdatedRowContext updatedRowContext = this.dataView.getUpdatedRowContext();
                block0: for (int i = 0; i < nArray.length && !this.error; ++i) {
                    Set<Integer> set = updatedRowContext.getUpdateKeys();
                    for (Integer n : set) {
                        if (Thread.currentThread().isInterrupted()) continue block0;
                        if (n != nArray[i]) continue;
                        this.updateARow(n);
                        this.keysToRemove.add(n);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateARow(Integer n) throws SQLException, DBException {
                UpdatedRowContext updatedRowContext = this.dataView.getUpdatedRowContext();
                SQLStatementGenerator sQLStatementGenerator = this.dataView.getSQLStatementGenerator();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                String string = sQLStatementGenerator.generateUpdateStatement(n, updatedRowContext.getChangedData(n), arrayList, arrayList2, dataViewTableUI.getModel());
                this.pstmt = this.conn.prepareStatement(string);
                int n2 = 1;
                for (Object e : arrayList) {
                    if (DataViewUtils.isSQLConstantString(e)) continue;
                    DBReadWriteHelper.setAttributeValue(this.pstmt, n2, (Integer)arrayList2.get(n2 - 1), e);
                    ++n2;
                }
                try {
                    SQLExecutionHelper.this.executePreparedStatement(this.pstmt);
                    int n3 = this.dataView.getUpdateCount();
                    if (n3 == 0) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_match_to_update");
                    } else if (n3 > 1) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_unique_row_for_match");
                    }
                }
                finally {
                    DataViewUtils.closeResources(this.pstmt);
                }
            }

            public void finished() {
                this.dataView.setEditable(true);
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_update_command"));
            }

            protected void executeOnSucess() {
                UpdatedRowContext updatedRowContext = this.dataView.getUpdatedRowContext();
                for (Integer n : this.keysToRemove) {
                    updatedRowContext.removeUpdateForSelectedRow(n);
                }
                this.dataView.syncPageWithTableModel();
                this.reinstateToolbar();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)sQLStatementExecutor);
        sQLStatementExecutor.setTask(task);
        task.schedule(0);
    }

    void executeTruncate() {
        String string = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_truncate_table_progress");
        String string2 = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_truncate");
        SQLStatementExecutor sQLStatementExecutor = new SQLStatementExecutor(this.dataView, string2, string){
            private PreparedStatement stmt;
            {
                this.stmt = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws SQLException, DBException {
                DBTable dBTable = this.dataView.getDataViewDBTable().geTable(0);
                String string = "TRUNCATE TABLE " + dBTable.getFullyQualifiedName(true);
                try {
                    this.stmt = this.conn.prepareStatement(string);
                    SQLExecutionHelper.this.executePreparedStatement(this.stmt);
                }
                catch (SQLException sQLException) {
                    mLogger.log(Level.FINE, "TRUNCATE Not supported...will try DELETE * \n");
                    string = "DELETE FROM " + dBTable.getFullyQualifiedName(true);
                    this.stmt = this.conn.prepareStatement(string);
                    SQLExecutionHelper.this.executePreparedStatement(this.stmt);
                }
                finally {
                    DataViewUtils.closeResources(this.stmt);
                }
            }

            public void finished() {
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_truncate_command"));
            }

            protected void executeOnSucess() {
                this.dataView.getDataViewPageContext().setTotalRows(0);
                this.dataView.getDataViewPageContext().first();
                SQLExecutionHelper.this.executeQuery();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)sQLStatementExecutor);
        sQLStatementExecutor.setTask(task);
        task.schedule(0);
    }

    void executeQuery() {
        String string = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_executequery");
        SQLStatementExecutor sQLStatementExecutor = new SQLStatementExecutor(this.dataView, string, this.dataView.getSQLString()){
            private ResultSet rs;
            private Statement stmt;
            boolean lastEditState;
            {
                this.rs = null;
                this.stmt = null;
                this.lastEditState = this.dataView.isEditable();
            }

            public void execute() throws SQLException, DBException {
                String string;
                block8: {
                    this.dataView.setEditable(false);
                    string = this.dataView.getSQLString();
                    this.stmt = SQLExecutionHelper.this.prepareSQLStatement(this.conn, string);
                    try {
                        SQLExecutionHelper.this.executeSQLStatement(this.stmt, string);
                        if (this.dataView.hasResultSet()) {
                            this.rs = this.stmt.getResultSet();
                            SQLExecutionHelper.this.loadDataFrom(this.rs);
                            break block8;
                        }
                        return;
                    }
                    catch (SQLException sQLException) {
                        String string2 = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_error");
                        String string3 = NbBundle.getMessage(SQLExecutionHelper.class, (String)"Confirm_Close");
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)(sQLException.getMessage() + "\n" + string3), string2, 2, 3);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                        if (confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                            this.dataView.removeComponents();
                        }
                        throw sQLException;
                    }
                    finally {
                        DataViewUtils.closeResources(this.rs);
                    }
                }
                if (this.dataView.getDataViewPageContext().getTotalRows() == -1) {
                    SQLExecutionHelper.this.getTotalCount(SQLExecutionHelper.this.isSelectStatement(string), string, this.stmt);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished() {
                DataViewUtils.closeResources(this.stmt);
                this.dataView.setEditable(this.lastEditState);
                DataView dataView = this.dataView;
                synchronized (dataView) {
                    if (this.error) {
                        this.dataView.setErrorStatusText(this.ex);
                    }
                    this.dataView.getUpdatedRowContext().removeAllUpdates();
                    this.dataView.resetToolbar(this.error);
                    this.dataView.setRowsInTableModel();
                }
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)sQLStatementExecutor);
        sQLStatementExecutor.setTask(task);
        task.schedule(0);
    }

    void loadDataFrom(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            return;
        }
        int n = this.dataView.getDataViewPageContext().getPageSize();
        int n2 = 0;
        if (!this.dataView.isLimitSupported() || this.isLimitUsedInSelect(this.dataView.getSQLString())) {
            n2 = this.dataView.getDataViewPageContext().getCurrentPos() - 1;
        }
        DataViewDBTable dataViewDBTable = this.dataView.getDataViewDBTable();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n3 = dataViewDBTable.getColumnCount();
        try {
            boolean bl = resultSet.next();
            for (int i = 1; bl && i < n2 + 1; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                bl = resultSet.next();
            }
            for (int i = 0; (n == -1 || n > i) && (bl || resultSet.next()); ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Object[] objectArray = new Object[n3];
                for (int j = 0; j < n3; ++j) {
                    objectArray[j] = DBReadWriteHelper.readResultSet(resultSet, dataViewDBTable.getColumn(j), j + 1);
                }
                arrayList.add(objectArray);
                if (!bl) continue;
                bl = false;
            }
        }
        catch (SQLException sQLException) {
            mLogger.log(Level.SEVERE, "Failed to set up table model" + sQLException);
            throw sQLException;
        }
        finally {
            this.dataView.getDataViewPageContext().setCurrentRows(arrayList);
        }
    }

    void setTotalCount(ResultSet resultSet) {
        try {
            if (resultSet == null) {
                this.dataView.getDataViewPageContext().setTotalRows(-1);
            } else if (resultSet.next()) {
                int n = resultSet.getInt(1);
                this.dataView.getDataViewPageContext().setTotalRows(n);
            }
        }
        catch (SQLException sQLException) {
            mLogger.log(Level.SEVERE, "Could not get total row count " + sQLException);
        }
    }

    private String appendLimitIfRequired(String string) {
        if (this.dataView.isLimitSupported() && this.isSelectStatement(string) && !this.isLimitUsedInSelect(string)) {
            string = string + LIMIT_CLAUSE + this.dataView.getDataViewPageContext().getPageSize();
            string = string + OFFSET_CLAUSE + (this.dataView.getDataViewPageContext().getCurrentPos() - 1);
        }
        return string;
    }

    private Statement prepareSQLStatement(Connection connection, String string) throws SQLException {
        Statement statement = null;
        boolean bl = false;
        if (string.startsWith("{")) {
            statement = connection.prepareCall(string);
        } else if (this.isSelectStatement(string)) {
            statement = connection.createStatement(1003, 1007);
            bl = true;
        } else {
            statement = connection.createStatement();
        }
        int n = this.dataView.getDataViewPageContext().getPageSize();
        try {
            statement.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.WARNING, "Unable to set Fetch size" + sQLException);
        }
        try {
            if (this.dataView.isLimitSupported() && bl && string.toUpperCase().indexOf(LIMIT_CLAUSE) == -1) {
                statement.setMaxRows(n);
            } else {
                statement.setMaxRows(this.dataView.getDataViewPageContext().getCurrentPos() + n);
            }
        }
        catch (SQLException sQLException) {
            mLogger.log(Level.WARNING, "Unable to set Max row size" + sQLException);
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQLStatement(Statement statement, String string) throws SQLException {
        mLogger.log(Level.FINE, "Statement: " + string);
        this.dataView.setInfoStatusText(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_executestmt") + string);
        long l = System.currentTimeMillis();
        boolean bl = false;
        if (statement instanceof PreparedStatement) {
            bl = ((PreparedStatement)statement).execute();
        } else {
            try {
                bl = statement.execute(this.appendLimitIfRequired(string));
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 1064 && sQLException.getSQLState().equals("37000")) {
                    bl = statement.execute(string);
                }
                mLogger.log(Level.SEVERE, "Failed to execute SQL Statement" + sQLException);
                throw sQLException;
            }
        }
        long l2 = System.currentTimeMillis() - l;
        DataView dataView = this.dataView;
        synchronized (dataView) {
            this.dataView.setHasResultSet(bl);
            this.dataView.setUpdateCount(statement.getUpdateCount());
            this.dataView.setExecutionTime(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        long l = System.currentTimeMillis();
        boolean bl = preparedStatement.execute();
        long l2 = System.currentTimeMillis() - l;
        String string = SQLExecutionHelper.millisecondsToSeconds(l2);
        this.dataView.setInfoStatusText(NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_execution_success", (Object)string));
        DataView dataView = this.dataView;
        synchronized (dataView) {
            this.dataView.setHasResultSet(bl);
            this.dataView.setUpdateCount(preparedStatement.getUpdateCount());
            this.dataView.setExecutionTime(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getTotalCount(boolean bl, String string, Statement statement) {
        if (bl && this.isLimitUsedInSelect(string)) {
            try {
                String string2 = string.toUpperCase().split(LIMIT_CLAUSE)[1].trim();
                int n = Integer.parseInt(string2.split(" ")[0]);
                this.dataView.getDataViewPageContext().setTotalRows(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ResultSet resultSet = null;
        if (bl) {
            try {
                resultSet = statement.executeQuery(SQLStatementGenerator.getCountAsSubQuery(string));
                this.setTotalCount(resultSet);
            }
            catch (SQLException sQLException) {
                DataViewUtils.closeResources(resultSet);
                catch (Throwable throwable) {
                    DataViewUtils.closeResources(resultSet);
                    throw throwable;
                }
            }
            DataViewUtils.closeResources(resultSet);
            return;
        }
        if (bl && !this.isGroupByUsedInSelect(string)) {
            resultSet = null;
            try {
                resultSet = statement.executeQuery(SQLStatementGenerator.getCountSQLQuery(string));
                this.setTotalCount(resultSet);
                return;
            }
            catch (SQLException sQLException) {
            }
            finally {
                DataViewUtils.closeResources(resultSet);
            }
        }
        resultSet = null;
        int n = 0;
        try {
            int n2 = this.dataView.getDataViewPageContext().getPageSize();
            try {
                n2 = statement.getFetchSize();
                statement.setFetchSize(20000);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                ++n;
            }
            this.dataView.getDataViewPageContext().setTotalRows(n);
            try {
                statement.setFetchSize(n2);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return;
        }
        catch (SQLException sQLException) {
        }
        finally {
            DataViewUtils.closeResources(resultSet);
        }
        this.setTotalCount(null);
    }

    private boolean isSelectStatement(String string) {
        return string.trim().toUpperCase().startsWith("SELECT");
    }

    private boolean isLimitUsedInSelect(String string) {
        return string.toUpperCase().indexOf(LIMIT_CLAUSE) != -1;
    }

    private boolean isGroupByUsedInSelect(String string) {
        return string.toUpperCase().indexOf(" GROUP BY ") != -1 || string.toUpperCase().indexOf(" COUNT(*) ") != -1;
    }

    static String millisecondsToSeconds(long l) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        return numberFormat.format((double)l / 1000.0);
    }
}

