/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.sql.Connection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.spi.DBConnectionProvider;
import org.openide.util.Mutex;

public final class DBConnectionFactory {
    private static volatile DBConnectionFactory INSTANCE = null;
    private volatile Throwable ex = null;
    private static Logger mLogger = Logger.getLogger(DBConnectionFactory.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBConnectionFactory getInstance() {
        Class<DBConnectionFactory> clazz = DBConnectionFactory.class;
        synchronized (DBConnectionFactory.class) {
            if (INSTANCE == null && INSTANCE == null) {
                INSTANCE = new DBConnectionFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private DBConnectionFactory() {
    }

    public void closeConnection(Connection connection) {
        DBConnectionProvider dBConnectionProvider = this.findDBConnectionProvider();
        if (dBConnectionProvider != null) {
            dBConnectionProvider.closeConnection(connection);
        }
    }

    public Connection getConnection(DatabaseConnection databaseConnection) {
        DBConnectionProvider dBConnectionProvider = this.findDBConnectionProvider();
        this.ex = null;
        try {
            if (dBConnectionProvider != null) {
                return dBConnectionProvider.getConnection(databaseConnection);
            }
            return this.showConnectionDialog(databaseConnection);
        }
        catch (Exception exception) {
            mLogger.log(Level.WARNING, "Failed to set connection:" + exception);
            this.ex = exception;
            return null;
        }
    }

    public Throwable getLastException() {
        return this.ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection showConnectionDialog(final DatabaseConnection databaseConnection) {
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                if (databaseConnection == null) {
                    return null;
                }
                Connection connection = databaseConnection.getJDBCConnection(!SwingUtilities.isEventDispatchThread());
                if (connection == null) {
                    ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
                }
                return null;
            }
        });
        Class<DBConnectionFactory> clazz = DBConnectionFactory.class;
        synchronized (DBConnectionFactory.class) {
            if (databaseConnection != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return databaseConnection.getJDBCConnection(!SwingUtilities.isEventDispatchThread());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    private DBConnectionProvider findDBConnectionProvider() {
        Iterator<DBConnectionProvider> iterator = ServiceRegistry.lookupProviders(DBConnectionProvider.class);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        ClassLoader classLoader = DBConnectionFactory.class.getClassLoader();
        iterator = ServiceRegistry.lookupProviders(DBConnectionProvider.class, classLoader);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

