/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.mercurial;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

class MercurialHyperlink
implements OutputListener {
    private static final Logger LOG = Logger.getLogger(MercurialHyperlink.class.getName());
    private final URI repo;
    private final String node;
    private final HudsonJobChangeItem.HudsonJobChangeFile file;
    private static final Map<String, String> parents = new HashMap<String, String>();
    private static final Pattern PARENT_COMMENT = Pattern.compile("# Parent +([0-9a-f]{40})");

    MercurialHyperlink(URI uRI, String string, HudsonJobChangeItem.HudsonJobChangeFile hudsonJobChangeFile) {
        this.repo = uRI;
        this.node = string;
        this.file = hudsonJobChangeFile;
    }

    public void outputLineAction(OutputEvent outputEvent) {
        HudsonSCM.Helper.noteWillShowDiff((String)this.file.getName());
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    StreamSource streamSource = MercurialHyperlink.this.makeSource(false);
                    StreamSource streamSource2 = MercurialHyperlink.this.makeSource(true);
                    HudsonSCM.Helper.showDiff((StreamSource)streamSource, (StreamSource)streamSource2, (String)MercurialHyperlink.this.file.getName());
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, null, iOException);
                }
            }
        });
    }

    public void outputLineSelected(OutputEvent outputEvent) {
    }

    public void outputLineCleared(OutputEvent outputEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSource makeSource(boolean bl) throws IOException {
        Object object;
        Object object2;
        String string;
        StringReader stringReader;
        if (this.file.getEditType() == (bl ? HudsonJobChangeItem.HudsonJobChangeFile.EditType.delete : HudsonJobChangeItem.HudsonJobChangeFile.EditType.add)) {
            stringReader = new StringReader("");
            string = null;
        } else {
            string = bl ? this.node : MercurialHyperlink.findParent(this.repo, this.node);
            object2 = this.repo.resolve("raw-file/" + string + "/" + this.file.getName()).toURL().openStream();
            try {
                object = new ByteArrayOutputStream();
                FileUtil.copy((InputStream)object2, (OutputStream)object);
                stringReader = new StringReader(((ByteArrayOutputStream)object).toString());
            }
            finally {
                ((InputStream)object2).close();
            }
        }
        object2 = "text/plain";
        object = this.file.getName();
        String string2 = NbBundle.getMessage(MercurialHyperlink.class, (String)"MercurialHyperlink.title", (Object)((String)object).replaceFirst(".+/", ""), (Object)(string != null ? string.substring(0, 12) : "null"));
        return StreamSource.createSource((String)object, (String)string2, (String)object2, (Reader)stringReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String findParent(URI uRI, String string) throws IOException {
        String string2 = parents.get(string);
        if (string2 == null) {
            URL uRL = uRI.resolve("raw-rev/" + string).toURL();
            try {
                InputStream inputStream = uRL.openStream();
                try {
                    String string3;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        Matcher matcher = PARENT_COMMENT.matcher(string3);
                        if (!matcher.matches()) continue;
                        string2 = matcher.group(1);
                        break;
                    }
                }
                finally {
                    inputStream.close();
                }
                if (string2 == null) {
                    throw new IOException("No parent rev spec found");
                }
            }
            catch (IOException iOException) {
                throw (IOException)new IOException("Could not parse " + uRL + ": " + iOException).initCause(iOException);
            }
            parents.put(string, string2);
        }
        return string2;
    }
}

