/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Keymap;
import org.openide.awt.AlwaysEnabledAction;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.JMenuPlus;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.SystemAction;

public class Actions {
    private static Map<Action, Reference<JMenuItem>> menuActionCache;
    private static Object menuActionLock;
    private static RGBImageFilter DISABLED_BUTTON_FILTER;

    private static Icon nonNullIcon(Icon icon) {
        return null;
    }

    public static String findKey(SystemAction systemAction) {
        return Actions.findKey((Action)systemAction);
    }

    private static String findKey(Action action) {
        if (action == null) {
            return null;
        }
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke == null) {
            return null;
        }
        int n = keyStroke.getModifiers();
        String string = "";
        if (n > 0) {
            string = KeyEvent.getKeyModifiersText(n);
            string = string + "+";
        } else if (keyStroke.getKeyCode() == 0) {
            return "";
        }
        string = string + KeyEvent.getKeyText(keyStroke.getKeyCode());
        return string;
    }

    public static void connect(JMenuItem jMenuItem, SystemAction systemAction, boolean bl) {
        Actions.connect(jMenuItem, (Action)systemAction, bl);
    }

    public static void connect(JMenuItem jMenuItem, Action action, boolean bl) {
        for (ButtonActionConnector buttonActionConnector : Lookup.getDefault().lookupAll(ButtonActionConnector.class)) {
            if (!buttonActionConnector.connect(jMenuItem, action, bl)) continue;
            return;
        }
        MenuBridge menuBridge = new MenuBridge(jMenuItem, action, bl);
        if (jMenuItem instanceof MenuItem) {
            ((MenuItem)jMenuItem).setBridge(menuBridge);
        }
        ((Bridge)menuBridge).updateState(null);
        if (!bl) {
            Actions.setMenuActionConnection(jMenuItem, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setMenuActionConnection(JMenuItem jMenuItem, Action action) {
        Object object = menuActionLock;
        synchronized (object) {
            if (menuActionCache == null) {
                menuActionCache = new WeakHashMap<Action, Reference<JMenuItem>>();
                Keymap keymap = (Keymap)Lookup.getDefault().lookup(Keymap.class);
                if (keymap instanceof Observable) {
                    ((Observable)((Object)keymap)).addObserver(new Observer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void update(Observable observable, Object object) {
                            Object object2 = menuActionLock;
                            synchronized (object2) {
                                for (Map.Entry entry : menuActionCache.entrySet()) {
                                    Action action = (Action)entry.getKey();
                                    Reference reference = (Reference)entry.getValue();
                                    JMenuItem jMenuItem = (JMenuItem)reference.get();
                                    if (action == null || jMenuItem == null) continue;
                                    KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                                    KeyStroke keyStroke2 = jMenuItem.getAccelerator();
                                    if (!(keyStroke2 == null && keyStroke != null || keyStroke2 != null && keyStroke == null) && (keyStroke2 == null || keyStroke == null || keyStroke.equals(keyStroke2))) continue;
                                    jMenuItem.setAccelerator(keyStroke);
                                }
                            }
                        }
                    });
                } else {
                    Logger.getLogger(Actions.class.getName()).warning("Keymap is not observable, behaviour described in bug #39508 can reappear.");
                }
            }
            menuActionCache.put(action, new WeakReference<JMenuItem>(jMenuItem));
        }
    }

    public static void connect(JCheckBoxMenuItem jCheckBoxMenuItem, BooleanStateAction booleanStateAction, boolean bl) {
        CheckMenuBridge checkMenuBridge = new CheckMenuBridge(jCheckBoxMenuItem, booleanStateAction, bl);
        ((Bridge)checkMenuBridge).updateState(null);
    }

    public static void connect(AbstractButton abstractButton, SystemAction systemAction) {
        Actions.connect(abstractButton, (Action)systemAction);
    }

    public static void connect(AbstractButton abstractButton, Action action) {
        for (ButtonActionConnector buttonActionConnector : Lookup.getDefault().lookupAll(ButtonActionConnector.class)) {
            if (!buttonActionConnector.connect(abstractButton, action)) continue;
            return;
        }
        ButtonBridge buttonBridge = new ButtonBridge(abstractButton, action);
        ((Bridge)buttonBridge).updateState(null);
    }

    public static void connect(AbstractButton abstractButton, BooleanStateAction booleanStateAction) {
        BooleanButtonBridge booleanButtonBridge = new BooleanButtonBridge(abstractButton, booleanStateAction);
        ((Bridge)booleanButtonBridge).updateState(null);
    }

    public static void setMenuText(AbstractButton abstractButton, String string, boolean bl) {
        if (bl) {
            Mnemonics.setLocalizedText(abstractButton, string);
        } else {
            abstractButton.setText(Actions.cutAmpersand(string));
        }
    }

    public static String cutAmpersand(String string) {
        String string2 = string;
        int n = string.indexOf("(&");
        string2 = n >= 0 && n + 3 < string.length() && string.charAt(n + 3) == ')' ? string.substring(0, n) + string.substring(n + 4) : ((n = string.indexOf(38)) < 0 ? string : (n == string.length() - 1 ? string.substring(0, n) : (" ".equals(string.substring(n + 1, n + 2)) ? string : string.substring(0, n) + string.substring(n + 1))));
        return string2;
    }

    public static Action alwaysEnabled(ActionListener actionListener, String string, String string2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("delegate", actionListener);
        hashMap.put("displayName", string);
        hashMap.put("iconBase", string2);
        hashMap.put("noIconInMenu", bl);
        return Actions.alwaysEnabled(hashMap);
    }

    static Action alwaysEnabled(Map map) {
        return new AlwaysEnabledAction(map);
    }

    private static HelpCtx findHelp(Action action) {
        if (action instanceof HelpCtx.Provider) {
            return ((HelpCtx.Provider)action).getHelpCtx();
        }
        return HelpCtx.DEFAULT_HELP;
    }

    static void prepareMenuBridgeItemsInContainer(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JComponent jComponent;
            MenuBridge menuBridge;
            if (!(componentArray[i] instanceof JComponent) || (menuBridge = (MenuBridge)(jComponent = (JComponent)componentArray[i]).getClientProperty("menubridgeresizehack")) == null) continue;
            menuBridge.updateState(null);
        }
    }

    static void prepareMargins(JMenuItem jMenuItem, Action action) {
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setHorizontalAlignment(2);
    }

    static void updateKey(JMenuItem jMenuItem, Action action) {
        if (!(jMenuItem instanceof JMenu)) {
            jMenuItem.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
        }
    }

    private static Icon createDisabledIcon(Image image) {
        return new LazyDisabledIcon(image);
    }

    private static RGBImageFilter disabledButtonFilter() {
        if (DISABLED_BUTTON_FILTER == null) {
            DISABLED_BUTTON_FILTER = new DisabledButtonFilter();
        }
        return DISABLED_BUTTON_FILTER;
    }

    static {
        menuActionLock = new Object();
    }

    private static class DisabledButtonFilter
    extends RGBImageFilter {
        DisabledButtonFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return (n3 & 0xFF000000) + 0x888888 + ((n3 >> 16 & 0xFF) >> 2 << 16) + ((n3 >> 8 & 0xFF) >> 2 << 8) + ((n3 & 0xFF) >> 2);
        }

        public void setProperties(Hashtable hashtable) {
            hashtable = (Hashtable)hashtable.clone();
            this.consumer.setProperties(hashtable);
        }
    }

    public static interface ButtonActionConnector {
        public boolean connect(AbstractButton var1, Action var2);

        public boolean connect(JMenuItem var1, Action var2, boolean var3);
    }

    public static class SubMenu
    extends JMenuPlus
    implements DynamicMenuContent {
        static final long serialVersionUID = -4446966671302959091L;
        private SubMenuBridge bridge;

        public SubMenu(SystemAction systemAction, SubMenuModel subMenuModel) {
            this(systemAction, subMenuModel, true);
        }

        public SubMenu(SystemAction systemAction, SubMenuModel subMenuModel, boolean bl) {
            this((Action)systemAction, subMenuModel, bl);
        }

        public SubMenu(Action action, SubMenuModel subMenuModel, boolean bl) {
            this.bridge = new SubMenuBridge(new JMenuItem(), this, action, subMenuModel, bl);
            this.bridge.updateState("Name");
        }

        public JComponent[] getMenuPresenters() {
            return this.bridge.getMenuPresenters();
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return this.bridge.synchMenuPresenters(jComponentArray);
        }
    }

    public static class ToolbarToggleButton
    extends org.openide.awt.ToolbarToggleButton {
        static final long serialVersionUID = -4783163952526348942L;

        public ToolbarToggleButton(BooleanStateAction booleanStateAction) {
            super((Icon)null, false);
            Actions.connect((AbstractButton)this, booleanStateAction);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    public static class ToolbarButton
    extends org.openide.awt.ToolbarButton {
        static final long serialVersionUID = 6564434578524381134L;

        public ToolbarButton(SystemAction systemAction) {
            super((Icon)null);
            Actions.connect((AbstractButton)this, systemAction);
        }

        public ToolbarButton(Action action) {
            super((Icon)null);
            Actions.connect((AbstractButton)this, action);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    public static class CheckboxMenuItem
    extends JCheckBoxMenuItem {
        static final long serialVersionUID = 6190621106981774043L;

        public CheckboxMenuItem(BooleanStateAction booleanStateAction, boolean bl) {
            Actions.connect(this, booleanStateAction, !bl);
        }
    }

    public static class MenuItem
    extends JMenuItem
    implements DynamicMenuContent {
        static final long serialVersionUID = -21757335363267194L;
        private Bridge bridge;

        public MenuItem(SystemAction systemAction, boolean bl) {
            Actions.connect((JMenuItem)this, systemAction, !bl);
        }

        public MenuItem(Action action, boolean bl) {
            Actions.connect((JMenuItem)this, action, !bl);
        }

        void setBridge(Bridge bridge) {
            this.bridge = bridge;
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            if (this.bridge != null) {
                this.bridge.updateState(null);
            }
            return this.getMenuPresenters();
        }

        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this};
        }
    }

    private static final class SubMenuBridge
    extends MenuBridge
    implements ChangeListener,
    DynamicMenuContent {
        private SubMenuModel model;
        private List<JMenuItem> currentOnes;
        private JMenuItem single;
        private JMenu multi;

        public SubMenuBridge(JMenuItem jMenuItem, JMenu jMenu, Action action, SubMenuModel subMenuModel, boolean bl) {
            super(jMenuItem, action, bl);
            this.single = jMenuItem;
            this.multi = jMenu;
            Actions.setMenuText(this.multi, (String)action.getValue("Name"), bl);
            Actions.prepareMargins(jMenuItem, action);
            Actions.prepareMargins(jMenu, action);
            this.currentOnes = new ArrayList<JMenuItem>();
            this.model = subMenuModel;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!EventQueue.isDispatchThread()) {
                new IllegalStateException("This must happen in the event thread!").printStackTrace();
            }
        }

        public void updateState(String string) {
            super.updateState(string);
        }

        public JComponent[] getMenuPresenters() {
            return this.synchMenuPresenters(null);
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            this.currentOnes.clear();
            int n = this.model.getCount();
            if (n == 0) {
                this.updateState(null);
                this.currentOnes.add(this.single);
                this.single.setEnabled(false);
            } else if (n == 1) {
                this.updateState(null);
                this.currentOnes.add(this.single);
                this.single.setEnabled(this.action.isEnabled());
                HelpCtx helpCtx = this.model.getHelpCtx(0);
                this.associateHelp(this.single, helpCtx == null ? Actions.findHelp(this.action) : helpCtx);
            } else {
                this.currentOnes.add(this.multi);
                this.multi.removeAll();
                Mnemonics.setLocalizedText(this.multi, (String)this.action.getValue("Name"));
                boolean bl = false;
                int n2 = this.model.getCount();
                for (int i = 0; i < n2; ++i) {
                    String string = this.model.getLabel(i);
                    if (string == null) {
                        bl = this.multi.getItemCount() > 0;
                    } else {
                        if (bl) {
                            this.multi.addSeparator();
                            bl = false;
                        }
                        JMenuItem jMenuItem = new JMenuItem();
                        Mnemonics.setLocalizedText(jMenuItem, string);
                        if (i == 0) {
                            Actions.updateKey(jMenuItem, this.action);
                        }
                        jMenuItem.addActionListener(new ISubActionListener(i, this.model));
                        HelpCtx helpCtx = this.model.getHelpCtx(i);
                        this.associateHelp(jMenuItem, helpCtx == null ? Actions.findHelp(this.action) : helpCtx);
                        this.multi.add(jMenuItem);
                    }
                    this.associateHelp(this.multi, Actions.findHelp(this.action));
                }
                this.multi.setEnabled(true);
            }
            return this.currentOnes.toArray(new JMenuItem[this.currentOnes.size()]);
        }

        private void associateHelp(JComponent jComponent, HelpCtx helpCtx) {
            if (helpCtx != null && !helpCtx.equals((Object)HelpCtx.DEFAULT_HELP) && helpCtx.getHelpID() != null) {
                HelpCtx.setHelpIDString((JComponent)jComponent, (String)helpCtx.getHelpID());
            } else {
                HelpCtx.setHelpIDString((JComponent)jComponent, null);
            }
        }
    }

    private static class ISubActionListener
    implements ActionListener {
        int index;
        SubMenuModel support;

        public ISubActionListener(int n, SubMenuModel subMenuModel) {
            this.index = n;
            this.support = subMenuModel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.support.performActionAt(this.index);
        }
    }

    private static final class CheckMenuBridge
    extends BooleanButtonBridge {
        private boolean popup;
        private boolean hasOwnIcon = false;

        public CheckMenuBridge(JCheckBoxMenuItem jCheckBoxMenuItem, BooleanStateAction booleanStateAction, boolean bl) {
            super((AbstractButton)jCheckBoxMenuItem, booleanStateAction);
            this.popup = bl;
            if (bl) {
                Actions.prepareMargins(jCheckBoxMenuItem, (Action)booleanStateAction);
            }
            Object object = booleanStateAction.getValue("iconBase");
            Object object2 = null;
            object2 = booleanStateAction instanceof SystemAction ? booleanStateAction.getValue("icon") : booleanStateAction.getValue("SmallIcon");
            this.hasOwnIcon = object != null || object2 != null;
        }

        public void updateState(String string) {
            Object object;
            super.updateState(string);
            if (string == null || !string.equals("AcceleratorKey")) {
                Actions.updateKey((JMenuItem)this.comp, this.action);
            }
            if ((string == null || string.equals("Name")) && (object = this.action.getValue("Name")) instanceof String) {
                Actions.setMenuText((JMenuItem)this.comp, (String)object, true);
            }
        }

        protected void updateButtonIcon() {
            if (this.hasOwnIcon) {
                super.updateButtonIcon();
                return;
            }
            if (!this.popup) {
                boolean bl = "1.6".compareTo(System.getProperty("java.version")) <= 0;
                this.button.setIcon(ImageUtilities.loadImageIcon((String)(bl ? "org/openide/resources/actions/empty.gif" : "org/openide/resources/actions/gap.gif"), (boolean)true));
            }
        }

        protected boolean useTextIcons() {
            return false;
        }
    }

    private static class MenuBridge
    extends ButtonBridge {
        private boolean popup;

        public MenuBridge(JMenuItem jMenuItem, Action action, boolean bl) {
            super(jMenuItem, action);
            this.popup = bl;
            if (jMenuItem instanceof MenuItem) {
                this.comp.removePropertyChangeListener(this.listener);
            }
            if (bl) {
                Actions.prepareMargins(jMenuItem, action);
            } else {
                jMenuItem.putClientProperty("menubridgeresizehack", this);
            }
        }

        public void updateState(String string) {
            if (this.button == null) {
                this.button = (AbstractButton)this.comp;
            }
            if (string == null || string.equals("enabled")) {
                this.button.setEnabled(this.action.isEnabled());
            }
            if (string == null || !string.equals("AcceleratorKey")) {
                Actions.updateKey((JMenuItem)this.comp, this.action);
            }
            if (!this.popup && (string == null || string.equals("icon") || string.equals("SmallIcon") || string.equals("iconBase"))) {
                this.updateButtonIcon();
            }
            if (string == null || string.equals("Name")) {
                Object object = null;
                if (this.popup) {
                    object = this.action.getValue("popupText");
                }
                if (object == null) {
                    object = this.action.getValue("menuText");
                }
                if (object == null) {
                    object = this.action.getValue("Name");
                }
                if (object instanceof String) {
                    Actions.setMenuText((JMenuItem)this.comp, (String)object, true);
                }
            }
        }

        protected void updateButtonIcon() {
            Object object;
            Object object2 = null;
            Object object3 = this.action.getValue("noIconInMenu");
            if (Boolean.TRUE.equals(object3)) {
                return;
            }
            if (this.action instanceof SystemAction) {
                object = (SystemAction)this.action;
                object2 = object.getIcon(this.useTextIcons());
                this.button.setIcon((Icon)object2);
                if (object2 instanceof ImageIcon) {
                    this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)object2).getImage()));
                }
            } else {
                object2 = this.action.getValue("SmallIcon");
                if (object2 instanceof Icon) {
                    this.button.setIcon((Icon)object2);
                    if (object2 instanceof ImageIcon) {
                        this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)object2).getImage()));
                    }
                }
            }
            object = this.action.getValue("iconBase");
            if (object instanceof String) {
                Image image;
                Image image2;
                Image image3;
                String string = (String)object;
                Image image4 = null;
                if (object2 == null && (image4 = ImageUtilities.loadImage((String)string, (boolean)true)) != null) {
                    this.button.setIcon(new ImageIcon(image4));
                    this.button.setDisabledIcon(Actions.createDisabledIcon(image4));
                }
                if ((image3 = ImageUtilities.loadImage((String)MenuBridge.insertBeforeSuffix(string, "_pressed"), (boolean)true)) != null) {
                    this.button.setPressedIcon(new ImageIcon(image3));
                }
                if ((image2 = ImageUtilities.loadImage((String)MenuBridge.insertBeforeSuffix(string, "_rollover"), (boolean)true)) != null) {
                    this.button.setRolloverIcon(new ImageIcon(image2));
                }
                if ((image = ImageUtilities.loadImage((String)MenuBridge.insertBeforeSuffix(string, "_disabled"), (boolean)true)) != null) {
                    this.button.setDisabledIcon(new ImageIcon(image));
                } else if (image4 != null) {
                    this.button.setDisabledIcon(Actions.createDisabledIcon(image4));
                }
            }
        }

        protected boolean useTextIcons() {
            return false;
        }
    }

    private static class BooleanButtonBridge
    extends ButtonBridge {
        public BooleanButtonBridge(AbstractButton abstractButton, BooleanStateAction booleanStateAction) {
            super(abstractButton, (Action)booleanStateAction);
        }

        public void updateState(String string) {
            super.updateState(string);
            if (string == null || string.equals("booleanState")) {
                this.button.setSelected(((BooleanStateAction)this.action).getBooleanState());
            }
        }
    }

    private static class ButtonBridge
    extends Bridge
    implements ActionListener {
        private static Logger UILOG = Logger.getLogger("org.netbeans.ui.actions");
        protected AbstractButton button;

        public ButtonBridge(AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
            abstractButton.addActionListener(action);
            this.button = abstractButton;
            abstractButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LogRecord logRecord = new LogRecord(Level.FINER, "UI_ACTION_BUTTON_PRESS");
            logRecord.setParameters(new Object[]{this.button, this.button.getClass().getName(), this.action, this.action.getClass().getName(), this.action.getValue("Name")});
            logRecord.setResourceBundle(NbBundle.getBundle(Actions.class));
            logRecord.setResourceBundleName(Actions.class.getPackage().getName() + ".Bundle");
            logRecord.setLoggerName(UILOG.getName());
            UILOG.log(logRecord);
        }

        protected void updateButtonIcon() {
            Object object;
            Image image;
            String string;
            Object object2 = null;
            Object object3 = this.action.getValue("iconBase");
            boolean bl = true;
            Object object4 = this.button.getClientProperty("PreferredIconSize");
            if (object4 instanceof Integer && (Integer)object4 == 24) {
                bl = false;
            }
            if (this.action instanceof SystemAction) {
                if (object3 instanceof String) {
                    string = (String)object3;
                    image = null;
                    if (!bl) {
                        image = ImageUtilities.loadImage((String)ButtonBridge.insertBeforeSuffix(string, "24"), (boolean)true);
                        if (image == null) {
                            image = ImageUtilities.loadImage((String)string, (boolean)true);
                        }
                    } else {
                        image = ImageUtilities.loadImage((String)string, (boolean)true);
                    }
                    if (image != null) {
                        object2 = new ImageIcon(image);
                        this.button.setIcon((Icon)object2);
                        this.button.setDisabledIcon(Actions.createDisabledIcon(image));
                    } else {
                        object = (SystemAction)this.action;
                        object2 = object.getIcon(this.useTextIcons());
                        this.button.setIcon((Icon)object2);
                        if (object2 instanceof ImageIcon) {
                            this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)object2).getImage()));
                        }
                    }
                } else {
                    string = (SystemAction)this.action;
                    object2 = string.getIcon(this.useTextIcons());
                    this.button.setIcon((Icon)object2);
                    if (object2 instanceof ImageIcon) {
                        this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)object2).getImage()));
                    }
                }
            } else if (object3 instanceof String) {
                string = (String)object3;
                image = null;
                if (!bl) {
                    image = ImageUtilities.loadImage((String)ButtonBridge.insertBeforeSuffix(string, "24"), (boolean)true);
                    if (image == null) {
                        image = ImageUtilities.loadImage((String)string, (boolean)true);
                    }
                } else {
                    image = ImageUtilities.loadImage((String)string, (boolean)true);
                }
                if (image != null) {
                    object2 = new ImageIcon(image);
                    this.button.setIcon((Icon)object2);
                    this.button.setDisabledIcon(Actions.createDisabledIcon(image));
                } else {
                    object2 = this.action.getValue("SmallIcon");
                    if (object2 instanceof Icon) {
                        this.button.setIcon((Icon)object2);
                        if (object2 instanceof ImageIcon) {
                            this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)object2).getImage()));
                        }
                    } else {
                        this.button.setIcon(Actions.nonNullIcon(null));
                    }
                }
            } else {
                object2 = this.action.getValue("SmallIcon");
                if (object2 instanceof Icon) {
                    this.button.setIcon((Icon)object2);
                    if (object2 instanceof ImageIcon) {
                        this.button.setDisabledIcon(Actions.createDisabledIcon(((ImageIcon)object2).getImage()));
                    }
                } else {
                    this.button.setIcon(Actions.nonNullIcon(null));
                }
            }
            if (object3 instanceof String) {
                Image image2;
                Image image3;
                string = (String)object3;
                if (!bl) {
                    string = ButtonBridge.insertBeforeSuffix(string, "24");
                }
                image = null;
                if (object2 == null) {
                    image = ImageUtilities.loadImage((String)string, (boolean)true);
                    if (image != null) {
                        this.button.setIcon(new ImageIcon(image));
                    }
                    object2 = image;
                }
                if ((object = ImageUtilities.loadImage((String)ButtonBridge.insertBeforeSuffix(string, "_pressed"), (boolean)true)) != null) {
                    this.button.setPressedIcon(new ImageIcon((Image)object));
                }
                if ((image3 = ImageUtilities.loadImage((String)ButtonBridge.insertBeforeSuffix(string, "_rollover"), (boolean)true)) != null) {
                    this.button.setRolloverIcon(new ImageIcon(image3));
                }
                if ((image2 = ImageUtilities.loadImage((String)ButtonBridge.insertBeforeSuffix(string, "_disabled"), (boolean)true)) != null) {
                    this.button.setDisabledIcon(ImageUtilities.image2Icon((Image)image2));
                } else if (image != null) {
                    this.button.setDisabledIcon(Actions.createDisabledIcon(image));
                }
            }
        }

        static String insertBeforeSuffix(String string, String string2) {
            String string3 = string;
            String string4 = "";
            if (string.lastIndexOf(46) >= 0) {
                string3 = string.substring(0, string.lastIndexOf(46));
                string4 = string.substring(string.lastIndexOf(46), string.length());
            }
            return string3 + string2 + string4;
        }

        public void updateState(String string) {
            if (string == null || string.equals("enabled")) {
                this.button.setEnabled(this.action.isEnabled());
            }
            if (string == null || string.equals("icon") || string.equals("SmallIcon") || string.equals("iconBase")) {
                this.updateButtonIcon();
            }
            if (string == null || string.equals("AcceleratorKey") || string.equals("Name") && this.action.getValue("ShortDescription") == null || string.equals("ShortDescription")) {
                String string2 = Actions.findKey(this.action);
                String string3 = (String)this.action.getValue("ShortDescription");
                if (string3 == null) {
                    string3 = (String)this.action.getValue("Name");
                    String string4 = string3 = string3 == null ? "" : Actions.cutAmpersand(string3);
                }
                if (string2 == null || string2.equals("")) {
                    this.button.setToolTipText(string3);
                } else {
                    this.button.setToolTipText(NbBundle.getMessage(Actions.class, (String)"FMT_ButtonHint", (Object)string3, (Object)string2));
                }
            }
            if (this.button instanceof Accessible && (string == null || string.equals("Name"))) {
                this.button.getAccessibleContext().setAccessibleName((String)this.action.getValue("Name"));
            }
        }

        protected boolean useTextIcons() {
            return true;
        }
    }

    private static abstract class Bridge
    implements PropertyChangeListener {
        protected JComponent comp;
        protected Action action;
        protected PropertyChangeListener listener;

        public Bridge(JComponent jComponent, Action action) {
            HelpCtx helpCtx;
            if (jComponent == null || action == null) {
                throw new IllegalArgumentException("None of the arguments can be null: comp=" + jComponent + ", action=" + action);
            }
            this.comp = jComponent;
            this.action = action;
            this.listener = new VisL();
            this.comp.addPropertyChangeListener(this.listener);
            if (this.comp.isShowing()) {
                this.addNotify();
            }
            if ((helpCtx = Actions.findHelp(action)) != null && !helpCtx.equals((Object)HelpCtx.DEFAULT_HELP) && helpCtx.getHelpID() != null) {
                HelpCtx.setHelpIDString((JComponent)jComponent, (String)helpCtx.getHelpID());
            }
        }

        public void addNotify() {
            this.action.addPropertyChangeListener(this);
            this.updateState(null);
        }

        public void removeNotify() {
            this.action.removePropertyChangeListener(this);
        }

        public abstract void updateState(String var1);

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!EventQueue.isDispatchThread()) {
                new IllegalStateException("This must happen in the event thread!").printStackTrace();
            }
            this.updateState(propertyChangeEvent.getPropertyName());
        }

        private class VisL
        implements PropertyChangeListener {
            VisL() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("ancestor".equals(propertyChangeEvent.getPropertyName())) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        Bridge.this.addNotify();
                    } else {
                        Bridge.this.removeNotify();
                    }
                }
            }
        }
    }

    public static interface SubMenuModel {
        public int getCount();

        public String getLabel(int var1);

        public HelpCtx getHelpCtx(int var1);

        public void performActionAt(int var1);

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    private static class LazyDisabledIcon
    implements Icon {
        private Image img;
        private Icon disabledIcon;

        public LazyDisabledIcon(Image image) {
            assert (null != image);
            this.img = image;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.getDisabledIcon().paintIcon(component, graphics, n, n2);
        }

        public int getIconWidth() {
            return this.getDisabledIcon().getIconWidth();
        }

        public int getIconHeight() {
            return this.getDisabledIcon().getIconHeight();
        }

        private Icon getDisabledIcon() {
            if (null == this.disabledIcon) {
                FilteredImageSource filteredImageSource = new FilteredImageSource(this.img.getSource(), Actions.disabledButtonFilter());
                this.disabledIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(filteredImageSource), "");
            }
            return this.disabledIcon;
        }
    }
}

