/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.collections.AST;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Utils {
    private static boolean useSystemExit = true;
    private static boolean useDirectClassLoading = false;
    private static final int CHILD = 1;
    private static final int SIBLING = 2;
    private static final int END_AST = 3;

    private Utils() {
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (!useDirectClassLoading && classLoader != null) {
                return classLoader.loadClass(string);
            }
            return Class.forName(string);
        }
        catch (Exception exception) {
            return Class.forName(string);
        }
    }

    public static Object createInstanceOf(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Utils.loadClass(string).newInstance();
    }

    public static void error(String string) {
        if (useSystemExit) {
            System.exit(1);
        }
        throw new RuntimeException("ANTLR Panic: " + string);
    }

    public static void error(String string, Throwable throwable) {
        if (useSystemExit) {
            System.exit(1);
        }
        throw new RuntimeException("ANTLR Panic", throwable);
    }

    public static void writeAST(ObjectOutputStream objectOutputStream, AST aST) throws IOException {
        objectOutputStream.writeObject(aST);
        if (aST != null) {
            Utils.writeTree(objectOutputStream, aST);
        }
    }

    public static AST readAST(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        AST aST = (AST)objectInputStream.readObject();
        if (aST != null) {
            Utils.readTree(objectInputStream, aST);
        }
        return aST;
    }

    private static void writeTree(ObjectOutputStream objectOutputStream, AST aST) throws IOException {
        assert (aST != null) : "there must be something to write";
        AST aST2 = aST;
        do {
            AST aST3;
            if ((aST3 = aST2.getFirstChild()) != null) {
                objectOutputStream.writeInt(1);
                Utils.writeAST(objectOutputStream, aST3);
            }
            if ((aST2 = aST2.getNextSibling()) == null) continue;
            objectOutputStream.writeInt(2);
            objectOutputStream.writeObject(aST2);
        } while (aST2 != null);
        objectOutputStream.writeInt(3);
    }

    private static void readTree(ObjectInputStream objectInputStream, AST aST) throws IOException, ClassNotFoundException {
        assert (aST != null) : "there must be something to read";
        AST aST2 = aST;
        do {
            int n = objectInputStream.readInt();
            switch (n) {
                case 3: {
                    return;
                }
                case 1: {
                    aST2.setFirstChild(Utils.readAST(objectInputStream));
                    break;
                }
                case 2: {
                    AST aST3 = (AST)objectInputStream.readObject();
                    aST2.setNextSibling(aST3);
                    aST2 = aST3;
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } while (aST2 != null);
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("ANTLR_DO_NOT_EXIT", "false"))) {
            useSystemExit = false;
        }
        if ("true".equalsIgnoreCase(System.getProperty("ANTLR_USE_DIRECT_CLASS_LOADING", "false"))) {
            useDirectClassLoading = true;
        }
    }
}

