/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.debug.Context;
import org.jruby.debug.DebugBreakpoint;
import org.jruby.debug.DebugContext;
import org.jruby.debug.DebugEventHook;
import org.jruby.debug.Util;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Debugger {
    private DebugEventHook debugEventHook;
    private Map<RubyThread, Context> threadsTable;
    private IRubyObject breakpoints;
    private IRubyObject catchpoints;
    private boolean tracing;
    private boolean postMortem;
    private boolean keepFrameBinding;
    private boolean debug;
    private boolean trackFrameArgs;
    private IRubyObject lastContext;
    private IRubyObject lastThread;
    private boolean started;
    private int startCount;
    private int lastBreakpointID;
    private DebugContext lastDebugContext;

    Debugger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRubyObject start(IRubyObject recv, Block block) {
        RubyBoolean result;
        Ruby runtime = recv.getRuntime();
        ++this.startCount;
        if (this.started) {
            result = runtime.getFalse();
        } else {
            IRubyObject nil;
            this.lastThread = nil = runtime.getNil();
            this.started = true;
            this.setLastContext(nil);
            this.debugEventHook = new DebugEventHook(this, runtime);
            this.breakpoints = runtime.newArray();
            this.catchpoints = RubyHash.newHash((Ruby)runtime);
            this.threadsTable = new IdentityHashMap<RubyThread, Context>();
            runtime.addEventHook((EventHook)this.debugEventHook);
            result = runtime.getTrue();
        }
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(runtime.getCurrentContext(), recv);
                return iRubyObject;
            }
            finally {
                this.stop(runtime);
            }
        }
        return result;
    }

    boolean stop(Ruby runtime) {
        this.checkStarted(runtime);
        --this.startCount;
        if (this.startCount > 0) {
            return false;
        }
        runtime.removeEventHook((EventHook)this.debugEventHook);
        this.breakpoints = null;
        this.catchpoints = null;
        this.debugEventHook = null;
        this.started = false;
        this.threadsTable = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(IRubyObject recv, IRubyObject[] args) {
        Ruby rt = recv.getRuntime();
        Arity.checkArgumentCount((Ruby)rt, (IRubyObject[])args, (int)1, (int)3);
        IRubyObject[] actual = Arity.scanArgs((Ruby)rt, (IRubyObject[])args, (int)1, (int)2);
        IRubyObject file = args[0];
        IRubyObject stop = actual[1];
        IRubyObject incrementStart = actual[2];
        this.start(recv, Block.NULL_BLOCK);
        if (!incrementStart.isTrue()) {
            --this.startCount;
        }
        IRubyObject context = this.getCurrentContext(recv);
        DebugContext debugContext = (DebugContext)context.dataGetStruct();
        debugContext.clearFrames();
        if (stop.isTrue()) {
            debugContext.setStopNext(1);
        }
        try {
            rt.getLoadService().load(((RubyString)file).toString(), false);
        }
        finally {
            this.stop(rt);
        }
    }

    IRubyObject getCurrentContext(IRubyObject recv) {
        this.checkStarted(recv);
        RubyThread thread = recv.getRuntime().getCurrentContext().getThread();
        return this.contextForThread(thread);
    }

    DebugContext getCurrentDebugContext(IRubyObject recv) {
        this.checkStarted(recv);
        RubyThread thread = recv.getRuntime().getCurrentContext().getThread();
        return this.threadContextLookup((RubyThread)thread, (boolean)true).debugContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebugContextPair threadContextLookup(RubyThread thread, boolean wantDebugContext) {
        this.checkStarted((IRubyObject)thread);
        DebugContextPair ctxs = new DebugContextPair();
        if (this.lastThread == thread && !this.lastContext.isNil()) {
            ctxs.context = (Context)this.lastContext;
            if (wantDebugContext) {
                ctxs.debugContext = this.lastDebugContext;
            }
            return ctxs;
        }
        Map<RubyThread, Context> map = this.threadsTable;
        synchronized (map) {
            ctxs.context = this.threadsTable.get(thread);
            if (ctxs.context == null) {
                ctxs.context = this.debugContextCreate(thread);
                this.threadsTable.put(thread, ctxs.context);
            }
        }
        DebugContext lDebugContext = (DebugContext)ctxs.context.dataGetStruct();
        if (wantDebugContext) {
            ctxs.debugContext = lDebugContext;
        }
        this.lastThread = thread;
        this.setLastContext((IRubyObject)ctxs.context);
        this.lastDebugContext = lDebugContext;
        return ctxs;
    }

    private Context contextForThread(RubyThread thread) {
        return this.threadContextLookup((RubyThread)thread, (boolean)false).context;
    }

    void checkStarted(IRubyObject recv) {
        this.checkStarted(recv.getRuntime());
    }

    void checkStarted(Ruby runtime) {
        if (!this.started) {
            throw runtime.newRuntimeError("Debugger.start is not called yet.");
        }
    }

    private Context debugContextCreate(RubyThread thread) {
        DebugContext debugContext = new DebugContext(thread);
        if (thread.getType().getName().equals("Debugger::DebugThread")) {
            debugContext.setIgnored(true);
        }
        RubyClass cContext = thread.getRuntime().getModule("Debugger").getClass("Context");
        Context context = (Context)cContext.allocate();
        context.dataWrapStruct(debugContext);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRubyObject getDebugContexts(IRubyObject self) {
        this.checkStarted(self);
        RubyArray newList = self.getRuntime().newArray();
        RubyArray list = RubyThread.list((IRubyObject)self);
        Map<RubyThread, Context> map = this.threadsTable;
        synchronized (map) {
            int i;
            for (i = 0; i < list.size(); ++i) {
                RubyThread thread = (RubyThread)list.entry(i);
                Context context = this.contextForThread(thread);
                newList.add((Object)context);
            }
            for (i = 0; i < newList.size(); ++i) {
                Context context = (Context)newList.entry(i);
                DebugContext debugContext = (DebugContext)context.dataGetStruct();
                this.threadsTable.put(debugContext.getThread(), context);
            }
        }
        return newList;
    }

    void suspend(IRubyObject recv) {
        this.checkStarted(recv);
        for (Context context : this.getNonCurrentContexts(recv)) {
            context.suspend0();
        }
    }

    void resume(IRubyObject recv) {
        this.checkStarted(recv);
        for (Context context : this.getNonCurrentContexts(recv)) {
            context.resume0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Context> getNonCurrentContexts(IRubyObject recv) {
        Context current;
        RubyArray contexts;
        Map<RubyThread, Context> map = this.threadsTable;
        synchronized (map) {
            contexts = (RubyArray)this.getDebugContexts(recv);
            RubyThread thread = recv.getRuntime().getCurrentContext().getThread();
            current = this.contextForThread(thread);
        }
        int len = contexts.getLength();
        for (int i = 0; i < len; ++i) {
            Context context = (Context)contexts.entry(i);
            if (context != current) continue;
            contexts.remove(i);
        }
        return contexts;
    }

    boolean isStarted() {
        return this.started;
    }

    void setTracing(boolean tracing) {
        this.tracing = tracing;
    }

    boolean isTracing() {
        return this.tracing;
    }

    void setKeepFrameBinding(boolean keepFrameBinding) {
        this.keepFrameBinding = keepFrameBinding;
    }

    boolean isKeepFrameBinding() {
        return this.keepFrameBinding;
    }

    boolean isTrackFrameArgs() {
        return this.trackFrameArgs;
    }

    IRubyObject getBreakpoints() {
        return this.breakpoints;
    }

    IRubyObject addBreakpoint(IRubyObject recv, IRubyObject[] args) {
        this.checkStarted(recv);
        IRubyObject result = this.createBreakpointFromArgs(recv, args, ++this.lastBreakpointID);
        ((RubyArray)this.breakpoints).add((Object)result);
        return result;
    }

    IRubyObject removeBreakpoint(IRubyObject recv, IRubyObject breakpointId) {
        this.checkStarted(recv);
        int id = RubyFixnum.fix2int((IRubyObject)breakpointId);
        RubyArray breakpointsA = (RubyArray)this.breakpoints;
        for (int i = 0; i < breakpointsA.size(); ++i) {
            IRubyObject breakpoint = breakpointsA.entry(i);
            DebugBreakpoint debugBreakpoint = (DebugBreakpoint)breakpoint.dataGetStruct();
            if (debugBreakpoint.getId() != id) continue;
            breakpointsA.remove(i);
            return breakpoint;
        }
        return Util.nil(recv);
    }

    IRubyObject createBreakpointFromArgs(IRubyObject recv, IRubyObject[] args) {
        return this.createBreakpointFromArgs(recv, args, ++this.lastBreakpointID);
    }

    IRubyObject createBreakpointFromArgs(IRubyObject recv, IRubyObject[] args, int id) {
        DebugBreakpoint.Type type;
        Ruby rt = recv.getRuntime();
        IRubyObject expr = Arity.checkArgumentCount((Ruby)rt, (IRubyObject[])args, (int)2, (int)3) == 3 ? args[2] : rt.getNil();
        IRubyObject source = args[0];
        IRubyObject pos = args[1];
        DebugBreakpoint.Type type2 = type = pos instanceof RubyFixnum ? DebugBreakpoint.Type.POS : DebugBreakpoint.Type.METHOD;
        if (type == DebugBreakpoint.Type.POS) {
            source = source.asString();
        } else {
            pos = pos.asString();
        }
        DebugBreakpoint debugBreakpoint = new DebugBreakpoint();
        debugBreakpoint.setId(id);
        debugBreakpoint.setSource(source);
        debugBreakpoint.setType(type);
        if (type == DebugBreakpoint.Type.POS) {
            debugBreakpoint.getPos().setLine(RubyFixnum.num2int((IRubyObject)pos));
        } else {
            debugBreakpoint.getPos().setMethodName(((RubyString)pos).toString());
        }
        debugBreakpoint.setExpr((IRubyObject)(expr.isNil() ? expr : (RubyString)expr));
        debugBreakpoint.setHitCount(0);
        debugBreakpoint.setHitValue(0);
        debugBreakpoint.setHitCondition(DebugBreakpoint.HitCondition.NONE);
        RubyClass cBreakpoint = rt.getModule("Debugger").getClass("Breakpoint");
        IRubyObject breakpoint = cBreakpoint.allocate();
        breakpoint.dataWrapStruct((Object)debugBreakpoint);
        return breakpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRubyObject lastInterrupted(IRubyObject recv) {
        this.checkStarted(recv);
        IRubyObject result = Util.nil(recv);
        Map<RubyThread, Context> map = this.threadsTable;
        synchronized (map) {
            for (Map.Entry<RubyThread, Context> entry : this.threadsTable.entrySet()) {
                IRubyObject context = (IRubyObject)entry.getValue();
                DebugContext debugContext = (DebugContext)context.dataGetStruct();
                if (debugContext.getThnum() != this.debugEventHook.getLastDebuggedThnum()) continue;
                result = context;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkThreadContexts(Ruby runtime) {
        Map<RubyThread, Context> map = this.threadsTable;
        synchronized (map) {
            Iterator<Map.Entry<RubyThread, Context>> it = this.threadsTable.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<RubyThread, Context> entry = it.next();
                if (!entry.getKey().alive_p().isFalse()) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRubyObject skip(IRubyObject recv, Block block) {
        if (!block.isGiven()) {
            throw recv.getRuntime().newArgumentError("called without a block");
        }
        DebugContext context = this.getCurrentDebugContext(recv);
        try {
            context.setSkipped(true);
            IRubyObject iRubyObject = block.yield(recv.getRuntime().getCurrentContext(), recv.getRuntime().getNil());
            return iRubyObject;
        }
        finally {
            context.setSkipped(false);
        }
    }

    boolean isPostMortem() {
        return this.postMortem;
    }

    void setPostMortem(boolean postMortem) {
        this.postMortem = postMortem;
    }

    boolean isDebug() {
        return this.debug;
    }

    void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void setLastContext(IRubyObject value) {
        this.lastContext = value;
    }

    void setTrackFrameArgs(boolean trackFrameArgs) {
        this.trackFrameArgs = trackFrameArgs;
    }

    RubyHash getCatchpoints() {
        return (RubyHash)this.catchpoints;
    }

    void addCatchpoint(IRubyObject recv, IRubyObject catchpoint) {
        Ruby runtime = recv.getRuntime();
        this.checkStarted(recv);
        if (catchpoint.isNil()) {
            this.catchpoints = runtime.getNil();
        } else {
            if (!runtime.getString().isInstance(catchpoint)) {
                throw runtime.newTypeError("value of checkpoint must be String");
            }
            this.getCatchpoints().op_aset(runtime.getCurrentContext(), catchpoint.dup(), (IRubyObject)RubyFixnum.zero((Ruby)runtime));
        }
    }

    static final class DebugContextPair {
        Context context;
        DebugContext debugContext;

        DebugContextPair() {
        }
    }
}

