/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class Logger {
    private static OutputStream outLogStream;
    private static OutputStream inLogStream;
    private static final String LOG_PROPERTY = "cvsClientLog";
    private static boolean logging;

    public static void setLogging(String string) {
        logging = string != null;
        try {
            if (logging) {
                if (string.equals("system")) {
                    outLogStream = System.err;
                    inLogStream = System.err;
                } else {
                    outLogStream = new BufferedOutputStream(new FileOutputStream(string + ".out"));
                    inLogStream = new BufferedOutputStream(new FileOutputStream(string + ".in"));
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Unable to create log files: " + iOException);
            System.err.println("Logging DISABLED");
            logging = false;
            try {
                if (outLogStream != null) {
                    outLogStream.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                if (inLogStream != null) {
                    inLogStream.close();
                }
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
    }

    public static void logInput(byte[] byArray) {
        Logger.logInput(byArray, 0, byArray.length);
    }

    public static void logInput(byte[] byArray, int n, int n2) {
        if (!logging) {
            return;
        }
        try {
            inLogStream.write(byArray, n, n2);
            inLogStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("Could not write to log file: " + iOException);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }

    public static void logInput(char c) {
        if (!logging) {
            return;
        }
        try {
            inLogStream.write(c);
            inLogStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("Could not write to log file: " + iOException);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }

    public static void logOutput(byte[] byArray) {
        if (!logging) {
            return;
        }
        try {
            outLogStream.write(byArray);
            outLogStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("Could not write to log file: " + iOException);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }

    static {
        Logger.setLogging(System.getProperty(LOG_PROPERTY));
    }
}

