/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml.ruby;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.languages.yaml.YamlTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyEmbeddingProvider
extends EmbeddingProvider {
    public static final String RUBY_MIME_TYPE = "text/x-ruby";
    private static final Logger LOG = Logger.getLogger(RubyEmbeddingProvider.class.getName());

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        if ("text/x-yaml".equals(snapshot.getMimeType())) {
            List<Embedding> list = this.translate(snapshot);
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Embedding.create(list));
        }
        LOG.warning("Unexpected snapshot type: '" + snapshot.getMimeType() + "'; expecting '" + "text/x-yaml" + "'");
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Embedding> translate(Snapshot snapshot) {
        BaseDocument baseDocument = (BaseDocument)snapshot.getSource().getDocument(false);
        if (baseDocument == null) {
            return Collections.emptyList();
        }
        ArrayList<Embedding> arrayList = new ArrayList<Embedding>();
        try {
            baseDocument.readLock();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence(YamlTokenId.language());
            this.translate(snapshot, (TokenHierarchy<Document>)tokenHierarchy, (TokenSequence<? extends YamlTokenId>)tokenSequence, arrayList);
        }
        finally {
            baseDocument.readUnlock();
        }
        return arrayList;
    }

    private void translate(Snapshot snapshot, TokenHierarchy<Document> tokenHierarchy, TokenSequence<? extends YamlTokenId> tokenSequence, List<Embedding> list) {
        list.add(snapshot.create((CharSequence)"_buf='';", RUBY_MIME_TYPE));
        boolean bl = false;
        while (tokenSequence.moveNext()) {
            String string;
            int n;
            Token token = tokenSequence.token();
            if (token.id() == YamlTokenId.TEXT || token.id() == YamlTokenId.COMMENT) {
                int n2;
                n = token.offset(tokenHierarchy);
                string = ((Object)token.text()).toString();
                boolean bl2 = false;
                for (n2 = 0; n2 < string.length(); ++n2) {
                    char c = string.charAt(n2);
                    if (c == '\n') {
                        ++n2;
                        bl2 = true;
                        break;
                    }
                    if (!Character.isWhitespace(c)) break;
                }
                if (bl2 && tokenSequence.index() < tokenSequence.tokenCount() - 1) {
                    list.add(snapshot.create(n, n2, RUBY_MIME_TYPE));
                    string = string.substring(n2);
                } else {
                    list.add(snapshot.create((CharSequence)";", RUBY_MIME_TYPE));
                }
                list.add(snapshot.create((CharSequence)"_buf << '", RUBY_MIME_TYPE));
                if (bl && string.startsWith("\n")) {
                    string = string.substring(1);
                }
                string = string.replace("'", "\\'");
                list.add(snapshot.create((CharSequence)string, RUBY_MIME_TYPE));
                list.add(snapshot.create((CharSequence)"';\n", RUBY_MIME_TYPE));
                bl = false;
                continue;
            }
            if (token.id() == YamlTokenId.RUBY) {
                n = token.offset(tokenHierarchy);
                string = ((Object)token.text()).toString();
                bl = false;
                if (string.endsWith("-")) {
                    string = string.substring(0, string.length() - 1);
                    bl = true;
                }
                list.add(snapshot.create(n, string.length(), RUBY_MIME_TYPE));
                bl = false;
                continue;
            }
            if (token.id() != YamlTokenId.RUBY_EXPR) continue;
            list.add(snapshot.create((CharSequence)"_buf << (", RUBY_MIME_TYPE));
            n = token.offset(tokenHierarchy);
            string = ((Object)token.text()).toString();
            bl = false;
            if (string.endsWith("-")) {
                string = string.substring(0, string.length() - 1);
                bl = true;
            }
            list.add(snapshot.create(n, string.length(), RUBY_MIME_TYPE));
            list.add(snapshot.create((CharSequence)").to_s;", RUBY_MIME_TYPE));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            if (!"text/x-yaml".equals(snapshot.getMimeType())) {
                return Collections.emptyList();
            }
            return Collections.singleton(new RubyEmbeddingProvider());
        }
    }
}

