/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.model.settings.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.modules.maven.model.settings.spi.ElementFactory;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFactoryRegistry {
    private static ElementFactoryRegistry registry = null;
    private Map<QName, ElementFactory> factories = null;
    private Set<Class> knownEmbeddedModelTypes = null;
    private Set<QName> knownQNames = null;
    private Set<String> knownNames = null;

    private ElementFactoryRegistry() {
        this.initialize();
    }

    public static ElementFactoryRegistry getDefault() {
        if (registry == null) {
            registry = new ElementFactoryRegistry();
        }
        return registry;
    }

    private void initialize() {
        this.factories = new Hashtable<QName, ElementFactory>();
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ElementFactory.class));
        for (Object object : result.allInstances()) {
            this.register((ElementFactory)object);
        }
        if (this.factories.size() < 1) {
            Object object;
            Lookup lookup = Lookups.metaInfServices((ClassLoader)this.getClass().getClassLoader());
            object = lookup.lookup(new Lookup.Template(ElementFactory.class));
            for (Object e : object.allInstances()) {
                this.register((ElementFactory)e);
            }
        }
    }

    public void register(ElementFactory elementFactory) {
        for (QName qName : elementFactory.getElementQNames()) {
            this.factories.put(qName, elementFactory);
        }
        this.resetQNameCache();
    }

    public void unregister(ElementFactory elementFactory) {
        for (QName qName : elementFactory.getElementQNames()) {
            this.factories.remove(qName);
        }
        this.resetQNameCache();
    }

    public ElementFactory get(QName qName) {
        return this.factories.get(qName);
    }

    public void resetQNameCache() {
        this.knownEmbeddedModelTypes = null;
        this.knownQNames = null;
        this.knownNames = null;
    }

    public Set<QName> getKnownQNames() {
        return Collections.unmodifiableSet(this.knownQNames());
    }

    private Set<QName> knownQNames() {
        if (this.knownQNames == null) {
            this.knownQNames = new HashSet<QName>();
            for (ElementFactory elementFactory : this.factories.values()) {
                for (QName qName : elementFactory.getElementQNames()) {
                    if (this.knownQNames.add(qName)) continue;
                    String string = "Duplicate factory for: " + qName;
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "getKnownQNames", string);
                }
            }
        }
        return this.knownQNames;
    }

    public Set<String> getKnownElementNames() {
        return Collections.unmodifiableSet(this.knownElementNames());
    }

    private Set<String> knownElementNames() {
        if (this.knownNames == null) {
            this.knownNames = new HashSet<String>();
            for (QName qName : this.knownQNames()) {
                this.knownNames.add(qName.getLocalPart());
            }
        }
        return this.knownNames;
    }

    public void addEmbeddedModelQNames(AbstractDocumentModel abstractDocumentModel) {
        if (this.knownEmbeddedModelTypes == null) {
            this.knownEmbeddedModelTypes = new HashSet<Class>();
        }
        if (!this.knownEmbeddedModelTypes.contains(abstractDocumentModel.getClass())) {
            this.knownQNames().addAll(abstractDocumentModel.getQNames());
            this.knownNames = null;
        }
    }
}

