/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class J2SESources
implements Sources,
PropertyChangeListener,
ChangeListener {
    private static final String BUILD_DIR_PROP = "${build.dir}";
    private static final String DIST_DIR_PROP = "${dist.dir}";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private boolean dirty;
    private Sources delegate;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    J2SESources(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        this.project = project;
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = sourceRoots2;
        this.sourceRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.testRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.delegate = this.initSources();
    }

    public SourceGroup[] getSourceGroups(final String string) {
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SourceGroup[] run() {
                SourceGroup[] sourceGroupArray = J2SESources.this;
                synchronized (J2SESources.this) {
                    FileObject fileObject;
                    if (J2SESources.this.dirty) {
                        J2SESources.this.delegate.removeChangeListener((ChangeListener)J2SESources.this);
                        J2SESources.this.delegate = J2SESources.this.initSources();
                        J2SESources.this.delegate.addChangeListener((ChangeListener)J2SESources.this);
                        J2SESources.this.dirty = false;
                    }
                    Sources sources = J2SESources.this.delegate;
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    sourceGroupArray = sources.getSourceGroups(string);
                    if (string.equals("generic") && (fileObject = J2SESources.this.getSharedLibraryFolderLocation()) != null) {
                        SourceGroup[] sourceGroupArray2 = new SourceGroup[sourceGroupArray.length + 1];
                        System.arraycopy(sourceGroupArray, 0, sourceGroupArray2, 0, sourceGroupArray.length);
                        sourceGroupArray2[sourceGroupArray2.length - 1] = GenericSources.group(null, (FileObject)fileObject, (String)"sharedlibraries", (String)NbBundle.getMessage(J2SESources.class, (String)"LibrarySourceGroup_DisplayName"), null, null);
                        return sourceGroupArray2;
                    }
                    return sourceGroupArray;
                }
            }
        });
    }

    private FileObject getSharedLibraryFolderLocation() {
        String string = this.helper.getLibrariesLocation();
        if (string != null) {
            FileObject fileObject;
            String string2 = this.evaluator.evaluate(string);
            File file = null;
            if (string2 != null) {
                file = this.helper.resolveFile(string2);
            }
            if ((fileObject = FileUtil.toFileObject(file)) != null) {
                FileObject fileObject2 = fileObject.getParent();
                return fileObject2;
            }
        }
        return null;
    }

    private Sources initSources() {
        SourcesHelper sourcesHelper = new SourcesHelper(this.project, this.helper, this.evaluator);
        this.register(sourcesHelper, this.sourceRoots);
        this.register(sourcesHelper, this.testRoots);
        sourcesHelper.addNonSourceRoot(BUILD_DIR_PROP);
        sourcesHelper.addNonSourceRoot(DIST_DIR_PROP);
        sourcesHelper.registerExternalRoots(0, false);
        return sourcesHelper.createSources();
    }

    private void register(SourcesHelper sourcesHelper, SourceRoots sourceRoots) {
        String[] stringArray = sourceRoots.getRootProperties();
        String[] stringArray2 = sourceRoots.getRootNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = sourceRoots.getRootDisplayName(stringArray2[i], string);
            String string3 = "${" + string + "}";
            String string4 = "${includes}";
            String string5 = "${excludes}";
            sourcesHelper.addPrincipalSourceRoot(string3, string4, string5, string2, null, null);
            sourcesHelper.addTypedSourceRoot(string3, string4, string5, "java", string2, null, null);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        J2SESources j2SESources = this;
        synchronized (j2SESources) {
            this.dirty = true;
        }
        this.changeSupport.fireChange();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (SourceRoots.PROP_ROOT_PROPERTIES.equals(string) || "build.dir".equals(string) || "dist.dir".equals(string)) {
            this.fireChange();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }
}

