/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.components;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorComponentEmptyContentProvider;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DLightIndicatorsTopComponent
extends TopComponent {
    private static DLightIndicatorsTopComponent instance;
    private DLightSession session;
    static final String ICON_PATH = "org/netbeans/modules/dlight/core/ui/resources/indicators_small.png";
    private static final String PREFERRED_ID = "DLightIndicatorsTopComponent";
    private final CardLayout cardLayout = new CardLayout();
    private JPanel cardsLayoutPanel;
    private JPanel panel1;
    private JPanel panel2;
    private boolean showFirstPanel = true;

    private DLightIndicatorsTopComponent() {
        this.initComponents();
        this.setSession(null);
        this.setName(DLightIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent", new Object[0]));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    void initComponents() {
        this.cardsLayoutPanel = new JPanel(this.cardLayout);
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.cardsLayoutPanel.add((Component)this.panel1, "#1");
        this.cardsLayoutPanel.add((Component)this.panel2, "#2");
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.cardsLayoutPanel);
    }

    void setActive() {
        this.cardLayout.show(this.cardsLayoutPanel, this.showFirstPanel ? "#1" : "#2");
        this.showFirstPanel = !this.showFirstPanel;
    }

    JPanel getNextPanel() {
        return this.showFirstPanel ? this.panel1 : this.panel2;
    }

    public void setSession(DLightSession dLightSession) {
        if (this.session != null && this.session != dLightSession) {
            DLightManager.getDefault().closeSessionOnExit(this.session);
        }
        this.session = dLightSession;
        List list = null;
        if (dLightSession != null) {
            this.setDisplayName(DLightIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent.withSession", dLightSession.getDisplayName()));
            list = dLightSession.getIndicators();
        } else {
            this.setDisplayName(DLightIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent", new Object[0]));
            IndicatorComponentEmptyContentProvider indicatorComponentEmptyContentProvider = (IndicatorComponentEmptyContentProvider)Lookup.getDefault().lookup(IndicatorComponentEmptyContentProvider.class);
            if (indicatorComponentEmptyContentProvider != null) {
                list = indicatorComponentEmptyContentProvider.getEmptyContent();
            }
        }
        Collections.sort(list, new Comparator<Indicator>(){

            @Override
            public int compare(Indicator indicator, Indicator indicator2) {
                if (indicator.getPosition() < indicator2.getPosition()) {
                    return -1;
                }
                if (indicator2.getPosition() < indicator.getPosition()) {
                    return 1;
                }
                return 0;
            }
        });
        this.setContent(list);
    }

    private void setContent(List<Indicator> list) {
        JComponent jComponent;
        JComponent jComponent2;
        if (list != null) {
            jComponent2 = new JScrollPane();
            jComponent2.setBorder(BorderFactory.createEmptyBorder());
            JSplitPane jSplitPane = null;
            for (int i = 0; i < list.size(); ++i) {
                JComponent jComponent3 = list.get(i).getComponent();
                if (i + 1 < list.size()) {
                    JSplitPane jSplitPane2 = new JSplitPane(0);
                    jSplitPane2.setBorder(BorderFactory.createEmptyBorder());
                    jSplitPane2.setContinuousLayout(true);
                    jSplitPane2.setDividerSize(5);
                    jSplitPane2.setResizeWeight(1.0 / (double)(list.size() - i));
                    jSplitPane2.setTopComponent(jComponent3);
                    jComponent3 = jSplitPane2;
                }
                if (jSplitPane == null) {
                    ((JScrollPane)jComponent2).setViewportView(jComponent3);
                } else {
                    jSplitPane.setBottomComponent(jComponent3);
                }
                if (!(jComponent3 instanceof JSplitPane)) continue;
                jSplitPane = (JSplitPane)jComponent3;
            }
            jComponent = jComponent2;
        } else {
            jComponent2 = new JLabel(NbBundle.getMessage(DLightIndicatorsTopComponent.class, (String)"IndicatorsTopCompinent.EmptyContent"));
            jComponent2.setAlignmentX(0.5f);
            jComponent = jComponent2;
        }
        jComponent2 = this.getNextPanel();
        jComponent2.removeAll();
        jComponent2.setLayout(new BoxLayout(jComponent2, 1));
        jComponent2.add(jComponent);
        this.setActive();
        this.repaint();
    }

    public static synchronized DLightIndicatorsTopComponent getDefault() {
        if (instance == null) {
            instance = new DLightIndicatorsTopComponent();
        }
        return instance;
    }

    public static synchronized DLightIndicatorsTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(DLightIndicatorsTopComponent.class.getName()).warning("Cannot find DLightIndicatorsTopComponent component. It will not be located properly in the window system.");
            return DLightIndicatorsTopComponent.getDefault();
        }
        if (topComponent instanceof DLightIndicatorsTopComponent) {
            return (DLightIndicatorsTopComponent)topComponent;
        }
        Logger.getLogger(DLightIndicatorsTopComponent.class.getName()).warning("There seem to be multiple components with the 'DLightIndicatorsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return DLightIndicatorsTopComponent.getDefault();
    }

    public static synchronized DLightIndicatorsTopComponent newInstance() {
        return new DLightIndicatorsTopComponent();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        if (this.session != null) {
            DLightManager.getDefault().closeSessionOnExit(this.session);
        }
        super.componentClosed();
    }

    DLightSession getSession() {
        return this.session;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(DLightIndicatorsTopComponent.class, (String)string, (Object[])objectArray);
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return DLightIndicatorsTopComponent.getDefault();
        }
    }
}

