/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.webframeworks;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.webframeworks.AddFrameworkPanel;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebFrameworksPanel
extends JPanel
implements ListSelectionListener {
    private final ProjectCustomizer.Category category;
    private Project project;
    private List<WebModuleExtender> newExtenders = new LinkedList<WebModuleExtender>();
    private List<WebFrameworkProvider> usedFrameworks = new LinkedList<WebFrameworkProvider>();
    private Map<WebFrameworkProvider, WebModuleExtender> extenders = new IdentityHashMap<WebFrameworkProvider, WebModuleExtender>();
    List<WebFrameworkProvider> addedFrameworks = new LinkedList<WebFrameworkProvider>();
    private ExtenderController controller = ExtenderController.create();
    private ModelHandle handle;
    static final String UI_LOGGER_NAME = "org.netbeans.ui.web.project";
    static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.web.project");
    private JButton btnRemoveAdded;
    private JButton jButtonAdd;
    private JLabel jLabelConfig;
    private JLabel jLabelFrameworks;
    private JList jListFrameworks;
    private JPanel jPanelConfig;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public WebFrameworksPanel(ProjectCustomizer.Category category, ModelHandle modelHandle, Project project) {
        this.category = category;
        this.project = project;
        this.handle = modelHandle;
        this.initComponents();
        this.btnRemoveAdded.setEnabled(false);
        this.initFrameworksList();
        this.jListFrameworks.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                WebFrameworkProvider webFrameworkProvider = (WebFrameworkProvider)object;
                Component component = super.getListCellRendererComponent((JList<?>)jList, webFrameworkProvider.getName(), n, bl, bl2);
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    if (WebFrameworksPanel.this.addedFrameworks.contains(webFrameworkProvider)) {
                        jLabel.setFont(jLabel.getFont().deriveFont(1));
                    } else {
                        jLabel.setFont(jLabel.getFont().deriveFont(0));
                    }
                }
                return component;
            }
        });
    }

    void applyChanges() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        for (int i = 0; i < this.newExtenders.size(); ++i) {
            this.newExtenders.get(i).extend(webModule);
        }
        if (this.addedFrameworks != null && this.addedFrameworks.size() > 0) {
            LogRecord logRecord = new LogRecord(Level.INFO, "UI_WEB_PROJECT_FRAMEWORK_ADDED");
            logRecord.setLoggerName(UI_LOGGER_NAME);
            logRecord.setResourceBundle(NbBundle.getBundle(WebFrameworksPanel.class));
            logRecord.setParameters(this.addedFrameworks.toArray());
            UI_LOGGER.log(logRecord);
        }
    }

    private void initFrameworksList() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        ExtenderController.Properties properties = this.controller.getProperties();
        String string = webModule.getJ2eePlatformVersion();
        properties.setProperty("j2eeLevel", (Object)string);
        this.jListFrameworks.setModel(new DefaultListModel());
        List list = WebFrameworks.getFrameworks();
        for (int i = 0; i < list.size(); ++i) {
            WebFrameworkProvider webFrameworkProvider = (WebFrameworkProvider)list.get(i);
            if (!webFrameworkProvider.isInWebModule(webModule)) continue;
            this.usedFrameworks.add(webFrameworkProvider);
            ((DefaultListModel)this.jListFrameworks.getModel()).addElement(webFrameworkProvider);
            WebModuleExtender webModuleExtender = webFrameworkProvider.createWebModuleExtender(webModule, this.controller);
            this.extenders.put(webFrameworkProvider, webModuleExtender);
            webModuleExtender.addChangeListener((ChangeListener)new ExtenderListener(webModuleExtender));
        }
        this.jListFrameworks.getSelectionModel().setSelectionMode(0);
        this.jListFrameworks.addListSelectionListener(this);
        if (this.usedFrameworks.size() > 0) {
            this.jListFrameworks.setSelectedIndex(0);
        }
        if (list.size() == this.jListFrameworks.getModel().getSize()) {
            this.jButtonAdd.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jLabelFrameworks = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListFrameworks = new JList();
        this.jButtonAdd = new JButton();
        this.btnRemoveAdded = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanelConfig = new JPanel();
        this.jLabelConfig = new JLabel();
        this.jLabelFrameworks.setLabelFor(this.jListFrameworks);
        Mnemonics.setLocalizedText((JLabel)this.jLabelFrameworks, (String)NbBundle.getMessage(WebFrameworksPanel.class, (String)"LBL_UsedFrameworks"));
        this.jScrollPane1.setViewportView(this.jListFrameworks);
        this.jListFrameworks.getAccessibleContext().setAccessibleDescription("Used Frameworks");
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAdd, (String)NbBundle.getMessage(WebFrameworksPanel.class, (String)"LBL_AddFramework"));
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebFrameworksPanel.this.jButtonAddActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveAdded, (String)NbBundle.getMessage(WebFrameworksPanel.class, (String)"BTN_Remove"));
        this.btnRemoveAdded.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebFrameworksPanel.this.btnRemoveAddedActionPerformed(actionEvent);
            }
        });
        this.jPanelConfig.setLayout(new GridBagLayout());
        this.jLabelConfig.setLabelFor(this.jPanelConfig);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelFrameworks).add((Component)this.jScrollPane1, -1, 398, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.jButtonAdd).add((Component)this.btnRemoveAdded))).add((Component)this.jSeparator1, -1, 477, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelConfig, -2, 368, -2).addContainerGap()).add((Component)this.jPanelConfig, -1, 477, Short.MAX_VALUE));
        groupLayout.linkSize(new Component[]{this.btnRemoveAdded, this.jButtonAdd}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelFrameworks).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.btnRemoveAdded)).add((Component)this.jScrollPane1, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 2, -2).addPreferredGap(0).add((Component)this.jLabelConfig, -2, 19, -2).addPreferredGap(0).add((Component)this.jPanelConfig, -1, 158, Short.MAX_VALUE)));
        this.jButtonAdd.getAccessibleContext().setAccessibleDescription("Add Framework");
        this.btnRemoveAdded.getAccessibleContext().setAccessibleDescription("Remove framework");
    }

    private void jButtonAddActionPerformed(ActionEvent actionEvent) {
        AddFrameworkPanel addFrameworkPanel = new AddFrameworkPanel(this.usedFrameworks);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.getAccessibleContext().setAccessibleDescription(addFrameworkPanel.getAccessibleContext().getAccessibleDescription());
        jPanel.getAccessibleContext().setAccessibleName(addFrameworkPanel.getAccessibleContext().getAccessibleName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        jPanel.add((Component)addFrameworkPanel, gridBagConstraints);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage(WebFrameworksPanel.class, (String)"LBL_SelectWebExtension_DialogTitle"));
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object.equals(NotifyDescriptor.YES_OPTION)) {
            List<WebFrameworkProvider> list = addFrameworkPanel.getSelectedFrameworks();
            WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
            for (WebFrameworkProvider webFrameworkProvider : list) {
                WebModuleExtender webModuleExtender;
                if (!((DefaultListModel)this.jListFrameworks.getModel()).contains(webFrameworkProvider)) {
                    ((DefaultListModel)this.jListFrameworks.getModel()).addElement(webFrameworkProvider);
                }
                boolean bl = false;
                if (this.usedFrameworks.size() == 0) {
                    this.usedFrameworks.add(webFrameworkProvider);
                    bl = true;
                } else {
                    for (int i = 0; i < this.usedFrameworks.size(); ++i) {
                        if (this.usedFrameworks.get(i).getName().equals(webFrameworkProvider.getName())) continue;
                        this.usedFrameworks.add(webFrameworkProvider);
                        bl = true;
                        break;
                    }
                }
                if (bl && (webModuleExtender = webFrameworkProvider.createWebModuleExtender(webModule, this.controller)) != null) {
                    this.extenders.put(webFrameworkProvider, webModuleExtender);
                    this.newExtenders.add(webModuleExtender);
                    webModuleExtender.addChangeListener((ChangeListener)new ExtenderListener(webModuleExtender));
                    this.addedFrameworks.add(webFrameworkProvider);
                }
                this.jListFrameworks.setSelectedValue(webFrameworkProvider, true);
            }
        }
        if (WebFrameworks.getFrameworks().size() == this.jListFrameworks.getModel().getSize()) {
            this.jButtonAdd.setEnabled(false);
        }
    }

    private void btnRemoveAddedActionPerformed(ActionEvent actionEvent) {
        WebModuleExtender webModuleExtender;
        WebFrameworkProvider webFrameworkProvider = (WebFrameworkProvider)this.jListFrameworks.getSelectedValue();
        if (webFrameworkProvider != null && (webModuleExtender = this.extenders.get(webFrameworkProvider)) != null) {
            ((DefaultListModel)this.jListFrameworks.getModel()).removeElement(webFrameworkProvider);
            this.addedFrameworks.remove(webFrameworkProvider);
            this.newExtenders.remove(webModuleExtender);
            this.extenders.remove(webFrameworkProvider);
            this.usedFrameworks.remove(webFrameworkProvider);
            boolean bl = false;
            for (WebModuleExtender webModuleExtender2 : this.extenders.values()) {
                if (webModuleExtender2.isValid()) continue;
                webModuleExtender2.update();
                this.controller.setErrorMessage(null);
                webModuleExtender2.isValid();
                this.category.setValid(false);
                this.category.setErrorMessage(this.controller.getErrorMessage());
                bl = true;
            }
            if (!bl && !this.category.isValid()) {
                this.category.setValid(true);
                this.category.setErrorMessage(null);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.btnRemoveAdded.setEnabled(false);
        WebFrameworkProvider webFrameworkProvider = (WebFrameworkProvider)this.jListFrameworks.getSelectedValue();
        if (webFrameworkProvider != null) {
            WebModuleExtender webModuleExtender;
            if (this.addedFrameworks.contains(webFrameworkProvider)) {
                this.btnRemoveAdded.setEnabled(true);
            }
            if ((webModuleExtender = this.extenders.get(webFrameworkProvider)) != null) {
                String string = MessageFormat.format(NbBundle.getMessage(WebFrameworksPanel.class, (String)"LBL_FrameworkConfiguration"), webFrameworkProvider.getName());
                this.jLabelConfig.setText(string);
                this.jPanelConfig.removeAll();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.gridheight = 0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                this.jPanelConfig.add((Component)webModuleExtender.getComponent(), gridBagConstraints);
                this.jPanelConfig.repaint();
                this.jPanelConfig.revalidate();
                webModuleExtender.update();
                this.controller.setErrorMessage(null);
                webModuleExtender.isValid();
                this.category.setErrorMessage(this.controller.getErrorMessage());
            } else {
                this.hideConfigPanel();
            }
        } else {
            this.hideConfigPanel();
        }
    }

    private void hideConfigPanel() {
        this.jLabelConfig.setText("");
        this.jPanelConfig.removeAll();
        this.jPanelConfig.repaint();
        this.jPanelConfig.revalidate();
    }

    private final class ExtenderListener
    implements ChangeListener {
        private final WebModuleExtender extender;

        public ExtenderListener(WebModuleExtender webModuleExtender) {
            this.extender = webModuleExtender;
            webModuleExtender.update();
            this.stateChanged(new ChangeEvent(this));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            WebFrameworksPanel.this.controller.setErrorMessage(null);
            if (this.extender.isValid()) {
                if (!WebFrameworksPanel.this.category.isValid()) {
                    WebFrameworksPanel.this.category.setValid(true);
                    WebFrameworksPanel.this.category.setErrorMessage(null);
                }
            } else {
                WebFrameworksPanel.this.category.setValid(false);
                WebFrameworksPanel.this.category.setErrorMessage(WebFrameworksPanel.this.controller.getErrorMessage());
            }
        }
    }
}

