/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

public class StringTableSection
extends ElfSection {
    byte[] stringtable = null;

    public StringTableSection(ElfReader elfReader, int n) {
        super(elfReader, n);
        this.read();
    }

    public StringTableSection(ElfReader elfReader, byte[] byArray) {
        super(null, 0, null, "String Table");
        this.stringtable = byArray;
    }

    public StringTableSection read() {
        try {
            long l = this.reader.getFilePointer();
            this.reader.seek(this.header.getSectionOffset());
            this.stringtable = new byte[(int)this.header.getSectionSize()];
            this.reader.read(this.stringtable);
            this.reader.seek(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public byte[] getStringTable() {
        return this.stringtable;
    }

    public String getString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = (int)l; i < this.stringtable.length && this.stringtable[i] != 0; ++i) {
            stringBuilder.append((char)this.stringtable[i]);
        }
        return stringBuilder.toString();
    }

    public void dump(PrintStream printStream) {
        String string;
        super.dump(printStream);
        if (this.stringtable == null) {
            printStream.println("<Empty table>");
            return;
        }
        int n = 0;
        printStream.printf("No.\tOffset\tString\n", new Object[0]);
        for (int i = 0; i < this.stringtable.length; i += string.length() + 1) {
            string = this.getString(i);
            printStream.printf("%d.\t%d\t%s\n", ++n, i, string);
        }
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.dump(printStream);
        return byteArrayOutputStream.toString();
    }
}

