/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ChangeParametersPanel
extends JPanel
implements CustomRefactoringPanel {
    private final CsmObject selectedElement;
    private CsmFunction functionObj;
    private ParamTableModel model;
    private ChangeListener parent;
    private static final String DEFAULT_VALUES_ONLY_IN_DEFINITION = "UseDefaultValueOnlyInFunctionDefinition";
    private static Action editAction = null;
    private String returnType;
    private static final String[] modifierNames = new String[]{"public", "protected", "private", "<default>"};
    private static final String[] columnNames = new String[]{ChangeParametersPanel.getString("LBL_ChangeParsColName"), ChangeParametersPanel.getString("LBL_ChangeParsColType"), ChangeParametersPanel.getString("LBL_ChangeParsColDefVal"), ChangeParametersPanel.getString("LBL_ChangeParsColOrigIdx"), ChangeParametersPanel.getString("LBL_ChangeParsParUsed")};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_PRIVATE_INDEX = 2;
    private static final int MOD_DEFAULT_INDEX = 3;
    private static final String ACTION_INLINE_EDITOR = "invokeInlineEditor";
    private boolean initialized = false;
    private JButton addButton;
    private JPanel buttonsPanel;
    private JCheckBox defaultsOnlyInFunDefinition;
    private JPanel eastPanel;
    private JPanel fillPanel;
    private JComboBox modifiersCombo;
    private JLabel modifiersLabel;
    private JPanel modifiersPanel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JTable paramTable;
    private JLabel paramTitle;
    private JLabel previewChange;
    private JButton removeButton;
    private JScrollPane westPanel;
    private CsmVisibility modifier = CsmVisibility.NONE;

    public Component getComponent() {
        return this;
    }

    public ChangeParametersPanel(CsmObject csmObject, CsmContext csmContext, ChangeListener changeListener) {
        this.selectedElement = csmObject == null ? csmContext.getEnclosingFunction() : csmObject;
        this.parent = changeListener;
        this.model = new ParamTableModel(columnNames, 0);
        this.initComponents();
        this.defaultsOnlyInFunDefinition.setSelected(this.isUseDefaultValueOnlyInFunctionDefinition());
    }

    public void initialize() {
        CsmFunction csmFunction;
        if (this.initialized) {
            return;
        }
        this.functionObj = csmFunction = ((CsmFunction)CsmRefactoringUtils.getReferencedElement(this.selectedElement)).getDeclaration();
        this.returnType = ((Object)this.functionObj.getReturnType().getCanonicalText()).toString();
        if (CsmKindUtilities.isMethod((CsmObject)this.functionObj)) {
            CsmMethod csmMethod = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)this.functionObj);
            this.setModifier(csmMethod.getVisibility());
        } else {
            this.setModifier(CsmVisibility.NONE);
        }
        this.modifiersCombo.setEnabled(false);
        this.initTableData();
        this.previewChange.setText(this.genDeclarationString());
        this.initialized = true;
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    protected CsmVisibility getModifier() {
        int n = this.modifiersCombo.getSelectedIndex();
        switch (n) {
            case 2: {
                return CsmVisibility.PRIVATE;
            }
            case 3: {
                return CsmVisibility.NONE;
            }
            case 1: {
                return CsmVisibility.PROTECTED;
            }
            case 0: {
                return CsmVisibility.PUBLIC;
            }
        }
        assert (false) : "unexpected index:" + n;
        return CsmVisibility.NONE;
    }

    protected boolean isUseDefaultValueOnlyInFunctionDefinition() {
        return NbPreferences.forModule(ChangeParametersPanel.class).getBoolean(DEFAULT_VALUES_ONLY_IN_DEFINITION, false);
    }

    private void initComponents() {
        this.modifiersPanel = new JPanel();
        this.modifiersLabel = new JLabel();
        this.modifiersCombo = new JComboBox();
        this.defaultsOnlyInFunDefinition = new JCheckBox();
        this.eastPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.fillPanel = new JPanel();
        this.westPanel = new JScrollPane();
        this.paramTable = new JTable();
        this.paramTitle = new JLabel();
        this.previewChange = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setAutoscrolls(true);
        this.setName(ChangeParametersPanel.getString("LBL_TitleChangeParameters"));
        this.setLayout(new GridBagLayout());
        this.modifiersPanel.setLayout(new GridBagLayout());
        this.modifiersLabel.setLabelFor(this.modifiersCombo);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/refactoring/ui/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.modifiersLabel, (String)resourceBundle.getString("LBL_ChangeParsMods"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.modifiersPanel.add((Component)this.modifiersLabel, gridBagConstraints);
        this.modifiersCombo.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.modifiersCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeParametersPanel.this.modifiersComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.modifiersPanel.add((Component)this.modifiersCombo, gridBagConstraints);
        this.modifiersCombo.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_modifiersCombo"));
        Mnemonics.setLocalizedText((AbstractButton)this.defaultsOnlyInFunDefinition, (String)NbBundle.getMessage(ChangeParametersPanel.class, (String)"ChangeParametersPanel.defaultsOnlyInFunDefinition.text"));
        this.defaultsOnlyInFunDefinition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeParametersPanel.this.defaultsOnlyInFunDefinitionActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.modifiersPanel.add((Component)this.defaultsOnlyInFunDefinition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.modifiersPanel, gridBagConstraints);
        this.eastPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(1, 11, 1, 1));
        this.buttonsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)resourceBundle.getString("LBL_ChangeParsAdd"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeParametersPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ChangeParsAdd"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)resourceBundle.getString("LBL_ChangeParsRemove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeParametersPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ChangeParsRemove"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)resourceBundle.getString("LBL_ChangeParsMoveUp"));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeParametersPanel.this.moveUpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ChangeParsMoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)resourceBundle.getString("LBL_ChangeParsMoveDown"));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeParametersPanel.this.moveDownButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ChangeParsMoveDown"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.eastPanel.add((Component)this.buttonsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.eastPanel.add((Component)this.fillPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.eastPanel, gridBagConstraints);
        this.westPanel.setPreferredSize(new Dimension(453, 100));
        this.paramTable.setModel(this.model);
        this.initRenderer();
        this.paramTable.getSelectionModel().addListSelectionListener(this.getListener1());
        this.paramTable.getSelectionModel().setSelectionMode(1);
        this.model.addTableModelListener(this.getListener2());
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(113, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getActionMap().put(ACTION_INLINE_EDITOR, ChangeParametersPanel.getEditAction());
        this.paramTable.setSurrendersFocusOnKeystroke(true);
        this.paramTable.setCellSelectionEnabled(false);
        this.paramTable.setRowSelectionAllowed(true);
        this.paramTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.paramTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.westPanel.setViewportView(this.paramTable);
        this.paramTable.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_paramTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.westPanel, gridBagConstraints);
        this.paramTitle.setHorizontalAlignment(2);
        this.paramTitle.setLabelFor(this.paramTable);
        Mnemonics.setLocalizedText((JLabel)this.paramTitle, (String)resourceBundle.getString("LBL_ChangeParsParameters"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.paramTitle, gridBagConstraints);
        this.previewChange.setBorder(BorderFactory.createTitledBorder(NbBundle.getBundle(ChangeParametersPanel.class).getString("LBL_ChangeParsPreview")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.previewChange, gridBagConstraints);
    }

    private void modifiersComboActionPerformed(ActionEvent actionEvent) {
        this.previewChange.setText(this.genDeclarationString());
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.acceptEditedValue();
        int[] nArray = this.paramTable.getSelectedRows();
        ListSelectionModel listSelectionModel = this.paramTable.getSelectionModel();
        for (int i = 0; i < nArray.length; ++i) {
            boolean bl = (Boolean)this.model.getDataVector().get(nArray[i] - i).get(4);
            if (!bl) {
                String string = ChangeParametersPanel.getString("LBL_ChangeParsCannotDeleteTitle");
                String string2 = MessageFormat.format(ChangeParametersPanel.getString("LBL_ChangeParsCannotDelete"), this.model.getDataVector().get(nArray[i] - i).get(0));
                int n = JOptionPane.showConfirmDialog(this, string2, string, 0);
                if (n != 0) continue;
                this.model.removeRow(nArray[i] - i);
                listSelectionModel.clearSelection();
                continue;
            }
            this.model.removeRow(nArray[i] - i);
            listSelectionModel.clearSelection();
        }
    }

    private void moveDownButtonActionPerformed(ActionEvent actionEvent) {
        this.doMove(1);
    }

    private void moveUpButtonActionPerformed(ActionEvent actionEvent) {
        this.doMove(-1);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.acceptEditedValue();
        int n = this.model.getRowCount();
        this.model.addRow(new Object[]{"par" + n, "int", "0", -1, Boolean.TRUE});
    }

    private void defaultsOnlyInFunDefinitionActionPerformed(ActionEvent actionEvent) {
        NbPreferences.forModule(ChangeParametersPanel.class).putBoolean(DEFAULT_VALUES_ONLY_IN_DEFINITION, this.defaultsOnlyInFunDefinition.isSelected());
        this.previewChange.setText(this.genDeclarationString());
    }

    private ListSelectionListener getListener1() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int n = listSelectionModel.getMinSelectionIndex();
                    int n2 = listSelectionModel.getMaxSelectionIndex();
                    ChangeParametersPanel.this.setButtons(n, n2);
                    boolean bl = true;
                    for (int i = n; i <= n2 && (bl = ChangeParametersPanel.this.model.isRemovable(i)); ++i) {
                    }
                    ChangeParametersPanel.this.removeButton.setEnabled(bl);
                } else {
                    ChangeParametersPanel.this.moveDownButton.setEnabled(false);
                    ChangeParametersPanel.this.moveUpButton.setEnabled(false);
                    ChangeParametersPanel.this.removeButton.setEnabled(false);
                }
            }
        };
    }

    private TableModelListener getListener2() {
        return new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int[] nArray = ChangeParametersPanel.this.paramTable.getSelectedRows();
                if (nArray.length == 0) {
                    ChangeParametersPanel.this.removeButton.setEnabled(false);
                } else {
                    int n;
                    boolean bl = true;
                    for (n = 0; n < nArray.length && (nArray[n] >= ChangeParametersPanel.this.model.getRowCount() || (bl = ChangeParametersPanel.this.model.isCellEditable(nArray[n], 0))); ++n) {
                    }
                    ChangeParametersPanel.this.removeButton.setEnabled(bl);
                    n = nArray[0];
                    int n2 = nArray[nArray.length - 1];
                    ChangeParametersPanel.this.setButtons(n, n2);
                }
                ChangeParametersPanel.this.previewChange.setText(ChangeParametersPanel.this.genDeclarationString());
                ChangeParametersPanel.this.parent.stateChanged(null);
            }
        };
    }

    private void initTableData() {
        CsmFunction csmFunction;
        Object object2;
        Collection collection = this.functionObj.getParameters();
        ArrayList<CsmType> arrayList = new ArrayList<CsmType>();
        for (Object object2 : collection) {
            arrayList.add(object2.getType());
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(this.functionObj);
        if (CsmKindUtilities.isMethod((CsmObject)this.functionObj)) {
            object2 = (CsmMethod)this.functionObj;
            if (CsmVirtualInfoQuery.getDefault().isVirtual((CsmMethod)object2)) {
                linkedHashSet.addAll(CsmVirtualInfoQuery.getDefault().getOverridenMethods((CsmMethod)object2, true));
                assert (!linkedHashSet.isEmpty()) : "must be at least start object " + object2;
            }
        }
        object2 = new LinkedHashSet();
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            csmFunction = (CsmFunction)iterator.next();
            CsmFunctionDefinition csmFunctionDefinition = csmFunction.getDefinition();
            if (csmFunctionDefinition != null) {
                object2.add(csmFunctionDefinition);
                continue;
            }
            object2.add(csmFunction);
        }
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            csmFunction = (CsmFunction)iterator.next();
            int n = 0;
            CsmFile csmFile = csmFunction.getContainingFile();
            for (CsmParameter csmParameter : csmFunction.getParameters()) {
                Object[] objectArray;
                CsmType csmType = csmParameter.getType();
                String string = csmParameter.isVarArgs() && n == collection.size() - 1 ? "..." : ChangeParametersPanel.getTypeStringRepresentation(csmType);
                Collection<Object> collection2 = Collections.emptySet();
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmFunction)) {
                    collection2 = CsmReferenceRepository.getDefault().getReferences((CsmObject)csmParameter, csmFile, CsmReferenceKind.ALL, null);
                }
                Boolean bl = collection2.size() <= 1;
                if (this.model.getRowCount() <= n) {
                    objectArray = new Object[]{((Object)csmParameter.getName()).toString(), string, "", n, bl};
                    this.model.addRow(objectArray);
                } else {
                    bl = this.model.isRemovable(n) && bl != false;
                    objectArray = this.model.getDataVector().get(n);
                    objectArray.set(4, bl);
                }
                ++n;
            }
        }
    }

    private static String getTypeStringRepresentation(CsmType csmType) {
        return ((Object)csmType.getCanonicalText()).toString();
    }

    private boolean acceptEditedValue() {
        TableCellEditor tableCellEditor = this.paramTable.getCellEditor();
        if (tableCellEditor != null) {
            return this.paramTable.getCellEditor().stopCellEditing();
        }
        return false;
    }

    private void doMove(int n) {
        this.acceptEditedValue();
        ListSelectionModel listSelectionModel = this.paramTable.getSelectionModel();
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        listSelectionModel.clearSelection();
        this.model.moveRow(n2, n3, n2 + n);
        listSelectionModel.addSelectionInterval(n2 + n, n3 + n);
    }

    private void setButtons(int n, int n2) {
        int n3 = this.model.getRowCount() - 1;
        this.moveUpButton.setEnabled(n > 0);
        this.moveDownButton.setEnabled(n2 < n3);
    }

    private void initRenderer() {
        TableColumnModel tableColumnModel = this.paramTable.getColumnModel();
        this.paramTable.removeColumn(tableColumnModel.getColumn(3));
        this.paramTable.removeColumn(tableColumnModel.getColumn(3));
        Enumeration<TableColumn> enumeration = this.paramTable.getColumnModel().getColumns();
        TableColumn tableColumn = null;
        while (enumeration.hasMoreElements()) {
            tableColumn = enumeration.nextElement();
            tableColumn.setCellRenderer(new ParamRenderer());
        }
    }

    private void setModifier(CsmVisibility csmVisibility) {
        this.modifier = csmVisibility;
        switch (csmVisibility) {
            case NONE: {
                this.modifiersCombo.setSelectedIndex(3);
                break;
            }
            case PRIVATE: {
                this.modifiersCombo.setSelectedIndex(2);
                break;
            }
            case PROTECTED: {
                this.modifiersCombo.setSelectedIndex(1);
                break;
            }
            case PUBLIC: {
                this.modifiersCombo.setSelectedIndex(0);
            }
        }
    }

    public String genDeclarationString() {
        String string;
        String string2 = this.modifiersCombo.getSelectedIndex() != 3 ? (String)this.modifiersCombo.getSelectedItem() + ":" : "";
        StringBuilder stringBuilder = new StringBuilder(string2);
        if (CsmKindUtilities.isConstructor((CsmObject)this.functionObj)) {
            stringBuilder.append(' ');
            string = CsmRefactoringUtils.getSimpleText((CsmObject)this.functionObj);
        } else {
            stringBuilder.append(this.returnType);
            stringBuilder.append(' ');
            string = CsmRefactoringUtils.getSimpleText((CsmObject)this.functionObj);
        }
        stringBuilder.append(string);
        stringBuilder.append('(');
        Vector<Vector> vector = this.model.getDataVector();
        List[] listArray = vector.toArray(new List[0]);
        if (listArray.length > 0) {
            String string3;
            int n;
            for (n = 0; n < listArray.length - 1; ++n) {
                stringBuilder.append(listArray[n].get(1));
                stringBuilder.append(' ');
                stringBuilder.append(listArray[n].get(0));
                string3 = (String)listArray[n].get(2);
                if (string3 != null && string3.length() > 0) {
                    stringBuilder.append(" /* = ").append(string3).append(" */");
                }
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(listArray[n].get(1));
            stringBuilder.append(' ');
            stringBuilder.append(listArray[n].get(0));
            string3 = (String)listArray[n].get(2);
            if (string3 != null && string3.length() > 0) {
                stringBuilder.append(" /* = ").append(string3).append(" */");
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ChangeParametersPanel.class, (String)string);
    }

    private static Action getEditAction() {
        if (editAction == null) {
            editAction = new EditAction();
        }
        return editAction;
    }

    private static void autoEdit(JTable jTable) {
        if (jTable.editCellAt(jTable.getSelectedRow(), jTable.getSelectedColumn(), null) && jTable.getEditorComponent() != null) {
            JTextField jTextField = (JTextField)jTable.getEditorComponent();
            jTextField.setCaretPosition(jTextField.getText().length());
            jTextField.requestFocusInWindow();
            jTextField.selectAll();
        }
    }

    class ParamRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        Color origBackground;

        public ParamRenderer() {
            this.setOpaque(true);
            this.origBackground = this.getBackground();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = ChangeParametersPanel.this.model.isRemovable(n);
            if (!bl) {
                if (!bl3) {
                    this.setBackground(UIManager.getColor("Panel.background"));
                } else {
                    this.setBackground(this.origBackground);
                }
            }
            return this;
        }
    }

    private static class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ChangeParametersPanel.autoEdit((JTable)actionEvent.getSource());
        }
    }

    static class ParamTableModel
    extends DefaultTableModel {
        public ParamTableModel(Object[] objectArray, int n) {
            super(objectArray, n);
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 > 2) {
                return false;
            }
            Integer n3 = (Integer)this.getDataVector().get(n).get(3);
            return n3 == -1;
        }

        public boolean isRemovable(int n) {
            return (Boolean)this.getDataVector().get(n).get(4);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

