/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.plugins.CsmRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmModificationRefactoringPlugin
extends CsmRefactoringPlugin {
    private final CsmObject startReferenceObject;
    private final CsmContext editorContext;
    private final AbstractRefactoring refactoring;

    protected CsmModificationRefactoringPlugin(AbstractRefactoring abstractRefactoring) {
        this.refactoring = abstractRefactoring;
        this.startReferenceObject = (CsmObject)abstractRefactoring.getRefactoringSource().lookup(CsmObject.class);
        this.editorContext = (CsmContext)abstractRefactoring.getRefactoringSource().lookup(CsmContext.class);
        assert (this.startReferenceObject != null || this.editorContext != null) : "no start reference or editor context";
    }

    protected final CsmObject getStartReferenceObject() {
        return this.startReferenceObject;
    }

    protected final CsmContext getEditorContext() {
        return this.editorContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Problem problem = null;
        try {
            Collection<CsmFile> collection = this.getRefactoredFiles();
            this.fireProgressListenerStart(1, collection.size());
            problem = this.createAndAddElements(collection, refactoringElementsBag, this.refactoring);
        }
        finally {
            this.fireProgressListenerStop();
        }
        return problem;
    }

    protected abstract Collection<CsmFile> getRefactoredFiles();

    protected final Problem checkIfModificationPossible(Problem problem, CsmObject csmObject, String string, String string2) {
        problem = this.checkIfModificationPossibleInFile(problem, csmObject);
        this.fireProgressListenerStep();
        if (problem != null) {
            return problem;
        }
        if (CsmKindUtilities.isMethod((CsmObject)csmObject)) {
            Collection collection;
            this.fireProgressListenerStep();
            CsmMethod csmMethod = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)csmObject));
            if (CsmVirtualInfoQuery.getDefault().isVirtual(csmMethod) && (collection = CsmVirtualInfoQuery.getDefault().getOverridenMethods(csmMethod, true)).size() > 1) {
                Object object2;
                for (Object object2 : collection) {
                    problem = this.checkIfModificationPossibleInFile(problem, (CsmObject)object2);
                    CsmFunctionDefinition csmFunctionDefinition = object2.getDefinition();
                    if (csmFunctionDefinition == null || object2.equals(csmFunctionDefinition)) continue;
                    problem = this.checkIfModificationPossibleInFile(problem, (CsmObject)csmFunctionDefinition);
                }
                boolean bl = problem != null;
                object2 = bl ? string : string2;
                problem = CsmModificationRefactoringPlugin.createProblem(problem, bl, (String)object2);
            }
        } else {
            this.fireProgressListenerStep();
        }
        return problem;
    }

    private Problem checkIfModificationPossibleInFile(Problem problem, CsmObject csmObject) {
        CsmFile csmFile = null;
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            csmFile = (CsmFile)csmObject;
        } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            csmFile = ((CsmOffsetable)csmObject).getContainingFile();
        }
        if (csmFile != null) {
            FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
            if (!CsmRefactoringUtils.isRefactorable(fileObject)) {
                problem = CsmModificationRefactoringPlugin.createProblem(problem, true, this.getCannotRename(fileObject));
            }
            if (problem == null && !CsmRefactoringUtils.isElementInOpenProject(fileObject)) {
                problem = new Problem(true, NbBundle.getMessage(CsmModificationRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
        }
        return problem;
    }

    private String getCannotRename(FileObject fileObject) {
        return new MessageFormat(NbBundle.getMessage(CsmModificationRefactoringPlugin.class, (String)"ERR_CannotModifyInFile")).format(new Object[]{fileObject.getNameExt()});
    }

    @Override
    protected final ModificationResult processFiles(Collection<CsmFile> collection, AtomicReference<Problem> atomicReference) {
        ModificationResult modificationResult = null;
        for (CsmFile csmFile : collection) {
            if (this.isCancelled()) {
                return null;
            }
            if (modificationResult == null) {
                modificationResult = new ModificationResult(csmFile.getProject());
            }
            this.processFile(csmFile, modificationResult, atomicReference);
            this.fireProgressListenerStep();
        }
        return modificationResult;
    }

    protected abstract void processFile(CsmFile var1, ModificationResult var2, AtomicReference<Problem> var3);
}

