/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuxiliaryConfigBasedPreferencesProvider {
    private static Map<Project, Reference<AuxiliaryConfigBasedPreferencesProvider>> projects2SharedPrefs = new WeakHashMap<Project, Reference<AuxiliaryConfigBasedPreferencesProvider>>();
    private static Map<Project, Reference<AuxiliaryConfigBasedPreferencesProvider>> projects2PrivatePrefs = new WeakHashMap<Project, Reference<AuxiliaryConfigBasedPreferencesProvider>>();
    static final String NAMESPACE = "http://www.netbeans.org/ns/auxiliary-configuration-preferences/1";
    static final String EL_PREFERENCES = "preferences";
    private static final String EL_MODULE = "module";
    private static final String EL_PROPERTY = "property";
    private static final String EL_NODE = "node";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String INVALID_KEY_CHARACTERS = "_.";
    private static final RequestProcessor WORKER = new RequestProcessor("AuxiliaryConfigBasedPreferencesProvider worker", 1);
    private static final int AUTOFLUSH_TIMEOUT = 5000;
    private final Project project;
    private final AuxiliaryConfiguration ac;
    private final AuxiliaryProperties ap;
    private final boolean shared;
    private final Map<String, Reference<AuxiliaryConfigBasedPreferences>> module2Preferences = new HashMap<String, Reference<AuxiliaryConfigBasedPreferences>>();
    private Element configRoot;
    private boolean modified;
    private final RequestProcessor.Task autoFlushTask = WORKER.create(new Runnable(){

        public void run() {
            AuxiliaryConfigBasedPreferencesProvider.this.flush();
        }
    });
    private final Map<String, Map<String, String>> path2Data = new HashMap<String, Map<String, String>>();
    private final Map<String, Set<String>> path2Removed = new HashMap<String, Set<String>>();
    private final Set<String> removedNodes = new HashSet<String>();
    private final Set<String> createdNodes = new HashSet<String>();

    static synchronized AuxiliaryConfigBasedPreferencesProvider findProvider(Project project, boolean bl) {
        AuxiliaryConfigBasedPreferencesProvider auxiliaryConfigBasedPreferencesProvider;
        Map<Project, Reference<AuxiliaryConfigBasedPreferencesProvider>> map = bl ? projects2SharedPrefs : projects2PrivatePrefs;
        Reference<AuxiliaryConfigBasedPreferencesProvider> reference = map.get(project);
        AuxiliaryConfigBasedPreferencesProvider auxiliaryConfigBasedPreferencesProvider2 = auxiliaryConfigBasedPreferencesProvider = reference != null ? reference.get() : null;
        if (auxiliaryConfigBasedPreferencesProvider != null) {
            return auxiliaryConfigBasedPreferencesProvider;
        }
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration(project);
        assert (project.getLookup() != null) : project;
        AuxiliaryProperties auxiliaryProperties = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
        auxiliaryConfigBasedPreferencesProvider = new AuxiliaryConfigBasedPreferencesProvider(project, auxiliaryConfiguration, auxiliaryProperties, bl);
        map.put(project, new WeakReference<AuxiliaryConfigBasedPreferencesProvider>(auxiliaryConfigBasedPreferencesProvider));
        return auxiliaryConfigBasedPreferencesProvider;
    }

    public static Preferences getPreferences(Project project, Class clazz, boolean bl) {
        AuxiliaryConfigBasedPreferencesProvider auxiliaryConfigBasedPreferencesProvider = AuxiliaryConfigBasedPreferencesProvider.findProvider(project, bl);
        if (auxiliaryConfigBasedPreferencesProvider == null) {
            return null;
        }
        return auxiliaryConfigBasedPreferencesProvider.findModule(AuxiliaryConfigBasedPreferencesProvider.findCNBForClass(clazz));
    }

    private static String encodeString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (INVALID_KEY_CHARACTERS.indexOf(c) == -1) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append("_");
            stringBuilder.append(Integer.toHexString(c));
            stringBuilder.append("_");
        }
        return stringBuilder.toString();
    }

    private static String decodeString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("_");
        for (int i = 0; i < stringArray.length; i += 2) {
            stringBuilder.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuilder.append((char)Integer.parseInt(stringArray[i + 1], 16));
        }
        return stringBuilder.toString();
    }

    AuxiliaryConfigBasedPreferencesProvider(Project project, AuxiliaryConfiguration auxiliaryConfiguration, AuxiliaryProperties auxiliaryProperties, boolean bl) {
        this.project = project;
        this.ac = auxiliaryConfiguration;
        this.ap = auxiliaryProperties;
        this.shared = bl;
        this.loadConfigRoot();
    }

    private void loadConfigRoot() {
        if (this.ac == null) {
            return;
        }
        Element element = this.ac.getConfigurationFragment(EL_PREFERENCES, NAMESPACE, this.shared);
        if (element == null) {
            element = XMLUtil.createDocument((String)EL_PREFERENCES, (String)NAMESPACE, null, null).createElementNS(NAMESPACE, EL_PREFERENCES);
        }
        this.configRoot = element;
    }

    void flush() {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                AuxiliaryConfigBasedPreferencesProvider.this.flushImpl();
                return null;
            }
        });
    }

    private synchronized void flushImpl() {
        Element element;
        Object object;
        Object object2;
        if (!this.modified) {
            return;
        }
        boolean bl = false;
        for (String object3 : this.removedNodes) {
            if (this.ac != null && (object2 = this.findRelative(object3, false)) != null) {
                object2.getParentNode().removeChild((Node)object2);
                bl = true;
            }
            if (this.ap == null) continue;
            object2 = this.toPropertyName(object3, "");
            for (String string : this.ap.listKeys(this.shared)) {
                if (!string.startsWith((String)object2)) continue;
                this.ap.put(string, null, this.shared);
            }
        }
        for (Map.Entry entry : this.path2Data.entrySet()) {
            if (this.ap != null) {
                object2 = ((Map)entry.getValue()).entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    this.ap.put(this.toPropertyName((String)entry.getKey(), (String)object.getKey()), (String)object.getValue(), this.shared);
                }
                continue;
            }
            object2 = this.findRelative((String)entry.getKey(), true);
            if (object2 == null) continue;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                element = AuxiliaryConfigBasedPreferencesProvider.find(object2, (String)entry2.getKey(), EL_PROPERTY, true);
                element.setAttribute(ATTR_VALUE, (String)entry2.getValue());
            }
            bl = true;
        }
        for (Map.Entry entry : this.path2Removed.entrySet()) {
            if (this.ac != null && (object2 = this.findRelative((String)entry.getKey(), false)) != null) {
                for (String string : (Set)entry.getValue()) {
                    element = AuxiliaryConfigBasedPreferencesProvider.find(object2, string, EL_PROPERTY, true);
                    object2.removeChild(element);
                }
                bl = true;
            }
            if (this.ap == null) continue;
            object2 = ((Set)entry.getValue()).iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.ap.put(this.toPropertyName((String)entry.getKey(), (String)object), null, this.shared);
            }
        }
        if (bl) {
            this.ac.putConfigurationFragment(this.configRoot, true);
        }
        try {
            ProjectManager.getDefault().saveProject(this.project);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.path2Data.clear();
        this.path2Removed.clear();
        this.removedNodes.clear();
        this.modified = false;
    }

    void sync() {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                AuxiliaryConfigBasedPreferencesProvider.this.syncImpl();
                return null;
            }
        });
    }

    private synchronized void syncImpl() {
        this.loadConfigRoot();
        this.flush();
    }

    private void markModified() {
        this.autoFlushTask.cancel();
        this.autoFlushTask.schedule(5000);
        this.modified = true;
    }

    private static String findCNBForClass(Class clazz) {
        String string = null;
        ClassLoader classLoader = clazz.getClassLoader();
        for (ModuleInfo moduleInfo : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            if (!moduleInfo.isEnabled() || moduleInfo.getClassLoader() != classLoader) continue;
            string = moduleInfo.getCodeNameBase();
            break;
        }
        if (string == null) {
            string = clazz.getName().replaceFirst("(^|\\.)[^.]+$", "");
        }
        assert (string != null);
        return string.replace('.', '-');
    }

    public synchronized Preferences findModule(String string) {
        AuxiliaryConfigBasedPreferences auxiliaryConfigBasedPreferences;
        Reference<AuxiliaryConfigBasedPreferences> reference = this.module2Preferences.get(string);
        AuxiliaryConfigBasedPreferences auxiliaryConfigBasedPreferences2 = auxiliaryConfigBasedPreferences = reference != null ? reference.get() : null;
        if (auxiliaryConfigBasedPreferences == null) {
            auxiliaryConfigBasedPreferences = new AuxiliaryConfigBasedPreferences(null, "", string);
            this.module2Preferences.put(string, new WeakReference<AuxiliaryConfigBasedPreferences>(auxiliaryConfigBasedPreferences));
        }
        return auxiliaryConfigBasedPreferences;
    }

    private Element findRelative(String string, boolean bl) {
        if (this.ac == null) {
            return null;
        }
        String[] stringArray = string.split("/");
        assert (stringArray.length > 0);
        Element element = AuxiliaryConfigBasedPreferencesProvider.find(this.configRoot, stringArray[0], EL_MODULE, bl);
        for (int i = 1; i < stringArray.length && element != null; ++i) {
            element = AuxiliaryConfigBasedPreferencesProvider.find(element, stringArray[i], EL_NODE, bl);
        }
        return element;
    }

    private Map<String, String> getData(String string) {
        Map<String, String> map = this.path2Data.get(string);
        if (map == null) {
            map = new HashMap<String, String>();
            this.path2Data.put(string, map);
        }
        return map;
    }

    private Set<String> getRemoved(String string) {
        Set<String> set = this.path2Removed.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.path2Removed.put(string, set);
        }
        return set;
    }

    private void removeNode(String string) {
        this.path2Data.remove(string);
        this.path2Removed.remove(string);
        this.createdNodes.remove(string);
        this.removedNodes.add(string);
    }

    private boolean isRemovedNode(String string) {
        return this.removedNodes.contains(string);
    }

    private static Element find(Element element, String string, String string2, boolean bl) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !NAMESPACE.equals(node.getNamespaceURI()) || !string2.equals(node.getLocalName()) || !string.equals(((Element)node).getAttribute(ATTR_NAME))) continue;
            return (Element)node;
        }
        if (!bl) {
            return null;
        }
        Element element2 = element.getOwnerDocument().createElementNS(NAMESPACE, string2);
        element2.setAttribute(ATTR_NAME, string);
        element.appendChild(element2);
        return element2;
    }

    private String toPropertyName(String string, String string2) {
        return AuxiliaryConfigBasedPreferencesProvider.encodeString(string).replace('/', '.') + '.' + AuxiliaryConfigBasedPreferencesProvider.encodeString(string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuxiliaryConfigBasedPreferences
    extends AbstractPreferences {
        private final String path;

        public AuxiliaryConfigBasedPreferences(AbstractPreferences abstractPreferences, String string, String string2) {
            super(abstractPreferences, string);
            this.path = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void putSpi(String string, String string2) {
            AuxiliaryConfigBasedPreferencesProvider auxiliaryConfigBasedPreferencesProvider = AuxiliaryConfigBasedPreferencesProvider.this;
            synchronized (auxiliaryConfigBasedPreferencesProvider) {
                AuxiliaryConfigBasedPreferencesProvider.this.getData(this.path).put(string, string2);
                AuxiliaryConfigBasedPreferencesProvider.this.getRemoved(this.path).remove(string);
                AuxiliaryConfigBasedPreferencesProvider.this.markModified();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String getSpi(String string) {
            AuxiliaryConfigBasedPreferencesProvider auxiliaryConfigBasedPreferencesProvider = AuxiliaryConfigBasedPreferencesProvider.this;
            synchronized (auxiliaryConfigBasedPreferencesProvider) {
                Object object;
                if (AuxiliaryConfigBasedPreferencesProvider.this.getRemoved(this.path).contains(string)) {
                    return null;
                }
                if (AuxiliaryConfigBasedPreferencesProvider.this.getData(this.path).containsKey(string)) {
                    return (String)AuxiliaryConfigBasedPreferencesProvider.this.getData(this.path).get(string);
                }
                if (AuxiliaryConfigBasedPreferencesProvider.this.isRemovedNode(this.path)) {
                    return null;
                }
                if (AuxiliaryConfigBasedPreferencesProvider.this.ap != null) {
                    object = AuxiliaryConfigBasedPreferencesProvider.this.toPropertyName(this.path, string);
                    String string2 = AuxiliaryConfigBasedPreferencesProvider.this.ap.get((String)object, AuxiliaryConfigBasedPreferencesProvider.this.shared);
                    if (string2 != null) {
                        return string2;
                    }
                }
                Object object2 = object = (object = AuxiliaryConfigBasedPreferencesProvider.this.findRelative(this.path, false)) != null ? AuxiliaryConfigBasedPreferencesProvider.find((Element)object, string, AuxiliaryConfigBasedPreferencesProvider.EL_PROPERTY, false) : null;
                if (object == null) {
                    return null;
                }
                return object.getAttribute(AuxiliaryConfigBasedPreferencesProvider.ATTR_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void removeSpi(String string) {
            AuxiliaryConfigBasedPreferencesProvider auxiliaryConfigBasedPreferencesProvider = AuxiliaryConfigBasedPreferencesProvider.this;
            synchronized (auxiliaryConfigBasedPreferencesProvider) {
                AuxiliaryConfigBasedPreferencesProvider.this.getData(this.path).remove(string);
                AuxiliaryConfigBasedPreferencesProvider.this.getRemoved(this.path).add(string);
                AuxiliaryConfigBasedPreferencesProvider.this.markModified();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            AuxiliaryConfigBasedPreferencesProvider auxiliaryConfigBasedPreferencesProvider = AuxiliaryConfigBasedPreferencesProvider.this;
            synchronized (auxiliaryConfigBasedPreferencesProvider) {
                AuxiliaryConfigBasedPreferencesProvider.this.removeNode(this.path);
                AuxiliaryConfigBasedPreferencesProvider.this.markModified();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String[] keysSpi() throws BackingStoreException {
            AuxiliaryConfigBasedPreferencesProvider auxiliaryConfigBasedPreferencesProvider = AuxiliaryConfigBasedPreferencesProvider.this;
            synchronized (auxiliaryConfigBasedPreferencesProvider) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                if (!AuxiliaryConfigBasedPreferencesProvider.this.isRemovedNode(this.path)) {
                    linkedHashSet.addAll(this.list(AuxiliaryConfigBasedPreferencesProvider.EL_PROPERTY));
                }
                if (AuxiliaryConfigBasedPreferencesProvider.this.ap != null) {
                    String string = AuxiliaryConfigBasedPreferencesProvider.this.toPropertyName(this.path, "");
                    for (String string2 : AuxiliaryConfigBasedPreferencesProvider.this.ap.listKeys(AuxiliaryConfigBasedPreferencesProvider.this.shared)) {
                        String string3;
                        if (!string2.startsWith(string) || (string3 = string2.substring(string.length())).length() <= 0 || string3.indexOf(46) != -1) continue;
                        linkedHashSet.add(AuxiliaryConfigBasedPreferencesProvider.decodeString(string3));
                    }
                }
                linkedHashSet.addAll(AuxiliaryConfigBasedPreferencesProvider.this.getData(this.path).keySet());
                linkedHashSet.removeAll(AuxiliaryConfigBasedPreferencesProvider.this.getRemoved(this.path));
                return linkedHashSet.toArray(new String[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            AuxiliaryConfigBasedPreferencesProvider auxiliaryConfigBasedPreferencesProvider = AuxiliaryConfigBasedPreferencesProvider.this;
            synchronized (auxiliaryConfigBasedPreferencesProvider) {
                return this.getChildrenNames().toArray(new String[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected AbstractPreferences childSpi(String string) {
            AuxiliaryConfigBasedPreferencesProvider auxiliaryConfigBasedPreferencesProvider = AuxiliaryConfigBasedPreferencesProvider.this;
            synchronized (auxiliaryConfigBasedPreferencesProvider) {
                String string2 = this.path + "/" + string;
                if (!this.getChildrenNames().contains(string)) {
                    AuxiliaryConfigBasedPreferencesProvider.this.createdNodes.add(string2);
                }
                return new AuxiliaryConfigBasedPreferences(this, string, string2);
            }
        }

        @Override
        public void sync() throws BackingStoreException {
            AuxiliaryConfigBasedPreferencesProvider.this.sync();
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Should never be called.");
        }

        @Override
        public void flush() throws BackingStoreException {
            AuxiliaryConfigBasedPreferencesProvider.this.flush();
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Should never be called.");
        }

        private Collection<String> getChildrenNames() {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            if (!AuxiliaryConfigBasedPreferencesProvider.this.isRemovedNode(this.path)) {
                linkedHashSet.addAll(this.list(AuxiliaryConfigBasedPreferencesProvider.EL_NODE));
            }
            for (Object object : AuxiliaryConfigBasedPreferencesProvider.this.removedNodes) {
                int n;
                if (!this.path.equals(((String)object).substring(n = ((String)object).lastIndexOf(47)))) continue;
                linkedHashSet.remove(((String)object).substring(n + 1));
            }
            if (AuxiliaryConfigBasedPreferencesProvider.this.ap != null) {
                String string = AuxiliaryConfigBasedPreferencesProvider.this.toPropertyName(this.path, "");
                for (String string2 : AuxiliaryConfigBasedPreferencesProvider.this.ap.listKeys(AuxiliaryConfigBasedPreferencesProvider.this.shared)) {
                    String string3;
                    if (!string2.startsWith(string) || (string3 = string2.substring(string.length())).length() <= 0 || string3.indexOf(46) == -1) continue;
                    string3 = string3.substring(0, string3.indexOf(46));
                    linkedHashSet.add(AuxiliaryConfigBasedPreferencesProvider.decodeString(string3));
                }
            }
            for (Object object : AuxiliaryConfigBasedPreferencesProvider.this.createdNodes) {
                int n;
                if (!this.path.equals(((String)object).substring(n = ((String)object).lastIndexOf(47)))) continue;
                linkedHashSet.add(((String)object).substring(n + 1));
            }
            return linkedHashSet;
        }

        private Collection<String> list(String string) throws DOMException {
            Element element = AuxiliaryConfigBasedPreferencesProvider.this.findRelative(this.path, false);
            if (element == null) {
                return Collections.emptyList();
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            NodeList nodeList = element.getElementsByTagNameNS(AuxiliaryConfigBasedPreferencesProvider.NAMESPACE, string);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                linkedList.add(((Element)node).getAttribute(AuxiliaryConfigBasedPreferencesProvider.ATTR_NAME));
            }
            return linkedList;
        }

        @Override
        public void put(final String string, final String string2) {
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    String string3 = AuxiliaryConfigBasedPreferences.this.getSpi(string);
                    if (string2.equals(string3)) {
                        return null;
                    }
                    try {
                        AuxiliaryConfigBasedPreferences.super.put(string, string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (illegalArgumentException.getMessage().contains("too long")) {
                            AuxiliaryConfigBasedPreferences.this.putSpi(string, string2);
                        }
                        throw illegalArgumentException;
                    }
                    return null;
                }
            });
        }

        @Override
        public String get(final String string, final String string2) {
            return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    return AuxiliaryConfigBasedPreferences.super.get(string, string2);
                }
            });
        }

        @Override
        public void remove(final String string) {
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    AuxiliaryConfigBasedPreferences.super.remove(string);
                    return null;
                }
            });
        }

        @Override
        public void clear() throws BackingStoreException {
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws BackingStoreException {
                        AuxiliaryConfigBasedPreferences.super.clear();
                        return null;
                    }
                });
            }
            catch (MutexException mutexException) {
                throw (BackingStoreException)mutexException.getException();
            }
        }

        @Override
        public String[] keys() throws BackingStoreException {
            try {
                return (String[])ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String[]>(){

                    public String[] run() throws BackingStoreException {
                        return AuxiliaryConfigBasedPreferences.super.keys();
                    }
                });
            }
            catch (MutexException mutexException) {
                throw (BackingStoreException)mutexException.getException();
            }
        }

        @Override
        public String[] childrenNames() throws BackingStoreException {
            try {
                return (String[])ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String[]>(){

                    public String[] run() throws BackingStoreException {
                        return AuxiliaryConfigBasedPreferences.super.childrenNames();
                    }
                });
            }
            catch (MutexException mutexException) {
                throw (BackingStoreException)mutexException.getException();
            }
        }

        @Override
        public Preferences node(final String string) {
            return (Preferences)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Preferences>(){

                public Preferences run() {
                    return AuxiliaryConfigBasedPreferences.super.node(string);
                }
            });
        }

        @Override
        public boolean nodeExists(final String string) throws BackingStoreException {
            try {
                return (Boolean)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                    public Boolean run() throws BackingStoreException {
                        return AuxiliaryConfigBasedPreferences.super.nodeExists(string);
                    }
                });
            }
            catch (MutexException mutexException) {
                throw (BackingStoreException)mutexException.getException();
            }
        }

        @Override
        public void removeNode() throws BackingStoreException {
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws BackingStoreException {
                        AuxiliaryConfigBasedPreferences.super.removeNode();
                        return null;
                    }
                });
            }
            catch (MutexException mutexException) {
                throw (BackingStoreException)mutexException.getException();
            }
        }

        @Override
        protected AbstractPreferences getChild(final String string) throws BackingStoreException {
            try {
                return (AbstractPreferences)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<AbstractPreferences>(){

                    public AbstractPreferences run() throws BackingStoreException {
                        return AuxiliaryConfigBasedPreferences.super.getChild(string);
                    }
                });
            }
            catch (MutexException mutexException) {
                throw (BackingStoreException)mutexException.getException();
            }
        }
    }
}

