/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.customizer;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;

public class RailsProjectProperties
extends SharedRubyProjectProperties {
    private static final Logger LOGGER = Logger.getLogger(RailsProjectProperties.class.getName());
    public static final String RAILS_PORT = "rails.port";
    public static final String RAILS_SERVERTYPE = "rails.servertype";
    public static final String RAILS_ENV = "rails.env";
    public static final String RAILS_URL = "rails.url";
    private static final String[] CONFIG_PROPS = new String[]{"rails.port", "rails.servertype", "rake.args", "rails.env", "rails.url", "main.file", "application.args", "ruby.options", "rails.servertype", "platform.active"};
    private static final String[] CONFIG_PRIVATE_PROPS = new String[]{"rails.port", "rails.env", "rake.args", "application.args", "platform.active"};
    private RubyInstance server;
    private String railsEnvironment;

    public RailsProjectProperties(RubyBaseProject rubyBaseProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, GeneratedFilesHelper generatedFilesHelper) {
        super(rubyBaseProject, propertyEvaluator, updateHelper, generatedFilesHelper, referenceHelper);
    }

    RailsProject getRailsProject() {
        return (RailsProject)((Object)this.getProject().getLookup().lookup(RailsProject.class));
    }

    protected String[] getConfigProperties() {
        return CONFIG_PROPS;
    }

    protected String[] getConfigPrivateProperties() {
        return CONFIG_PRIVATE_PROPS;
    }

    protected void prePropertiesStore() throws IOException {
    }

    protected void storeProperties(EditableProperties editableProperties, EditableProperties editableProperties2) throws IOException {
        RubyPlatform rubyPlatform;
        if (this.server != null) {
            editableProperties2.remove((Object)RAILS_SERVERTYPE);
            editableProperties.setProperty(RAILS_SERVERTYPE, this.server.getServerUri());
        }
        if (this.getRailsEnvironment() != null) {
            editableProperties2.setProperty(RAILS_ENV, this.getRailsEnvironment());
        }
        if ((rubyPlatform = this.getPlatform()) == null) {
            LOGGER.fine("Project has invalid platform (null).");
            return;
        }
        RubyPlatform.Info info = rubyPlatform.getInfo();
        Util.logUsage(RailsProjectProperties.class, (String)"USG_PROJECT_CONFIG_RAILS", (Object[])new Object[]{info.getKind(), info.getPlatformVersion(), info.getGemVersion(), this.getServerIdForLogging(), "", ""});
    }

    private String getServerIdForLogging() {
        if (this.server != null) {
            return this.server.getDisplayName();
        }
        String string = this.evaluator.getProperty(RAILS_SERVERTYPE);
        RubyInstance rubyInstance = ServerRegistry.getDefault().getServer(string, this.getPlatform());
        return rubyInstance != null ? rubyInstance.getDisplayName() : "";
    }

    RubyInstance getServer() {
        return this.server;
    }

    void setServer(RubyInstance rubyInstance, String string) {
        ((Map)this.getRunConfigs().get(string)).put(RAILS_SERVERTYPE, rubyInstance.getServerUri());
        this.server = rubyInstance;
    }

    String getRailsEnvironment() {
        return this.railsEnvironment;
    }

    void setRailsEnvironment(String string, String string2) {
        if (string != null) {
            ((Map)this.getRunConfigs().get(string2)).put(RAILS_ENV, string);
        }
        this.railsEnvironment = string;
    }
}

