/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.railsprojects.Generator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.SourceRoots;
import org.netbeans.modules.ruby.railsprojects.ui.TreeRootNode;
import org.netbeans.modules.ruby.railsprojects.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.ui.LibrariesNode;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class ProjectRootNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        RailsProject railsProject = (RailsProject)((Object)project.getLookup().lookup(RailsProject.class));
        assert (railsProject != null);
        return new RootChildren(railsProject);
    }

    static class PreselectPropertiesAction
    extends AbstractAction {
        private final Project project;
        private final String nodeName;
        private final String panelName;

        public PreselectPropertiesAction(Project project, String string) {
            this(project, string, null);
        }

        public PreselectPropertiesAction(Project project, String string, String string2) {
            super(NbBundle.getMessage(ProjectRootNodeFactory.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = string;
            this.panelName = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomizerProviderImpl customizerProviderImpl = (CustomizerProviderImpl)((Object)this.project.getLookup().lookup(CustomizerProviderImpl.class));
            if (customizerProviderImpl != null) {
                customizerProviderImpl.showCustomizer(this.nodeName, this.panelName);
            }
        }
    }

    private static class FolderViewFilterNode
    extends FilterNode {
        private String nodeName;
        private Project project;
        Action[] actions;

        public FolderViewFilterNode(SourceGroup sourceGroup, Generator generator, Project project) {
            super((Node)new RootNode(sourceGroup, generator));
            this.project = project;
            this.nodeName = "Sources";
        }

        public Action[] getActions(boolean bl) {
            if (!bl) {
                if (this.actions == null) {
                    Action[] actionArray = super.getActions(bl);
                    this.actions = new Action[actionArray.length + 2];
                    System.arraycopy(actionArray, 0, this.actions, 0, actionArray.length);
                    this.actions[actionArray.length] = null;
                    this.actions[actionArray.length + 1] = new PreselectPropertiesAction(this.project, this.nodeName);
                }
                return this.actions;
            }
            return super.getActions(bl);
        }
    }

    private static final class RootNode
    extends FilterNode {
        private SourceGroup sourceGroup;

        private RootNode(SourceGroup sourceGroup, Generator generator) {
            super(RootNode.getOriginalNode(sourceGroup, generator));
            this.sourceGroup = sourceGroup;
        }

        private static Node getOriginalNode(SourceGroup sourceGroup, Generator generator) {
            FileObject fileObject = sourceGroup.getRootFolder();
            if (fileObject == null || !fileObject.isValid()) {
                return new AbstractNode(FilterNode.Children.LEAF, Lookups.singleton((Object)Generator.NONE));
            }
            return new TreeRootNode(sourceGroup, generator);
        }
    }

    private static class RootChildNode {
        private final SourceGroup group;
        private final FileObject fileObject;
        private final Generator generator;
        private final boolean libraryNode;

        private RootChildNode(SourceGroup sourceGroup, FileObject fileObject, Generator generator, boolean bl) {
            this.group = sourceGroup;
            this.fileObject = fileObject;
            this.generator = generator;
            this.libraryNode = bl;
        }

        private RootChildNode(SourceGroup sourceGroup, FileObject fileObject, Generator generator) {
            this(sourceGroup, fileObject, generator, false);
        }

        static RootChildNode group(SourceGroup sourceGroup, Generator generator) {
            return new RootChildNode(sourceGroup, sourceGroup.getRootFolder(), generator);
        }

        static RootChildNode fileObject(FileObject fileObject) {
            return new RootChildNode(null, fileObject, Generator.NONE);
        }

        static RootChildNode libraries() {
            return new RootChildNode(null, null, Generator.NONE, true);
        }

        public int hashCode() {
            if (this.libraryNode) {
                return 0;
            }
            return this.fileObject.hashCode();
        }

        public boolean equals(Object object) {
            String string;
            if (!(object instanceof RootChildNode)) {
                return false;
            }
            RootChildNode rootChildNode = (RootChildNode)object;
            if (this.libraryNode || rootChildNode.libraryNode) {
                return this.libraryNode && rootChildNode.libraryNode;
            }
            String string2 = this.group == null ? null : this.group.getDisplayName();
            String string3 = string = rootChildNode.group == null ? null : rootChildNode.group.getDisplayName();
            return this.fileObject.equals(rootChildNode.fileObject) && (string2 == null ? string == null : string2.equals(string));
        }

        public String toString() {
            return "ProjectRootNodeFactory[fileObject: " + this.fileObject + ", group: " + this.group + ", generator: " + this.generator + ", libraryNode: " + this.libraryNode + ']';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootChildren
    implements NodeList<RootChildNode>,
    ChangeListener {
        private final RailsProject project;
        private final List<ChangeListener> listeners;

        public RootChildren(RailsProject railsProject) {
            this.project = railsProject;
            this.listeners = new ArrayList<ChangeListener>();
        }

        public List<RootChildNode> keys() {
            FileObject[] fileObjectArray;
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("ruby");
            ArrayList<RootChildNode> arrayList = new ArrayList<RootChildNode>(sourceGroupArray.length);
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                arrayList.add(RootChildNode.group(sourceGroupArray[i], this.getGenerator(sourceGroupArray[i].getName())));
            }
            arrayList.add(RootChildNode.libraries());
            SourceRoots sourceRoots = this.project.getSourceRoots();
            if (sourceRoots != null && (fileObjectArray = sourceRoots.getExtraFiles()) != null && fileObjectArray.length > 0) {
                for (FileObject fileObject : fileObjectArray) {
                    arrayList.add(RootChildNode.fileObject(fileObject));
                }
            }
            return arrayList;
        }

        private Generator getGenerator(String string) {
            if (string.equals("app/controllers")) {
                return Generator.CONTROLLER;
            }
            if (string.equals("app/views")) {
                return Generator.CONTROLLER;
            }
            if (string.equals("app/models")) {
                return Generator.MODEL;
            }
            if (string.equals("db")) {
                return Generator.MIGRATION;
            }
            return Generator.NONE;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
            RootChildren rootChildren = this;
            synchronized (rootChildren) {
                arrayList.addAll(this.listeners);
            }
            for (ChangeListener changeListener : arrayList) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(RootChildNode rootChildNode) {
            if (rootChildNode.libraryNode) {
                return new LibrariesNode((RubyBaseProject)this.project);
            }
            if (rootChildNode.group != null) {
                return new FolderViewFilterNode(rootChildNode.group, rootChildNode.generator, (Project)this.project);
            }
            if (rootChildNode.fileObject != null) {
                try {
                    if (RakeSupport.isRakeFile((FileObject)rootChildNode.fileObject)) {
                        return new RakeSupport.RakeNode(rootChildNode.fileObject);
                    }
                    DataObject dataObject = DataObject.find((FileObject)rootChildNode.fileObject);
                    return new FilterNode(dataObject.getNodeDelegate());
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                    return null;
                }
            }
            throw new AssertionError((Object)("Unknown/Invalid key: " + rootChildNode));
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RootChildren.this.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }
}

