/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.LocationMappersFactory;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

final class RailsUrlDisplayer {
    private static final Logger LOGGER = Logger.getLogger(RailsUrlDisplayer.class.getName());
    private static boolean NO_BROWSER = Boolean.getBoolean("rails.nobrowser");

    RailsUrlDisplayer() {
    }

    static void showURL(String string, String string2, int n, boolean bl, RailsProject railsProject) {
        if (NO_BROWSER) {
            return;
        }
        LOGGER.fine("Opening URL: http://localhost:" + n + "/" + string2);
        try {
            URL uRL = new URL("http://localhost:" + n + string + "/" + string2);
            if (!bl) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            } else {
                FileObject fileObject = railsProject.getRakeProjectHelper().resolveFileObject("public");
                String string3 = "http://localhost:" + n + "/";
                HtmlBrowser.Factory factory = null;
                factory = WebClientToolsProjectUtils.isInternetExplorer((Project)railsProject) ? WebClientToolsProjectUtils.getInternetExplorerBrowser() : WebClientToolsProjectUtils.getFirefoxBrowser();
                if (factory == null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                    return;
                }
                LocationMappersFactory locationMappersFactory = (LocationMappersFactory)Lookup.getDefault().lookup(LocationMappersFactory.class);
                Lookup lookup = null;
                if (locationMappersFactory != null) {
                    URI uRI = new URI(string3);
                    HashMap<String, String> hashMap = null;
                    FileObject fileObject2 = fileObject.getFileObject("index.html");
                    if (fileObject2 != null) {
                        hashMap = new HashMap<String, String>();
                        hashMap.put("welcome-file", "index.html");
                    }
                    JSToNbJSLocationMapper jSToNbJSLocationMapper = locationMappersFactory.getJSToNbJSLocationMapper(fileObject, uRI, hashMap);
                    NbJSToJSLocationMapper nbJSToJSLocationMapper = locationMappersFactory.getNbJSToJSLocationMapper(fileObject, uRI, hashMap);
                    lookup = Lookups.fixed((Object[])new Object[]{jSToNbJSLocationMapper, nbJSToJSLocationMapper, railsProject});
                } else {
                    lookup = Lookups.fixed((Object[])new Object[]{railsProject});
                }
                WebClientToolsSessionStarterService.startSession((URI)uRL.toURI(), (HtmlBrowser.Factory)factory, (Lookup)lookup);
            }
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify((Throwable)malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
        }
        catch (WebClientToolsSessionException webClientToolsSessionException) {
            ErrorManager.getDefault().notify((Throwable)webClientToolsSessionException);
        }
    }
}

