/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.ruby.platform.RubyInstallation;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformProvider;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BootClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final Logger LOGGER;
    private static final boolean INCLUDE_NONLIBPLUGINS;
    private static final Pattern GEM_EXCLUDE_FILTER;
    private static final Pattern GEM_INCLUDE_FILTER;
    private File projectDirectory;
    private final PropertyEvaluator evaluator;
    private String activePlatformName;
    private boolean isActivePlatformValid;
    private List<PathResourceImplementation> resourcesCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public BootClassPathImplementation(File file, PropertyEvaluator propertyEvaluator) {
        this.projectDirectory = file;
        assert (propertyEvaluator != null);
        this.evaluator = propertyEvaluator;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resourcesCache == null) {
            Serializable serializable22;
            ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
            try {
                arrayList.add(ClassPathSupport.createResource((URL)RubyPlatform.getRubyStubs().getURL()));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            RubyPlatform rubyPlatform = new RubyPlatformProvider(this.evaluator).getPlatform();
            if (rubyPlatform == null) {
                LOGGER.severe("Cannot resolve platform for project: " + this.projectDirectory);
                return Collections.emptyList();
            }
            if (!rubyPlatform.hasRubyGemsInstalled()) {
                LOGGER.fine("Not RubyGems installed, returning empty result");
                return Collections.emptyList();
            }
            GemManager gemManager = rubyPlatform.getGemManager();
            assert (gemManager != null) : "not null when RubyGems are installed";
            Map<String, URL> map = gemManager.getGemUrls();
            Map map2 = gemManager.getGemVersions();
            for (Serializable serializable22 : gemManager.getNonGemLoadPath()) {
                arrayList.add(ClassPathSupport.createResource((URL)serializable22));
            }
            Object object = GEM_INCLUDE_FILTER;
            serializable22 = GEM_EXCLUDE_FILTER;
            String string = this.evaluator.getProperty("ruby.includegems");
            String string2 = this.evaluator.getProperty("ruby.excludegems");
            try {
                if (string != null) {
                    object = Pattern.compile(string);
                }
                if (string2 != null) {
                    serializable22 = Pattern.compile(string2);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Exceptions.printStackTrace((Throwable)patternSyntaxException);
            }
            map = this.adjustGemsForExplicitVersion(map);
            File file = new File(this.projectDirectory, "vendor");
            if (file.exists()) {
                List<URL> list = this.getVendorPlugins(file);
                for (URL object22 : list) {
                    arrayList.add(ClassPathSupport.createResource((URL)object22));
                }
                List<URL> list2 = this.mergeVendorGems(file, new HashMap<String, String>(map2), new HashMap<String, URL>(map));
                Iterator string4 = list2.iterator();
                while (string4.hasNext()) {
                    String string3;
                    URL uRL = (URL)string4.next();
                    if (object != null && ((Pattern)object).matcher(string3 = BootClassPathImplementation.getGemName(uRL)).find()) {
                        arrayList.add(ClassPathSupport.createResource((URL)uRL));
                        continue;
                    }
                    if (serializable22 != null && ((Pattern)serializable22).matcher(string3 = BootClassPathImplementation.getGemName(uRL)).find()) continue;
                    arrayList.add(ClassPathSupport.createResource((URL)uRL));
                }
            } else {
                for (URL uRL : map.values()) {
                    String string4;
                    String string5;
                    if (object != null && ((Pattern)object).matcher(string5 = BootClassPathImplementation.getGemName(uRL)).find()) {
                        arrayList.add(ClassPathSupport.createResource((URL)uRL));
                        continue;
                    }
                    if (serializable22 != null && ((Pattern)serializable22).matcher(string4 = BootClassPathImplementation.getGemName(uRL)).find()) continue;
                    arrayList.add(ClassPathSupport.createResource((URL)uRL));
                }
            }
            this.resourcesCache = Collections.unmodifiableList(arrayList);
        }
        return this.resourcesCache;
    }

    private static String getGemName(URL uRL) {
        String string = uRL.getFile();
        if (string.endsWith("/lib/")) {
            string = string.substring(string.lastIndexOf(47, string.length() - 6) + 1, string.length() - 5);
        }
        return string;
    }

    private Map<String, URL> adjustGemsForExplicitVersion(Map<String, URL> map) {
        File file = new File(this.projectDirectory, "config" + File.separator + "environment.rb");
        if (!file.isFile()) {
            return map;
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            return map;
        }
        String string = RailsProjectUtil.getSpecifiedRailsVersion(fileObject);
        if (string == null) {
            return map;
        }
        String string2 = "activerecord";
        URL uRL = map.get(string2);
        if (uRL == null) {
            return map;
        }
        String string3 = uRL.toExternalForm();
        if (string3.indexOf(string2 + "-" + string) != -1) {
            return map;
        }
        Pattern pattern = Pattern.compile(".*activerecord-(\\d+\\.\\d+\\.\\d+).*");
        Matcher matcher = pattern.matcher(string3);
        if (!matcher.matches()) {
            return map;
        }
        String string4 = matcher.group(1);
        map.get("actionwebservice");
        String[] stringArray = new String[]{"actionmailer", "actionpack", "activerecord", "activeresource", "activesupport", "rails", "actionwebservice"};
        boolean bl = true;
        for (String string5 : stringArray) {
            String string6;
            String string7;
            int n;
            URL uRL2 = map.get(string5);
            if (uRL2 == null || (n = (string7 = uRL2.toExternalForm()).indexOf(string6 = string5 + "-" + string4)) == -1) continue;
            try {
                URL uRL3 = new URL(string7.replace(string6, string5 + "-" + string));
                if (bl) {
                    bl = false;
                    FileObject fileObject2 = URLMapper.findFileObject((URL)uRL3);
                    if (fileObject2 == null) {
                        return map;
                    }
                    map = new HashMap<String, URL>(map);
                }
                map.put(string5, uRL3);
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return map;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == RubyInstallation.getInstance() && propertyChangeEvent.getPropertyName().equals("roots")) {
            this.resetCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            this.resourcesCache = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    private List<URL> mergeVendorGems(File file, Map<String, String> map, Map<String, URL> map2) {
        BootClassPathImplementation.chooseGems(file.listFiles(), map, map2);
        return new ArrayList<URL>(map2.values());
    }

    private static void chooseGems(File[] fileArray, Map<String, String> map, Map<String, URL> map2) {
        Pattern pattern = Pattern.compile("(\\S|-)+-((\\d+)\\.(\\d+)\\.(\\d+))(-\\S+)?");
        for (File file : fileArray) {
            File file2;
            Matcher matcher;
            String string;
            if (!file.isDirectory() || "plugins".equals(string = file.getName())) continue;
            if ("rails".equals(string)) {
                BootClassPathImplementation.chooseRails(file.listFiles(), map, map2);
                continue;
            }
            if ("gems".equals(string) || "gems-jruby".equals(string)) {
                BootClassPathImplementation.chooseGems(file.listFiles(), map, map2);
            }
            if (string.indexOf(45) == -1 || !(matcher = pattern.matcher(string)).matches() || !(file2 = new File(file, "lib")).exists()) continue;
            try {
                URL uRL = file2.toURI().toURL();
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                BootClassPathImplementation.addGem(map, map2, string2, string3, uRL);
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
    }

    private static void addGem(Map<String, String> map, Map<String, URL> map2, String string, String string2, URL uRL) {
        if (!map.containsKey(string) || Util.compareVersions((String)string2, (String)map.get(string)) > 0) {
            map.put(string, string2);
            map2.put(string, uRL);
        }
    }

    private static void chooseRails(File[] fileArray, Map<String, String> map, Map<String, URL> map2) {
        for (File file : fileArray) {
            String string;
            File file2;
            File file3;
            String string2;
            if (!file.isDirectory()) continue;
            String string3 = string2 = file.getName();
            if (string2.indexOf(95) == -1 && (string2.startsWith("action") || string2.startsWith("active"))) {
                string3 = string2.substring(0, 6) + "_" + string2.substring(6);
            }
            if (!(file3 = new File(file, "lib")).exists() || !(file2 = new File(file3, string3 + File.separator + "version.rb")).exists() || (string = RailsProjectUtil.getVersionString(file2)) == null) continue;
            try {
                URL uRL = file3.toURI().toURL();
                BootClassPathImplementation.addGem(map, map2, string2, string, uRL);
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
    }

    private List<URL> getVendorPlugins(File file) {
        assert (file != null);
        File file2 = new File(file, "plugins");
        if (!file2.exists()) {
            return Collections.emptyList();
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file3 : file2.listFiles()) {
            File file4 = new File(file3, "lib");
            if (INCLUDE_NONLIBPLUGINS) {
                file4 = file3;
            }
            if (!file4.exists()) continue;
            try {
                URL uRL = file4.toURI().toURL();
                arrayList.add(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return arrayList;
    }

    static {
        Object object;
        LOGGER = Logger.getLogger(BootClassPathImplementation.class.getName());
        INCLUDE_NONLIBPLUGINS = Boolean.getBoolean("ruby.include_nonlib_plugins");
        String string = System.getProperty("rails.prj.excludegems");
        if (string == null || "none".equals(string)) {
            GEM_EXCLUDE_FILTER = null;
        } else {
            try {
                object = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Invalid regular expression: " + string);
                Logger.getAnonymousLogger().log(Level.WARNING, patternSyntaxException.toString());
                object = null;
            }
            GEM_EXCLUDE_FILTER = object;
        }
        object = System.getProperty("rails.prj.includegems");
        if (object == null || "all".equals(object)) {
            GEM_INCLUDE_FILTER = null;
        } else {
            Pattern pattern;
            try {
                pattern = Pattern.compile((String)object);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Invalid regular expression: " + (String)object);
                Logger.getAnonymousLogger().log(Level.WARNING, patternSyntaxException.toString());
                pattern = null;
            }
            GEM_INCLUDE_FILTER = pattern;
        }
    }
}

