/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.VirtualMachine;
import java.util.logging.Logger;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;

public class JPDAUtils {
    public static final boolean IS_JDK_16 = !System.getProperty("java.version").startsWith("1.5");
    public static final boolean IS_JDK_160_02 = IS_JDK_16 && !System.getProperty("java.version").equals("1.6.0") && !System.getProperty("java.version").equals("1.6.0_01");

    public static void printFeatures(Logger logger, VirtualMachine virtualMachine) {
        try {
            logger.fine("canAddMethod " + VirtualMachineWrapper.canAddMethod(virtualMachine));
            logger.fine("canBeModified " + VirtualMachineWrapper.canBeModified(virtualMachine));
            logger.fine("canGetBytecodes " + VirtualMachineWrapper.canGetBytecodes(virtualMachine));
            logger.fine("canGetCurrentContendedMonitor " + VirtualMachineWrapper.canGetCurrentContendedMonitor(virtualMachine));
            logger.fine("canGetMonitorInfo " + VirtualMachineWrapper.canGetMonitorInfo(virtualMachine));
            logger.fine("canGetOwnedMonitorInfo " + VirtualMachineWrapper.canGetOwnedMonitorInfo(virtualMachine));
            logger.fine("canGetSourceDebugExtension " + VirtualMachineWrapper.canGetSourceDebugExtension(virtualMachine));
            logger.fine("canGetSyntheticAttribute " + VirtualMachineWrapper.canGetSyntheticAttribute(virtualMachine));
            logger.fine("canPopFrames " + VirtualMachineWrapper.canPopFrames(virtualMachine));
            logger.fine("canRedefineClasses " + VirtualMachineWrapper.canRedefineClasses(virtualMachine));
            logger.fine("canRequestVMDeathEvent " + VirtualMachineWrapper.canRequestVMDeathEvent(virtualMachine));
            logger.fine("canUnrestrictedlyRedefineClasses " + VirtualMachineWrapper.canUnrestrictedlyRedefineClasses(virtualMachine));
            logger.fine("canUseInstanceFilters " + VirtualMachineWrapper.canUseInstanceFilters(virtualMachine));
            logger.fine("canWatchFieldAccess " + VirtualMachineWrapper.canWatchFieldAccess(virtualMachine));
            logger.fine("canWatchFieldModification " + VirtualMachineWrapper.canWatchFieldModification(virtualMachine));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            logger.fine(internalExceptionWrapper.getLocalizedMessage());
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            logger.fine(vMDisconnectedExceptionWrapper.getLocalizedMessage());
        }
    }
}

