/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassesTreeModel
implements TreeModel {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(115) >= 0;
    private Properties classesProperties = Properties.getDefault().getProperties("debugger").getProperties("classesView");
    private JPDADebuggerImpl debugger;
    private Listener listener;
    private Vector<ModelListener> listeners = new Vector();
    private List<ReferenceType> classes = null;
    private List<String> names = null;
    private HashMap cache = new HashMap();
    private Comparator comparator = new PackageComparator();
    private Comparator comparator1 = new ClassLoaderComparator();
    static final Integer NULL_CLASS_LOADER = new Integer(11);

    public ClassesTreeModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        try {
            Object[] objectArray = null;
            if (object.equals("Root")) {
                objectArray = this.getLoaders();
            } else if (object instanceof Object[]) {
                objectArray = this.getChildren((Object[])object);
            } else if (object instanceof ClassLoaderReference) {
                objectArray = this.getPackages((ClassLoaderReference)object);
            } else if (object == NULL_CLASS_LOADER) {
                objectArray = this.getPackages(null);
            } else if (object instanceof ReferenceType) {
                objectArray = ReferenceTypeWrapper.nestedTypes((ReferenceType)object).toArray();
            } else {
                throw new UnknownTypeException(object);
            }
            n2 = Math.min(objectArray.length, n2);
            n = Math.min(objectArray.length, n);
            Object[] objectArray2 = new Object[n2 - n];
            System.arraycopy(objectArray, n, objectArray2, 0, n2 - n);
            return objectArray2;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return new Object[0];
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return new Object[0];
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return new Object[0];
        }
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        try {
            if (object.equals("Root")) {
                return Integer.MAX_VALUE;
            }
            if (object instanceof Object[]) {
                return Integer.MAX_VALUE;
            }
            if (object instanceof ClassLoaderReference) {
                return Integer.MAX_VALUE;
            }
            if (object == NULL_CLASS_LOADER) {
                return Integer.MAX_VALUE;
            }
            if (object instanceof ReferenceType) {
                return Integer.MAX_VALUE;
            }
            throw new UnknownTypeException(object);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return 0;
        }
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return false;
        }
        if (object instanceof Object[]) {
            return false;
        }
        if (object instanceof ReferenceType) {
            return false;
        }
        if (object instanceof ClassLoaderReference) {
            return false;
        }
        if (object == NULL_CLASS_LOADER) {
            return false;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
        if (this.listener == null) {
            this.listener = new Listener(this, this.debugger);
        }
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
        if (this.listeners.size() == 0) {
            this.listener.destroy();
            this.listener = null;
        }
    }

    public void fireTreeChanged() {
        this.classes = null;
        this.names = null;
        this.cache = new HashMap();
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    private List<String> getNames() {
        if (this.classes == null) {
            VirtualMachine virtualMachine = this.debugger.getVirtualMachine();
            List<Object> list = new ArrayList();
            if (virtualMachine != null) {
                list = VirtualMachineWrapper.allClasses0(virtualMachine);
            }
            int n = list.size();
            this.names = new ArrayList<String>();
            this.classes = new ArrayList<ReferenceType>();
            for (int i = 0; i < n; ++i) {
                ReferenceType referenceType = (ReferenceType)list.get(i);
                if (referenceType instanceof ArrayType) continue;
                try {
                    this.names.add(ReferenceTypeWrapper.name(referenceType));
                    this.classes.add(referenceType);
                    continue;
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    continue;
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    // empty catch block
                }
            }
        }
        return this.names;
    }

    private Object[] getLoaders() {
        Object[] objectArray = (Object[])this.cache.get(null);
        if (objectArray != null) {
            return objectArray;
        }
        List<String> list = this.getNames();
        TreeSet<Object> treeSet = new TreeSet<Object>(this.comparator1);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                String string = list.get(i);
                ReferenceType referenceType = this.classes.get(i);
                ClassLoaderReference classLoaderReference = ReferenceTypeWrapper.classLoader(referenceType);
                if (classLoaderReference == null) {
                    treeSet.add(NULL_CLASS_LOADER);
                    continue;
                }
                if (ReferenceTypeWrapper.name(ObjectReferenceWrapper.referenceType(classLoaderReference)).equals("sun.reflect.DelegatingClassLoader")) continue;
                treeSet.add(classLoaderReference);
                continue;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                continue;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                continue;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                // empty catch block
            }
        }
        objectArray = treeSet.toArray();
        this.cache.put(null, objectArray);
        return objectArray;
    }

    private Object[] getPackages(ClassLoaderReference classLoaderReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = classLoaderReference == null ? (Object[])this.cache.get(NULL_CLASS_LOADER) : (Object[])this.cache.get(classLoaderReference);
        if (objectArray != null) {
            return objectArray;
        }
        boolean bl = this.classesProperties.getBoolean("flat", true);
        List<String> list = this.getNames();
        TreeSet<Object> treeSet = new TreeSet<Object>(this.comparator);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            ReferenceType referenceType = this.classes.get(i);
            if (ReferenceTypeWrapper.classLoader(referenceType) != classLoaderReference) continue;
            int n2 = bl ? string.lastIndexOf(46) : string.indexOf(46);
            if (n2 < 0) {
                if (string.indexOf(36) >= 0) continue;
                ReferenceType referenceType2 = this.classes.get(i);
                treeSet.add(referenceType2);
                continue;
            }
            treeSet.add(new Object[]{string.substring(0, n2), classLoaderReference});
        }
        objectArray = treeSet.toArray();
        if (classLoaderReference == null) {
            this.cache.put(NULL_CLASS_LOADER, objectArray);
        } else {
            this.cache.put(classLoaderReference, objectArray);
        }
        return objectArray;
    }

    private Object[] getChildren(Object[] objectArray) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        Object[] objectArray2 = (Object[])this.cache.get(objectArray);
        if (objectArray2 != null) {
            return objectArray2;
        }
        List<String> list = this.getNames();
        TreeSet<Object> treeSet = new TreeSet<Object>(this.comparator);
        int n = list.size();
        boolean bl = this.classesProperties.getBoolean("flat", true);
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = list.get(i);
            ReferenceType referenceType = this.classes.get(i);
            if (ReferenceTypeWrapper.classLoader(referenceType) != objectArray[1] || !string2.startsWith(string = (String)objectArray[0] + '.')) continue;
            int n2 = string.length();
            int n3 = string2.indexOf(46, n2);
            if (n3 < 0) {
                if (string2.indexOf(36, n2) >= 0) continue;
                treeSet.add(referenceType);
                continue;
            }
            if (bl) continue;
            treeSet.add(new Object[]{string2.substring(0, n3), ReferenceTypeWrapper.classLoader(referenceType)});
        }
        objectArray2 = treeSet.toArray();
        this.cache.put(objectArray, objectArray2);
        return objectArray2;
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    private static String shortName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static class ClassLoaderComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object == NULL_CLASS_LOADER) {
                if (object2 == NULL_CLASS_LOADER) {
                    return 0;
                }
                return -1;
            }
            if (object2 == NULL_CLASS_LOADER) {
                return 1;
            }
            return ((ClassLoaderReference)object).toString().compareTo(((ClassLoaderReference)object2).toString());
        }
    }

    private static class PackageComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof Object[]) {
                if (object2 instanceof Object[]) {
                    return ((String)((Object[])object)[0]).compareTo((String)((Object[])object2)[0]);
                }
                return -1;
            }
            if (object2 instanceof Object[]) {
                return 1;
            }
            return ClassesTreeModel.shortName(((ReferenceType)object).name()).compareTo(ClassesTreeModel.shortName(((ReferenceType)object2).name()));
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebuggerImpl debugger;
        private WeakReference<ClassesTreeModel> model;
        private RequestProcessor.Task task;

        public Listener(ClassesTreeModel classesTreeModel, JPDADebuggerImpl jPDADebuggerImpl) {
            this.debugger = jPDADebuggerImpl;
            this.model = new WeakReference<ClassesTreeModel>(classesTreeModel);
            jPDADebuggerImpl.addPropertyChangeListener(this);
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("ClTM cancel old task " + this.task);
                }
                this.task = null;
            }
        }

        private ClassesTreeModel getModel() {
            ClassesTreeModel classesTreeModel = (ClassesTreeModel)this.model.get();
            if (classesTreeModel == null) {
                this.destroy();
            }
            return classesTreeModel;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block9: {
                block8: {
                    if (propertyChangeEvent.getPropertyName() == "currentCallStackFrame") break block8;
                    if (propertyChangeEvent.getPropertyName() != "state") break block9;
                }
                if (this.debugger.getState() == 3) {
                    final ClassesTreeModel classesTreeModel = this.getModel();
                    if (classesTreeModel == null) {
                        return;
                    }
                    if (this.task != null) {
                        this.task.cancel();
                        if (verbose) {
                            System.out.println("ClTM cancel old task " + this.task);
                        }
                        this.task = null;
                    }
                    this.task = this.debugger.getRequestProcessor().post(new Runnable(){

                        public void run() {
                            int n = Listener.this.debugger.getState();
                            Listener.this.debugger;
                            if (n != 3) {
                                if (verbose) {
                                    System.out.println("ClTM cancel started task " + Listener.this.task);
                                }
                                return;
                            }
                            if (verbose) {
                                System.out.println("ClTM do task " + Listener.this.task);
                            }
                            classesTreeModel.fireTreeChanged();
                        }
                    }, 500);
                    if (!verbose) return;
                    System.out.println("ClTM  create task " + this.task);
                    return;
                }
            }
            if (propertyChangeEvent.getPropertyName() != "state") return;
            if (this.debugger.getState() == 3) return;
            if (this.task == null) return;
            this.task.cancel();
            if (verbose) {
                System.out.println("ClTM cancel task " + this.task);
            }
            this.task = null;
        }
    }
}

