/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.NativeMethodExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StackFrameWrapper {
    private StackFrameWrapper() {
    }

    public static List<Value> getArgumentValues(StackFrame stackFrame) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            return (List)StackFrame.class.getMethod("getArgumentValues", new Class[0]).invoke((Object)stackFrame, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new IllegalStateException(securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof InternalException) {
                JDIExceptionReporter.report((InternalException)throwable);
                throw new InternalExceptionWrapper((InternalException)throwable);
            }
            if (throwable instanceof VMDisconnectedException) {
                throw new VMDisconnectedExceptionWrapper((VMDisconnectedException)throwable);
            }
            if (throwable instanceof InvalidStackFrameException) {
                throw new InvalidStackFrameExceptionWrapper((InvalidStackFrameException)throwable);
            }
            throw new IllegalStateException(throwable);
        }
    }

    public static List<Value> getArgumentValues0(StackFrame stackFrame) throws InvalidStackFrameExceptionWrapper {
        try {
            return (List)StackFrame.class.getMethod("getArgumentValues", new Class[0]).invoke((Object)stackFrame, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new IllegalStateException(securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof InternalException) {
                JDIExceptionReporter.report((InternalException)throwable);
                return Collections.emptyList();
            }
            if (throwable instanceof VMDisconnectedException) {
                return Collections.emptyList();
            }
            if (throwable instanceof InvalidStackFrameException) {
                throw new InvalidStackFrameExceptionWrapper((InvalidStackFrameException)throwable);
            }
            throw new IllegalStateException(throwable);
        }
    }

    public static Value getValue(StackFrame stackFrame, LocalVariable localVariable) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            return stackFrame.getValue(localVariable);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidStackFrameExceptionWrapper(invalidStackFrameException);
        }
    }

    public static Map<LocalVariable, Value> getValues0(StackFrame stackFrame, List<? extends LocalVariable> list) throws InvalidStackFrameExceptionWrapper {
        try {
            return stackFrame.getValues(list);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return Collections.emptyMap();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return Collections.emptyMap();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidStackFrameExceptionWrapper(invalidStackFrameException);
        }
    }

    public static Map<LocalVariable, Value> getValues(StackFrame stackFrame, List<? extends LocalVariable> list) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            return stackFrame.getValues(list);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidStackFrameExceptionWrapper(invalidStackFrameException);
        }
    }

    public static Location location(StackFrame stackFrame) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            return stackFrame.location();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidStackFrameExceptionWrapper(invalidStackFrameException);
        }
    }

    public static void setValue(StackFrame stackFrame, LocalVariable localVariable, Value value) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            stackFrame.setValue(localVariable, value);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidStackFrameExceptionWrapper(invalidStackFrameException);
        }
    }

    public static ObjectReference thisObject(StackFrame stackFrame) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            try {
                return stackFrame.thisObject();
            }
            catch (InternalException internalException) {
                try {
                    if (internalException.errorCode() == 35) {
                        return null;
                    }
                    throw internalException;
                }
                catch (InternalException internalException2) {
                    JDIExceptionReporter.report(internalException2);
                    throw new InternalExceptionWrapper(internalException2);
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidStackFrameExceptionWrapper(invalidStackFrameException);
        }
    }

    public static ThreadReference thread(StackFrame stackFrame) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            return stackFrame.thread();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidStackFrameExceptionWrapper(invalidStackFrameException);
        }
    }

    public static LocalVariable visibleVariableByName(StackFrame stackFrame, String string) throws AbsentInformationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper, NativeMethodExceptionWrapper {
        try {
            return stackFrame.visibleVariableByName(string);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidStackFrameExceptionWrapper(invalidStackFrameException);
        }
        catch (NativeMethodException nativeMethodException) {
            throw new NativeMethodExceptionWrapper(nativeMethodException);
        }
    }

    public static List<LocalVariable> visibleVariables0(StackFrame stackFrame) throws AbsentInformationException, InvalidStackFrameExceptionWrapper, NativeMethodExceptionWrapper {
        try {
            return stackFrame.visibleVariables();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return Collections.emptyList();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return Collections.emptyList();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidStackFrameExceptionWrapper(invalidStackFrameException);
        }
        catch (NativeMethodException nativeMethodException) {
            throw new NativeMethodExceptionWrapper(nativeMethodException);
        }
    }

    public static List<LocalVariable> visibleVariables(StackFrame stackFrame) throws AbsentInformationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper, NativeMethodExceptionWrapper {
        try {
            return stackFrame.visibleVariables();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidStackFrameExceptionWrapper(invalidStackFrameException);
        }
        catch (NativeMethodException nativeMethodException) {
            throw new NativeMethodExceptionWrapper(nativeMethodException);
        }
    }
}

