/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.SmartSteppingFilterImpl;
import org.netbeans.modules.debugger.jpda.actions.StepIntoActionProvider;
import org.netbeans.modules.debugger.jpda.breakpoints.MethodBreakpointImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.util.Exceptions;

public class StepActionProvider
extends JPDADebuggerActionProvider
implements Executor {
    private StepRequest stepRequest;
    private ContextProvider lookupProvider;
    private JPDAStepImpl.MethodExitBreakpointListener lastMethodExitBreakpointListener;
    private boolean smartSteppingStepOut;
    private Properties p;
    private static boolean ssverbose = System.getProperty("netbeans.debugger.smartstepping") != null;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    private StepIntoActionProvider stepIntoActionProvider;
    private SmartSteppingFilterImpl smartSteppingFilterImpl;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    private static int getJDIAction(Object object) {
        if (object == ActionsManager.ACTION_STEP_OUT) {
            return 3;
        }
        if (object == ActionsManager.ACTION_STEP_OVER) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public StepActionProvider(ContextProvider contextProvider) {
        super((JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class)));
        this.lookupProvider = contextProvider;
        this.setProviderToDisableOnLazyAction(this);
        Map map = (Map)contextProvider.lookupFirst(null, Map.class);
        if (map != null) {
            this.smartSteppingStepOut = map.containsKey("SS_ACTION_STEPOUT");
        }
        this.p = Properties.getDefault().getProperties("debugger.options.JPDA");
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_STEP_OVER));
    }

    public void doAction(Object object) {
        this.runAction(object);
    }

    public void postAction(final Object object, final Runnable runnable) {
        this.doLazyAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    StepActionProvider.this.runAction(object);
                    Object var2_1 = null;
                    runnable.run();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    runnable.run();
                    throw throwable;
                }
            }
        });
    }

    public void runAction(Object object) {
        this.runAction(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runAction(Object object, boolean bl) {
        int n = this.getDebuggerImpl().getSuspend();
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
        Lock lock = n == 1 ? jPDAThreadImpl.accessLock.writeLock() : this.getDebuggerImpl().accessLock.writeLock();
        lock.lock();
        try {
            block20: {
                try {
                    while (!jPDAThreadImpl.isSuspended()) {
                        lock.unlock();
                        Thread.yield();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        lock.lock();
                        if (jPDAThreadImpl.isSuspended() || jPDAThreadImpl.isInStep() || jPDAThreadImpl.isMethodInvoking()) continue;
                        jPDAThreadImpl.suspend();
                    }
                    jPDAThreadImpl.waitUntilMethodInvokeDone();
                    ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
                    this.removeStepRequests(threadReference);
                    VirtualMachine virtualMachine = this.getDebuggerImpl().getVirtualMachine();
                    if (virtualMachine == null) {
                        Object var11_13 = null;
                        lock.unlock();
                        return;
                    }
                    this.stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), threadReference, -2, StepActionProvider.getJDIAction(object));
                    EventRequestWrapper.addCountFilter(this.stepRequest, 1);
                    this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
                    EventRequestWrapper.setSuspendPolicy(this.stepRequest, n);
                    try {
                        EventRequestWrapper.enable(this.stepRequest);
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        if (logger.isLoggable(Level.WARNING)) {
                            try {
                                logger.warning(illegalThreadStateException.getLocalizedMessage() + "\nThread: " + ThreadReferenceWrapper.name(threadReference) + ", suspended = " + ThreadReferenceWrapper.isSuspended(threadReference) + ", status = " + ThreadReferenceWrapper.status(threadReference));
                            }
                            catch (Exception exception) {
                                logger.warning(exception.getLocalizedMessage());
                            }
                        }
                        this.getDebuggerImpl().getOperator().unregister(this.stepRequest);
                        Object var11_14 = null;
                        lock.unlock();
                        return;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("JDI Request (action " + object + "): " + this.stepRequest);
                    }
                    if (object == ActionsManager.ACTION_STEP_OUT) {
                        this.addMethodExitBP(threadReference, jPDAThreadImpl);
                    }
                    jPDAThreadImpl.disableMethodInvokeUntilResumed();
                    jPDAThreadImpl.setInStep(true, this.stepRequest);
                    if (!bl) break block20;
                    if (n == 1) {
                        this.getDebuggerImpl().resumeCurrentThread();
                    } else {
                        this.getDebuggerImpl().resume();
                    }
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    Object var11_16 = null;
                    lock.unlock();
                    return;
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    Object var11_17 = null;
                    lock.unlock();
                    return;
                }
                catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
                    Exceptions.printStackTrace((Throwable)invalidStackFrameExceptionWrapper);
                    Object var11_18 = null;
                    lock.unlock();
                    return;
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    Object var11_19 = null;
                    lock.unlock();
                    return;
                }
            }
            Object var11_15 = null;
            lock.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private void addMethodExitBP(ThreadReference threadReference, JPDAThread jPDAThread) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper, InvalidStackFrameExceptionWrapper, ObjectCollectedExceptionWrapper {
        Location location;
        if (!MethodBreakpointImpl.canGetMethodReturnValues(MirrorWrapper.virtualMachine(threadReference))) {
            return;
        }
        try {
            location = StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            logger.fine("Incompatible Thread State: " + incompatibleThreadStateException.getLocalizedMessage());
            return;
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return;
        }
        String string = ReferenceTypeWrapper.name(LocationWrapper.declaringType(location));
        String string2 = TypeComponentWrapper.name(LocationWrapper.method(location));
        MethodBreakpoint methodBreakpoint = MethodBreakpoint.create((String)string, (String)string2);
        methodBreakpoint.setBreakpointType(2);
        methodBreakpoint.setHidden(true);
        methodBreakpoint.setSuspend(0);
        methodBreakpoint.setThreadFilters((JPDADebugger)this.getDebuggerImpl(), new JPDAThread[]{jPDAThread});
        this.lastMethodExitBreakpointListener = new JPDAStepImpl.MethodExitBreakpointListener(methodBreakpoint);
        methodBreakpoint.addJPDABreakpointListener((JPDABreakpointListener)this.lastMethodExitBreakpointListener);
        try {
            Method method = JPDABreakpoint.class.getDeclaredMethod("setSession", JPDADebugger.class);
            method.setAccessible(true);
            method.invoke((Object)methodBreakpoint, new Object[]{this.debugger});
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)methodBreakpoint);
    }

    protected void checkEnabled(int n) {
        for (Object e : this.getActions()) {
            this.getDebuggerImpl();
            this.setEnabled(e, n == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exec(Event event) {
        try {
            StepRequest stepRequest = (StepRequest)EventWrapper.request(event);
            JPDAThreadImpl jPDAThreadImpl = this.getDebuggerImpl().getThread(StepRequestWrapper.thread(stepRequest));
            jPDAThreadImpl.setInStep(false, null);
            LocatableEvent locatableEvent = (LocatableEvent)event;
            String string = ReferenceTypeWrapper.name(LocationWrapper.declaringType(LocatableWrapper.location(locatableEvent)));
            ThreadReference threadReference = LocatableEventWrapper.thread(locatableEvent);
            this.setLastOperation(threadReference);
            this.removeStepRequests(threadReference);
            Lock lock = this.getDebuggerImpl().getSuspend() == 1 ? jPDAThreadImpl.accessLock.writeLock() : this.getDebuggerImpl().accessLock.writeLock();
            lock.lock();
            try {
                int n;
                boolean bl;
                boolean bl2;
                Object object;
                block23: {
                    boolean bl3;
                    int n2;
                    int n3;
                    block24: {
                        n3 = this.getDebuggerImpl().getSuspend();
                        if (!TypeComponentWrapper.isSynthetic(LocationWrapper.method(StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0))))) break block23;
                        n2 = StepRequestWrapper.depth((StepRequest)EventWrapper.request(event));
                        object = this.getDebuggerImpl().getVirtualMachine();
                        if (object != null) break block24;
                        boolean bl4 = false;
                        Object var14_26 = null;
                        lock.unlock();
                        return bl4;
                    }
                    try {
                        this.stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager((VirtualMachine)object), threadReference, -2, n2);
                        EventRequestWrapper.addCountFilter(this.stepRequest, 1);
                        this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
                        EventRequestWrapper.setSuspendPolicy(this.stepRequest, n3);
                        try {
                            EventRequestWrapper.enable(this.stepRequest);
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            this.getDebuggerImpl().getOperator().unregister(this.stepRequest);
                            this.stepRequest = null;
                        }
                        bl3 = true;
                    }
                    catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                        Exceptions.printStackTrace((Throwable)incompatibleThreadStateException);
                        logger.fine("Incompatible Thread State: " + incompatibleThreadStateException.getLocalizedMessage());
                        break block23;
                    }
                    catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                        boolean bl5 = false;
                        Object var14_28 = null;
                        lock.unlock();
                        return bl5;
                    }
                    catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
                        Exceptions.printStackTrace((Throwable)invalidStackFrameExceptionWrapper);
                    }
                    Object var14_27 = null;
                    lock.unlock();
                    return bl3;
                }
                boolean bl6 = this.getSmartSteppingFilterImpl().stopHere(string);
                if (ssverbose) {
                    System.out.println("SS  SmartSteppingFilter.stopHere (" + string + ") ? " + bl6);
                }
                if (bl6) {
                    object = this.getDebuggerImpl().getThread(threadReference);
                    if (this.getCompoundSmartSteppingListener().stopHere(this.lookupProvider, (JPDAThread)object, this.getSmartSteppingFilterImpl())) {
                        boolean bl7 = false;
                        Object var14_29 = null;
                        lock.unlock();
                        return bl7;
                    }
                }
                if (ssverbose) {
                    System.out.println("\nSS:  SMART STEPPING START! ********** ");
                }
                boolean bl8 = bl2 = (bl = this.p.getBoolean("UseStepFilters", true)) && this.p.getBoolean("StepThroughFilters", false);
                if (!bl2 || this.smartSteppingStepOut) {
                    this.getStepIntoActionProvider().runAction(ActionsManager.ACTION_STEP_OUT, false);
                } else {
                    n = StepRequestWrapper.depth(stepRequest);
                    if (n == 2) {
                        this.runAction(ActionsManager.ACTION_STEP_OVER, false);
                    } else if (n == 3) {
                        this.runAction(ActionsManager.ACTION_STEP_OUT, false);
                    } else {
                        this.getStepIntoActionProvider().runAction("smartStepInto", false);
                    }
                }
                n = 1;
                Object var14_30 = null;
                lock.unlock();
                return n != 0;
            }
            catch (Throwable throwable) {
                Object var14_31 = null;
                lock.unlock();
                throw throwable;
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return false;
        }
    }

    public void removed(EventRequest eventRequest) {
        StepRequest stepRequest = (StepRequest)eventRequest;
        try {
            JPDAThreadImpl jPDAThreadImpl = this.getDebuggerImpl().getThread(StepRequestWrapper.thread(stepRequest));
            jPDAThreadImpl.setInStep(false, null);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        if (this.lastMethodExitBreakpointListener != null) {
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
    }

    private void setLastOperation(ThreadReference threadReference) throws VMDisconnectedExceptionWrapper {
        Variable variable = null;
        if (this.lastMethodExitBreakpointListener != null) {
            variable = this.lastMethodExitBreakpointListener.getReturnValue();
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
        StepActionProvider.setLastOperation(threadReference, this.getDebuggerImpl(), variable);
    }

    public static void setLastOperation(ThreadReference threadReference, JPDADebuggerImpl jPDADebuggerImpl, Variable variable) throws VMDisconnectedExceptionWrapper {
        byte[] byArray;
        int n;
        String string;
        Location location;
        try {
            location = StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            Exceptions.printStackTrace((Throwable)incompatibleThreadStateException);
            logger.fine("Incompatible Thread State: " + incompatibleThreadStateException.getLocalizedMessage());
            return;
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return;
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return;
        }
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        String string2 = session == null ? null : session.getCurrentLanguage();
        SourcePath sourcePath = jPDADebuggerImpl.getEngineContext();
        try {
            string = sourcePath.getURL(location, string2);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return;
        }
        ExpressionPool expressionPool = jPDADebuggerImpl.getExpressionPool();
        ExpressionPool.Expression expression = expressionPool.getExpressionAt(location, string);
        if (expression == null) {
            return;
        }
        EditorContext.Operation[] operationArray = expression.getOperations();
        try {
            n = (int)LocationWrapper.codeIndex(location);
            byArray = MethodWrapper.bytecodes(LocationWrapper.method(location));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return;
        }
        n = n >= 5 && (byArray[n - 5] & 0xFF) == 185 ? (n -= 5) : (n -= 3);
        int n2 = expression.findNextOperationIndex(n - 1);
        if (n2 < 0 || operationArray[n2].getBytecodeIndex() != n) {
            return;
        }
        EditorContext.Operation operation = operationArray[n2];
        operation.setReturnValue(variable);
        JPDAThreadImpl jPDAThreadImpl = jPDADebuggerImpl.getThread(threadReference);
        jPDAThreadImpl.addLastOperation(operation);
        jPDAThreadImpl.setCurrentOperation(operation);
    }

    private StepIntoActionProvider getStepIntoActionProvider() {
        if (this.stepIntoActionProvider == null) {
            List list = this.lookupProvider.lookup(null, ActionsProvider.class);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!(list.get(i) instanceof StepIntoActionProvider)) continue;
                this.stepIntoActionProvider = (StepIntoActionProvider)list.get(i);
            }
        }
        return this.stepIntoActionProvider;
    }

    private SmartSteppingFilterImpl getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilterImpl == null) {
            this.smartSteppingFilterImpl = (SmartSteppingFilterImpl)this.lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilterImpl;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.lookupProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }
}

