/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class VCSHooksConfig {
    private static VCSHooksConfig instance = null;
    private static final String HG_HOOK_COMMENT_FORMAT = "vcshook.hg_comment_format";
    private static final String HG_HOOK_ISSUE_FORMAT = "vcshook.hg_issue_format";
    private static final String SVN_HOOK_COMMENT_FORMAT = "vcshook.svn_comment_format";
    private static final String SVN_HOOK_ISSUE_FORMAT = "vcshook.svn_issue_format";
    private static final String HG_HOOK_PUSH_ = "vcshook.hg_push_hook_";
    private static final String DELIMITER = "<=>";

    private VCSHooksConfig() {
    }

    static VCSHooksConfig getInstance() {
        if (instance == null) {
            instance = new VCSHooksConfig();
        }
        return instance;
    }

    Preferences getPreferences() {
        return NbPreferences.forModule(VCSHooksConfig.class);
    }

    void setHgCommentFormat(Format format) {
        this.getPreferences().put(HG_HOOK_COMMENT_FORMAT, format.toString());
    }

    void setHgIssueFormat(Format format) {
        this.getPreferences().put(HG_HOOK_ISSUE_FORMAT, format.toString());
    }

    void setSvnCommentFormat(Format format) {
        this.getPreferences().put(SVN_HOOK_COMMENT_FORMAT, format.toString());
    }

    void setSvnIssueFormat(Format format) {
        this.getPreferences().put(SVN_HOOK_ISSUE_FORMAT, format.toString());
    }

    Format getHgCommentFormat() {
        return this.getFormat(this.getPreferences().get(HG_HOOK_COMMENT_FORMAT, null), this.getDefaultHgFormat());
    }

    Format getHgIssueFormat() {
        return this.getFormat(this.getPreferences().get(HG_HOOK_ISSUE_FORMAT, null), this.getDefaultIssueFormat());
    }

    Format getSvnCommentFormat() {
        return this.getFormat(this.getPreferences().get(SVN_HOOK_COMMENT_FORMAT, null), this.getDefaultSvnFormat());
    }

    Format getSvnIssueFormat() {
        return this.getFormat(this.getPreferences().get(SVN_HOOK_ISSUE_FORMAT, null), this.getDefaultIssueFormat());
    }

    void setHgPushAction(String string, PushAction pushAction) {
        this.getPreferences().put(HG_HOOK_PUSH_ + string, pushAction.toString());
    }

    PushAction popHGPushAction(String string) {
        String string2 = this.getPreferences().get(HG_HOOK_PUSH_ + string, null);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(DELIMITER);
        this.getPreferences().remove(HG_HOOK_PUSH_ + string);
        return new PushAction(stringArray[0], stringArray[1], stringArray[2].equals("1"));
    }

    private Format getDefaultHgFormat() {
        return new Format(false, this.normalizeFormat(new String[]{NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Changeset"), "{changeset}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Author"), "{author}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Date"), "{date}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Message"), "{message}"}));
    }

    private Format getDefaultIssueFormat() {
        return new Format(false, NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Issue") + "{id} - {summary}");
    }

    private Format getDefaultSvnFormat() {
        return new Format(false, this.normalizeFormat(new String[]{NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Revision"), "{revision}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Author"), "{author}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Date"), "{date}\n", NbBundle.getMessage(VCSHooksConfig.class, (String)"LBL_Message"), "{message}"}));
    }

    private Format getFormat(String string, Format format) {
        Format format2;
        if (string == null) {
            format2 = format;
        } else {
            String[] stringArray = string.split(DELIMITER);
            format2 = new Format(stringArray[0].equals("1"), stringArray[1]);
        }
        return format2;
    }

    private String normalizeFormat(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; i += 2) {
            if (n >= stringArray[i].length()) continue;
            n = stringArray[i].length();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int j = 0; j < n - stringArray[i].length() + 1; ++j) {
                stringBuffer2.append(" ");
            }
            stringBuffer.append(stringBuffer2.toString());
            stringBuffer.append(stringArray[++i]);
        }
        return stringBuffer.toString();
    }

    static class Format {
        private boolean above;
        private String format;

        public Format(boolean bl, String string) {
            this.above = bl;
            this.format = string;
        }

        public boolean isAbove() {
            return this.above;
        }

        public String getFormat() {
            return this.format;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.above ? "1" : "0");
            stringBuffer.append(VCSHooksConfig.DELIMITER);
            stringBuffer.append(this.format);
            return stringBuffer.toString();
        }
    }

    static class PushAction {
        private final String issueID;
        private final String msg;
        private final boolean close;

        public PushAction(String string, String string2, boolean bl) {
            this.issueID = string;
            this.msg = string2;
            this.close = bl;
        }

        public String getIssueID() {
            return this.issueID;
        }

        public boolean isClose() {
            return this.close;
        }

        public String getMsg() {
            return this.msg;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getIssueID());
            stringBuffer.append(VCSHooksConfig.DELIMITER);
            stringBuffer.append(this.getMsg());
            stringBuffer.append(VCSHooksConfig.DELIMITER);
            stringBuffer.append(this.isClose() ? "1" : "0");
            return stringBuffer.toString();
        }
    }
}

