/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.bridge.exportdiff;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.bridge.exportdiff.AttachPanel;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.versioning.util.ExportDiffSupport;

public class AttachIssueProvider
extends ExportDiffSupport.ExportDiffProvider
implements DocumentListener,
PropertyChangeListener {
    private BugtrackingOwnerSupport support = BugtrackingOwnerSupport.getInstance();
    private AttachPanel panel;
    private File[] files;
    private static Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.exportdiff.AttachIssueProvider");

    protected void setContext(File[] fileArray) {
        this.files = fileArray;
    }

    public void handleDiffFile(File file) {
        LOG.log(Level.FINE, "handeDiff start for " + file);
        Issue issue = this.panel.getIssue();
        if (issue == null) {
            LOG.log(Level.FINE, " no issue set");
            return;
        }
        issue.attachPatch(file, this.panel.descriptionTextField.getText());
        issue.open();
        LOG.log(Level.FINE, "handeDiff end for " + file);
    }

    public JComponent createComponent() {
        assert (this.files != null);
        this.panel = new AttachPanel(this);
        this.panel.descriptionTextField.getDocument().addDocumentListener(this);
        Repository[] repositoryArray = BugtrackingUtil.getKnownRepositories();
        Repository repository = null;
        if (this.files.length > 0) {
            for (File file : this.files) {
                repository = this.support.getRepository(file, false);
                if (repository != null) {
                    LOG.log(Level.FINE, " found issue tracker " + repository + " for " + file);
                    break;
                }
                LOG.log(Level.FINE, " could not find issue tracker for " + file);
            }
        }
        this.panel.init(repositoryArray, repository);
        return this.panel;
    }

    public boolean isValid() {
        return !this.panel.descriptionTextField.getText().trim().equals("") && this.panel.getIssue() != null;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireDataChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireDataChanged();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireDataChanged();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(QuickSearchComboBar.EVT_ISSUE_CHANGED)) {
            this.fireDataChanged();
        }
    }
}

