/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGRect;

class TextRenderer {
    private float myLetterWidth;
    private SVGLocatableElement myElement;

    TextRenderer(SVGLocatableElement sVGLocatableElement) {
        this.myElement = sVGLocatableElement;
    }

    void initEmpiricalLetterWidth(SVGLocatableElement sVGLocatableElement) {
        if (this.myLetterWidth != 0.0f) {
            return;
        }
        String string = sVGLocatableElement.getTrait("#text");
        if (string != null && string.length() != 0 && sVGLocatableElement.getBBox() != null) {
            string = string.trim();
            this.myLetterWidth = sVGLocatableElement.getBBox().getWidth() / (float)string.length();
        }
    }

    String truncateToShownText(String string, float f) {
        if (f == 0.0f) {
            return "";
        }
        if (this.myLetterWidth == 0.0f) {
            return string;
        }
        int n = Math.max(0, (int)(f / this.myLetterWidth));
        String string2 = string;
        string2 = string.substring(0, Math.min(string.length(), n + 1));
        float f2 = this.getTextWidth(string2);
        boolean bl = true;
        while (f2 > f && string2.length() > 0) {
            string2 = string2.substring(0, string2.length() - 1);
            f2 = this.getTextWidth(string2);
            bl = false;
        }
        String string3 = string2;
        while (bl && f2 <= f && n <= string.length()) {
            string2 = string3;
            string3 = string.substring(0, n);
            ++n;
            f2 = this.getTextWidth(string3);
        }
        if (n == string.length()) {
            string2 = string3;
        }
        return string2;
    }

    float getTextWidth(String string) {
        if (string.endsWith(" ")) {
            return this.doGetTextWidth(string + "i") - this.doGetTextWidth("i");
        }
        return this.doGetTextWidth(string);
    }

    boolean isEmpiricInitialized() {
        return this.myLetterWidth == 0.0f;
    }

    float doGetTextWidth(String string) {
        float f = 0.0f;
        if (string.length() > 0) {
            String string2 = string.trim();
            this.getHiddenTextElement().setTrait("#text", string2);
            SVGRect sVGRect = this.getHiddenTextElement().getBBox();
            if (sVGRect != null) {
                f = sVGRect.getWidth();
            }
        }
        return f;
    }

    SVGLocatableElement getHiddenTextElement() {
        return this.myElement;
    }
}

