/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.m2g.SVGImage;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementEvent;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementListener;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorMessageAwareness;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGImageCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComponentCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormSupport;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGFormImageParser;
import org.netbeans.modules.vmd.midpnb.screen.display.SVGImageComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGFormEditorElement
extends PropertyEditorResourceElement
implements Runnable,
PropertyEditorResourceElementListener,
CleanUp {
    private static final String EXTENSION = "svg";
    private long componentID;
    private boolean doNotFireEvent;
    private Project project;
    private String lastDir;
    private SVGImageComponent imageView;
    private DefaultComboBoxModel comboBoxModel;
    private Map<String, FileObject> paths;
    private final AtomicBoolean requiresModelUpdate = new AtomicBoolean(false);
    private PropertyEditorResourceElement.DesignComponentWrapper wrapper;
    private PropertyEditorMessageAwareness messageAwareness;
    private WeakReference<DesignDocument> documentReferences;
    private Map<String, String> pathMap;
    private JPopupMenu menu;
    private WeakReference<DesignComponent> svgFormReferences;
    private boolean needUpdate;
    private boolean orderNeedsUpdate;
    private JButton chooserButton;
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JButton jButton1;
    private JPanel jPanelImageFile;
    private JPanel jPanelSVGComponents;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JLabel pathLabel;
    private JComboBox pathTextComboBox;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JProgressBar progressBar;
    private JLabel widthLabel;
    private JTextField widthTextField;

    public SVGFormEditorElement() {
        this.paths = new HashMap<String, FileObject>();
        this.comboBoxModel = new DefaultComboBoxModel();
        this.initComponents();
        this.progressBar.setVisible(false);
        this.imageView = new SVGImageComponent();
        this.previewPanel.add((Component)this.imageView, "Center");
        this.menu = new JPopupMenu();
        this.menu.add(new MoveAction(ResourceBundle.getBundle("org/netbeans/modules/vmd/midpnb/propertyeditors/Bundle").getString("Move_Up_Action"), 1));
        this.menu.add(new MoveAction(ResourceBundle.getBundle("org/netbeans/modules/vmd/midpnb/propertyeditors/Bundle").getString("Move_Down_Action"), -1));
        this.jTable1.addMouseListener(new PopupListener());
        this.pathMap = new HashMap<String, String>();
        this.jTable1.setSelectionMode(0);
    }

    public void clean(DesignComponent designComponent) {
        this.project = null;
        this.imageView = null;
        this.comboBoxModel = null;
        if (this.paths != null) {
            this.paths.clear();
            this.paths = null;
        }
        this.wrapper = null;
        this.messageAwareness = null;
        this.documentReferences = null;
        if (this.pathMap != null) {
            this.pathMap.clear();
            this.pathMap = null;
        }
        this.menu = null;
        this.svgFormReferences = null;
        this.chooserButton = null;
        this.heightLabel = null;
        this.heightTextField = null;
        this.jButton1 = null;
        this.jPanelImageFile = null;
        this.jPanelSVGComponents = null;
        this.jScrollPane1 = null;
        this.jTabbedPane1 = null;
        this.jTable1 = null;
        this.pathLabel = null;
        this.pathTextComboBox = null;
        this.previewLabel = null;
        this.previewPanel = null;
        this.progressBar = null;
        this.widthLabel = null;
        this.widthTextField = null;
        this.removeAll();
    }

    public void setPropertyEditorMessageAwareness(PropertyEditorMessageAwareness propertyEditorMessageAwareness) {
        this.messageAwareness = propertyEditorMessageAwareness;
    }

    public JComponent getJComponent() {
        return this;
    }

    public TypeID getTypeID() {
        return SVGImageCD.TYPEID;
    }

    public List<String> getPropertyValueNames() {
        return Arrays.asList("resourcePath");
    }

    public boolean isResetToDefaultAutomatically(final DesignComponent designComponent) {
        if (designComponent == null) {
            return super.isResetToDefaultAutomatically(designComponent);
        }
        final boolean[] blArray = new boolean[]{true};
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
                if (descriptorRegistry.isInHierarchy(SVGFormCD.TYPEID, designComponent.getType())) {
                    blArray[0] = false;
                }
            }
        });
        return blArray[0];
    }

    public void preResetToDefaultValue(DesignComponent designComponent) {
        this.nullValueSet(designComponent);
        super.preResetToDefaultValue(designComponent);
    }

    public void setDesignComponentWrapper(PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper) {
        this.wrapper = designComponentWrapper;
        if (this.documentReferences == null || this.documentReferences.get() == null) {
            return;
        }
        DesignDocument designDocument = (DesignDocument)this.documentReferences.get();
        this.project = ProjectUtils.getProject((DesignDocument)designDocument);
        if (designComponentWrapper == null) {
            this.setText(null);
            this.setAllEnabled(false);
            return;
        }
        this.componentID = designComponentWrapper.getComponentID();
        final String[] stringArray = new String[1];
        final DesignComponent designComponent = designComponentWrapper.getComponent();
        if (designComponent != null) {
            if (!designComponent.getType().equals((Object)this.getTypeID())) {
                throw new IllegalArgumentException("Passed component must have typeID " + this.getTypeID() + " instead passed " + designComponent.getType());
            }
            this.componentID = designComponent.getComponentID();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    PropertyValue propertyValue = designComponent.readProperty("resourcePath");
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType((PropertyValue)propertyValue)) {
                        stringArray[0] = MidpTypes.getString((PropertyValue)propertyValue);
                    }
                }
            });
        }
        if (designComponentWrapper.hasChanges()) {
            Map map = designComponentWrapper.getChanges();
            for (String string : map.keySet()) {
                PropertyValue propertyValue = (PropertyValue)map.get(string);
                if (!"resourcePath".equals(string)) continue;
                stringArray[0] = MidpTypes.getString((PropertyValue)propertyValue);
            }
        }
        this.setAllEnabled(true);
        this.setText(stringArray[0]);
    }

    public boolean isPostSetValueSupported(final DesignComponent designComponent) {
        final boolean[] blArray = new boolean[1];
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                blArray[0] = designComponent.getDocument().getDescriptorRegistry().isInHierarchy(SVGFormCD.TYPEID, designComponent.getType());
            }
        });
        return blArray[0];
    }

    public void postSetValue(final DesignComponent designComponent, final DesignComponent designComponent2) {
        final FileObject[] fileObjectArray = new FileObject[1];
        final Boolean[] booleanArray = new Boolean[]{Boolean.TRUE};
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                Object object;
                PropertyValue propertyValue = designComponent2.readProperty("resourcePath");
                if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                    object = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)designComponent.getDocument(), (String)MidpTypes.getString((PropertyValue)propertyValue));
                    Iterator iterator = object.keySet().iterator();
                    fileObjectArray[0] = iterator.hasNext() ? (FileObject)iterator.next() : null;
                    booleanArray[0] = Boolean.TRUE;
                }
                object = designComponent.readProperty("svgImage").getComponent();
                if (!SVGFormEditorElement.this.needUpdate && object == designComponent2 && fileObjectArray[0] != null) {
                    booleanArray[0] = Boolean.FALSE;
                }
            }
        });
        if (booleanArray[0] != null && booleanArray[0].booleanValue()) {
            this.parseSVGImageItems(fileObjectArray[0], designComponent);
            this.orderSVGComponentsArray(designComponent);
        }
        if (this.orderNeedsUpdate) {
            this.orderSVGComponentsArray(designComponent);
        }
    }

    private void orderSVGComponentsArray(final DesignComponent designComponent) {
        final TableModel tableModel = this.jTable1.getModel();
        final ArrayList arrayList = new ArrayList(tableModel.getRowCount());
        designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                block0: for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    String string = (String)tableModel.getValueAt(i, 1);
                    for (DesignComponent designComponent2 : SVGFormSupport.getSVGFormComponents(designComponent)) {
                        if (!designComponent2.readProperty("id").getPrimitiveValue().equals(string)) continue;
                        arrayList.add(i, PropertyValue.createComponentReference((DesignComponent)designComponent2));
                        continue block0;
                    }
                }
                designComponent.writeProperty("components", PropertyValue.createArray((TypeID)SVGComponentCD.TYPEID, (List)arrayList));
            }
        });
    }

    public void nullValueSet(final DesignComponent designComponent) {
        designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                SVGFormSupport.removeAllSVGFormComponents(designComponent);
                designComponent.resetToDefault("svgImage");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSVGImageItems(FileObject fileObject, final DesignComponent designComponent) {
        this.nullValueSet(designComponent);
        if (fileObject == null) {
            return;
        }
        final SVGComponentImageParser[] sVGComponentImageParserArray = new SVGComponentImageParser[1];
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                sVGComponentImageParserArray[0] = SVGComponentImageParser.getParserByComponent(designComponent);
            }
        });
        SVGComponentImageParser sVGComponentImageParser = sVGComponentImageParserArray[0];
        if (sVGComponentImageParser == null) {
            return;
        }
        InputStream inputStream = null;
        inputStream = fileObject.getInputStream();
        if (inputStream != null) {
            sVGComponentImageParser.parse(inputStream, designComponent);
        }
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
        return;
        catch (FileNotFoundException fileNotFoundException) {
            try {
                Debug.warning((Object[])new Object[]{fileNotFoundException});
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    Debug.warning((Object[])new Object[]{iOException});
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{iOException});
            }
            return;
        }
    }

    private void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.addImage(string, true);
    }

    private void addImage(String string, boolean bl) {
        this.doNotFireEvent = true;
        if (this.comboBoxModel.getIndexOf(string) == -1) {
            this.comboBoxModel.addElement(string);
            this.sortComboBoxContent();
        }
        if (bl) {
            this.pathTextComboBox.setSelectedItem(string);
            this.updatePreview();
        }
        this.doNotFireEvent = false;
    }

    private void sortComboBoxContent() {
        int n = this.pathTextComboBox.getItemCount();
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.pathTextComboBox.getItemAt(i));
        }
        Collections.sort(arrayList, PropertyEditorResourceElement.StringComparator.instance);
        this.pathTextComboBox.removeAllItems();
        for (Object e : arrayList) {
            this.pathTextComboBox.addItem(e);
        }
    }

    void setAllEnabled(boolean bl) {
        this.pathLabel.setEnabled(bl);
        this.pathTextComboBox.setEnabled(bl);
        this.previewLabel.setEnabled(bl);
        this.previewPanel.setEnabled(bl);
        this.widthLabel.setEnabled(bl);
        this.widthTextField.setEnabled(bl);
        this.heightLabel.setEnabled(bl);
        this.heightTextField.setEnabled(bl);
        this.chooserButton.setEnabled(bl);
    }

    private void updateModel(DesignDocument designDocument) {
        boolean bl = this.pathTextComboBox.isEnabled();
        this.pathTextComboBox.setEnabled(false);
        this.doNotFireEvent = true;
        this.comboBoxModel.removeAllElements();
        this.doNotFireEvent = false;
        this.paths.clear();
        Map map = MidpProjectSupport.getAllFilesForProjectByExt((DesignDocument)designDocument, Collections.singleton(EXTENSION));
        for (Map.Entry entry : map.entrySet()) {
            this.checkFile((FileObject)entry.getKey(), (String)entry.getValue());
        }
        if (bl) {
            this.pathTextComboBox.setEnabled(true);
        }
    }

    private void checkFile(FileObject fileObject, String string) {
        String string2;
        if (EXTENSION.equals(fileObject.getExt().toLowerCase()) && (string2 = this.convertFile(fileObject, string, false)) != null) {
            this.addImage(string2, false);
        }
    }

    private void updatePreview() {
        SVGImage sVGImage;
        block6: {
            String string = (String)this.pathTextComboBox.getSelectedItem();
            FileObject fileObject = this.paths.get(string);
            sVGImage = null;
            try {
                if (fileObject != null) {
                    sVGImage = Util.createSVGImage((FileObject)fileObject, (boolean)true);
                }
                if (this.messageAwareness != null) {
                    this.messageAwareness.clearErrorStatus();
                }
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{iOException});
                if (this.messageAwareness == null) break block6;
                this.messageAwareness.displayWarning(NbBundle.getMessage(SVGFormEditorElement.class, (String)"MSG_SVG_Image_Not_SVG_Tiny"));
            }
        }
        if (sVGImage != null) {
            int n = sVGImage.getViewportWidth();
            int n2 = sVGImage.getViewportHeight();
            this.widthTextField.setText(String.valueOf(n));
            this.heightTextField.setText(String.valueOf(n2));
        } else {
            this.widthTextField.setText(null);
            this.heightTextField.setText(null);
        }
        this.imageView.setImage(sVGImage);
        this.previewPanel.invalidate();
        this.previewPanel.validate();
        this.previewPanel.repaint();
    }

    private FileObject getSourceFolder() {
        if (this.project == null) {
            throw Debug.illegalState((Object[])new Object[]{"Current project is null"});
        }
        String string = ProjectUtils.getProjectID((Project)this.project);
        return ((SourceGroup)ProjectUtils.getSourceGroups((String)string).iterator().next()).getRootFolder();
    }

    private String convertFile(FileObject fileObject, String string, boolean bl) {
        String string2;
        FileObject fileObject2 = this.getSourceFolder();
        String string3 = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            string2 = !fileObject.getPath().startsWith("/") ? "/" + fileObject.getPath() : fileObject.getPath();
        } else {
            String string4 = file.getAbsolutePath();
            if (string4.contains(string3)) {
                int n;
                string4 = fileObject.getPath();
                string2 = !string4.substring(n = string4.indexOf(string3) + string3.length() + 1).startsWith("/") ? "/" + string4.substring(n) : string4.substring(n);
            } else if (bl) {
                File file2 = new File(string3 + File.separator + fileObject.getNameExt());
                if (file2.exists()) {
                    return null;
                }
                try {
                    fileObject = fileObject.copy(fileObject2, fileObject.getName(), fileObject.getExt());
                }
                catch (IOException iOException) {
                    Debug.warning((Object[])new Object[]{"SVGImageEditorElement.convertFile()", "can't copy file", string4, iOException});
                }
                string2 = "/" + fileObject.getNameExt();
            } else {
                string2 = string;
            }
        }
        this.paths.put(string2, fileObject);
        return string2;
    }

    @Override
    public void run() {
        this.orderNeedsUpdate = false;
        this.needUpdate = false;
        if (this.documentReferences == null || this.documentReferences.get() == null) {
            return;
        }
        DesignDocument designDocument = (DesignDocument)this.documentReferences.get();
        this.project = ProjectUtils.getProject((DesignDocument)designDocument);
        this.updateModel(designDocument);
        this.showProgressBar(false);
        this.setDesignComponentWrapper(this.wrapper);
        this.requiresModelUpdate.set(false);
    }

    public void addNotify() {
        super.addNotify();
        if (this.requiresModelUpdate.getAndSet(true)) {
            return;
        }
        this.showProgressBar(true);
        new Thread(this).start();
    }

    private void showProgressBar(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SVGFormEditorElement.this.progressBar.setVisible(bl);
            }
        });
    }

    public void removeNotify() {
        this.paths.clear();
        this.project = null;
        this.wrapper = null;
        super.removeNotify();
    }

    public void setDesignComponent(DesignComponent designComponent) {
        this.documentReferences = new WeakReference<DesignDocument>(designComponent.getDocument());
        this.svgFormReferences = new WeakReference<DesignComponent>(designComponent);
        super.setDesignComponent(designComponent);
    }

    public void listSelectionHappened() {
        this.updateSVGComponentsList();
    }

    private void updateSVGComponentsList() {
        String string = (String)this.pathTextComboBox.getSelectedItem();
        FileObject fileObject = this.paths.get(string);
        this.updateSVGModelTable(null);
        try {
            InputStream inputStream = null;
            if (fileObject != null) {
                inputStream = fileObject.getInputStream();
                this.updateSVGModelTable(inputStream);
            }
            this.jTable1.repaint();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
    }

    public void getCustomEdiotrNotification() {
        this.jTable1.setModel(new Model());
        this.jTable1.repaint();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelImageFile = new JPanel();
        this.pathLabel = new JLabel();
        this.previewLabel = new JLabel();
        this.previewPanel = new JPanel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField();
        this.chooserButton = new JButton();
        this.pathTextComboBox = new JComboBox();
        this.progressBar = new JProgressBar();
        this.jPanelSVGComponents = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1.setText(NbBundle.getMessage(SVGFormEditorElement.class, (String)"SVGFormEditorElement.jButton1.text"));
        Mnemonics.setLocalizedText((JLabel)this.pathLabel, (String)NbBundle.getMessage(SVGFormEditorElement.class, (String)"ImageEditorElement.pathLabel.text"));
        this.pathLabel.setEnabled(false);
        this.previewLabel.setText(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ImageEditorElement.previewLabel.text"));
        this.previewLabel.setEnabled(false);
        this.previewPanel.setEnabled(false);
        this.previewPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.widthLabel, (String)NbBundle.getMessage(SVGFormEditorElement.class, (String)"ImageEditorElement.widthLabel.text"));
        this.widthLabel.setEnabled(false);
        this.widthTextField.setEditable(false);
        this.widthTextField.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.heightLabel, (String)NbBundle.getMessage(SVGFormEditorElement.class, (String)"ImageEditorElement.heightLabel.text"));
        this.heightLabel.setEnabled(false);
        this.heightTextField.setEditable(false);
        this.heightTextField.setEnabled(false);
        this.chooserButton.setText(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ImageEditorElement.chooserButton.text"));
        this.chooserButton.setEnabled(false);
        this.chooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGFormEditorElement.this.chooserButtonActionPerformed(actionEvent);
            }
        });
        this.pathTextComboBox.setEditable(true);
        this.pathTextComboBox.setModel(this.comboBoxModel);
        this.pathTextComboBox.setEnabled(false);
        this.pathTextComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGFormEditorElement.this.pathTextComboBoxActionPerformed(actionEvent);
            }
        });
        this.progressBar.setIndeterminate(true);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanelImageFile);
        this.jPanelImageFile.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 408, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.pathLabel).addPreferredGap(0, 339, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.previewLabel).addPreferredGap(0).add((Component)this.previewPanel, -1, 164, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.heightLabel).add((Component)this.widthLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.widthTextField, -2, 92, -2).add((Component)this.heightTextField, -2, 92, -2))).add((Component)this.progressBar, -2, 146, -2))).add((Component)this.pathTextComboBox, 0, 362, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.chooserButton, -2, 30, -2))).addContainerGap())));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 223, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.pathLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.chooserButton).add((Component)this.pathTextComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.widthLabel).add((Component)this.widthTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.heightLabel).add((Component)this.heightTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addPreferredGap(0)).add((Component)this.previewLabel).add((Component)this.previewPanel, -1, 163, Short.MAX_VALUE)).addContainerGap())));
        this.jTabbedPane1.addTab(NbBundle.getMessage(SVGFormEditorElement.class, (String)"SVGFormEditorElement.jPanelImageFile.TabConstraints.tabTitle"), this.jPanelImageFile);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ACSN_RecognizedComponents"));
        this.jTable1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ACSD_RecognizedComponents"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanelSVGComponents);
        this.jPanelSVGComponents.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 408, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 223, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(SVGFormEditorElement.class, (String)"SVGFormEditorElement.jPanelSVGComponents.TabConstraints.tabTitle"), this.jPanelSVGComponents);
        GroupLayout groupLayout3 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(0, 445, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(0, 16, Short.MAX_VALUE).add((Component)this.jTabbedPane1, -2, -1, -2).add(0, 16, Short.MAX_VALUE))));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(0, 282, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(0, 17, Short.MAX_VALUE).add((Component)this.jTabbedPane1, -2, -1, -2).add(0, 17, Short.MAX_VALUE))));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ACSN_TabbedPane"));
        this.jTabbedPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGFormEditorElement.class, (String)"ACSD_TabbedPane"));
    }

    private void chooserButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.lastDir != null ? this.lastDir : this.project.getProjectDirectory().getPath());
        jFileChooser.setFileFilter(new ImageFilter());
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)jFileChooser.getSelectedFile()));
            this.lastDir = jFileChooser.getSelectedFile().getParentFile().getPath();
            String string = this.convertFile(fileObject, null, true);
            if (string != null) {
                this.setText(string);
                this.pathMap.put(string, fileObject.getPath());
                this.pathTextComboBoxActionPerformed(null);
            } else {
                String string2 = NbBundle.getMessage(SVGFormEditorElement.class, (String)"MSG_FILE_EXIST");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2));
            }
        }
        this.updateSVGComponentsList();
    }

    private void pathTextComboBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.doNotFireEvent) {
            String string = (String)this.pathTextComboBox.getSelectedItem();
            this.fireElementChanged(this.componentID, "resourcePath", MidpTypes.createStringValue((String)(string != null ? string : "")));
            this.updatePreview();
            this.updateSVGComponentsList();
            this.needUpdate = true;
        }
    }

    private void updateSVGModelTable(InputStream inputStream) {
        this.jTable1.setModel(new Model(inputStream));
    }

    public void elementChanged(PropertyEditorResourceElementEvent propertyEditorResourceElementEvent) {
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = SVGFormEditorElement.this.jTable1.rowAtPoint(mouseEvent.getPoint());
            SVGFormEditorElement.this.jTable1.getSelectionModel().setSelectionInterval(n, n);
            this.showPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = SVGFormEditorElement.this.jTable1.rowAtPoint(mouseEvent.getPoint());
            SVGFormEditorElement.this.jTable1.getSelectionModel().setSelectionInterval(n, n);
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                SVGFormEditorElement.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class MoveAction
    extends AbstractAction {
        private int step;

        public MoveAction(String string, int n) {
            super(string);
            this.step = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.step < 0) {
                if (SVGFormEditorElement.this.jTable1.getSelectedRow() < SVGFormEditorElement.this.jTable1.getRowCount() - 1) {
                    this.moveValue(this.step);
                }
            } else if (SVGFormEditorElement.this.jTable1.getSelectedRow() > 0) {
                this.moveValue(this.step);
            }
        }

        private void moveValue(int n) {
            SVGFormEditorElement.this.orderNeedsUpdate = true;
            TableModel tableModel = SVGFormEditorElement.this.jTable1.getModel();
            int n2 = SVGFormEditorElement.this.jTable1.getSelectedRow();
            String string = (String)tableModel.getValueAt(n2, 0);
            String string2 = (String)tableModel.getValueAt(n2, 1);
            String string3 = (String)tableModel.getValueAt(n2 - n, 0);
            String string4 = (String)tableModel.getValueAt(n2 - n, 1);
            tableModel.setValueAt(string, n2 - n, 0);
            tableModel.setValueAt(string2, n2 - n, 1);
            tableModel.setValueAt(string3, n2, 0);
            tableModel.setValueAt(string4, n2, 1);
            SVGFormEditorElement.this.jTable1.getSelectionModel().setSelectionInterval(n2 - n, n2 - n);
            SVGFormEditorElement.this.jTabbedPane1.repaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Model
    implements TableModel {
        private String COLUMN_NAME_I = ResourceBundle.getBundle("org/netbeans/modules/vmd/midpnb/propertyeditors/Bundle").getString("SVG_Component_Type_Column");
        private String COLUMN_NAME_II = ResourceBundle.getBundle("org/netbeans/modules/vmd/midpnb/propertyeditors/Bundle").getString("SVG_Component_ID_Column");
        private Object[][] values;

        public Model() {
            if (SVGFormEditorElement.this.svgFormReferences == null || SVGFormEditorElement.this.svgFormReferences.get() == null) {
                return;
            }
            final DesignComponent designComponent = (DesignComponent)SVGFormEditorElement.this.svgFormReferences.get();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    List list = designComponent.readProperty("components").getArray();
                    Model.access$602(Model.this, new Object[list.size()][2]);
                    int n = 0;
                    for (PropertyValue propertyValue : list) {
                        String string = (String)propertyValue.getComponent().readProperty("id").getPrimitiveValue();
                        String string2 = MidpTypes.getSimpleClassName((TypeID)propertyValue.getComponent().getType());
                        ((Model)Model.this).values[n][1] = string;
                        ((Model)Model.this).values[n++][0] = string2;
                    }
                }
            });
        }

        public Model(InputStream inputStream) {
            if (inputStream == null) {
                this.values = new Object[0][0];
                return;
            }
            this.values = SVGFormImageParser.getComponentsInformation(inputStream);
        }

        @Override
        public int getRowCount() {
            if (this.values == null) {
                return 0;
            }
            return this.values.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return this.COLUMN_NAME_I;
            }
            return this.COLUMN_NAME_II;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.values != null) {
                return this.values[n][n2];
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.values[n][n2] = (String)object;
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        static /* synthetic */ Object[][] access$602(Model model, Object[][] objectArray) {
            model.values = objectArray;
            return objectArray;
        }
    }

    private static class ImageFilter
    extends FileFilter {
        private String description = NbBundle.getMessage(SVGFormEditorElement.class, (String)"DISP_SVG_Image_Files");

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = ImageFilter.getExtension(file);
            return SVGFormEditorElement.EXTENSION.equals(string);
        }

        public String getDescription() {
            return this.description;
        }

        private static String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }
}

