/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGButtonGroupCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGCheckBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComboBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComponentCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGLabelCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGRadioButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSliderCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSpinnerCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGTextFieldCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.AbstractElementsContentHandler;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGFormImageParser
extends SVGComponentImageParser {
    private static final String DIGITS = "_\\d+";
    private static final String DIGITS_END = "_\\d+$";
    private static final String PREFIX = "^";
    private static final Pattern FORM_COMPONENT_ID_BUTTON = Pattern.compile("^button_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_LABEL = Pattern.compile("^label_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_RADIO = Pattern.compile("^radiobutton_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_CHECKBOX = Pattern.compile("^checkbox_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_COMBOBOX = Pattern.compile("^combobox_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_LIST = Pattern.compile("^list_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_SLIDER = Pattern.compile("^slider_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_SPINNER = Pattern.compile("^spinner_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_TEXTFIELD = Pattern.compile("^textfield_\\d+$");
    private static final Pattern FORM_COMPONENT_ID_RADIOBUTTONFRAME = Pattern.compile("^radiobuttonframe_\\d+$");
    private static final Pattern LABEL_TEXT_PROP = Pattern.compile("^label_\\d+_text$");
    private static final Pattern RADIO_TEXT_PROP = Pattern.compile("^radiobutton_\\d+_text$");

    public static synchronized void parseSVGForm(InputStream inputStream, final DesignComponent designComponent) {
        final SVGFormComponent[] sVGFormComponentArray = SVGFormImageParser.getFormComponents(inputStream);
        if (sVGFormComponentArray != null) {
            designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    HashMap<SVGFormComponent, DesignComponent> hashMap = new HashMap<SVGFormComponent, DesignComponent>();
                    for (SVGFormComponent sVGFormComponent : sVGFormComponentArray) {
                        DesignComponent designComponent2 = sVGFormComponent.createComponent(designComponent);
                        designComponent.addComponent(designComponent2);
                        hashMap.put(sVGFormComponent, designComponent2);
                        MidpArraySupport.append((DesignComponent)designComponent, (String)"components", (DesignComponent)designComponent2);
                    }
                    SVGFormImageParser.initButtonGroup(hashMap);
                }
            });
        }
    }

    @Override
    public void parse(InputStream inputStream, DesignComponent designComponent) {
        SVGFormImageParser.parseSVGForm(inputStream, designComponent);
    }

    public static void initButtonGroup(Map<SVGFormComponent, DesignComponent> map) {
        for (Map.Entry<SVGFormComponent, DesignComponent> entry : map.entrySet()) {
            SVGFormComponent sVGFormComponent;
            Map<String, Object> map2;
            SVGFormComponent sVGFormComponent2 = entry.getKey();
            if (!sVGFormComponent2.getTypeID().equals((Object)SVGRadioButtonCD.TYPEID) || (map2 = sVGFormComponent2.getProperties()) == null || (sVGFormComponent = (SVGFormComponent)map2.get("buttonGroup")) == null) continue;
            entry.getValue().writeProperty("buttonGroup", PropertyValue.createComponentReference((DesignComponent)map.get(sVGFormComponent)));
        }
    }

    private static SVGFormComponent[] getFormComponents(InputStream inputStream) {
        NamedElementsContentHandler namedElementsContentHandler = new NamedElementsContentHandler();
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(namedElementsContentHandler);
            xMLReader.setEntityResolver(namedElementsContentHandler);
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
        catch (SAXException sAXException) {
            Debug.warning((Object[])new Object[]{sAXException});
        }
        return namedElementsContentHandler.getFoundElements();
    }

    private static Float getPosition(Attributes attributes) {
        String string = attributes.getValue("transform");
        Float f = null;
        if (string != null) {
            if (string.startsWith("translate")) {
                f = SVGFormImageParser.getPositionFromTranslate(string);
            } else if (string.startsWith("matrix")) {
                f = SVGFormImageParser.getPositionFromMatrix(string);
            }
        }
        return f;
    }

    private static Float getPositionFromTranslate(String string) {
        Float f = null;
        int n = string.indexOf(",");
        int n2 = string.indexOf(")");
        try {
            f = new Float(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(SVGFormImageParser.class.getName()).info(numberFormatException.getMessage());
        }
        return f;
    }

    private static Float getPositionFromMatrix(String string) {
        Float f = null;
        int n = string.lastIndexOf(",");
        int n2 = string.indexOf(")");
        try {
            f = new Float(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(SVGFormImageParser.class.getName()).info(numberFormatException.getMessage());
        }
        return f;
    }

    private static Float getPositionForRadioButton(Attributes attributes, Float f) {
        Float f2 = SVGFormImageParser.getPosition(attributes);
        if (f2 == null || attributes == null || f == null) {
            return new Float(0.0f);
        }
        if (f2 != null) {
            f2 = Float.valueOf(f2.floatValue() + f.floatValue());
        }
        return f2;
    }

    public static final Object[][] getComponentsInformation(InputStream inputStream) {
        SVGFormComponent[] sVGFormComponentArray = SVGFormImageParser.getFormComponents(inputStream);
        Object[][] objectArray = new Object[sVGFormComponentArray.length][3];
        for (int i = 0; i < sVGFormComponentArray.length; ++i) {
            objectArray[i][1] = sVGFormComponentArray[i].getId();
            objectArray[i][0] = MidpTypes.getSimpleClassName((TypeID)sVGFormComponentArray[i].getTypeID());
            objectArray[i][2] = sVGFormComponentArray[i];
        }
        return objectArray;
    }

    private static class NamedElementsContentHandler
    extends AbstractElementsContentHandler {
        private ArrayList<SVGFormComponent> foundElements = new ArrayList();
        private Float radioButtonFramePosition;
        private SVGFormComponent myCurrentComponent;
        private SVGFormComponent myButtonGroup;
        private String myPropName;
        private StringBuilder myText;

        public SVGFormComponent[] getFoundElements() {
            LinkedList<SVGFormComponent> linkedList = new LinkedList<SVGFormComponent>();
            for (SVGFormComponent sVGFormComponent : this.foundElements) {
                linkedList.addFirst(sVGFormComponent);
            }
            return linkedList.toArray(new SVGFormComponent[linkedList.size()]);
        }

        public final void resetFoundElements() {
            this.foundElements.clear();
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = attributes.getValue("id");
            String string5 = attributes.getValue("transform");
            if (string4 != null && (LABEL_TEXT_PROP.matcher(string4).find() || RADIO_TEXT_PROP.matcher(string4).find())) {
                this.myPropName = "text";
                return;
            }
            if (string4 == null || string5 == null) {
                return;
            }
            if (FORM_COMPONENT_ID_RADIOBUTTONFRAME.matcher(string4).find()) {
                this.radioButtonFramePosition = SVGFormImageParser.getPosition(attributes);
                this.addSVGFormComponent(string4, SVGButtonGroupCD.TYPEID, SVGFormImageParser.getPosition(attributes), string2);
                this.myButtonGroup = this.myCurrentComponent;
                return;
            }
            if (FORM_COMPONENT_ID_BUTTON.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGButtonCD.TYPEID, SVGFormImageParser.getPosition(attributes), string2);
            } else if (FORM_COMPONENT_ID_CHECKBOX.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGCheckBoxCD.TYPEID, SVGFormImageParser.getPosition(attributes), string2);
            } else if (FORM_COMPONENT_ID_COMBOBOX.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGComboBoxCD.TYPEID, SVGFormImageParser.getPosition(attributes), string2);
            } else if (FORM_COMPONENT_ID_LABEL.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGLabelCD.TYPEID, SVGFormImageParser.getPosition(attributes), string2);
            } else if (FORM_COMPONENT_ID_LIST.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGListCD.TYPEID, SVGFormImageParser.getPosition(attributes), string2);
            } else if (FORM_COMPONENT_ID_RADIO.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGRadioButtonCD.TYPEID, SVGFormImageParser.getPositionForRadioButton(attributes, this.radioButtonFramePosition), string2);
            } else if (FORM_COMPONENT_ID_SLIDER.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGSliderCD.TYPEID, SVGFormImageParser.getPosition(attributes), string2);
            } else if (FORM_COMPONENT_ID_SPINNER.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGSpinnerCD.TYPEID, SVGFormImageParser.getPosition(attributes), string2);
            } else if (FORM_COMPONENT_ID_TEXTFIELD.matcher(string4).find()) {
                this.addSVGFormComponent(string4, SVGTextFieldCD.TYPEID, SVGFormImageParser.getPosition(attributes), string2);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.myPropName == null) {
                return;
            }
            if (this.myText == null) {
                this.myText = new StringBuilder();
            }
            this.myText.append(cArray, n, n2);
        }

        private void addSVGFormComponent(String string, TypeID typeID, Float f, String string2) {
            int n = this.getIndex(f);
            this.myCurrentComponent = SVGFormComponent.createComponent(string, typeID, SVGComponentCD.getEventType(typeID), f);
            if (!typeID.equals((Object)SVGRadioButtonCD.TYPEID)) {
                this.myButtonGroup = null;
            } else if (this.myButtonGroup != null) {
                this.myCurrentComponent.setProperty("buttonGroup", this.myButtonGroup);
            }
            if (n == -1) {
                this.foundElements.add(this.myCurrentComponent);
            } else {
                this.foundElements.add(n, this.myCurrentComponent);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.myPropName == null) {
                return;
            }
            this.myCurrentComponent.setProperty(this.myPropName, this.myText.toString().trim());
            this.myText = null;
            this.myPropName = null;
        }

        private int getIndex(Float f) {
            int n = -1;
            if (f != null) {
                Float f2 = new Float(-1.0f);
                for (SVGFormComponent sVGFormComponent : this.foundElements) {
                    if (!(f.floatValue() > sVGFormComponent.getPositon().floatValue()) || !(f2.floatValue() < sVGFormComponent.getPositon().floatValue())) continue;
                    f2 = sVGFormComponent.getPositon();
                    n = this.foundElements.indexOf(sVGFormComponent);
                }
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SVGFormComponent {
        private String id;
        private TypeID type;
        private Float position;
        private Map<String, Object> myProperties;

        public static SVGFormComponent createComponent(SVGFormComponent sVGFormComponent, Float f) {
            sVGFormComponent.setPosition(f);
            return sVGFormComponent;
        }

        public static SVGFormComponent createComponent(String string, TypeID typeID, TypeID typeID2, Float f) {
            return new SVGFormComponentImpl(string, typeID, f, typeID2);
        }

        SVGFormComponent(String string, TypeID typeID, Float f) {
            if (typeID == null || string == null || f == null) {
                throw new IllegalArgumentException(" id or type argument is null");
            }
            this.type = typeID;
            this.id = string;
            this.position = f;
        }

        public abstract DesignComponent createComponent(DesignComponent var1);

        String getId() {
            return this.id;
        }

        TypeID getTypeID() {
            return this.type;
        }

        Float getPositon() {
            return this.position;
        }

        void setPosition(Float f) {
            this.position = f;
        }

        void setProperty(String string, Object object) {
            if (this.myProperties == null) {
                this.myProperties = new HashMap<String, Object>();
            }
            this.myProperties.put(string, object);
        }

        void setProperties(Map<String, Object> map) {
            this.myProperties = map;
        }

        Map<String, Object> getProperties() {
            return this.myProperties;
        }

        private static class SVGFormComponentImpl
        extends SVGFormComponent {
            private TypeID myEventType;

            SVGFormComponentImpl(String string, TypeID typeID, Float f, TypeID typeID2) {
                super(string, typeID, f);
                this.myEventType = typeID2;
            }

            SVGFormComponentImpl(SVGFormComponent sVGFormComponent, Float f) {
                super(sVGFormComponent.id, sVGFormComponent.type, f);
                this.setProperties(sVGFormComponent.getProperties());
            }

            public DesignComponent createComponent(DesignComponent designComponent) {
                Object object;
                DesignComponent designComponent2 = designComponent.getDocument().createComponent(this.getTypeID());
                if (this.myEventType != null) {
                    object = designComponent.getDocument().createComponent(this.myEventType);
                    object.writeProperty("svgButton", PropertyValue.createComponentReference((DesignComponent)designComponent2));
                    designComponent.addComponent((DesignComponent)object);
                }
                designComponent2.writeProperty("id", MidpTypes.createStringValue((String)this.getId()));
                object = this.getProperties();
                if (object != null) {
                    for (Map.Entry entry : object.entrySet()) {
                        if (((String)entry.getKey()).equals("buttonGroup")) continue;
                        designComponent2.writeProperty((String)entry.getKey(), MidpTypes.createStringValue((String)entry.getValue().toString()));
                    }
                }
                return designComponent2;
            }
        }
    }
}

