/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.SemanticAnalysisVisitor;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovySemanticAnalyzer
extends SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final synchronized void cancel() {
        this.cancelled = true;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        GroovyParserResult groovyParserResult = AstUtilities.getParseResult(result);
        if (groovyParserResult == null) {
            return;
        }
        ModuleNode moduleNode = AstUtilities.getRoot(groovyParserResult);
        if (moduleNode == null) {
            return;
        }
        HashMap<OffsetRange, Set<ColoringAttributes>> hashMap = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        AstPath astPath = new AstPath();
        astPath.descend(moduleNode);
        BaseDocument baseDocument = LexUtilities.getDocument(groovyParserResult.getSnapshot().getSource(), false);
        if (baseDocument == null) {
            return;
        }
        SemanticAnalysisVisitor semanticAnalysisVisitor = new SemanticAnalysisVisitor(moduleNode, baseDocument);
        hashMap.putAll(semanticAnalysisVisitor.annotate());
        astPath.ascend();
        if (this.isCancelled()) {
            return;
        }
        if (hashMap.size() > 0) {
            HashMap hashMap2 = new HashMap(2 * hashMap.size());
            for (Map.Entry entry : hashMap.entrySet()) {
                OffsetRange offsetRange = LexUtilities.getLexerOffsets(groovyParserResult, (OffsetRange)entry.getKey());
                if (offsetRange == OffsetRange.NONE) continue;
                hashMap2.put(offsetRange, entry.getValue());
            }
            hashMap = hashMap2;
            this.semanticHighlights = hashMap;
        } else {
            this.semanticHighlights = null;
        }
    }
}

