/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.parser;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyResourceLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.GroovyCompilerErrorID;
import org.netbeans.modules.groovy.editor.api.GroovyUtils;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyError;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class GroovyParser
extends Parser {
    private static final Logger LOG = Logger.getLogger(GroovyParser.class.getName());
    private static final AtomicLong PARSING_TIME = new AtomicLong(0L);
    private static final AtomicInteger PARSING_COUNT = new AtomicInteger(0);
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private static long maximumParsingTime;
    private boolean waitJavaScanFinished = true;
    private GroovyParserResult lastResult;
    private AtomicBoolean cancelled = new AtomicBoolean();

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void cancel() {
        LOG.log(Level.FINEST, "Parser cancelled");
        this.cancelled.set(true);
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sourceModificationEvent) throws ParseException {
        this.cancelled.set(false);
        Context context = new Context(snapshot, sourceModificationEvent);
        final ArrayList arrayList = new ArrayList();
        context.errorHandler = new ParseErrorHandler(){

            public void error(Error error) {
                arrayList.add(error);
            }
        };
        this.lastResult = this.parseBuffer(context, Sanitize.NONE);
        if (this.lastResult != null) {
            this.lastResult.setErrors(arrayList);
        } else {
            this.lastResult = this.createParseResult(snapshot, null, null);
        }
    }

    void setWaitJavaScanFinished(boolean bl) {
        this.waitJavaScanFinished = bl;
    }

    protected GroovyParserResult createParseResult(Snapshot snapshot, ModuleNode moduleNode, ErrorCollector errorCollector) {
        GroovyParserResult groovyParserResult = new GroovyParserResult(this, snapshot, moduleNode, errorCollector);
        return groovyParserResult;
    }

    private boolean sanitizeSource(Context context, Sanitize sanitize) {
        if (sanitize == Sanitize.MISSING_END) {
            context.sanitizedSource = context.source + "}";
            int n = context.source.length();
            context.sanitizedRange = new OffsetRange(n, n + 1);
            context.sanitizedContents = "";
            return true;
        }
        int n = context.caretOffset;
        if (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.ERROR_LINE) {
            n = context.errorOffset;
        }
        if (n == -1) {
            return false;
        }
        String string = context.source;
        if (n > string.length()) {
            return false;
        }
        try {
            if ((GroovyUtils.isRowEmpty(string, n) || GroovyUtils.isRowWhite(string, n)) && (n = GroovyUtils.getRowStart(string, n) - 1) < 0) {
                n = 0;
            }
            if (!GroovyUtils.isRowEmpty(string, n) && !GroovyUtils.isRowWhite(string, n)) {
                if (sanitize == Sanitize.EDITED_LINE || sanitize == Sanitize.ERROR_LINE) {
                    int n2;
                    Object object;
                    if (sanitize == Sanitize.ERROR_LINE) {
                        TokenSequence<? extends GroovyTokenId> tokenSequence;
                        TokenSequence<? extends GroovyTokenId> tokenSequence2 = tokenSequence = context.document != null ? LexUtilities.getPositionedSequence(context.document, n) : null;
                        if (tokenSequence != null && (object = LexUtilities.findPreviousNonWsNonComment(tokenSequence)).id() == GroovyTokenId.DOT) {
                            int n3 = tokenSequence.offset();
                            int n4 = n3 + 1;
                            StringBuilder stringBuilder = new StringBuilder(string.length());
                            stringBuilder.append(string.substring(0, n3));
                            stringBuilder.append(' ');
                            if (n4 < string.length()) {
                                stringBuilder.append(string.substring(n4, string.length()));
                            }
                            assert (stringBuilder.length() == string.length());
                            context.sanitizedRange = new OffsetRange(n3, n4);
                            context.sanitizedSource = stringBuilder.toString();
                            context.sanitizedContents = string.substring(n3, n4);
                            return true;
                        }
                    }
                    if ((n2 = GroovyUtils.getRowLastNonWhite(string, n)) != -1) {
                        object = new StringBuilder(string.length());
                        int n5 = GroovyUtils.getRowStart(string, n);
                        if (++n2 >= n5 + 2) {
                            ((StringBuilder)object).append(string.substring(0, n5));
                            ((StringBuilder)object).append("//");
                            int n6 = n5 + 2;
                            if (n6 < string.length()) {
                                ((StringBuilder)object).append(string.substring(n6, string.length()));
                            }
                        } else {
                            ((StringBuilder)object).append(string.substring(0, n5));
                            ((StringBuilder)object).append(" ");
                            int n7 = n5 + 1;
                            if (n7 < string.length()) {
                                ((StringBuilder)object).append(string.substring(n7, string.length()));
                            }
                        }
                        assert (((StringBuilder)object).length() == string.length());
                        context.sanitizedRange = new OffsetRange(n5, n2);
                        context.sanitizedSource = ((StringBuilder)object).toString();
                        context.sanitizedContents = string.substring(n5, n2);
                        return true;
                    }
                } else {
                    int n8;
                    assert (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.EDITED_DOT);
                    int n9 = GroovyUtils.getRowStart(string, n);
                    for (n8 = n - 1; n8 >= n9 && n8 < string.length() && Character.isWhitespace(string.charAt(n8)); --n8) {
                    }
                    if (n8 > n9) {
                        StringBuilder stringBuilder = new StringBuilder(string.length());
                        String string2 = string.substring(n9, n8 + 1);
                        int n10 = 0;
                        int n11 = n8 + 1;
                        if (string2.endsWith("?.") || string2.endsWith(".&")) {
                            n10 = 2;
                        } else if (string2.endsWith(".") || string2.endsWith("(")) {
                            n10 = 1;
                        } else if (string2.endsWith(",")) {
                            n10 = 1;
                        } else if (string2.endsWith(", ")) {
                            n10 = 2;
                        } else if (string2.endsWith(",)")) {
                            n10 = 1;
                            --n11;
                        } else if (string2.endsWith(", )")) {
                            n10 = 1;
                            n11 -= 2;
                        }
                        if (n10 == 0) {
                            return false;
                        }
                        int n12 = n11 - n10;
                        stringBuilder.append(string.substring(0, n12));
                        for (int i = 0; i < n10; ++i) {
                            stringBuilder.append(' ');
                        }
                        if (n11 < string.length()) {
                            stringBuilder.append(string.substring(n11, string.length()));
                        }
                        assert (stringBuilder.length() == string.length());
                        context.sanitizedRange = new OffsetRange(n12, n11);
                        context.sanitizedSource = stringBuilder.toString();
                        context.sanitizedContents = string.substring(n12, n11);
                        return true;
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return false;
    }

    private GroovyParserResult sanitize(Context context, Sanitize sanitize) {
        switch (sanitize) {
            case NEVER: {
                return this.createParseResult(context.snapshot, null, null);
            }
            case NONE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_DOT);
                }
            }
            case EDITED_DOT: {
                if (context.errorOffset != -1 && context.errorOffset != context.caretOffset) {
                    return this.parseBuffer(context, Sanitize.ERROR_DOT);
                }
            }
            case ERROR_DOT: {
                if (context.errorOffset != -1) {
                    return this.parseBuffer(context, Sanitize.ERROR_LINE);
                }
            }
            case ERROR_LINE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_LINE);
                }
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.MISSING_END);
            }
        }
        return this.createParseResult(context.snapshot, null, null);
    }

    /*
     * Exception decompiling
     */
    GroovyParserResult parseBuffer(Context var1_1, Sanitize var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logParsingTime(Context context, long l, boolean bl) {
        long l2 = System.currentTimeMillis() - l;
        long l3 = PARSING_TIME.addAndGet(l2);
        if (bl) {
            LOG.log(Level.FINEST, "Compilation cancelled in {0} for file {3}; total time spent {1}; total count {2}", new Object[]{l2, l3, PARSING_COUNT.intValue(), context.snapshot.getSource().getFileObject()});
        } else {
            LOG.log(Level.FINEST, "Compilation finished in {0} for file {3}; total time spent {1}; total count {2}", new Object[]{l2, l3, PARSING_COUNT.intValue(), context.snapshot.getSource().getFileObject()});
        }
        Class<GroovyParser> clazz = GroovyParser.class;
        synchronized (GroovyParser.class) {
            if (l2 > maximumParsingTime) {
                maximumParsingTime = l2;
                LOG.log(Level.FINEST, "Maximum parsing time has been updated to {0}; file {1}", new Object[]{l2, context.snapshot.getSource().getFileObject()});
            }
            // ** MonitorExit[var8_5] (shouldn't be in output)
            return;
        }
    }

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    private static void notifyError(Context context, String string, Severity severity, String string2, String string3, int n, Sanitize sanitize) {
        GroovyParser.notifyError(context, string, severity, string2, string3, n, n, sanitize);
    }

    private static void notifyError(Context context, String string, Severity severity, String string2, String string3, int n, int n2, Sanitize sanitize) {
        LOG.log(Level.FINEST, "---------------------------------------------------");
        LOG.log(Level.FINEST, "key         : {0}\n", string);
        LOG.log(Level.FINEST, "description : {0}\n", string2);
        LOG.log(Level.FINEST, "displayName : {0}\n", string3);
        LOG.log(Level.FINEST, "startOffset : {0}\n", n);
        LOG.log(Level.FINEST, "endOffset   : {0}\n", n2);
        if (string2 == null) {
            LOG.log(Level.FINEST, "dropping error");
            return;
        }
        if (string == null) {
            string = string2;
        }
        if (string3 == null) {
            string3 = string2;
        }
        GroovyError groovyError = new GroovyError(string, string3, string2, context.snapshot.getSource().getFileObject(), n, n2, severity, GroovyParser.getIdForErrorMessage(string2));
        context.errorHandler.error(groovyError);
        if (sanitize == Sanitize.NONE) {
            context.errorOffset = n;
        }
    }

    static GroovyCompilerErrorID getIdForErrorMessage(String string) {
        String string2 = "unable to resolve class ";
        if (string != null && string.startsWith(string2)) {
            return GroovyCompilerErrorID.CLASS_NOT_FOUND;
        }
        return GroovyCompilerErrorID.UNDEFINED;
    }

    private void handleErrorCollector(ErrorCollector errorCollector, Context context, ModuleNode moduleNode, boolean bl, Sanitize sanitize) {
        List list;
        if (!bl && errorCollector != null && (list = errorCollector.getErrors()) != null) {
            for (Object e : list) {
                Object object;
                LOG.log(Level.FINEST, "Error found in collector: {0}", e);
                if (e instanceof SyntaxErrorMessage) {
                    object = ((SyntaxErrorMessage)e).getCause();
                    String string = ((SyntaxException)object).getSourceLocator();
                    String string2 = null;
                    if (moduleNode != null) {
                        string2 = moduleNode.getContext().getName();
                    } else if (context.snapshot.getSource().getFileObject() != null) {
                        string2 = context.snapshot.getSource().getFileObject().getNameExt();
                    }
                    if (string == null || string2 == null || !string.equals(string2)) continue;
                    int n = ((SyntaxException)object).getStartLine();
                    int n2 = ((SyntaxException)object).getStartColumn();
                    int n3 = ((SyntaxException)object).getLine();
                    int n4 = ((SyntaxException)object).getEndColumn();
                    int n5 = 0;
                    int n6 = 0;
                    if (context.document != null) {
                        n5 = AstUtilities.getOffset(context.document, n > 0 ? n : 1, n2 > 0 ? n2 : 1);
                        n6 = AstUtilities.getOffset(context.document, n3 > 0 ? n3 : 1, n4 > 0 ? n4 : 1);
                    }
                    GroovyParser.notifyError(context, null, Severity.ERROR, ((SyntaxException)object).getMessage(), null, n5, n6, sanitize);
                    continue;
                }
                if (e instanceof SimpleMessage) {
                    object = ((SimpleMessage)e).getMessage();
                    GroovyParser.notifyError(context, null, Severity.ERROR, (String)object, null, -1, sanitize);
                    continue;
                }
                GroovyParser.notifyError(context, null, Severity.ERROR, "Error", null, -1, sanitize);
            }
        }
    }

    private static class ParsingClassLoader
    extends GroovyClassLoader {
        private final CompilerConfiguration config;
        private final ClassPath path;
        private final GroovyResourceLoader resourceLoader = new GroovyResourceLoader(){

            public URL loadGroovySource(final String string) throws MalformedURLException {
                URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ParsingClassLoader.this.getSourceFile(string);
                    }
                });
                return uRL;
            }
        };

        public ParsingClassLoader(ClassPath classPath, CompilerConfiguration compilerConfiguration) {
            super(classPath.getClassLoader(true), compilerConfiguration);
            this.config = compilerConfiguration;
            this.path = classPath;
        }

        public Class loadClass(String string, boolean bl, boolean bl2, boolean bl3) throws ClassNotFoundException, CompilationFailedException {
            boolean bl4 = false;
            if (!$assertionsDisabled) {
                bl4 = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (bl4) {
                Class clazz = super.loadClass(string, bl, bl2, bl3);
                assert (false) : "Class " + clazz + " loaded by GroovyClassLoader";
            }
            throw new ClassNotFoundException();
        }

        public GroovyResourceLoader getResourceLoader() {
            return this.resourceLoader;
        }

        private URL getSourceFile(String string) {
            FileObject fileObject = this.path.findResource(string.replace('.', '/') + this.config.getDefaultScriptExtension());
            if (fileObject == null || fileObject.isFolder()) {
                return null;
            }
            return URLMapper.findURL((FileObject)fileObject, (int)1);
        }
    }

    private static interface ParseErrorHandler {
        public void error(Error var1);
    }

    public static final class Context {
        private final Snapshot snapshot;
        private final SourceModificationEvent event;
        private final BaseDocument document;
        private ParseErrorHandler errorHandler;
        private int errorOffset;
        private String source;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private int caretOffset;
        private Sanitize sanitized = Sanitize.NONE;

        public Context(Snapshot snapshot, SourceModificationEvent sourceModificationEvent) {
            this.snapshot = snapshot;
            this.event = sourceModificationEvent;
            this.source = GroovyParser.asString(snapshot.getText());
            this.caretOffset = GsfUtilities.getLastKnownCaretOffset((Snapshot)snapshot, (EventObject)sourceModificationEvent);
            this.document = LexUtilities.getDocument(snapshot.getSource(), true);
        }

        public String toString() {
            return "GroovyParser.Context(" + this.snapshot.getSource().getFileObject() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }

        static /* synthetic */ String access$100(Context context) {
            return context.sanitizedSource;
        }

        static /* synthetic */ Sanitize access$902(Context context, Sanitize sanitize) {
            context.sanitized = sanitize;
            return context.sanitized;
        }

        static /* synthetic */ Sanitize access$900(Context context) {
            return context.sanitized;
        }

        static /* synthetic */ OffsetRange access$300(Context context) {
            return context.sanitizedRange;
        }

        static /* synthetic */ String access$400(Context context) {
            return context.sanitizedContents;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sanitize {
        NEVER,
        NONE,
        EDITED_DOT,
        ERROR_DOT,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_END;

    }
}

