/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.elements;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.elements.GroovyElement;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexedElement
extends GroovyElement {
    protected IndexResult result;
    protected final String classFqn;
    protected final GroovyIndex index;
    protected final String attributes;
    protected Set<Modifier> modifiers;
    protected int flags;
    protected int docLength = -1;
    private Document document;

    protected IndexedElement(GroovyIndex groovyIndex, IndexResult indexResult, String string, String string2, int n) {
        this.index = groovyIndex;
        this.result = indexResult;
        this.attributes = string2;
        this.classFqn = string;
        this.flags = n;
    }

    public abstract String getSignature();

    public String toString() {
        return this.getSignature();
    }

    public GroovyIndex getIndex() {
        return this.index;
    }

    @Override
    public String getIn() {
        return this.classFqn;
    }

    public Document getDocument() throws IOException {
        if (this.document == null) {
            FileObject fileObject = this.getFileObject();
            if (fileObject == null) {
                return null;
            }
            this.document = LexUtilities.getDocument(fileObject, true);
        }
        return this.document;
    }

    @Override
    public FileObject getFileObject() {
        return this.result.getFile();
    }

    @Override
    public final Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            Modifier modifier = null;
            if (this.isPublic()) {
                modifier = Modifier.PUBLIC;
            } else if (this.isProtected()) {
                modifier = Modifier.PROTECTED;
            } else if (this.isPrivate()) {
                modifier = Modifier.PRIVATE;
            }
            boolean bl = this.isStatic();
            this.modifiers = modifier != null ? (bl ? EnumSet.of(modifier, Modifier.STATIC) : EnumSet.of(modifier)) : (bl ? EnumSet.of(Modifier.STATIC) : Collections.emptySet());
        }
        return this.modifiers;
    }

    public static char flagToFirstChar(int n) {
        char c = (char)(n >>= 4);
        if (c >= '\n') {
            return (char)(c - 10 + 97);
        }
        return (char)(c + 48);
    }

    public static char flagToSecondChar(int n) {
        char c = (char)(n & 0xF);
        if (c >= '\n') {
            return (char)(c - 10 + 97);
        }
        return (char)(c + 48);
    }

    public static String flagToString(int n) {
        return "" + IndexedElement.flagToFirstChar(n) + IndexedElement.flagToSecondChar(n);
    }

    public static int stringToFlag(String string, int n) {
        return IndexedElement.stringToFlag(string.charAt(n), string.charAt(n + 1));
    }

    public static int stringToFlag(char c, char c2) {
        int n = 0;
        int n2 = 0;
        n = c > '9' ? c - 97 + 10 : c - 48;
        n2 = c2 > '9' ? c2 - 97 + 10 : c2 - 48;
        return (n << 4) + n2;
    }

    public boolean isPublic() {
        return (this.flags & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.flags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.flags & 4) != 0;
    }

    public boolean isStatic() {
        return (this.flags & 8) != 0;
    }

    public static String decodeFlags(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 1) != 0) {
            stringBuilder.append("|PUBLIC");
        }
        if ((n & 4) != 0) {
            stringBuilder.append("|PROTECTED");
        }
        if ((n & 8) != 0) {
            stringBuilder.append("|STATIC");
        }
        return stringBuilder.toString();
    }
}

