/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.etable.TableColumnSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColumnSelectionPanel
extends JPanel {
    private static final String COLUMNS_SELECTOR_HINT = "ColumnsSelectorHint";
    private Map<ETableColumn, JCheckBox> checkBoxes = new HashMap<ETableColumn, JCheckBox>();
    private ETableColumnModel columnModel;

    public ColumnSelectionPanel(ETable eTable) {
        ETableColumnModel eTableColumnModel;
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        this.setLayout(new GridBagLayout());
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        this.columnModel = eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList = Collections.list(eTableColumnModel.getColumns());
        arrayList.addAll(eTableColumnModel.hiddenColumns);
        Collections.sort(arrayList, ETableColumnComparator.DEFAULT);
        int n = 1;
        this.layoutPanel(arrayList, n, eTable);
    }

    private void layoutPanel(List<TableColumn> list, int n, ETable eTable) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList;
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ETableColumn eTableColumn = (ETableColumn)list.get(i);
            JCheckBox jCheckBox = new JCheckBox();
            Object object3 = eTable.transformValue(eTableColumn);
            String string = object3 == eTableColumn ? eTableColumn.getHeaderValue().toString() : eTable.transformValue(eTableColumn).toString();
            jCheckBox.setText(string);
            jCheckBox = (JCheckBox)eTable.transformValue(jCheckBox);
            this.checkBoxes.put(eTableColumn, jCheckBox);
            jCheckBox.setSelected(!this.columnModel.isColumnHidden(eTableColumn));
            jCheckBox.setEnabled(eTableColumn.isHidingAllowed());
            if (!arrayList2.contains(string)) {
                hashMap.put(string, jCheckBox);
            } else {
                arrayList = null;
                object2 = hashMap.get(string);
                if (object2 instanceof JCheckBox) {
                    object = (JCheckBox)object2;
                    arrayList = new ArrayList<Object>();
                    arrayList.add(object);
                } else if (object2 instanceof ArrayList) {
                    arrayList = (ArrayList)object2;
                } else {
                    throw new IllegalStateException("Wrong object theFirstOne is " + object2);
                }
                arrayList.add(jCheckBox);
                hashMap.put(string, arrayList);
            }
            arrayList2.add(string);
        }
        String string = (String)arrayList2.remove(0);
        Collections.sort(arrayList2, Collator.getInstance());
        arrayList2.add(0, string);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = list.size() / n;
        arrayList = eTable.transformValue(COLUMNS_SELECTOR_HINT);
        if (arrayList != null) {
            object2 = new GridBagConstraints();
            ((GridBagConstraints)object2).gridx = 0;
            ((GridBagConstraints)object2).gridy = 0;
            ((GridBagConstraints)object2).insets = new Insets(5, 12, 12, 12);
            ((GridBagConstraints)object2).anchor = 18;
            this.add((Component)new JLabel(((Object)arrayList).toString()), object2);
        }
        object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            Cloneable cloneable;
            if (n2 >= n5) {
                n2 = 0;
                ++n3;
            }
            object = (String)object2.next();
            Object v = hashMap.get(object);
            JCheckBox jCheckBox = null;
            if (v instanceof JCheckBox) {
                jCheckBox = (JCheckBox)v;
            } else if (v instanceof ArrayList) {
                cloneable = (ArrayList)v;
                if (n4 >= ((ArrayList)cloneable).size()) {
                    n4 = 0;
                }
                jCheckBox = (JCheckBox)((ArrayList)cloneable).get(n4++);
            } else {
                throw new IllegalStateException("Wrong object obj is " + v);
            }
            cloneable = new GridBagConstraints();
            ((GridBagConstraints)cloneable).gridx = n3;
            ((GridBagConstraints)cloneable).gridy = n2 + (arrayList == null ? n2 : n2 + 1);
            ((GridBagConstraints)cloneable).insets = new Insets(0, 12, 0, 12);
            ((GridBagConstraints)cloneable).anchor = 18;
            ((GridBagConstraints)cloneable).weightx = 1.0;
            this.add((Component)jCheckBox, cloneable);
            ++n2;
        }
    }

    public void changeColumnVisibility() {
        if (this.columnModel == null) {
            return;
        }
        Iterator<ETableColumn> iterator = this.checkBoxes.keySet().iterator();
        while (iterator.hasNext()) {
            ETableColumn eTableColumn;
            JCheckBox jCheckBox = this.checkBoxes.get(eTableColumn = iterator.next());
            this.columnModel.setColumnHidden(eTableColumn, !jCheckBox.isSelected());
        }
    }

    static void showColumnSelectionPopup(Component component, final ETable eTable) {
        ArrayList<JCheckBoxMenuItem> arrayList;
        JCheckBoxMenuItem jCheckBoxMenuItem;
        String string;
        if (!eTable.isColumnHidingAllowed()) {
            return;
        }
        if (!eTable.isPopupUsedFromTheCorner()) {
            ColumnSelectionPanel.showColumnSelectionDialog(eTable);
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        final ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList2 = Collections.list(eTableColumnModel.getColumns());
        arrayList2.addAll(eTableColumnModel.hiddenColumns);
        Collections.sort(arrayList2, ETableColumnComparator.DEFAULT);
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (final ETableColumn object2 : arrayList2) {
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem();
            string = eTable.transformValue(object2).toString();
            jCheckBoxMenuItem2.setText(string);
            JCheckBoxMenuItem jCheckBoxMenuItem3 = (JCheckBoxMenuItem)eTable.transformValue(jCheckBoxMenuItem2);
            jCheckBoxMenuItem3.setSelected(!eTableColumnModel.isColumnHidden(object2));
            jCheckBoxMenuItem3.setEnabled(object2.isHidingAllowed());
            jCheckBoxMenuItem = jCheckBoxMenuItem3;
            jCheckBoxMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    eTableColumnModel.setColumnHidden(object2, !jCheckBoxMenuItem.isSelected());
                    eTable.updateColumnSelectionMouseListener();
                }
            });
            if (!arrayList3.contains(string)) {
                hashMap.put(string, jCheckBoxMenuItem3);
            } else {
                arrayList = null;
                Object v = hashMap.get(string);
                if (v instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem jCheckBoxMenuItem4 = (JCheckBoxMenuItem)v;
                    arrayList = new ArrayList<JCheckBoxMenuItem>();
                    arrayList.add(jCheckBoxMenuItem4);
                } else if (v instanceof ArrayList) {
                    arrayList = (ArrayList)v;
                } else {
                    throw new IllegalStateException("Wrong object theFirstOne is " + v);
                }
                arrayList.add(jCheckBoxMenuItem3);
                hashMap.put(string, arrayList);
            }
            arrayList3.add(string);
        }
        Collections.sort(arrayList3, Collator.getInstance());
        int n = 0;
        for (String string2 : arrayList3) {
            string = hashMap.get(string2);
            jCheckBoxMenuItem = null;
            if (string instanceof JCheckBoxMenuItem) {
                jCheckBoxMenuItem = (JCheckBoxMenuItem)((Object)string);
            } else if (string instanceof ArrayList) {
                arrayList = (ArrayList<JCheckBoxMenuItem>)((Object)string);
                if (n >= arrayList.size()) {
                    n = 0;
                }
                jCheckBoxMenuItem = (JCheckBoxMenuItem)arrayList.get(n++);
            } else {
                throw new IllegalStateException("Wrong object obj is " + string);
            }
            jPopupMenu.add(jCheckBoxMenuItem);
        }
        jPopupMenu.show(component, 8, 8);
    }

    static void showColumnSelectionDialog(ETable eTable) {
        if (!eTable.isColumnHidingAllowed()) {
            return;
        }
        TableColumnSelector tableColumnSelector = eTable.getColumnSelector();
        if (tableColumnSelector != null) {
            ETableColumnModel eTableColumnModel = (ETableColumnModel)eTable.getColumnModel();
            TableColumnSelector.TreeNode treeNode = eTableColumnModel.getColumnHierarchyRoot();
            if (treeNode != null) {
                String[] stringArray = ColumnSelectionPanel.getAvailableColumnNames(eTable, true);
                String[] stringArray2 = tableColumnSelector.selectVisibleColumns(treeNode, stringArray);
                ColumnSelectionPanel.makeVisibleColumns(eTable, stringArray2);
            } else {
                String[] stringArray = ColumnSelectionPanel.getAvailableColumnNames(eTable, false);
                String[] stringArray3 = ColumnSelectionPanel.getAvailableColumnNames(eTable, true);
                String[] stringArray4 = tableColumnSelector.selectVisibleColumns(stringArray, stringArray3);
                ColumnSelectionPanel.makeVisibleColumns(eTable, stringArray4);
            }
            return;
        }
        ColumnSelectionPanel columnSelectionPanel = new ColumnSelectionPanel(eTable);
        int n = JOptionPane.showConfirmDialog(null, columnSelectionPanel, eTable.selectVisibleColumnsLabel, 2);
        if (n == 0) {
            columnSelectionPanel.changeColumnVisibility();
            eTable.updateColumnSelectionMouseListener();
        }
    }

    private static void makeVisibleColumns(ETable eTable, String[] stringArray) {
        ETableColumn eTableColumn;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return;
        }
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList = Collections.list(eTableColumnModel.getColumns());
        arrayList.addAll(eTableColumnModel.hiddenColumns);
        Collections.sort(arrayList, ETableColumnComparator.DEFAULT);
        HashMap<String, ETableColumn> hashMap = new HashMap<String, ETableColumn>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = eTable.getColumnDisplayName((eTableColumn = (ETableColumn)iterator.next()).getHeaderValue().toString());
            eTableColumnModel.setColumnHidden(eTableColumn, !hashSet.contains(string));
            hashMap.put(string, eTableColumn);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            eTableColumn = (ETableColumn)hashMap.get(stringArray[i]);
            if (eTableColumn == null) {
                throw new IllegalStateException("Cannot find column with name " + stringArray[i]);
            }
            int n = eTableColumnModel.getColumnIndex(eTableColumn.getIdentifier());
            eTableColumnModel.moveColumn(n, i);
        }
    }

    private static String[] getAvailableColumnNames(ETable eTable, boolean bl) {
        TableColumnModel tableColumnModel = eTable.getColumnModel();
        if (!(tableColumnModel instanceof ETableColumnModel)) {
            return new String[0];
        }
        ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
        ArrayList<TableColumn> arrayList = Collections.list(eTableColumnModel.getColumns());
        if (!bl) {
            arrayList.addAll(eTableColumnModel.hiddenColumns);
        }
        Collections.sort(arrayList, ETableColumnComparator.DEFAULT);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ETableColumn eTableColumn : arrayList) {
            String string = eTable.getColumnDisplayName(eTableColumn.getHeaderValue().toString());
            arrayList2.add(string);
        }
        Collections.sort(arrayList2, Collator.getInstance());
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ETableColumnComparator
    implements Comparator<TableColumn> {
        public static final ETableColumnComparator DEFAULT = new ETableColumnComparator();

        private ETableColumnComparator() {
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            if (tableColumn instanceof ETableColumn && tableColumn2 instanceof ETableColumn) {
                ((ETableColumn)tableColumn).compareTo((ETableColumn)tableColumn2);
            }
            return 0;
        }
    }
}

