/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class OutputWindowWriter
extends Writer {
    private final ExecutionEnvironment execEnv;
    private final OutputWriter delegate;
    private final StringBuffer buffer;
    private final boolean parseOutputForErrors;
    private static final String LINE_SEPARATOR_QUOTED = System.getProperty("line.separator");
    private final ErrorParser[] parsers;
    private static final Pattern SS_OF_1 = Pattern.compile("::\\(.*\\)");
    private static final Pattern SS_OF_2 = Pattern.compile(":\\(.*\\).*");
    private static final Pattern SS_OF_3 = Pattern.compile("\\(.*\\).*:");
    private static final Pattern[] SunStudioOutputFilters = new Pattern[]{SS_OF_1, SS_OF_2, SS_OF_3};
    private static final int LENGTH_TRESHOLD = 2048;
    private static final Pattern CW_ERROR_SCANNER = Pattern.compile("([^:\n]*):([0-9]+): .*");
    private static final Pattern MSVC_WARNING_SCANNER = Pattern.compile("([a-zA-Z0-0\\\\._]+)\\(([0-9]+)\\) : warning ([a-zA-Z0-9]+): .*");
    private static final Pattern MSVC_ERROR_SCANNER = Pattern.compile("([a-zA-Z0-0\\\\._]+)\\(([0-9]+)\\) : error ([a-zA-Z0-9]+): .*");
    private static final Pattern GCC_ERROR_SCANNER = Pattern.compile("^([a-zA-Z]:[^:\n]*|[^:\n]*):([0-9]+)[\\.:]([^:\n]*):([^\n]*)");
    private static final Pattern GCC_ERROR_SCANNER_ANOTHER = Pattern.compile("^([^:\n]*):([0-9]+): ([a-zA-Z]*):*.*");
    private static final Pattern GCC_ERROR_SCANNER_INTEL = Pattern.compile("^([^\\(\n]*)\\(([0-9]+)\\): ([^:\n]*): ([^\n]*)");
    private static final Pattern GCC_DIRECTORY_ENTER = Pattern.compile("[gd]?make(?:\\.exe)?(?:\\[([0-9]+)\\])?: Entering[\\w+\\s+]+`([^']*)'");
    private static final Pattern GCC_DIRECTORY_LEAVE = Pattern.compile("[gd]?make(?:\\.exe)?(?:\\[([0-9]+)\\])?: Leaving[\\w+\\s+]+`([^']*)'");
    private static final Pattern GCC_DIRECTORY_CD = Pattern.compile("cd\\s+([\\S]+)[\\s;]");
    private static final Pattern GCC_STACK_HEADER = Pattern.compile("In file included from ([A-Z]:[^:\n]*|[^:\n]*):([^:^,]*)");
    private static final Pattern GCC_STACK_NEXT = Pattern.compile("                 from ([A-Z]:[^:\n]*|[^:\n]*):([^:^,]*)");
    private static final Pattern SUN_ERROR_SCANNER_CPP_ERROR = Pattern.compile("^\"(.*)\", line ([0-9]+): Error:");
    private static final Pattern SUN_ERROR_SCANNER_CPP_WARNING = Pattern.compile("^\"(.*)\", line ([0-9]+): Warning:");
    private static final Pattern SUN_ERROR_SCANNER_C_ERROR = Pattern.compile("^\"(.*)\", line ([0-9]+):");
    private static final Pattern SUN_ERROR_SCANNER_C_WARNING = Pattern.compile("^\"(.*)\", line ([0-9]+): warning:");
    private static final Pattern SUN_ERROR_SCANNER_FORTRAN_ERROR = Pattern.compile("^\"(.*)\", Line = ([0-9]+),");
    private static final Pattern SUN_ERROR_SCANNER_FORTRAN_WARNING = Pattern.compile("^\"(.*)\", Line = ([0-9]+), Column = ([0-9]+): WARNING:");
    private static final Pattern SUN_DIRECTORY_ENTER = Pattern.compile("\\(([^)]*)\\)[^:]*:");

    public OutputWindowWriter(ExecutionEnvironment executionEnvironment, OutputWriter outputWriter, FileObject fileObject, boolean bl) {
        this.execEnv = executionEnvironment;
        this.delegate = outputWriter;
        this.parseOutputForErrors = bl;
        this.buffer = new StringBuffer();
        this.parsers = new ErrorParser[]{new GCCErrorParser(executionEnvironment, fileObject), new SUNErrorParser(executionEnvironment, fileObject), new MSVCErrorParser(executionEnvironment, fileObject), new CWErrorParser(executionEnvironment, fileObject)};
        ErrorAnnotation.getInstance().detach(null);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3;
        this.buffer.append(new String(cArray, n, n2).replaceAll(LINE_SEPARATOR_QUOTED, "\n"));
        while ((n3 = this.buffer.indexOf("\n")) != -1) {
            this.handleLine(this.buffer.substring(0, n3));
            this.buffer.delete(0, n3 + "\n".length() + 1);
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    private void handleLine(String string) throws IOException {
        if (this.parseOutputForErrors && string.length() < 2048) {
            int n;
            Object object;
            int n2;
            for (n2 = 0; n2 < this.parsers.length; ++n2) {
                object = this.parsers[n2].getPattern();
                for (n = 0; n < ((Pattern[])object).length; ++n) {
                    Object object2 = object[n];
                    Matcher matcher = ((Pattern)object2).matcher(string);
                    boolean bl = matcher.find();
                    if (!bl || matcher.start() != 0 || !this.parsers[n2].handleLine(this.delegate, string, matcher)) continue;
                    return;
                }
            }
            for (n2 = 0; n2 < SunStudioOutputFilters.length; ++n2) {
                object = SunStudioOutputFilters[n2].matcher(string);
                n = ((Matcher)object).find() ? 1 : 0;
                if (n == 0 || ((Matcher)object).start() != 0) continue;
                return;
            }
        }
        this.delegate.println(string);
    }

    private static class ErrorAnnotation
    extends Annotation
    implements PropertyChangeListener {
        private static ErrorAnnotation instance;
        private Line currentLine;

        private ErrorAnnotation() {
        }

        public static ErrorAnnotation getInstance() {
            if (instance == null) {
                instance = new ErrorAnnotation();
            }
            return instance;
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-cnd-error";
        }

        public String getShortDescription() {
            return NbBundle.getMessage(OutputWindowWriter.class, (String)"HINT_CompilerError");
        }

        public void attach(Line line) {
            if (this.currentLine != null) {
                this.detach(this.currentLine);
            }
            this.currentLine = line;
            super.attach((Annotatable)line);
            line.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void detach(Line line) {
            if (line == this.currentLine || line == null) {
                this.currentLine = null;
                Annotatable annotatable = this.getAttachedAnnotatable();
                if (annotatable != null) {
                    annotatable.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.detach();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("text".equals(propertyChangeEvent.getPropertyName())) {
                this.detach(null);
            }
        }
    }

    private static final class SUNErrorParser
    extends ErrorParser {
        public SUNErrorParser(ExecutionEnvironment executionEnvironment, FileObject fileObject) {
            super(executionEnvironment, fileObject);
        }

        public boolean handleLine(OutputWriter outputWriter, String string, Matcher matcher) throws IOException {
            if (matcher.pattern() == SUN_DIRECTORY_ENTER) {
                FileObject fileObject = this.resolveFile(matcher.group(1));
                if (fileObject != null) {
                    this.relativeTo = fileObject;
                }
                return false;
            }
            if (matcher.pattern() == SUN_ERROR_SCANNER_CPP_ERROR || matcher.pattern() == SUN_ERROR_SCANNER_CPP_WARNING || matcher.pattern() == SUN_ERROR_SCANNER_C_ERROR || matcher.pattern() == SUN_ERROR_SCANNER_C_WARNING || matcher.pattern() == SUN_ERROR_SCANNER_FORTRAN_ERROR || matcher.pattern() == SUN_ERROR_SCANNER_FORTRAN_WARNING) {
                try {
                    boolean bl;
                    String string2 = matcher.group(1);
                    Integer n = Integer.valueOf(matcher.group(2));
                    FileObject fileObject = this.resolveRelativePath(this.relativeTo, string2);
                    boolean bl2 = bl = matcher.pattern() == SUN_ERROR_SCANNER_CPP_ERROR || matcher.pattern() == SUN_ERROR_SCANNER_C_ERROR || matcher.pattern() == SUN_ERROR_SCANNER_FORTRAN_ERROR;
                    if (fileObject != null) {
                        outputWriter.println(string, (OutputListener)new OutputListenerImpl(fileObject, n - 1), bl);
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return false;
            }
            throw new IllegalArgumentException("Unknown pattern: " + matcher.pattern().pattern());
        }

        public Pattern[] getPattern() {
            return new Pattern[]{SUN_ERROR_SCANNER_CPP_ERROR, SUN_ERROR_SCANNER_CPP_WARNING, SUN_ERROR_SCANNER_FORTRAN_WARNING, SUN_ERROR_SCANNER_FORTRAN_ERROR, SUN_ERROR_SCANNER_C_WARNING, SUN_ERROR_SCANNER_C_ERROR, SUN_DIRECTORY_ENTER};
        }
    }

    private static final class GCCErrorParser
    extends ErrorParser {
        private Stack<FileObject> relativesTo = new Stack();
        private Stack<Integer> relativesLevel = new Stack();
        private ArrayList<StackIncludeItem> errorInludes = new ArrayList();
        private boolean failed;
        private boolean isEntered;

        public GCCErrorParser(ExecutionEnvironment executionEnvironment, FileObject fileObject) {
            super(executionEnvironment, fileObject);
            this.relativesTo.push(fileObject);
            this.relativesLevel.push(0);
            this.isEntered = false;
        }

        private void popPath() {
            if (this.relativesTo.size() > 1) {
                this.relativesTo.pop();
            }
        }

        private void popLevel() {
            if (this.relativesLevel.size() > 1) {
                this.relativesLevel.pop();
            }
        }

        public boolean handleLine(OutputWriter outputWriter, String string, Matcher matcher) throws IOException {
            if (matcher.pattern() == GCC_DIRECTORY_ENTER || matcher.pattern() == GCC_DIRECTORY_LEAVE) {
                String string2 = matcher.group(1);
                int n = string2 == null ? 0 : Integer.valueOf(string2);
                int fileObject = this.relativesLevel.peek();
                String fileObject4 = matcher.group(2);
                if (n > fileObject) {
                    this.isEntered = true;
                    this.relativesLevel.push(n);
                    this.isEntered = true;
                } else if (n == fileObject) {
                    this.isEntered = !this.isEntered;
                } else {
                    this.isEntered = false;
                    this.popLevel();
                }
                if (this.isEntered) {
                    FileObject fileObject2;
                    if (!IpeUtils.isPathAbsolute(fileObject4) && this.relativeTo != null && this.relativeTo.isFolder()) {
                        fileObject4 = this.relativeTo.getURL().getPath() + File.separator + fileObject4;
                    }
                    if ((fileObject2 = this.resolveFile(fileObject4)) != null) {
                        this.relativesTo.push(fileObject2);
                    }
                    return false;
                }
                this.popPath();
                return false;
            }
            if (matcher.pattern() == GCC_DIRECTORY_CD) {
                FileObject fileObject;
                String string4 = matcher.group(1);
                if (!IpeUtils.isPathAbsolute(string4) && this.relativeTo != null && this.relativeTo.isFolder()) {
                    string4 = this.relativeTo.getURL().getPath() + File.separator + string4;
                }
                if ((fileObject = this.resolveFile(string4)) != null) {
                    this.relativesTo.push(fileObject);
                }
                return false;
            }
            if (matcher.pattern() == GCC_STACK_HEADER) {
                for (StackIncludeItem object : this.errorInludes) {
                    outputWriter.println(object.line);
                }
                this.errorInludes.clear();
                try {
                    FileObject fileObject;
                    String string5 = matcher.group(1);
                    Integer n = Integer.valueOf(matcher.group(2));
                    FileObject fileObject3 = this.relativesTo.peek();
                    if (fileObject3 != null && (fileObject = this.resolveRelativePath(fileObject3, string5)) != null) {
                        this.errorInludes.add(new StackIncludeItem(fileObject, string, n - 1));
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.errorInludes.add(new StackIncludeItem(null, string, 0));
                return true;
            }
            if (matcher.pattern() == GCC_STACK_NEXT) {
                try {
                    FileObject fileObject;
                    String string6 = matcher.group(1);
                    Integer object = Integer.valueOf(matcher.group(2));
                    FileObject fileObject4 = this.relativesTo.peek();
                    if (fileObject4 != null && (fileObject = this.resolveRelativePath(fileObject4, string6)) != null) {
                        this.errorInludes.add(new StackIncludeItem(fileObject, string, object - 1));
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.errorInludes.add(new StackIncludeItem(null, string, 0));
                return true;
            }
            if (matcher.pattern() == GCC_ERROR_SCANNER || matcher.pattern() == GCC_ERROR_SCANNER_ANOTHER || matcher.pattern() == GCC_ERROR_SCANNER_INTEL || matcher.pattern() == MSVC_WARNING_SCANNER || matcher.pattern() == MSVC_ERROR_SCANNER) {
                try {
                    String string7 = matcher.group(1);
                    Integer n = Integer.valueOf(matcher.group(2));
                    FileObject fileObject = this.relativesTo.peek();
                    if (fileObject != null) {
                        boolean bl;
                        FileObject fileObject5 = this.resolveRelativePath(fileObject, string7);
                        boolean bl2 = bl = matcher.group(3).indexOf("error") != -1;
                        if (fileObject5 != null) {
                            for (StackIncludeItem stackIncludeItem : this.errorInludes) {
                                if (stackIncludeItem.fo != null) {
                                    outputWriter.println(stackIncludeItem.line, (OutputListener)new OutputListenerImpl(stackIncludeItem.fo, stackIncludeItem.lineNumber), bl);
                                    continue;
                                }
                                outputWriter.println(stackIncludeItem.line);
                            }
                            this.errorInludes.clear();
                            outputWriter.println(string, (OutputListener)new OutputListenerImpl(fileObject5, n - 1), bl);
                            if (!this.failed) {
                                this.failed = true;
                            }
                            return true;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                for (StackIncludeItem stackIncludeItem : this.errorInludes) {
                    outputWriter.println(stackIncludeItem.line);
                }
                this.errorInludes.clear();
                return false;
            }
            throw new IllegalArgumentException("Unknown pattern: " + matcher.pattern().pattern());
        }

        public Pattern[] getPattern() {
            return new Pattern[]{GCC_DIRECTORY_ENTER, GCC_DIRECTORY_LEAVE, GCC_DIRECTORY_CD, GCC_STACK_HEADER, GCC_STACK_NEXT, GCC_ERROR_SCANNER, GCC_ERROR_SCANNER_ANOTHER, GCC_ERROR_SCANNER_INTEL, MSVC_WARNING_SCANNER, MSVC_ERROR_SCANNER};
        }

        private static class StackIncludeItem {
            private FileObject fo;
            private String line;
            private int lineNumber;

            private StackIncludeItem(FileObject fileObject, String string, int n) {
                this.fo = fileObject;
                this.line = string;
                this.lineNumber = n;
            }
        }
    }

    private static final class MSVCErrorParser
    extends ErrorParser {
        private boolean failed;

        public MSVCErrorParser(ExecutionEnvironment executionEnvironment, FileObject fileObject) {
            super(executionEnvironment, fileObject);
        }

        public boolean handleLine(OutputWriter outputWriter, String string, Matcher matcher) throws IOException {
            if (matcher.pattern() == MSVC_ERROR_SCANNER || matcher.pattern() == MSVC_WARNING_SCANNER) {
                try {
                    boolean bl;
                    String string2 = matcher.group(1);
                    Integer n = Integer.valueOf(matcher.group(2));
                    FileObject fileObject = this.relativeTo.getFileSystem().getRoot().getFileObject(string2);
                    if (fileObject == null) {
                        return false;
                    }
                    boolean bl2 = bl = matcher.pattern() == MSVC_ERROR_SCANNER;
                    if (fileObject != null) {
                        outputWriter.println(string, (OutputListener)new OutputListenerImpl(fileObject, n - 1), bl);
                        if (!this.failed) {
                            this.failed = true;
                        }
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return false;
            }
            throw new IllegalArgumentException("Unknown pattern: " + matcher.pattern().pattern());
        }

        public Pattern[] getPattern() {
            return new Pattern[]{MSVC_WARNING_SCANNER, MSVC_ERROR_SCANNER};
        }
    }

    private static final class CWErrorParser
    extends ErrorParser {
        private boolean failed;

        public CWErrorParser(ExecutionEnvironment executionEnvironment, FileObject fileObject) {
            super(executionEnvironment, fileObject);
        }

        public boolean handleLine(OutputWriter outputWriter, String string, Matcher matcher) throws IOException {
            if (matcher.pattern() == CW_ERROR_SCANNER) {
                try {
                    String string2 = matcher.group(1);
                    Integer n = Integer.valueOf(matcher.group(2));
                    FileObject fileObject = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)new File(FileUtil.toFile((FileObject)this.relativeTo), string2)));
                    if (fileObject == null) {
                        return false;
                    }
                    outputWriter.println(string, (OutputListener)new OutputListenerImpl(fileObject, n - 1), true);
                    if (!this.failed) {
                        this.failed = true;
                    }
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }

        public Pattern[] getPattern() {
            return new Pattern[]{CW_ERROR_SCANNER};
        }
    }

    private static abstract class ErrorParser {
        protected FileObject relativeTo;
        protected final ExecutionEnvironment execEnv;

        public ErrorParser(ExecutionEnvironment executionEnvironment, FileObject fileObject) {
            this.relativeTo = fileObject;
            this.execEnv = executionEnvironment;
        }

        public abstract boolean handleLine(OutputWriter var1, String var2, Matcher var3) throws IOException;

        public abstract Pattern[] getPattern();

        protected FileObject resolveFile(String string) {
            if (Utilities.isWindows()) {
                if (string.startsWith("/cygdrive/")) {
                    string = string.substring("/cygdrive/".length());
                    string = "" + string.charAt(0) + ':' + string.substring(1);
                } else if (string.length() > 3 && string.charAt(0) == '/' && string.charAt(2) == '/') {
                    string = "" + string.charAt(1) + ':' + string.substring(2);
                }
                if (string.startsWith("/") || string.startsWith(".")) {
                    return null;
                }
                string = string.replace('/', '\\');
            }
            string = HostInfoProvider.getMapper((ExecutionEnvironment)this.execEnv).getLocalPath(string, true);
            File file = CndFileUtils.normalizeFile((File)new File(string));
            return FileUtil.toFileObject((File)file);
        }

        protected FileObject resolveRelativePath(FileObject object, String string) {
            Object object2;
            Object object3;
            String string2;
            Object object4;
            if (IpeUtils.isPathAbsolute(string)) {
                if (this.execEnv.isRemote() || Utilities.isWindows()) {
                    object4 = string;
                    string2 = null;
                    if (((String)object4).startsWith("/usr/lib")) {
                        string2 = ((String)object4).substring(4);
                    }
                    object3 = CompilerSetManager.getDefault(this.execEnv).getCompilerSets();
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        CompilerSet compilerSet = (CompilerSet)object2.next();
                        Tool tool = compilerSet.getTool(0);
                        if (tool == null) continue;
                        String string3 = tool.getIncludeFilePathPrefix();
                        File file = new File(string3 + (String)object4);
                        if (!CndFileUtils.exists((File)file) && string2 != null) {
                            file = new File(string3 + string2);
                        }
                        if (!CndFileUtils.exists((File)file)) continue;
                        FileObject fileObject = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)file));
                        return fileObject;
                    }
                }
                if ((object4 = this.resolveFile(string)) != null) {
                    return object4;
                }
                if (string.startsWith(File.separator)) {
                    string = string.substring(1);
                }
                try {
                    string2 = object.getFileSystem();
                    object4 = string2.findResource(string);
                    if (object4 != null) {
                        return object4;
                    }
                    object4 = string2.getRoot();
                    if (object4 != null) {
                        object = object4;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            object4 = object;
            string2 = Utilities.isWindows() ? File.separator + '/' : File.separator;
            object3 = new StringTokenizer(string, string2);
            while (object4 != null && ((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken();
                if ("..".equals(object2)) {
                    object4 = object4.getParent();
                    continue;
                }
                if (".".equals(object2)) continue;
                object4 = object4.getFileObject((String)object2, null);
            }
            return object4;
        }
    }

    private static final class OutputListenerImpl
    implements OutputListener {
        private FileObject file;
        private int line;

        public OutputListenerImpl(FileObject fileObject, int n) {
            this.file = fileObject;
            this.line = n;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            this.showLine(false);
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.showLine(true);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            ErrorAnnotation.getInstance().detach(null);
        }

        private void showLine(boolean bl) {
            block7: {
                try {
                    DataObject dataObject = DataObject.find((FileObject)this.file);
                    LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
                    if (lineCookie == null) break block7;
                    try {
                        Line line = lineCookie.getLineSet().getOriginal(this.line);
                        if (!line.isDeleted()) {
                            if (bl) {
                                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                            } else {
                                line.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE);
                            }
                            ErrorAnnotation.getInstance().attach(line);
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
        }
    }
}

