/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.editor.parser.CppFile;
import org.netbeans.modules.cnd.editor.parser.ParsingEvent;
import org.netbeans.modules.cnd.editor.parser.ParsingListener;
import org.netbeans.modules.cnd.loaders.CppEditorSupport;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppMetaModel
implements PropertyChangeListener {
    private int reparseDelay = 1000;
    private Map<String, CppFile> map = new ConcurrentHashMap<String, CppFile>();
    private Collection<ParsingListener> listeners = new ConcurrentLinkedQueue<ParsingListener>();
    private static CppMetaModel instance = new CppMetaModel();
    private static RequestProcessor cppParserRP;
    private static final Logger log;
    private RequestProcessor.Task task = null;

    private CppMetaModel() {
    }

    public static CppMetaModel getDefault() {
        return instance;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("opened".equals(propertyChangeEvent.getPropertyName())) {
            this.checkClosed(propertyChangeEvent.getNewValue());
        }
    }

    private void checkClosed(Object object) {
        if (object instanceof Set) {
            HashSet<CppEditorSupport.CppEditorComponent> hashSet = new HashSet<CppEditorSupport.CppEditorComponent>();
            for (Object e : (Set)object) {
                if (!(e instanceof CppEditorSupport.CppEditorComponent)) continue;
                hashSet.add((CppEditorSupport.CppEditorComponent)((Object)e));
            }
            this.checkClosed(hashSet);
        }
    }

    private void checkClosed(Set<CppEditorSupport.CppEditorComponent> set) {
        Object object222;
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object222 : set) {
            StyledDocument styledDocument;
            CppEditorSupport object3 = object222.getSupport();
            if (object3 == null || (styledDocument = object3.getDocument()) == null) continue;
            String string = (String)styledDocument.getProperty("title");
            hashSet.add(string);
        }
        ArrayList arrayList = new ArrayList();
        for (String string : this.map.keySet()) {
            if (hashSet.contains(string)) continue;
            arrayList.add(string);
        }
        object222 = arrayList.iterator();
        while (object222.hasNext()) {
            String string = (String)object222.next();
            this.map.remove(string);
        }
        if (this.map.size() == 0 && this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    private static synchronized RequestProcessor getCppParserRP() {
        if (cppParserRP == null) {
            cppParserRP = new RequestProcessor("CPP Parser", 1);
        }
        return cppParserRP;
    }

    public void scheduleParsing(final Document document) {
        final String string = (String)document.getProperty("title");
        log.log(Level.FINE, "CppMetaModel.scheduleParsing: Checking " + this.getShortName(document) + " [" + Thread.currentThread().getName() + "]");
        final CppFile cppFile = this.map.get(string);
        if (this.task != null) {
            this.task.cancel();
        }
        if (cppFile == null) {
            log.log(Level.FINE, "CppMetaModel.scheduleParsing: Starting initial parse for " + this.getShortName(document));
            this.task = CppMetaModel.getCppParserRP().post(new Runnable(){

                public void run() {
                    CppFile cppFile = new CppFile(string);
                    CppMetaModel.this.map.put(string, cppFile);
                    cppFile.startParsing(document);
                    CppMetaModel.this.fireObjectParsed(document);
                }
            }, this.reparseDelay);
        } else if (cppFile.needsUpdate()) {
            log.log(Level.FINE, "CppMetaModel.scheduleParsing: Starting update parse for " + this.getShortName(document));
            this.task = CppMetaModel.getCppParserRP().post(new Runnable(){

                public void run() {
                    cppFile.startParsing(document);
                    CppMetaModel.this.fireObjectParsed(document);
                }
            }, this.reparseDelay);
        }
    }

    private void fireObjectParsed(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof DataObject) {
            DataObject dataObject = (DataObject)object;
            for (ParsingListener parsingListener : this.listeners) {
                parsingListener.objectParsed(new ParsingEvent(dataObject));
            }
        }
    }

    private String getShortName(Document document) {
        String string = (String)document.getProperty("title");
        int n = string.lastIndexOf(File.separatorChar);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public CppFile get(String string) {
        return this.map.get(string);
    }

    public void addParsingListener(ParsingListener parsingListener) {
        this.listeners.add(parsingListener);
    }

    public void removeParsingListener(ParsingListener parsingListener) {
        this.listeners.remove(parsingListener);
    }

    private void fireParsingEvent(ParsingEvent parsingEvent) {
        ArrayList<ParsingListener> arrayList = new ArrayList<ParsingListener>(this.listeners);
        for (ParsingListener parsingListener : arrayList) {
            parsingListener.objectParsed(parsingEvent);
        }
    }

    static {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)instance);
        log = Logger.getLogger(CppMetaModel.class.getName());
    }
}

