/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.editor.filecreation.BrowseFolders;
import org.netbeans.modules.cnd.editor.filecreation.CndPanelGUI;
import org.netbeans.modules.cnd.editor.filecreation.NewQtFormPanel;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

class NewQtFormPanelGUI
extends CndPanelGUI
implements ActionListener {
    private static final String FORM_EXT = "ui";
    private String sourceExt;
    private String headerExt;
    private final NewQtFormPanel.FormType[] formTypes;
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JCheckBox cbCreateClass;
    private JComboBox cbFormType;
    private JComboBox cbLocation;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel lbClassFile;
    private JLabel lbFolder;
    private JLabel lbFormFile;
    private JLabel lbFormName;
    private JLabel lbHeaderFile;
    private JLabel lbLocation;
    private JLabel lbProject;
    private JSeparator targetSeparator;
    private JTextField tfClassFile;
    private JTextField tfFolder;
    private JTextField tfFormFile;
    private JTextField tfFormName;
    private JTextField tfHeaderFile;
    private JTextField tfProject;

    NewQtFormPanelGUI(Project project, SourceGroup[] sourceGroupArray, Component component, NewQtFormPanel.FormType[] formTypeArray) {
        super(project, sourceGroupArray);
        this.formTypes = formTypeArray;
        this.initComponents();
        this.initMnemonics();
        if (component != null) {
            this.bottomPanelContainer.add(component, "Center");
        }
        this.initValues(null, null, null);
        this.tfFormName.getDocument().addDocumentListener(this);
        this.tfFolder.getDocument().addDocumentListener(this);
        this.cbCreateClass.addActionListener(this);
        this.cbLocation.addActionListener(this);
        this.browseButton.addActionListener(this);
    }

    public void initValues(FileObject fileObject, FileObject fileObject2, String string) {
        DataObject dataObject;
        this.tfProject.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.folders = sources.getSourceGroups("generic");
        if (this.folders.length < 2) {
            this.lbLocation.setVisible(false);
            this.cbLocation.setVisible(false);
        } else {
            this.lbLocation.setVisible(true);
            this.cbLocation.setVisible(true);
        }
        this.cbLocation.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup sourceGroup = NewQtFormPanelGUI.getPreselectedGroup(this.folders, fileObject2);
        this.cbLocation.setSelectedItem(sourceGroup);
        this.tfFolder.setText(NewQtFormPanelGUI.getRelativeNativeName(sourceGroup.getRootFolder(), fileObject2));
        String string2 = null;
        try {
            if (fileObject != null) {
                dataObject = DataObject.find((FileObject)fileObject);
                string2 = dataObject.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string2 = fileObject.getName();
        }
        this.putClientProperty("NewFileWizard_Title", string2);
        this.sourceExt = MIMEExtensions.get((String)"text/x-c++").getDefaultExtension();
        this.headerExt = MIMEExtensions.get((String)"text/x-h").getDefaultExtension();
        if (fileObject != null) {
            if (string == null) {
                string = NewQtFormPanelGUI.getMessage("NewFormSuggestedName");
                FileObject fileObject3 = dataObject = fileObject2 != null ? fileObject2 : ((SourceGroup)this.cbLocation.getSelectedItem()).getRootFolder();
                if (dataObject != null) {
                    string = string + NewQtFormPanelGUI.generateUniqueSuffix((FileObject)dataObject, NewQtFormPanelGUI.getFileName(string), FORM_EXT, this.sourceExt, this.headerExt);
                }
            }
            this.tfFormName.setText(string);
            this.tfFormName.selectAll();
        }
    }

    public SourceGroup getTargetGroup() {
        return (SourceGroup)this.cbLocation.getSelectedItem();
    }

    public String getTargetFolder() {
        String string = this.tfFolder.getText().trim();
        return string.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String string = NewQtFormPanelGUI.getFileName(this.getFormName());
        if (string.length() == 0 || string.charAt(string.length() - 1) == '.') {
            return null;
        }
        return string;
    }

    protected void updateCreatedFile() {
        FileObject fileObject = ((SourceGroup)this.cbLocation.getSelectedItem()).getRootFolder();
        String string = this.tfFolder.getText().trim();
        String string2 = FileUtil.getFileDisplayName((FileObject)fileObject) + (string.startsWith("/") || string.startsWith(File.separator) ? "" : "/") + string + (string.endsWith("/") || string.endsWith(File.separator) || string.length() == 0 ? "" : "/");
        string2 = string2.replace('/', File.separatorChar);
        String string3 = string2 + this.getFormFileName();
        this.tfFormFile.setText(string3);
        if (this.cbCreateClass.isSelected()) {
            String string4 = string2 + this.getSourceFileName();
            this.tfClassFile.setText(string4);
            String string5 = string2 + this.getHeaderFileName();
            this.tfHeaderFile.setText(string5);
        } else {
            this.tfClassFile.setText("");
            this.tfHeaderFile.setText("");
        }
        this.tfClassFile.setEnabled(this.cbCreateClass.isSelected());
        this.tfHeaderFile.setEnabled(this.cbCreateClass.isSelected());
        this.changeSupport.fireChange();
    }

    public String getFormFileName() {
        return NewQtFormPanelGUI.getFileName(this.getFormName()) + "." + FORM_EXT;
    }

    public String getSourceFileName() {
        return this.cbCreateClass.isSelected() ? NewQtFormPanelGUI.getFileName(this.getFormName()) + "." + this.sourceExt : null;
    }

    public String getHeaderFileName() {
        return this.cbCreateClass.isSelected() ? NewQtFormPanelGUI.getFileName(this.getFormName()) + "." + this.headerExt : null;
    }

    public NewQtFormPanel.FormType getFormType() {
        return (NewQtFormPanel.FormType)this.cbFormType.getSelectedItem();
    }

    private static String getFileName(String string) {
        return string;
    }

    public String getFormName() {
        return this.tfFormName.getText().trim();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lbFormName = new JLabel();
        this.tfFormName = new JTextField();
        this.jLabel1 = new JLabel();
        this.cbFormType = new JComboBox();
        this.cbCreateClass = new JCheckBox();
        this.lbProject = new JLabel();
        this.tfProject = new JTextField();
        this.lbLocation = new JLabel();
        this.cbLocation = new JComboBox();
        this.lbFolder = new JLabel();
        this.tfFolder = new JTextField();
        this.browseButton = new JButton();
        this.lbFormFile = new JLabel();
        this.tfFormFile = new JTextField();
        this.lbClassFile = new JLabel();
        this.tfClassFile = new JTextField();
        this.lbHeaderFile = new JLabel();
        this.tfHeaderFile = new JTextField();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.setName(NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_SimpleTargetChooserPanel_Name"));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.lbFormName.setLabelFor(this.tfFormName);
        Mnemonics.setLocalizedText((JLabel)this.lbFormName, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_FormName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.lbFormName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.tfFormName, gridBagConstraints);
        this.tfFormName.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_documentNameTextField"));
        this.jLabel1.setLabelFor(this.cbFormType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_FormType_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.cbFormType.setModel(new DefaultComboBoxModel<NewQtFormPanel.FormType>(this.formTypes));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.cbFormType, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbCreateClass, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_CreateWrapperClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.cbCreateClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.lbProject.setLabelFor(this.tfProject);
        Mnemonics.setLocalizedText((JLabel)this.lbProject, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_Project_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.lbProject, gridBagConstraints);
        this.tfProject.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.tfProject, gridBagConstraints);
        this.tfProject.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_projectTextField"));
        this.lbLocation.setLabelFor(this.cbLocation);
        Mnemonics.setLocalizedText((JLabel)this.lbLocation, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_Location_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.lbLocation, gridBagConstraints);
        this.cbLocation.setRenderer(this.CELL_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 4, 0);
        this.add((Component)this.cbLocation, gridBagConstraints);
        this.cbLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_locationComboBox"));
        this.lbFolder.setLabelFor(this.tfFolder);
        Mnemonics.setLocalizedText((JLabel)this.lbFolder, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lbFolder, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tfFolder, gridBagConstraints);
        this.tfFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_folderTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_Browse_Button"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName("");
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_browseButton"));
        this.lbFormFile.setLabelFor(this.tfFormFile);
        Mnemonics.setLocalizedText((JLabel)this.lbFormFile, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_FormFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lbFormFile, gridBagConstraints);
        this.tfFormFile.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tfFormFile, gridBagConstraints);
        this.lbClassFile.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_CreatedFile_Label_Mnemonic").charAt(0));
        this.lbClassFile.setLabelFor(this.tfClassFile);
        Mnemonics.setLocalizedText((JLabel)this.lbClassFile, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_ClassFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lbClassFile, gridBagConstraints);
        this.tfClassFile.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tfClassFile, gridBagConstraints);
        this.tfClassFile.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_fileTextField"));
        this.lbHeaderFile.setLabelFor(this.tfHeaderFile);
        Mnemonics.setLocalizedText((JLabel)this.lbHeaderFile, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_HeaderFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lbHeaderFile, gridBagConstraints);
        this.tfHeaderFile.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tfHeaderFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI_1"));
    }

    private void initMnemonics() {
        this.lbFormName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_FileName_Label_Mnemonic").charAt(0));
        this.lbProject.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Project_Label_Mnemonic").charAt(0));
        this.lbLocation.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Location_Label_Mnemonic").charAt(0));
        this.lbFolder.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Folder_Label_Mnemonic").charAt(0));
        this.browseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Browse_Button_Mnemonic").charAt(0));
        this.lbClassFile.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_CreatedFile_Label_Mnemonic").charAt(0));
        this.lbHeaderFile.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_CreatedHeader_Label_Mnemonic").charAt(0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.browseButton == actionEvent.getSource()) {
            FileObject fileObject = null;
            SourceGroup sourceGroup = (SourceGroup)this.cbLocation.getSelectedItem();
            fileObject = BrowseFolders.showDialog(new SourceGroup[]{sourceGroup}, this.project, this.tfFolder.getText().replace(File.separatorChar, '/'));
            if (fileObject != null && fileObject.isFolder()) {
                String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
                this.tfFolder.setText(string.replace('/', File.separatorChar));
            }
        } else if (this.cbLocation == actionEvent.getSource()) {
            this.updateCreatedFile();
        } else if (this.cbCreateClass == actionEvent.getSource()) {
            this.updateCreatedFile();
        }
    }
}

