/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.remote.CommandProvider;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformInfo {
    private ArrayList<String> list = new ArrayList();
    private String pathName = null;
    private final ExecutionEnvironment executionEnvironment;
    private final int platform;
    private static Map<ExecutionEnvironment, PlatformInfo> map = new HashMap<ExecutionEnvironment, PlatformInfo>();

    private PlatformInfo(ExecutionEnvironment executionEnvironment, int n) {
        this.executionEnvironment = executionEnvironment;
        this.platform = n;
        String string = this.getEnv().get(this.getPathName());
        if (Boolean.getBoolean("cnd.debug.use_altpath")) {
            string = System.getProperty("cnd.debug.altpath", string);
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.list.add(string2);
            }
        } else if (this.isUnix()) {
            this.list.add("/bin");
            this.list.add("/usr/bin");
            this.list.add("/sbin");
            this.list.add("/usr/sbin");
        } else if (this.isWindows()) {
            this.list.add("C:/WINDOWS/System32");
            this.list.add("C:/WINDOWS");
            this.list.add("C:/WINDOWS/System32/WBem");
        } else {
            System.err.println("PlatformInfo: Path is empty for host " + this.executionEnvironment);
        }
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setPath(ArrayList<String> arrayList) {
        this.list = arrayList;
    }

    public ArrayList<String> getPath() {
        return this.list;
    }

    public String getPathAsString() {
        if (this.list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.list) {
            stringBuilder.append(string);
            stringBuilder.append(this.pathSeparator());
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public String getPathAsStringWith(String string) {
        return this.getPathName() + '=' + this.getPathAsString() + this.pathSeparator() + string;
    }

    public void add(int n, String string) throws IndexOutOfBoundsException {
        this.list.add(n, string);
    }

    public void remove(int n) throws IndexOutOfBoundsException {
        this.list.remove(n);
    }

    public String getPathName() {
        if (this.pathName == null) {
            if (this.isWindows()) {
                for (String string : this.getEnv().keySet()) {
                    if (!string.toLowerCase().equals("path")) continue;
                    this.pathName = string.substring(0, 4);
                    return this.pathName;
                }
            }
            this.pathName = "PATH";
        }
        return this.pathName;
    }

    public String findCommand(String string) {
        if (string != null && string.length() > 0) {
            int n = string.replace('\\', '/').lastIndexOf(47);
            if (n >= 0) {
                return null;
            }
            String string2 = null;
            ArrayList<String> arrayList = this.getPath();
            if (this.isWindows() && !string.endsWith(".exe")) {
                string2 = string + ".exe";
            }
            for (String string3 : arrayList) {
                String string4;
                String string5 = string3 + this.separator() + string;
                if (this.fileExists(string5)) {
                    return string5;
                }
                if (this.isWindows() && string.endsWith(".exe") && this.fileExists(string4 = string3 + this.separator() + string + ".lnk")) {
                    return string5;
                }
                if (string2 == null) continue;
                string5 = string3 + this.separator() + string2;
                if (this.fileExists(string5)) {
                    return string5;
                }
                string4 = string3 + this.separator() + string + ".lnk";
                if (!this.fileExists(string4)) continue;
                return string5;
            }
        }
        return null;
    }

    public String separator() {
        return this.isWindows() ? "\\" : "/";
    }

    public String pathSeparator() {
        return this.isWindows() ? ";" : ":";
    }

    public int getPlatform() {
        return this.platform;
    }

    public boolean isWindows() {
        return this.platform == 3;
    }

    public boolean isUnix() {
        return this.platform == 1 || this.platform == 0 || this.platform == 2 || this.platform == 4;
    }

    public boolean isLinux() {
        return this.platform == 2;
    }

    public boolean isMac() {
        return this.platform == 4;
    }

    public boolean isSolaris() {
        return this.platform == 1 || this.platform == 0;
    }

    public boolean isLocalhost() {
        return this.executionEnvironment.isLocal();
    }

    public Map<String, String> getEnv() {
        return HostInfoProvider.getEnv((ExecutionEnvironment)this.executionEnvironment);
    }

    public boolean fileExists(String string) {
        return HostInfoProvider.fileExists((ExecutionEnvironment)this.executionEnvironment, (String)string);
    }

    public File[] listFiles(File file) {
        String string;
        if (this.executionEnvironment.isLocal()) {
            return file.listFiles();
        }
        CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        if (commandProvider.run(this.executionEnvironment, "ls -A1", null) == 0 && (string = commandProvider.getOutput()) != null) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            ArrayList<File> arrayList = new ArrayList<File>();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    arrayList.add(new File(string2));
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        return null;
    }

    public boolean fileIsDirectory(File file) {
        if (this.executionEnvironment.isLocal()) {
            return file.isDirectory();
        }
        CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        return commandProvider.run(this.executionEnvironment, "test -d \"" + file.getPath() + "\"", null) == 0;
    }

    public boolean fileIsFile(File file) {
        if (this.executionEnvironment.isLocal()) {
            return file.isFile();
        }
        CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        return commandProvider.run(this.executionEnvironment, "test -f \"" + file.getPath() + "\"", null) == 0;
    }

    public boolean fileCanRead(File file) {
        if (this.executionEnvironment.isLocal()) {
            return file.canRead();
        }
        CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        return commandProvider.run(this.executionEnvironment, "test -r \"" + file.getPath() + "\"", null) == 0;
    }

    public static synchronized PlatformInfo getDefault(ExecutionEnvironment executionEnvironment) {
        PlatformInfo platformInfo = map.get(executionEnvironment);
        if (platformInfo == null) {
            int n = HostInfoProvider.getPlatform((ExecutionEnvironment)executionEnvironment);
            platformInfo = new PlatformInfo(executionEnvironment, n);
            map.put(executionEnvironment, platformInfo);
        }
        return platformInfo;
    }

    public static PlatformInfo localhost() {
        return PlatformInfo.getDefault(ExecutionEnvironmentFactory.getLocal());
    }
}

