/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.utils.UnexpectedEOFException;

public class FortranReader {
    private PushbackInputStream in;
    private StringBuffer statement = new StringBuffer(256);
    private boolean freeFormat;
    private boolean preprocess;
    private boolean longLines;
    private StringBuffer sbuf = new StringBuffer();
    private byte curc = 0;
    private byte lastc;
    private byte qchar;
    private byte prevlastc;
    private int col;
    int lastcol = 0;
    private static final byte EOF = -1;
    private int lineno;
    private int lnum;
    private State state;
    private final State StartOfLine = new State("StartOfLine");
    private final State EndOfLine = new State("EndOfLine");
    private final State StartOfStatement = new State("StartOfStatement");
    private final State EndOfStatement = new State("EndOfStatement");
    private final State InStatement = new State("InStatement");
    private final State InComment = new State("InComment");
    private final State InQuote = new State("InQuote");
    private final State GotEOF = new State("GotEOF");
    private boolean verbose = false;

    public FortranReader(String string, String string2, boolean bl) throws FileNotFoundException {
        this.verbose = bl;
        try {
            this.in = new PushbackInputStream(new FileInputStream(string), 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.lineno = 1;
        this.col = 0;
        this.state = this.StartOfLine;
        this.setModes(string, string2);
    }

    public FortranReader(String string, String string2) throws FileNotFoundException {
        this(string, string2, false);
    }

    public String getStatement() throws UnexpectedEOFException {
        String string;
        block10: {
            this.statement.delete(0, this.statement.length());
            while (true) {
                byte by;
                string = null;
                if (this.state == this.StartOfLine) {
                    this.state = this.readStartOfLine();
                    this.lnum = this.lineno;
                    if (this.state != this.StartOfStatement || this.statement.length() <= 0 || (string = this.statement.toString().trim()).length() <= 0) continue;
                    break block10;
                }
                if (this.state == this.EndOfLine) {
                    by = this.getc();
                    if (by != 10) continue;
                    this.state = this.StartOfLine;
                    continue;
                }
                if (this.state == this.StartOfStatement || this.state == this.InStatement) {
                    this.state = this.readStatement();
                    continue;
                }
                if (this.state == this.EndOfStatement) {
                    by = this.getc();
                    if (by != 59) continue;
                    this.state = this.StartOfStatement;
                    string = this.statement.toString().trim();
                    continue;
                }
                if (this.state == this.InComment) {
                    this.state = this.readUntilEOL();
                    continue;
                }
                if (this.state == this.InQuote) {
                    this.state = this.continueQuote();
                    continue;
                }
                if (this.state == this.GotEOF) break;
            }
            if (this.curc == -1 && this.lastc == 10) {
                string = this.statement.toString().trim();
                if (string.length() <= 0) {
                    return null;
                }
            } else {
                throw new UnexpectedEOFException();
            }
        }
        return string;
    }

    private State readStartOfLine() {
        byte by = this.getc();
        if (by == 33 || !this.freeFormat && this.isComment((char)by)) {
            String string = this.getbytes(4);
            if (string.equalsIgnoreCase("dir$")) {
                this.trimInput();
                string = this.getbytes(5);
                if (string.equalsIgnoreCase("fixed")) {
                    this.freeFormat = false;
                } else if (string.length() >= 4 && string.substring(0, 4).equalsIgnoreCase("free")) {
                    this.freeFormat = true;
                }
            }
            return this.InComment;
        }
        if (by == 10) {
            return this.state;
        }
        if (this.freeFormat) {
            this.ungetc(by);
            return this.nextState();
        }
        String string = this.getbytes(5);
        if (string.length() == 5 && this.isContinuation(string.charAt(4))) {
            return this.InStatement;
        }
        return this.nextState();
    }

    private State nextState() {
        if (this.state == this.StartOfLine) {
            byte by;
            while ((by = this.getc()) != -1) {
                if (this.col > 132 || !this.freeFormat && !this.longLines && this.col > 72) {
                    return this.readUntilEOL();
                }
                if (this.isSpace((char)by)) continue;
                if (by == 33) {
                    return this.readUntilEOL();
                }
                if (by == 59) {
                    this.ungetc(by);
                    return this.EndOfStatement;
                }
                if (by == 10) {
                    this.ungetc(by);
                    return this.EndOfLine;
                }
                if (by == 39 || by == 34) {
                    return this.readQuote(by, true);
                }
                this.ungetc(by);
                return this.StartOfStatement;
            }
            return this.GotEOF;
        }
        return this.state;
    }

    private State readStatement() {
        byte by;
        while ((by = this.getc()) != -1) {
            if (this.freeFormat && this.col > 132 || !this.freeFormat && (this.col > 72 || this.longLines && this.col > 132)) {
                return this.readUntilEOL();
            }
            if (by == 10) {
                this.ungetc(by);
                return this.EndOfLine;
            }
            if (by == 39 || by == 34) {
                return this.readQuote(by, true);
            }
            if (this.freeFormat && by == 38) {
                this.ungetc(by);
                return this.EndOfLine;
            }
            if (by == 59) {
                this.ungetc(by);
                return this.EndOfStatement;
            }
            if (by == 32) continue;
            this.statement.append((char)by);
        }
        return this.GotEOF;
    }

    private State readQuote(byte by, boolean bl) {
        byte by2;
        this.qchar = by;
        if (bl) {
            this.statement.append((char)by);
        }
        while ((by2 = this.getc()) != -1) {
            if (by2 == by && this.peekc() != by && this.lastc != by) {
                this.statement.append((char)by2);
                return this.InStatement;
            }
            if (this.freeFormat && by2 == 38 && this.peekc() == 10) {
                return this.InQuote;
            }
            if (by2 == 10) {
                this.ungetc(by2);
                return this.InQuote;
            }
            this.statement.append((char)by2);
        }
        return this.GotEOF;
    }

    private State continueQuote() {
        byte by;
        if (this.freeFormat) {
            if (this.curc == 38 && this.peekc() == 10) {
                byte by2;
                this.getc();
                this.sbuf.delete(0, this.sbuf.length());
                while ((by2 = this.getc()) != -1) {
                    if (by2 == 32 || by2 == 9) {
                        this.sbuf.append(by2);
                        continue;
                    }
                    if (by2 == 38) {
                        return this.readQuote(this.qchar, false);
                    }
                    if (by2 == 33) {
                        this.readUntilEOL();
                        continue;
                    }
                    if (by2 == 10) {
                        this.statement.append(this.sbuf);
                        this.sbuf.delete(0, this.sbuf.length());
                        continue;
                    }
                    this.statement.append(this.sbuf);
                    this.ungetc(by2);
                    return this.readQuote(this.qchar, false);
                }
                return this.GotEOF;
            }
            if (this.curc == 10) {
                return this.readQuote(this.qchar, false);
            }
            this.readUntilEOL();
            return this.EndOfLine;
        }
        this.getc();
        while (true) {
            this.sbuf.delete(0, this.sbuf.length());
            while ((by = this.getc()) == 32 || by == 9) {
                this.sbuf.append(by);
            }
            if (this.col == 1 && (by == 67 || by == 42) || this.col < 6 && by == 33) {
                this.readUntilEOL();
                continue;
            }
            if (by == -1) {
                return this.GotEOF;
            }
            if (by == 10) continue;
            if (this.col == 6 && this.isContinuation((char)by)) {
                return this.readQuote(this.qchar, false);
            }
            if (this.col > 6) break;
        }
        this.statement.append(this.sbuf);
        this.statement.append((char)by);
        return this.readQuote(this.qchar, false);
    }

    private State readUntilEOL() {
        byte by;
        while ((by = this.getc()) != -1) {
            if (by != 10) continue;
            this.ungetc(by);
            return this.EndOfLine;
        }
        return this.GotEOF;
    }

    private void trimInput() {
        byte by;
        while ((by = this.getc()) == 32 || by == 9) {
        }
        this.ungetc(by);
    }

    private boolean isComment(char c) {
        return "cC!dD*".indexOf(c) != -1;
    }

    private boolean isSpace(char c) {
        return " \t".indexOf(c) != -1;
    }

    private boolean isContinuation(char c) {
        return "0 ".indexOf(c) == -1;
    }

    private String getbytes(int n) {
        if (n < 0) {
            return null;
        }
        this.sbuf.delete(0, this.sbuf.length());
        for (int i = 0; i < n; ++i) {
            byte by = this.getc();
            if (by == 10) {
                this.ungetc(by);
                break;
            }
            this.sbuf.append((char)by);
        }
        return this.sbuf.toString();
    }

    private byte getc() {
        if (this.curc == -1) {
            return -1;
        }
        try {
            this.prevlastc = this.lastc;
            this.lastc = this.curc;
            this.curc = (byte)(this.in.read() & 0xFF);
            if (this.curc == 10) {
                this.lastcol = this.col;
                ++this.lineno;
                this.col = 0;
            } else {
                if (this.curc == -1) {
                    return -1;
                }
                ++this.col;
            }
            return this.curc;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private byte peekc() {
        byte by = this.getc();
        this.ungetc(by);
        return by;
    }

    private void ungetc(byte by) {
        if (by != -1) {
            if (by == 10) {
                --this.lineno;
                this.col = this.lastcol;
            } else {
                --this.col;
            }
            try {
                this.in.unread(by);
                this.curc = this.lastc;
                this.lastc = this.prevlastc;
                this.prevlastc = 0;
            }
            catch (IOException iOException) {
                this.println("*** Unread too many bytes ***");
            }
        }
    }

    private void setModes(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            String string3 = string.substring(n + 1);
            if (string3.equals("f90") || string3.equals("f95")) {
                this.freeFormat = true;
            } else if (string3.equals("F90") || string3.equals("F95")) {
                this.freeFormat = true;
                this.preprocess = true;
            } else if (string3.equals(".f") || string3.equals("for")) {
                this.freeFormat = false;
            } else if (string3.equals("F")) {
                this.freeFormat = false;
                this.preprocess = true;
            }
        }
        if (string2 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("-free")) {
                    this.freeFormat = true;
                    continue;
                }
                if (string4.equals("-fixed")) {
                    this.freeFormat = false;
                    continue;
                }
                if (string4.equals("-e")) {
                    this.longLines = true;
                    continue;
                }
                if (!string4.equals("-fpp")) continue;
                this.preprocess = true;
            }
        }
    }

    private void println(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        FortranReader fortranReader = null;
        boolean bl = false;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-v")) {
                bl = true;
                continue;
            }
            string = stringArray[i];
        }
        if (string == null) {
            string = "fwutil.f";
        }
        try {
            String string2;
            fortranReader = new FortranReader(string, null);
            fortranReader.verbose = bl;
            boolean bl2 = false;
            while ((string2 = fortranReader.getStatement()) != null) {
                int n = fortranReader.lnum - 1;
                System.out.println(n + ": " + string2);
            }
        }
        catch (UnexpectedEOFException unexpectedEOFException) {
            System.err.println("Unexpected EOF exception");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found exception");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class State {
        private final String name;

        public State(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

