/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.lib2.EditorApiPackageAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorRegistry {
    private static final Logger LOG;
    public static final String FOCUS_GAINED_PROPERTY = "focusGained";
    public static final String FOCUS_LOST_PROPERTY = "focusLost";
    public static final String FOCUSED_DOCUMENT_PROPERTY = "focusedDocument";
    public static final String LAST_FOCUSED_REMOVED_PROPERTY = "lastFocusedRemoved";
    private static Item items;
    private static final PropertyChangeSupport pcs;
    private static Class ignoredAncestorClass;

    private EditorRegistry() {
    }

    public static synchronized JTextComponent lastFocusedComponent() {
        return EditorRegistry.firstValidComponent();
    }

    public static synchronized JTextComponent focusedComponent() {
        JTextComponent jTextComponent = EditorRegistry.firstValidComponent();
        return jTextComponent != null && jTextComponent.isFocusOwner() ? jTextComponent : null;
    }

    public static synchronized List<? extends JTextComponent> componentList() {
        List list;
        JTextComponent jTextComponent = EditorRegistry.firstValidComponent();
        if (jTextComponent != null) {
            list = new ArrayList();
            list.add(jTextComponent);
            Item item = EditorRegistry.items.next;
            while (item != null) {
                jTextComponent = (JTextComponent)item.get();
                if (jTextComponent != null) {
                    list.add(jTextComponent);
                    item = item.next;
                    continue;
                }
                item = EditorRegistry.removeFromItemList(item);
            }
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(JTextComponent jTextComponent) {
        ArrayList<PropertyChangeEvent> arrayList = new ArrayList<PropertyChangeEvent>();
        Class<EditorRegistry> clazz = EditorRegistry.class;
        synchronized (EditorRegistry.class) {
            assert (jTextComponent != null);
            if (EditorRegistry.item(jTextComponent) == null) {
                Item item = new Item(jTextComponent);
                jTextComponent.putClientProperty(Item.class, item);
                jTextComponent.addFocusListener(FocusL.INSTANCE);
                jTextComponent.addAncestorListener(AncestorL.INSTANCE);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "EditorRegistry.register(): " + EditorRegistry.dumpComponent(jTextComponent) + '\n');
                }
                if (jTextComponent.isFocusOwner()) {
                    EditorRegistry._focusGained(jTextComponent, null, arrayList);
                } else if (jTextComponent.isDisplayable()) {
                    EditorRegistry.itemMadeDisplayable(item);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            EditorRegistry.fireEvents(arrayList);
            return;
        }
    }

    static synchronized void setIgnoredAncestorClass(Class clazz) {
        ignoredAncestorClass = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyClose(JComponent jComponent) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "EditorRegistry.notifyClose(): " + EditorRegistry.dumpComponent(jComponent) + '\n');
        }
        ArrayList<PropertyChangeEvent> arrayList = new ArrayList<PropertyChangeEvent>();
        Class<EditorRegistry> clazz = EditorRegistry.class;
        synchronized (EditorRegistry.class) {
            Item item = items;
            while (item != null) {
                JTextComponent jTextComponent = (JTextComponent)item.get();
                if (jTextComponent == null || item.ignoreAncestorChange && jComponent.isAncestorOf(jTextComponent)) {
                    if (jTextComponent != null) {
                        EditorRegistry._focusLost(jTextComponent, null, arrayList);
                        item = EditorRegistry.removeFromRegistry(item, arrayList);
                        continue;
                    }
                    item = EditorRegistry.removeFromItemList(item);
                    continue;
                }
                item = item.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            EditorRegistry.fireEvents(arrayList);
            return;
        }
    }

    static void focusGained(JTextComponent jTextComponent, Component component) {
        ArrayList<PropertyChangeEvent> arrayList = new ArrayList<PropertyChangeEvent>();
        EditorRegistry._focusGained(jTextComponent, component, arrayList);
        EditorRegistry.fireEvents(arrayList);
    }

    private static synchronized void _focusGained(JTextComponent jTextComponent, Component component, List<PropertyChangeEvent> list) {
        Item item = EditorRegistry.item(jTextComponent);
        assert (item != null) : "Not registered!";
        EditorRegistry.removeFromItemList(item);
        EditorRegistry.addToItemListAsFirst(item);
        item.focused = true;
        jTextComponent.addPropertyChangeListener(PropertyDocL.INSTANCE);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "focusGained: " + EditorRegistry.dumpComponent(jTextComponent) + '\n');
            EditorRegistry.logItemListFinest();
        }
        list.add(new PropertyChangeEvent(EditorRegistry.class, FOCUS_GAINED_PROPERTY, component, jTextComponent));
    }

    static void focusLost(JTextComponent jTextComponent, Component component) {
        ArrayList<PropertyChangeEvent> arrayList = new ArrayList<PropertyChangeEvent>();
        EditorRegistry._focusLost(jTextComponent, component, arrayList);
        EditorRegistry.fireEvents(arrayList);
    }

    private static synchronized void _focusLost(JTextComponent jTextComponent, Component component, List<PropertyChangeEvent> list) {
        Item item = EditorRegistry.item(jTextComponent);
        assert (item != null) : "Not registered!";
        if (item.focused) {
            item.focused = false;
            if (!item.ignoreAncestorChange && EditorRegistry.firstValidComponent() != jTextComponent) {
                throw new IllegalStateException("Invalid ordering of focusLost()");
            }
            jTextComponent.removePropertyChangeListener(PropertyDocL.INSTANCE);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "focusLost: " + EditorRegistry.dumpComponent(jTextComponent) + '\n');
                EditorRegistry.logItemListFinest();
            }
            list.add(new PropertyChangeEvent(EditorRegistry.class, FOCUS_LOST_PROPERTY, jTextComponent, component));
        }
    }

    static void itemMadeDisplayable(Item item) {
        EditorRegistry.addToItemListAsLast(item);
        JTextComponent jTextComponent = (JTextComponent)item.get();
        if (jTextComponent == null) {
            throw new IllegalStateException("Component should be non-null");
        }
        boolean bl = item.ignoreAncestorChange = SwingUtilities.getAncestorOfClass(ignoredAncestorClass, jTextComponent) != null;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.fine("ancestorAdded: " + EditorRegistry.dumpComponent((JComponent)item.get()) + '\n');
            EditorRegistry.logItemListFinest();
        }
    }

    static void focusedDocumentChange(JTextComponent jTextComponent, Document document, Document document2) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "focusedDocument: " + EditorRegistry.dumpComponent(jTextComponent) + "\n    OLDDoc=" + document + "\n    NEWDoc=" + document2 + '\n');
        }
        pcs.firePropertyChange(FOCUSED_DOCUMENT_PROPERTY, document, document2);
    }

    private static JTextComponent firstValidComponent() {
        JTextComponent jTextComponent = null;
        while (items != null && (jTextComponent = (JTextComponent)items.get()) == null) {
            EditorRegistry.removeFromItemList(items);
        }
        return jTextComponent;
    }

    static Item item(JComponent jComponent) {
        return (Item)jComponent.getClientProperty(Item.class);
    }

    private static void addToItemListAsLast(Item item) {
        if (item.linked) {
            return;
        }
        item.linked = true;
        if (items == null) {
            items = item;
        } else {
            Item item2 = items;
            while (item2.next != null) {
                item2 = item2.next;
            }
            item2.next = item;
            item.previous = item2;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            EditorRegistry.checkItemListConsistency();
        }
    }

    private static void addToItemListAsFirst(Item item) {
        if (item.linked) {
            return;
        }
        item.linked = true;
        item.next = items;
        if (items != null) {
            EditorRegistry.items.previous = item;
        }
        items = item;
        if (LOG.isLoggable(Level.FINEST)) {
            EditorRegistry.checkItemListConsistency();
        }
    }

    private static Item removeFromItemList(Item item) {
        if (!item.linked) {
            return null;
        }
        item.linked = false;
        Item item2 = item.next;
        if (item.previous == null) {
            assert (items == item);
            items = item2;
        } else {
            item.previous.next = item2;
        }
        if (item2 != null) {
            item2.previous = item.previous;
        }
        item.previous = null;
        item.next = null;
        if (LOG.isLoggable(Level.FINEST)) {
            EditorRegistry.checkItemListConsistency();
        }
        return item2;
    }

    static Item removeFromRegistry(Item item, List<PropertyChangeEvent> list) {
        boolean bl = items == item;
        JTextComponent jTextComponent = (JTextComponent)item.get();
        item = EditorRegistry.removeFromItemList(item);
        if (jTextComponent != null) {
            jTextComponent.putClientProperty(Item.class, null);
            jTextComponent.removeFocusListener(FocusL.INSTANCE);
            jTextComponent.removeAncestorListener(AncestorL.INSTANCE);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.fine("Component removed: " + EditorRegistry.dumpComponent(jTextComponent) + '\n');
                EditorRegistry.logItemListFinest();
            }
            if (bl) {
                list.add(new PropertyChangeEvent(EditorRegistry.class, LAST_FOCUSED_REMOVED_PROPERTY, jTextComponent, EditorRegistry.lastFocusedComponent()));
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Fired LAST_FOCUSED_REMOVED_PROPERTY for " + EditorRegistry.dumpComponent(jTextComponent) + '\n');
                }
            }
        }
        return item;
    }

    static void checkItemListConsistency() {
        Item item = items;
        Item item2 = null;
        while (item != null) {
            if (!item.linked) {
                throw new IllegalStateException("item=" + item + " is in list but item.linked is false.");
            }
            if (item.previous != item2) {
                throw new IllegalStateException("Invalid previous of item=" + item);
            }
            if (item.ignoreAncestorChange && item.runningTimer != null) {
                throw new IllegalStateException("item=" + item + " has running timer.");
            }
            if (item.focused && item != items) {
                throw new IllegalStateException("Non-first component has focused flag.");
            }
            item2 = item;
            item = item.next;
        }
    }

    static void fireEvents(List<PropertyChangeEvent> list) {
        for (PropertyChangeEvent propertyChangeEvent : list) {
            pcs.firePropertyChange(propertyChangeEvent);
        }
    }

    static void logItemListFinest() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(EditorRegistry.dumpItemList());
        }
    }

    private static String dumpItemList() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("---------- EditorRegistry Dump START ----------\n");
        int n = 0;
        Item item = items;
        while (item != null) {
            ArrayUtilities.appendBracketedIndex((StringBuilder)stringBuilder, (int)n, (int)1);
            stringBuilder.append(' ');
            if (item.focused) {
                stringBuilder.append("Focused, ");
            }
            if (item.ignoreAncestorChange) {
                stringBuilder.append("IgnoreAncestorChange, ");
            }
            stringBuilder.append(EditorRegistry.dumpComponent((JComponent)item.get()));
            stringBuilder.append('\n');
            item = item.next;
            ++n;
        }
        stringBuilder.append("---------- EditorRegistry Dump END ----------\n");
        return stringBuilder.toString();
    }

    static String dumpComponent(JComponent jComponent) {
        Document document;
        Object object = null;
        if (jComponent instanceof JTextComponent && (document = ((JTextComponent)jComponent).getDocument()) != null) {
            object = document.getProperty("stream");
        }
        return "component[IHC=" + System.identityHashCode(jComponent) + "]:" + (object != null ? object : jComponent);
    }

    static {
        EditorApiPackageAccessor.register(new PackageAccessor());
        LOG = Logger.getLogger(EditorRegistry.class.getName());
        pcs = new PropertyChangeSupport(EditorRegistry.class);
    }

    private static final class PackageAccessor
    extends EditorApiPackageAccessor {
        private PackageAccessor() {
        }

        public void register(JTextComponent jTextComponent) {
            EditorRegistry.register(jTextComponent);
        }

        public void setIgnoredAncestorClass(Class clazz) {
            EditorRegistry.setIgnoredAncestorClass(clazz);
        }

        public void notifyClose(JComponent jComponent) {
            EditorRegistry.notifyClose(jComponent);
        }
    }

    private static final class AncestorL
    implements AncestorListener {
        static final AncestorL INSTANCE = new AncestorL();
        private static final int BEFORE_REMOVE_DELAY = 2000;

        private AncestorL() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            Item item = EditorRegistry.item(ancestorEvent.getComponent());
            if (item.runningTimer != null) {
                item.runningTimer.stop();
                item.runningTimer = null;
            }
            EditorRegistry.itemMadeDisplayable(item);
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            final JComponent jComponent = ancestorEvent.getComponent();
            Item item = EditorRegistry.item(jComponent);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.fine("ancestorRemoved for " + EditorRegistry.dumpComponent(jComponent) + "; ignoreAncestorChange=" + item.ignoreAncestorChange + '\n');
            }
            if (!item.ignoreAncestorChange) {
                item.runningTimer = new Timer(2000, new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionPerformed(ActionEvent actionEvent) {
                        ArrayList<PropertyChangeEvent> arrayList = new ArrayList<PropertyChangeEvent>();
                        Class<EditorRegistry> clazz = EditorRegistry.class;
                        synchronized (EditorRegistry.class) {
                            Item item = EditorRegistry.item(jComponent);
                            item.runningTimer.stop();
                            item.runningTimer = null;
                            EditorRegistry.removeFromRegistry(item, arrayList);
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            EditorRegistry.fireEvents(arrayList);
                            return;
                        }
                    }
                });
                item.runningTimer.start();
            }
        }
    }

    private static final class PropertyDocL
    implements PropertyChangeListener {
        static final PropertyDocL INSTANCE = new PropertyDocL();

        private PropertyDocL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("document".equals(propertyChangeEvent.getPropertyName())) {
                EditorRegistry.focusedDocumentChange((JTextComponent)propertyChangeEvent.getSource(), (Document)propertyChangeEvent.getOldValue(), (Document)propertyChangeEvent.getNewValue());
            }
        }
    }

    private static final class FocusL
    implements FocusListener {
        static final FocusL INSTANCE = new FocusL();

        private FocusL() {
        }

        public void focusGained(FocusEvent focusEvent) {
            EditorRegistry.focusGained((JTextComponent)focusEvent.getSource(), focusEvent.getOppositeComponent());
        }

        public void focusLost(FocusEvent focusEvent) {
            EditorRegistry.focusLost((JTextComponent)focusEvent.getSource(), focusEvent.getOppositeComponent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Item
    extends WeakReference<JTextComponent> {
        boolean linked;
        boolean focused;
        Item next;
        Item previous;
        boolean ignoreAncestorChange;
        Timer runningTimer;

        Item(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        public String toString() {
            return "component=" + this.get() + ", linked=" + this.linked + ", hasPrevious=" + (this.previous != null) + ", hasNext=" + (this.next != null) + ", ignoreAncestorChange=" + this.ignoreAncestorChange + ", hasTimer=" + (this.runningTimer != null);
        }
    }
}

