/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.general.Bitmask;
import org.netbeans.modules.vmd.midp.components.items.ItemLayouts;
import org.netbeans.modules.vmd.midp.propertyeditors.Bundle;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorLayout
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private CustomEditorConstraints customEditor;
    private JRadioButton radioButton;
    private TypeID parentTypeID;
    private ItemLayouts layouts;
    private int bitMask;
    private HashMap<Integer, Bitmask.BitmaskItem> bits;

    private PropertyEditorLayout(TypeID typeID) {
        super(NbBundle.getMessage(PropertyEditorLayout.class, (String)"LBL_LAYOUT_STR_UCLABEL"));
        this.parentTypeID = typeID;
        this.initMap();
    }

    public static final PropertyEditorLayout createInstance() {
        return new PropertyEditorLayout(null);
    }

    public static final PropertyEditorLayout createInstance(TypeID typeID) {
        return new PropertyEditorLayout(typeID);
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.parentTypeID = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorLayout.class, (String)"LBL_LAYOUT_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorLayout.class, (String)"ACSN_LAYOUT_STR"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorLayout.class, (String)"ACSD_LAYOUT_STR"));
        this.customEditor = new CustomEditorConstraints();
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    private void combineMaskWithGuiName(Integer n, Bitmask.BitmaskItem bitmaskItem) {
        this.bits.put(n, bitmaskItem);
    }

    void initMap() {
        this.bits = new HashMap();
        this.layouts = new ItemLayouts(0);
        this.combineMaskWithGuiName(0, this.layouts.getBitmaskItem(0));
        this.combineMaskWithGuiName(16384, this.layouts.getBitmaskItem(16384));
        this.combineMaskWithGuiName(1, this.layouts.getBitmaskItem(1));
        this.combineMaskWithGuiName(2, this.layouts.getBitmaskItem(2));
        this.combineMaskWithGuiName(3, this.layouts.getBitmaskItem(3));
        this.combineMaskWithGuiName(16, this.layouts.getBitmaskItem(16));
        this.combineMaskWithGuiName(32, this.layouts.getBitmaskItem(32));
        this.combineMaskWithGuiName(48, this.layouts.getBitmaskItem(48));
        this.combineMaskWithGuiName(256, this.layouts.getBitmaskItem(256));
        this.combineMaskWithGuiName(512, this.layouts.getBitmaskItem(512));
        this.combineMaskWithGuiName(1024, this.layouts.getBitmaskItem(1024));
        this.combineMaskWithGuiName(2048, this.layouts.getBitmaskItem(2048));
        this.combineMaskWithGuiName(4096, this.layouts.getBitmaskItem(4096));
        this.combineMaskWithGuiName(8192, this.layouts.getBitmaskItem(8192));
    }

    public Component getCustomEditor() {
        assert (EventQueue.isDispatchThread());
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return true;
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        this.setConstant(MidpTypes.getInteger((PropertyValue)super.getValue()));
        return this.getBitmaskAsText();
    }

    public void setTextForPropertyValue(String string) {
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue propertyValue) {
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.setValue(0);
        } else {
            this.customEditor.setValue(MidpTypes.getInteger(propertyValue));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue() {
        super.setValue((Object)MidpTypes.createIntegerValue(this.customEditor.getBitMask()));
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue();
        }
    }

    public Boolean canEditAsText() {
        return false;
    }

    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.canWrite();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            final DesignComponent[] designComponentArray = new DesignComponent[1];
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    designComponentArray[0] = designComponent.getParentComponent();
                }
            });
            if (designComponentArray[0] != null && this.parentTypeID.equals((Object)designComponentArray[0].getType())) {
                return false;
            }
        }
        return true;
    }

    private void setConstant(int n) {
        this.layouts.setBitmask(n);
        this.bitMask = n;
    }

    public String getBitmaskAsText() {
        if (this.layouts.getBitmask() == 0) {
            return this.layouts.getBitmaskItem(this.layouts.getBitmask()).getName();
        }
        if (this.layouts.getBitmask() == 16384) {
            return this.layouts.getBitmaskItem(this.layouts.getBitmask()).getName();
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer(" | ");
        for (Integer n3 : this.bits.keySet()) {
            if (this.layouts.isSet(this.bits.get(n3)) && this.bits.get(n3).getAffectedBits() < 16 && n < this.bits.get(n3).getAffectedBits()) {
                n = this.bits.get(n3).getAffectedBits();
                stringBuffer2 = new StringBuffer(this.bits.get(n3).getName());
                stringBuffer2.append(stringBuffer4);
                continue;
            }
            if (this.layouts.isSet(this.bits.get(n3)) && this.bits.get(n3).getAffectedBits() >= 16 && n2 < this.bits.get(n3).getAffectedBits()) {
                n2 = this.bits.get(n3).getAffectedBits();
                stringBuffer3 = new StringBuffer(this.bits.get(n3).getName());
                stringBuffer3.append(stringBuffer4);
                continue;
            }
            if (!this.layouts.isSet(this.bits.get(n3)) || this.bits.get(n3).getAffectedBits() == 0 || this.bits.get(n3).getAffectedBits() < 48) continue;
            stringBuffer.append(this.bits.get(n3).getName());
            stringBuffer.append(stringBuffer4);
        }
        stringBuffer2.append(stringBuffer3.append(stringBuffer));
        stringBuffer2.deleteCharAt(stringBuffer2.lastIndexOf(stringBuffer4.toString().trim()));
        return stringBuffer2.toString();
    }

    private final class CustomEditorConstraints
    extends JPanel
    implements ItemListener {
        private JPanel generalPanel;
        private JPanel horizontalAlignmentPanel;
        private JPanel verticalAlignmentPanel;
        private JPanel newlinePanel;
        private JPanel shrinkPanel;
        private JPanel expandPanel;
        private JCheckBox defaultCheckBox;
        private JRadioButton horizontalAlignmentNoneCheckBox;
        private JRadioButton verticalAlignmentNoneCheckBox;
        private List<JToggleButton> guiItems;

        CustomEditorConstraints() {
            this.initComponents();
            this.setLayoutDefault(this.defaultCheckBox.isSelected());
        }

        void cleanUp() {
            PropertyEditorLayout.this.layouts = null;
            if (PropertyEditorLayout.this.bits != null) {
                PropertyEditorLayout.this.bits.clear();
                PropertyEditorLayout.this.bits = null;
            }
            this.generalPanel = null;
            this.horizontalAlignmentPanel = null;
            this.verticalAlignmentPanel = null;
            this.newlinePanel = null;
            this.shrinkPanel = null;
            this.expandPanel = null;
            this.defaultCheckBox = null;
            this.horizontalAlignmentNoneCheckBox = null;
            this.verticalAlignmentNoneCheckBox = null;
            this.removeAll();
        }

        void initComponents() {
            this.guiItems = new ArrayList<JToggleButton>();
            this.setLayout(new GridLayout(6, 1));
            this.generalPanel = new JPanel();
            this.generalPanel.setLayout(new GridLayout(1, 2));
            this.generalPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_GENERAL")));
            this.defaultCheckBox = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_GEN_DEFAULT"));
            this.defaultCheckBox.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_GEN_DEFAULT"));
            this.integrateGuiItem(this.defaultCheckBox, PropertyEditorLayout.this.layouts.getBitmaskItem(0));
            this.defaultCheckBox.setSelected(PropertyEditorLayout.this.layouts.getBitmask() == 0);
            this.guiItems.add(this.defaultCheckBox);
            this.generalPanel.add(this.defaultCheckBox);
            this.defaultCheckBox.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_GEN_DEFAULT"));
            this.defaultCheckBox.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_GEN_DEFAULT"));
            JToggleButton jToggleButton = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_GEN_MIDP2"));
            jToggleButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_GEN_MIDP2"));
            this.integrateGuiItem(jToggleButton, PropertyEditorLayout.this.layouts.getBitmaskItem(16384));
            this.guiItems.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_GEN_MIDP2"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSN_ITEMLAYOUTPE_GEN_MIDP2"));
            this.generalPanel.add(jToggleButton);
            this.add(this.generalPanel);
            this.horizontalAlignmentPanel = new JPanel();
            this.horizontalAlignmentPanel.setLayout(new GridLayout(1, 4));
            this.horizontalAlignmentPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_HORIZONTAL")));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.horizontalAlignmentNoneCheckBox = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_HOR_NONE"));
            this.horizontalAlignmentNoneCheckBox.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_HOR_NONE"));
            buttonGroup.add(this.horizontalAlignmentNoneCheckBox);
            this.horizontalAlignmentPanel.add(this.horizontalAlignmentNoneCheckBox);
            this.horizontalAlignmentNoneCheckBox.setSelected(true);
            this.horizontalAlignmentNoneCheckBox.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_HOR_NONE"));
            this.horizontalAlignmentNoneCheckBox.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_HOR_NONE"));
            jToggleButton = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_HOR_LEFT"));
            jToggleButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_HOR_LEFT"));
            buttonGroup.add(jToggleButton);
            this.integrateGuiItem(jToggleButton, PropertyEditorLayout.this.layouts.getBitmaskItem(1));
            this.guiItems.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_HOR_LEFT"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_HOR_LEFT"));
            this.horizontalAlignmentPanel.add(jToggleButton);
            JRadioButton jRadioButton = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_HOR_CENTER"));
            jRadioButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_HOR_CENTER"));
            buttonGroup.add(jRadioButton);
            this.guiItems.add(jRadioButton);
            jRadioButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_HOR_CENTER"));
            jRadioButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_HOR_CENTER"));
            this.horizontalAlignmentPanel.add(jRadioButton);
            jToggleButton = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_HOR_RIGHT"));
            jToggleButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_HOR_RIGHT"));
            buttonGroup.add(jToggleButton);
            this.integrateGuiItem(jToggleButton, PropertyEditorLayout.this.layouts.getBitmaskItem(2));
            this.guiItems.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_HOR_RIGHT"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_HOR_RIGHT"));
            this.horizontalAlignmentPanel.add(jToggleButton);
            this.integrateGuiItem(jRadioButton, PropertyEditorLayout.this.layouts.getBitmaskItem(3));
            this.add(this.horizontalAlignmentPanel);
            this.verticalAlignmentPanel = new JPanel();
            this.verticalAlignmentPanel.setLayout(new GridLayout(1, 4));
            this.verticalAlignmentPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_VERTICAL")));
            buttonGroup = new ButtonGroup();
            this.verticalAlignmentNoneCheckBox = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_VER_NONE"));
            this.verticalAlignmentNoneCheckBox.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_VER_NONE"));
            this.verticalAlignmentNoneCheckBox.setSelected(true);
            buttonGroup.add(this.verticalAlignmentNoneCheckBox);
            this.verticalAlignmentPanel.add(this.verticalAlignmentNoneCheckBox);
            this.verticalAlignmentNoneCheckBox.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_VER_NONE"));
            this.verticalAlignmentNoneCheckBox.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_VER_NONE"));
            jToggleButton = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_VER_TOP"));
            jToggleButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_VER_TOP"));
            buttonGroup.add(jToggleButton);
            this.integrateGuiItem(jToggleButton, PropertyEditorLayout.this.layouts.getBitmaskItem(16));
            this.guiItems.add(jToggleButton);
            this.verticalAlignmentPanel.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_VER_TOP"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_VER_TOP"));
            jRadioButton = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_VER_CENTER"));
            jRadioButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_VER_CENTER"));
            buttonGroup.add(jRadioButton);
            this.guiItems.add(jRadioButton);
            jRadioButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_VER_CENTER"));
            jRadioButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_VER_CENTER"));
            this.verticalAlignmentPanel.add(jRadioButton);
            jToggleButton = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_VER_BOTTOM"));
            jToggleButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_VER_BOTTOM"));
            buttonGroup.add(jToggleButton);
            this.integrateGuiItem(jToggleButton, PropertyEditorLayout.this.layouts.getBitmaskItem(32));
            this.guiItems.add(jToggleButton);
            this.verticalAlignmentPanel.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_VER_BOTTOM"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_VER_BOTTOM"));
            this.integrateGuiItem(jRadioButton, PropertyEditorLayout.this.layouts.getBitmaskItem(48));
            this.add(this.verticalAlignmentPanel);
            this.newlinePanel = new JPanel();
            this.newlinePanel.setLayout(new GridLayout(1, 2));
            this.newlinePanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_NEWLINE")));
            jToggleButton = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_NL_BEFORE"));
            jToggleButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_NL_BEFORE"));
            this.integrateGuiItem(jToggleButton, PropertyEditorLayout.this.layouts.getBitmaskItem(256));
            this.guiItems.add(jToggleButton);
            this.newlinePanel.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_NEWLINE"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_NEWLINE"));
            jToggleButton = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_NL_AFTER"));
            jToggleButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_NL_AFTER"));
            this.integrateGuiItem(jToggleButton, PropertyEditorLayout.this.layouts.getBitmaskItem(512));
            this.guiItems.add(jToggleButton);
            this.newlinePanel.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_NL_AFTER"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_NL_AFTER"));
            this.add(this.newlinePanel);
            this.shrinkPanel = new JPanel();
            this.shrinkPanel.setLayout(new GridLayout(1, 2));
            this.shrinkPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_SHRINK")));
            jToggleButton = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_SH_HORIZONTAL"));
            jToggleButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_SH_HORIZONTAL"));
            this.integrateGuiItem(jToggleButton, PropertyEditorLayout.this.layouts.getBitmaskItem(1024));
            this.guiItems.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_SH_HORIZONTAL"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_SH_HORIZONTAL"));
            this.shrinkPanel.add(jToggleButton);
            jToggleButton = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_SH_VERTICAL"));
            jToggleButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_SH_VERTICAL"));
            this.integrateGuiItem(jToggleButton, PropertyEditorLayout.this.layouts.getBitmaskItem(2048));
            this.guiItems.add(jToggleButton);
            this.shrinkPanel.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_SH_VERTICAL"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_SH_VERTICAL"));
            this.add(this.shrinkPanel);
            this.expandPanel = new JPanel();
            this.expandPanel.setLayout(new GridLayout(1, 2));
            this.expandPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_EXPAND")));
            jToggleButton = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_EX_HORIZONTAL"));
            jToggleButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_EX_HORIZONTAL"));
            this.integrateGuiItem(jToggleButton, PropertyEditorLayout.this.layouts.getBitmaskItem(4096));
            this.guiItems.add(jToggleButton);
            this.expandPanel.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_EX_HORIZONTAL"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_EX_HORIZONTAL"));
            jToggleButton = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_EX_VERTICAL"));
            jToggleButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_EX_VERTICAL"));
            this.integrateGuiItem(jToggleButton, PropertyEditorLayout.this.layouts.getBitmaskItem(8192));
            this.guiItems.add(jToggleButton);
            this.expandPanel.add(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_EX_VERTICAL"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_EX_VERTICAL"));
            this.add(this.expandPanel);
            for (JToggleButton jToggleButton2 : this.guiItems) {
                jToggleButton2.addItemListener(this);
            }
        }

        private void integrateGuiItem(JToggleButton jToggleButton, Bitmask.BitmaskItem bitmaskItem) {
            jToggleButton.setSelected(PropertyEditorLayout.this.layouts.isSet(bitmaskItem));
            jToggleButton.setName(Integer.toString(bitmaskItem.getAffectedBits()));
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (!(itemSelectable instanceof JToggleButton)) {
                return;
            }
            JToggleButton jToggleButton = (JToggleButton)itemSelectable;
            String string = jToggleButton.getName();
            if (string.equals(this.defaultCheckBox.getName())) {
                boolean bl = itemEvent.getStateChange() == 1;
                this.setLayoutDefault(bl);
                int n = 0;
                if (!bl) {
                    n = this.getComponentsBitmask().getBitmask();
                }
                PropertyEditorLayout.this.bitMask = n;
            } else {
                Bitmask.BitmaskItem bitmaskItem = (Bitmask.BitmaskItem)PropertyEditorLayout.this.bits.get(new Integer(String.valueOf(string)));
                assert (bitmaskItem != null);
                boolean bl = itemEvent.getStateChange() == 1;
                PropertyEditorLayout.this.bitMask = PropertyEditorLayout.this.layouts.addToBitmask(bitmaskItem, bl);
            }
        }

        private void setLayoutDefault(boolean bl) {
            boolean bl2 = !bl;
            for (Integer n : PropertyEditorLayout.this.bits.keySet()) {
                for (JToggleButton jToggleButton : this.guiItems) {
                    if (!jToggleButton.getName().equals(Integer.toString(n))) continue;
                    jToggleButton.setEnabled(bl2);
                }
            }
            this.defaultCheckBox.setEnabled(true);
            this.horizontalAlignmentNoneCheckBox.setEnabled(bl2);
            this.verticalAlignmentNoneCheckBox.setEnabled(bl2);
        }

        private ItemLayouts getComponentsBitmask() {
            ItemLayouts itemLayouts = new ItemLayouts(0);
            for (JToggleButton jToggleButton : this.guiItems) {
                if (!jToggleButton.isSelected()) continue;
                itemLayouts.addToBitmask((Bitmask.BitmaskItem)PropertyEditorLayout.this.bits.get(Integer.valueOf(jToggleButton.getName())), true);
            }
            return itemLayouts;
        }

        public void setValue(int n) {
            if (n == 0) {
                this.defaultCheckBox.setSelected(true);
                this.itemStateChanged(new ItemEvent(this.defaultCheckBox, 701, null, 1));
            } else {
                PropertyEditorLayout.this.setConstant(n);
            }
        }

        public int getBitMask() {
            return PropertyEditorLayout.this.bitMask;
        }
    }
}

