/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;

public class BooleanInplaceEditor
implements InplaceEditor {
    private JCheckBox checkBox;
    private DesignPropertyEditor propertyEditor;
    private PropertyModel model;

    public BooleanInplaceEditor(DesignPropertyEditor designPropertyEditor) {
        this.propertyEditor = designPropertyEditor;
        this.checkBox = new JCheckBox();
        PropertyValue propertyValue = (PropertyValue)designPropertyEditor.getValue();
        if (propertyValue != null && propertyValue.getKind() == PropertyValue.Kind.VALUE) {
            if (!(propertyValue.getPrimitiveValue() instanceof Boolean)) {
                Boolean bl = (Boolean)propertyValue.getPrimitiveValue();
                this.checkBox.setSelected(bl);
            }
        } else if (propertyValue == PropertyValue.createNull()) {
            this.checkBox.setSelected(false);
        }
    }

    public void cleanUp() {
        this.checkBox = null;
        this.model = null;
        this.propertyEditor = null;
    }

    public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
    }

    public JComponent getComponent() {
        if (this.checkBox == null) {
            return new JCheckBox();
        }
        this.checkBox.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        if (!this.propertyEditor.canWrite()) {
            this.checkBox.setEnabled(false);
        } else {
            this.checkBox.setEnabled(true);
        }
        return this.checkBox;
    }

    public void clear() {
    }

    public Object getValue() {
        return this.propertyEditor.getValue();
    }

    public void setValue(Object object) {
    }

    public boolean supportsTextEntry() {
        return true;
    }

    public void reset() {
    }

    public void addActionListener(ActionListener actionListener) {
    }

    public void removeActionListener(ActionListener actionListener) {
    }

    public KeyStroke[] getKeyStrokes() {
        return new KeyStroke[0];
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public PropertyModel getPropertyModel() {
        return this.model;
    }

    public void setPropertyModel(PropertyModel propertyModel) {
        this.model = propertyModel;
    }

    public boolean isKnownComponent(Component component) {
        return true;
    }
}

