/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.analyzer;

import java.awt.Dimension;
import java.awt.Image;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.netbeans.modules.vmd.api.analyzer.Analyzer;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.VersionDescriptor;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpVersionDescriptor;
import org.netbeans.modules.vmd.midp.components.MidpVersionable;
import org.netbeans.modules.vmd.midp.components.items.ImageItemCD;
import org.netbeans.modules.vmd.midp.components.items.ItemCD;
import org.openide.util.NbBundle;

public class Midp1CompliantAnalyzer
implements Analyzer {
    public String getProjectType() {
        return "vmd-midp";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"Midp1CompliantAnalyzer.displayName");
    }

    public String getToolTip() {
        return NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"Midp1CompliantAnalyzer.toolTip");
    }

    public Image getIcon() {
        return null;
    }

    public JComponent createVisualRepresentation() {
        JList jList = new JList(new DefaultListModel());
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setPreferredSize(new Dimension(400, 150));
        return jScrollPane;
    }

    public void update(JComponent jComponent, final DesignDocument designDocument) {
        if (jComponent == null || designDocument == null) {
            return;
        }
        final JList jList = (JList)((JScrollPane)jComponent).getViewport().getView();
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
                defaultListModel.removeAllElements();
                DesignComponent designComponent = designDocument.getRootComponent();
                if (designComponent != null) {
                    Midp1CompliantAnalyzer.this.analyze(defaultListModel, designComponent);
                }
            }
        });
    }

    private void analyze(DefaultListModel defaultListModel, DesignComponent designComponent) {
        ComponentDescriptor componentDescriptor = designComponent.getComponentDescriptor();
        if (componentDescriptor == null) {
            return;
        }
        VersionDescriptor versionDescriptor = componentDescriptor.getVersionDescriptor();
        if (!versionDescriptor.isCompatibleWith(MidpVersionDescriptor.MIDP_1)) {
            this.reportComponent(defaultListModel, designComponent);
            return;
        }
        for (PropertyDescriptor propertyDescriptor : componentDescriptor.getPropertyDescriptors()) {
            if (!propertyDescriptor.getVersionable().isCompatibleWith(MidpVersionable.MIDP_1) && !designComponent.isDefaultValue(propertyDescriptor.getName())) {
                this.reportComponentProperty(defaultListModel, designComponent, propertyDescriptor.getName());
            }
            this.processComponentProperty(defaultListModel, designComponent, propertyDescriptor);
        }
        for (PropertyDescriptor propertyDescriptor : designComponent.getComponents()) {
            this.analyze(defaultListModel, (DesignComponent)propertyDescriptor);
        }
    }

    private void reportComponent(DefaultListModel defaultListModel, DesignComponent designComponent) {
        defaultListModel.addElement(NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"MSG_IncompatibleComponent", (Object)InfoPresenter.getHtmlDisplayName((DesignComponent)designComponent)));
    }

    private void processComponentProperty(DefaultListModel defaultListModel, DesignComponent designComponent, PropertyDescriptor propertyDescriptor) {
        DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
        if (descriptorRegistry.isInHierarchy(ItemCD.TYPEID, designComponent.getType()) && "layout".equals(propertyDescriptor.getName())) {
            if (!descriptorRegistry.isInHierarchy(ImageItemCD.TYPEID, designComponent.getType())) {
                defaultListModel.addElement(NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"MSG_IncompatibleItemLayout", (Object)InfoPresenter.getHtmlDisplayName((DesignComponent)designComponent)));
                return;
            }
            int n = MidpTypes.getInteger(designComponent.readProperty("layout"));
            if ((n & 0x6C30) != 0) {
                defaultListModel.addElement(NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"MSG_IncompatibleItemLayout", (Object)InfoPresenter.getHtmlDisplayName((DesignComponent)designComponent)));
                return;
            }
        }
    }

    private void reportComponentProperty(DefaultListModel defaultListModel, DesignComponent designComponent, String string) {
        DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
        if (descriptorRegistry.isInHierarchy(ItemCD.TYPEID, designComponent.getType())) {
            if ("itemCommandListener".equals(string)) {
                return;
            }
            if ("commands".equals(string)) {
                defaultListModel.addElement(NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"MSG_ItemsCommandsNotAllowed", (Object)InfoPresenter.getHtmlDisplayName((DesignComponent)designComponent)));
                return;
            }
        }
        defaultListModel.addElement(NbBundle.getMessage(Midp1CompliantAnalyzer.class, (String)"MSG_IncompatiblePropertyValue", (Object)string, (Object)InfoPresenter.getHtmlDisplayName((DesignComponent)designComponent)));
    }
}

