/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.mobility.svgcore.api.snippets.SVGSnippetsProvider;
import org.netbeans.modules.mobility.svgcore.options.SvgcoreOptionsPanelController;
import org.netbeans.modules.mobility.svgcore.options.SvgcoreSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class SvgcorePanel
extends JPanel {
    private final SvgcoreOptionsPanelController controller;
    private JPanel editorPanel;
    private JButton jButtonBrowse;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField pathTextField;
    private JPanel snippetsPanel;

    SvgcorePanel(SvgcoreOptionsPanelController svgcoreOptionsPanelController) {
        this.controller = svgcoreOptionsPanelController;
        this.initComponents();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(SvgcorePanel.getListSnippets());
        this.jComboBox1.setModel(defaultComboBoxModel);
    }

    private void initComponents() {
        this.editorPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.pathTextField = new JTextField();
        this.jButtonBrowse = new JButton();
        this.snippetsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        this.editorPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_EditorFrame")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_AnimatorPath"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBrowse, (String)NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_ButtonChange"));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SvgcorePanel.this.jButtonBrowseActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.editorPanel);
        this.editorPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, 136, -2).addPreferredGap(0).add((Component)this.pathTextField, -1, 359, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonBrowse, -2, 100, -2).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.pathTextField, -2, -1, -2).add((Component)this.jButtonBrowse)).addContainerGap(-1, Short.MAX_VALUE)));
        this.snippetsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_SVGFrame")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_SnippetsName"));
        this.jLabel2.setPreferredSize(new Dimension(136, 16));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.snippetsPanel);
        this.snippetsPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jLabel2, -2, 136, -2).addPreferredGap(0).add((Component)this.jComboBox1, 0, 473, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel2, -2, -1, -2).add((Component)this.jComboBox1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.snippetsPanel, -1, -1, Short.MAX_VALUE).add((Component)this.editorPanel, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.snippetsPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.editorPanel, -2, -1, -2).add(39, 39, 39)));
    }

    private void jButtonBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.pathTextField.getText());
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(SvgcorePanel.class, (String)"LBL_Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!file.isFile()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SvgcorePanel.class, (String)"ERROR_NotFile", (Object)file), 2));
                return;
            }
            this.pathTextField.setText(file.getAbsoluteFile().toString());
        }
    }

    void load() {
        this.pathTextField.setText(SvgcoreSettings.getDefault().getExternalEditorPath());
        this.jComboBox1.setSelectedItem(SvgcoreSettings.getDefault().getCurrentSnippet());
    }

    void store() {
        SvgcoreSettings.getDefault().setExternalEditorPath(this.pathTextField.getText());
        SvgcoreSettings.getDefault().setCurrentSnippet((String)this.jComboBox1.getSelectedItem());
    }

    boolean valid() {
        return true;
    }

    private static final String[] getListSnippets() {
        Collection collection = Lookup.getDefault().lookupAll(SVGSnippetsProvider.class);
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (SVGSnippetsProvider sVGSnippetsProvider : collection) {
            stringArray[n++] = sVGSnippetsProvider.getDisplayName();
        }
        return stringArray;
    }
}

